/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si;

import android.content.Intent;
import com.cloudrail.si.servicecode.commands.AwaitCodeRedirect;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public final class CloudRail {
    private static String appKey = null;
    private static boolean advancedAuthenticationMode = false;
    private static Intent authenticationResponse = null;

    private CloudRail() {
    }

    public static String getAppKey() {
        return appKey;
    }

    public static void setAppKey(String appKey) {
        CloudRail.appKey = appKey;
    }

    public static void validateKey() {
        Pattern pattern = Pattern.compile("^[a-f\\d]{24}$");
        if (appKey == null || !pattern.matcher(appKey).matches()) {
            throw new RuntimeException("A valid CloudRail license key is required. You can get one for free at https://developers.cloudrail.com");
        }
    }

    public static boolean isAdvancedAuthenticationMode() {
        return advancedAuthenticationMode;
    }

    public static void setAdvancedAuthenticationMode(boolean advancedAuthenticationMode) {
        CloudRail.advancedAuthenticationMode = advancedAuthenticationMode;
    }

    public static Intent getAuthenticationResponse() {
        return authenticationResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAuthenticationResponse(Intent authenticationResponse) {
        CloudRail.authenticationResponse = authenticationResponse;
        AtomicReference<Boolean> atomicReference = AwaitCodeRedirect.isWebViewOpened;
        synchronized (atomicReference) {
            AwaitCodeRedirect.isWebViewOpened.set(false);
            AwaitCodeRedirect.isWebViewOpened.notify();
        }
    }

    public static void clearAuthenticationResponse() {
        authenticationResponse = null;
    }
}

