/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import com.cloudrail.si.servicecode.commands.AwaitCodeRedirect;
import com.cloudrail.si.servicecode.commands.CallFunc;
import com.cloudrail.si.servicecode.commands.Clone;
import com.cloudrail.si.servicecode.commands.Create;
import com.cloudrail.si.servicecode.commands.Delete;
import com.cloudrail.si.servicecode.commands.Get;
import com.cloudrail.si.servicecode.commands.GetMimeType;
import com.cloudrail.si.servicecode.commands.IfEqThan;
import com.cloudrail.si.servicecode.commands.IfGtEqThan;
import com.cloudrail.si.servicecode.commands.IfGtThan;
import com.cloudrail.si.servicecode.commands.IfLtEqThan;
import com.cloudrail.si.servicecode.commands.IfLtThan;
import com.cloudrail.si.servicecode.commands.IfNotEqThan;
import com.cloudrail.si.servicecode.commands.JumpRel;
import com.cloudrail.si.servicecode.commands.Pull;
import com.cloudrail.si.servicecode.commands.Push;
import com.cloudrail.si.servicecode.commands.Return;
import com.cloudrail.si.servicecode.commands.Set;
import com.cloudrail.si.servicecode.commands.Size;
import com.cloudrail.si.servicecode.commands.ThrowError;
import com.cloudrail.si.servicecode.commands.TypeOf;
import com.cloudrail.si.servicecode.commands.array.ArrayToData;
import com.cloudrail.si.servicecode.commands.array.DataToArray;
import com.cloudrail.si.servicecode.commands.array.Sort;
import com.cloudrail.si.servicecode.commands.array.Uint8ToBase64;
import com.cloudrail.si.servicecode.commands.crypt.rsa.SHA256;
import com.cloudrail.si.servicecode.commands.debug.Out;
import com.cloudrail.si.servicecode.commands.hash.Md5;
import com.cloudrail.si.servicecode.commands.hash.Sha1;
import com.cloudrail.si.servicecode.commands.hash.Sha256;
import com.cloudrail.si.servicecode.commands.http.RequestCall;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.JSONValue;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.ContainerFactory;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.JSONParser;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.ParseException;
import com.cloudrail.si.servicecode.commands.math.Add;
import com.cloudrail.si.servicecode.commands.math.Divide;
import com.cloudrail.si.servicecode.commands.math.Floor;
import com.cloudrail.si.servicecode.commands.math.Max;
import com.cloudrail.si.servicecode.commands.math.Min;
import com.cloudrail.si.servicecode.commands.math.Multiply;
import com.cloudrail.si.servicecode.commands.math.Subtract;
import com.cloudrail.si.servicecode.commands.object.GetKeyArray;
import com.cloudrail.si.servicecode.commands.object.GetKeyValueArrays;
import com.cloudrail.si.servicecode.commands.stats.AddStat;
import com.cloudrail.si.servicecode.commands.stream.DataToStream;
import com.cloudrail.si.servicecode.commands.stream.MakeJoinedStream;
import com.cloudrail.si.servicecode.commands.stream.MakeLimitedStream;
import com.cloudrail.si.servicecode.commands.stream.StreamToData;
import com.cloudrail.si.servicecode.commands.stream.StreamToString;
import com.cloudrail.si.servicecode.commands.stream.StringToStream;
import com.cloudrail.si.servicecode.commands.string.Base64Decode;
import com.cloudrail.si.servicecode.commands.string.Base64Encode;
import com.cloudrail.si.servicecode.commands.string.ChunkSplit;
import com.cloudrail.si.servicecode.commands.string.Concat;
import com.cloudrail.si.servicecode.commands.string.Format;
import com.cloudrail.si.servicecode.commands.string.IndexOf;
import com.cloudrail.si.servicecode.commands.string.LastIndexOf;
import com.cloudrail.si.servicecode.commands.string.LowerCase;
import com.cloudrail.si.servicecode.commands.string.Split;
import com.cloudrail.si.servicecode.commands.string.Substr;
import com.cloudrail.si.servicecode.commands.string.Substring;
import com.cloudrail.si.servicecode.commands.string.UpperCase;
import com.cloudrail.si.servicecode.commands.string.UrlDecode;
import com.cloudrail.si.servicecode.commands.string.UrlEncode;
import com.cloudrail.si.servicecode.commands.xml.Parse;
import com.cloudrail.si.servicecode.commands.xml.Stringify;
import com.cloudrail.si.statistics.Statistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Interpreter {
    protected Sandbox sandbox;
    private static final Command[] COMMAND_LIST = new Command[]{new Get(), new Set(), new Delete(), new Push(), new Pull(), new Create(), new Clone(), new Size(), new CallFunc(), new Return(), new IfEqThan(), new IfNotEqThan(), new IfGtEqThan(), new IfGtThan(), new IfLtEqThan(), new IfLtThan(), new JumpRel(), new ThrowError(), new Add(), new Multiply(), new Min(), new Max(), new Floor(), new Subtract(), new Divide(), new Concat(), new Substr(), new Substring(), new UpperCase(), new LowerCase(), new Format(), new Split(), new IndexOf(), new LastIndexOf(), new UrlEncode(), new UrlDecode(), new Out(), new Md5(), new com.cloudrail.si.servicecode.commands.crypt.hmac.Sha1(), new AwaitCodeRedirect(), new RequestCall(), new StreamToString(), new StringToStream(), new MakeJoinedStream(), new MakeLimitedStream(), new GetKeyArray(), new GetKeyValueArrays(), new Uint8ToBase64(), new GetMimeType(), new com.cloudrail.si.servicecode.commands.json.Parse(), new com.cloudrail.si.servicecode.commands.json.Stringify(), new Base64Encode(), new DataToStream(), new StreamToData(), new Sha1(), new Sha256(), new com.cloudrail.si.servicecode.commands.crypt.hmac.Sha256(), new Parse(), new Stringify(), new TypeOf(), new ArrayToData(), new DataToArray(), new Base64Decode(), new SHA256(), new Sort(), new ChunkSplit(), new AddStat()};
    private static final Map<String, Command> COMMANDS = Collections.unmodifiableMap(new TreeMap<String, Command>(){
        private static final long serialVersionUID = -3311515876674873465L;
        {
            for (Command cm : COMMAND_LIST) {
                this.put(cm.getID(), cm);
            }
        }
    });

    public Interpreter(Map<String, Object[]> serviceCode) {
        this(new Sandbox(serviceCode));
    }

    public Interpreter(Sandbox sandbox) {
        this.sandbox = sandbox;
    }

    public void callFunction(String functionName, Object ... parameters) {
        if (Statistics.getInstance().getBlock().booleanValue()) {
            throw new RuntimeException("Your CloudRail license has expired. Please visit https://developers.cloudrail.com to upgrade or contact support@cloudrail.com");
        }
        this.sandbox.createNewStackLevel(functionName);
        this.sandbox.currentParameters().addAll(Arrays.asList(parameters));
        if (this.sandbox.currentFunctionCode() == null) {
            String errorMessage = "ServiceCode Error: function '" + functionName + "' not found!";
            throw new RuntimeException(errorMessage);
        }
        this.run();
    }

    public void resumeFunction(String functionName, Object ... parameters) {
        List<Object> firstParameters;
        if (this.sandbox.getParameterStack().isEmpty()) {
            firstParameters = new ArrayList();
            this.sandbox.getParameterStack().add(firstParameters);
        } else {
            firstParameters = this.sandbox.getParameterStack().get(0);
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof Map) {
                Map m = (Map)parameters[i];
                m.clear();
                m.putAll((Map)firstParameters.get(i));
                continue;
            }
            if (i >= firstParameters.size()) {
                firstParameters.add(parameters[i]);
                continue;
            }
            firstParameters.set(i, parameters[i]);
        }
        this.run();
    }

    private void run() {
        try {
            while (this.sandbox.getCurrentServiceCodeLine() < this.sandbox.currentFunctionCode().length && this.sandbox.getCurrentServiceCodeLine() >= 0) {
                Object[] command = (Object[])this.sandbox.currentFunctionCode()[this.sandbox.getCurrentServiceCodeLine()];
                if (!COMMANDS.containsKey((String)command[0])) {
                    throw new Exception("Unknown command: " + (String)command[0]);
                }
                Object[] commandParameters = Interpreter.decodeCommandParameters(command);
                COMMANDS.get((String)command[0]).execute(this.sandbox, commandParameters);
                if (this.sandbox.getThrownError() != null) {
                    return;
                }
                this.sandbox.incrementCurrentServiceCodeLine();
                while ((this.sandbox.getCurrentServiceCodeLine() >= this.sandbox.currentFunctionCode().length || this.sandbox.getCurrentServiceCodeLine() < 0) && this.sandbox.getServiceCodeFunction().size() > 1) {
                    this.sandbox.returnFromFunction();
                }
            }
        }
        catch (Exception e) {
            String codeLine = "";
            try {
                Object[] code = (Object[])this.sandbox.currentFunctionCode()[this.sandbox.getCurrentServiceCodeLine()];
                for (int i = 0; i < code.length; ++i) {
                    codeLine = code[i] instanceof String ? codeLine + (String)code[i] + " " : (code[i] instanceof Integer ? codeLine + String.valueOf((Integer)code[i]) + " " : codeLine + "? ");
                }
            }
            catch (NullPointerException code) {
                // empty catch block
            }
            String errorMessage = "ServiceCode Error in function " + this.sandbox.currentFunctionName() + " at " + this.sandbox.getCurrentServiceCodeLine() + ": " + codeLine;
            throw new RuntimeException(errorMessage, e);
        }
    }

    public static Object[] decodeCommandParameters(Object[] command) {
        Object[] commandParameters = Arrays.copyOfRange(command, 1, command.length);
        for (int i = 0; i < commandParameters.length; ++i) {
            if (!(commandParameters[i] instanceof String)) continue;
            if (((String)commandParameters[i]).startsWith("$")) {
                commandParameters[i] = new VarAddress(((String)commandParameters[i]).substring(1));
                continue;
            }
            if (!((String)commandParameters[i]).startsWith("\\$")) continue;
            commandParameters[i] = ((String)commandParameters[i]).substring(1);
        }
        return commandParameters;
    }

    public Object getParameter(int idx) {
        return this.sandbox.getParameter(idx, 0);
    }

    public Object getError() {
        return this.sandbox.getThrownError();
    }

    public String saveAsString() {
        return JSONValue.toJSONString(this.sandbox.getPersistentStorage());
    }

    public void loadAsString(String savedState) throws com.cloudrail.si.exceptions.ParseException {
        try {
            this.sandbox.setPersistentStorage((List)new JSONParser().parse(savedState, (ContainerFactory)new LoadAsStringContainerFactory()));
        }
        catch (ParseException e) {
            throw new com.cloudrail.si.exceptions.ParseException(e.getMessage());
        }
    }

    private class LoadAsStringContainerFactory
    implements ContainerFactory {
        private LoadAsStringContainerFactory() {
        }

        @Override
        public Map createObjectContainer() {
            return new TreeMap();
        }

        @Override
        public List creatArrayContainer() {
            return new ArrayList();
        }
    }
}

