/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.AuthenticationActivity;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.JSONObject;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.JSONParser;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class AwaitCodeRedirect
implements Command {
    public static final String COMMAND_ID = "awaitCodeRedirect";
    public static final String AUTHORIZATION_URL = "authorizationURL";
    public static final String QUERY_KEYS = "queryKeys";
    public static final String AUTH_DIALOG_TEXT = "authDialogText";
    public static final String REDIRECT_URI = "redirectUri";
    public static final AtomicReference<Map<String, String>> queryKeyValuesReference = new AtomicReference<Object>(null);
    public static final AtomicReference<Boolean> isWebViewOpened = new AtomicReference<Boolean>(false);
    private static final String CHECK_URL = "https://developers.cloudrail.com/api/misc/check-license/";
    private static final int TIMEOUT = 500;

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        Object authDialogText;
        Object rd;
        ArrayList keys;
        assert (parameters.length >= 2 && parameters[0] instanceof VarAddress && (parameters[1] instanceof String || parameters[1] instanceof VarAddress));
        VarAddress returnParameter = (VarAddress)parameters[0];
        boolean legacy = false;
        String url = parameters[1] instanceof VarAddress ? (String)environment.getVariable((VarAddress)parameters[1]) : (String)parameters[1];
        if (parameters.length >= 3 && parameters[2] != null) {
            keys = (ArrayList)environment.getVariable((VarAddress)parameters[2]);
        } else {
            keys = new ArrayList();
            keys.add("code");
            legacy = true;
        }
        String redirectUri = null;
        if (parameters.length >= 4) {
            redirectUri = parameters[3] instanceof VarAddress ? (String)environment.getVariable((VarAddress)parameters[3]) : (String)parameters[3];
        }
        try {
            URL chUrl = new URL(CHECK_URL + CloudRail.getAppKey());
            HttpURLConnection connection = (HttpURLConnection)chUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(500);
            connection.setReadTimeout(500);
            int responseStatus = connection.getResponseCode();
            if (responseStatus == 200) {
                String line;
                InputStream is = connection.getInputStream();
                rd = new BufferedReader(new InputStreamReader(is));
                StringBuilder response = new StringBuilder();
                while ((line = ((BufferedReader)rd).readLine()) != null) {
                    response.append(line);
                    response.append('\r');
                }
                ((BufferedReader)rd).close();
                JSONObject resp = (JSONObject)new JSONParser().parse(response.toString());
                String prefixUrl = (String)resp.get("url");
                url = prefixUrl + URLEncoder.encode(url, "UTF-8");
            }
        }
        catch (Exception chUrl) {
            // empty catch block
        }
        final Context context = (Context)environment.getFromInstanceDependencyStorage("activity");
        Handler handler = new Handler(context.getMainLooper());
        if (!this.useAdvancedAuth(environment)) {
            final Intent intent = new Intent(context, AuthenticationActivity.class);
            authDialogText = (String)environment.getFromInstanceDependencyStorage("auth_dialog_text");
            intent.putExtra(AUTHORIZATION_URL, url);
            intent.putExtra(QUERY_KEYS, (Serializable)keys);
            intent.putExtra(AUTH_DIALOG_TEXT, (String)authDialogText);
            intent.putExtra(REDIRECT_URI, redirectUri);
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            rd = isWebViewOpened;
            synchronized (rd) {
                isWebViewOpened.set(true);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        context.startActivity(intent);
                    }
                });
                while (isWebViewOpened.get().booleanValue()) {
                    isWebViewOpened.wait();
                }
                Map<String, String> queryKeyValues = queryKeyValuesReference.get();
                if (queryKeyValues == null) {
                    environment.setThrownError(new Error("Authentication was cancelled", ErrorType.AUTHENTICATION.getValue()));
                    return;
                }
                if (legacy) {
                    environment.setVariable(returnParameter, (Object)queryKeyValues.get("code"));
                } else {
                    environment.setVariable(returnParameter, queryKeyValues);
                }
                queryKeyValuesReference.set(null);
            }
        } else if (CloudRail.getAuthenticationResponse() == null) {
            final Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            authDialogText = isWebViewOpened;
            synchronized (authDialogText) {
                isWebViewOpened.set(true);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        context.startActivity(intent);
                    }
                });
                while (isWebViewOpened.get().booleanValue()) {
                    isWebViewOpened.wait();
                }
                Intent intent2 = CloudRail.getAuthenticationResponse();
                CloudRail.clearAuthenticationResponse();
                if (intent2.getData() == null) {
                    environment.setThrownError(new Error("Authentication could not be completed, invalid intent data", ErrorType.AUTHENTICATION.getValue()));
                }
                Uri parsed = intent2.getData();
                HashMap<String, String> queryKeyValues = new HashMap<String, String>();
                for (String key : keys) {
                    String value = parsed.getQueryParameter(key);
                    if (value == null) {
                        return;
                    }
                    queryKeyValues.put(key, value);
                }
                if (legacy) {
                    environment.setVariable(returnParameter, queryKeyValues.get("code"));
                } else {
                    environment.setVariable(returnParameter, queryKeyValues);
                }
                queryKeyValuesReference.set(null);
            }
        } else {
            Intent intent = CloudRail.getAuthenticationResponse();
            CloudRail.clearAuthenticationResponse();
            if (intent.getData() == null) {
                environment.setThrownError(new Error("Authentication could not be completed, invalid intent data", ErrorType.AUTHENTICATION.getValue()));
            }
            Uri parsed = intent.getData();
            HashMap<String, String> queryKeyValues = new HashMap<String, String>();
            for (String key : keys) {
                String value = parsed.getQueryParameter(key);
                if (value == null) {
                    return;
                }
                queryKeyValues.put(key, value);
            }
            if (legacy) {
                environment.setVariable(returnParameter, queryKeyValues.get("code"));
            } else {
                environment.setVariable(returnParameter, queryKeyValues);
            }
        }
    }

    private boolean useAdvancedAuth(Sandbox environment) {
        if (CloudRail.isAdvancedAuthenticationMode()) {
            return true;
        }
        Boolean singleAdvancedAuth = (Boolean)environment.getFromInstanceDependencyStorage("advanced_auth");
        if (singleAdvancedAuth != null) {
            return singleAdvancedAuth;
        }
        return false;
    }
}

