/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Clone
implements Command {
    public static final String COMMAND_ID = "clone";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress);
        VarAddress targetID = (VarAddress)parameters[0];
        Object sourceObj = parameters[1];
        if (sourceObj instanceof VarAddress) {
            sourceObj = environment.getVariable((VarAddress)parameters[1]);
        }
        Object clone = null;
        Class<?> sourceObjClass = sourceObj.getClass();
        try {
            Method cloneMethod = sourceObjClass.getMethod(COMMAND_ID, new Class[0]);
            clone = cloneMethod.invoke(sourceObj, new Object[0]);
        }
        catch (NoSuchMethodException cloneMethod) {
            // empty catch block
        }
        if (clone == null) {
            Constructor<?>[] sourceObjClassConsturctors;
            Constructor<?> cloneConsturctor = null;
            for (Constructor<?> constructor : sourceObjClassConsturctors = sourceObjClass.getConstructors()) {
                Class<?>[] constructorParameterTypes = constructor.getParameterTypes();
                if (constructorParameterTypes.length != 1 || !sourceObjClass.isInstance(constructorParameterTypes[0])) continue;
                cloneConsturctor = constructor;
                break;
            }
            clone = cloneConsturctor.newInstance(sourceObj);
        }
        if (clone == null) {
            throw new ClassNotFoundException("Can't clone a object from type: '" + sourceObjClass.getName() + "', no clone constructor found!");
        }
        environment.setVariable(targetID, clone);
    }
}

