/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.array;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.util.List;

public class ArrayToData
implements Command {
    public static final String COMMAND_ID = "array.arrayToData";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress && parameters[1] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        Object sourceArrayObj = environment.getVariable((VarAddress)parameters[1]);
        List sourceArray = null;
        if (!(sourceArrayObj instanceof List)) {
            throw new IllegalArgumentException("command: array.arrayToData parameter sourceArray is not from type List!");
        }
        sourceArray = (List)sourceArrayObj;
        byte[] sourceData = new byte[sourceArray.size()];
        for (int i = 0; i < sourceArray.size(); ++i) {
            Object iObj = sourceArray.get(i);
            if (!(iObj instanceof Number)) {
                throw new IllegalArgumentException("command: array.arrayToData the sourceArray contains a not in a uint8 convertible entry!");
            }
            sourceData[i] = ((Number)iObj).byteValue();
        }
        environment.setVariable(resultVar, (Object)sourceData);
    }
}

