/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.array;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import com.cloudrail.si.servicecode.commands.string.Base64Encode;
import java.util.List;

public class Uint8ToBase64
implements Command {
    public static final String COMMAND_ID = "array.uint8ToBase64";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 2 && parameters[0] instanceof VarAddress && parameters[1] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        Object sourceArrayObj = environment.getVariable((VarAddress)parameters[1]);
        Object urlSaveObj = null;
        if (parameters.length > 2) {
            urlSaveObj = parameters[2];
        }
        if (urlSaveObj instanceof VarAddress) {
            urlSaveObj = environment.getVariable((VarAddress)urlSaveObj);
        }
        boolean urlSave = false;
        if (urlSaveObj instanceof Number && ((Number)urlSaveObj).intValue() != 0) {
            urlSave = true;
        }
        List sourceArray = null;
        if (!(sourceArrayObj instanceof List)) {
            throw new IllegalArgumentException("command: array.uint8ToBase64 parameter sourceArray is not from type List!");
        }
        sourceArray = (List)sourceArrayObj;
        byte[] sourceData = new byte[sourceArray.size()];
        for (int i = 0; i < sourceArray.size(); ++i) {
            Object iObj = sourceArray.get(i);
            if (!(iObj instanceof Number)) {
                throw new IllegalArgumentException("command: array.uint8ToBase64 the sourceArray contains a not in a uint8 convertible entry!");
            }
            sourceData[i] = ((Number)iObj).byteValue();
        }
        String dataString = new String(sourceData, "ISO_8859_1");
        String base64String = Base64Encode.encode(dataString, false, urlSave);
        environment.setVariable(resultVar, (Object)base64String);
    }
}

