/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.crypt.hmac;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Sha256
implements Command {
    public static final String COMMAND_ID = "crypt.hmac.sha256";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        byte[] key;
        assert (parameters.length == 3 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        Object keyObj = parameters[1];
        Object massageObj = parameters[2];
        if (keyObj instanceof VarAddress) {
            keyObj = environment.getVariable((VarAddress)keyObj);
        }
        if (keyObj instanceof String) {
            key = ((String)keyObj).getBytes();
        } else if (keyObj instanceof List) {
            List bytes = (List)keyObj;
            key = new byte[bytes.size()];
            for (int i = 0; i < bytes.size(); ++i) {
                key[i] = ((Number)bytes.get(i)).byteValue();
            }
        } else if (keyObj instanceof byte[]) {
            key = (byte[])keyObj;
        } else {
            throw new IllegalArgumentException("command: crypt.hmac.sha256 parameter key is not from type String!");
        }
        if (massageObj instanceof VarAddress) {
            massageObj = environment.getVariable((VarAddress)massageObj);
        }
        if (!(massageObj instanceof String)) {
            throw new IllegalArgumentException("command: crypt.hmac.sha256 parameter massage is not from type String!");
        }
        String massage = (String)massageObj;
        SecretKeySpec keySpec = new SecretKeySpec(key, "HmacSHA256");
        Mac hmac = Mac.getInstance("HmacSHA256");
        hmac.init(keySpec);
        byte[] resultBytes = hmac.doFinal(massage.getBytes());
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < resultBytes.length; ++i) {
            result.add(Long.valueOf(resultBytes[i] & 0xFF));
        }
        environment.setVariable(resultVar, result);
    }
}

