/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.crypt.rsa;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;

public class SHA256
implements Command {
    public static final String COMMAND_ID = "crypt.rsa.sha256";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 3 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        VarAddress sourceVar = (VarAddress)parameters[1];
        VarAddress keyVar = (VarAddress)parameters[2];
        byte[] source = (byte[])environment.getVariable(sourceVar);
        byte[] key = (byte[])environment.getVariable(keyVar);
        PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(key));
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(source);
        byte[] res = signature.sign();
        environment.setVariable(resultVar, (Object)res);
    }
}

