/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.hash;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.security.MessageDigest;
import java.util.ArrayList;

public class Md5
implements Command {
    public static final String COMMAND_ID = "hash.md5";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        Object inputObj = parameters[1];
        if (inputObj instanceof VarAddress) {
            inputObj = environment.getVariable((VarAddress)inputObj);
        }
        if (!(inputObj instanceof String)) {
            throw new IllegalArgumentException("command: hash.md5 parameter input is not from type String!");
        }
        String input = (String)inputObj;
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.reset();
        md.update(input.getBytes());
        byte[] digestBytes = md.digest();
        ArrayList<Long> digest = new ArrayList<Long>();
        for (int i = 0; i < digestBytes.length; ++i) {
            digest.add(Long.valueOf(digestBytes[i] & 0xFF));
        }
        environment.setVariable(resultVar, digest);
    }
}

