/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.hash;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.security.MessageDigest;
import java.util.ArrayList;

public class Sha1
implements Command {
    public static final String COMMAND_ID = "hash.sha1";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        byte[] message;
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        Object messageObj = parameters[1];
        if (messageObj instanceof VarAddress) {
            messageObj = environment.getVariable((VarAddress)messageObj);
        }
        if (messageObj instanceof String) {
            String messageStr = (String)messageObj;
            message = messageStr.getBytes();
        } else if (messageObj instanceof byte[]) {
            message = (byte[])messageObj;
        } else {
            throw new IllegalArgumentException("command: hash.sha1 parameter message must be a String or byte[]!");
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] result = messageDigest.digest(message);
        ArrayList<Long> digest = new ArrayList<Long>();
        for (int i = 0; i < result.length; ++i) {
            digest.add(Long.valueOf(result[i] & 0xFF));
        }
        environment.setVariable(resultVar, digest);
    }
}

