/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.http;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import com.cloudrail.si.types.ConnectError;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;

public class RequestCall
implements Command {
    private static final String USER_AGENT = "CloudRailSI/Android";
    private static final String URL = "url";
    private static final String METHOD = "method";
    private static final String REQUEST_HEADERS = "requestHeaders";
    private static final String REQUEST_BODY = "requestBody";
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private static final String RESPONSE_HEADERS = "responseHeaders";
    private static final String RESPONSE_BODY = "responseBody";

    @Override
    public String getID() {
        return "http.requestCall";
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress && parameters[1] instanceof VarAddress);
        VarAddress targetVar = (VarAddress)parameters[0];
        VarAddress optionsVar = (VarAddress)parameters[1];
        Map options = (Map)environment.getVariable(optionsVar);
        assert (options.containsKey(URL) && options.containsKey(METHOD));
        String url = (String)options.get(URL);
        String method = (String)options.get(METHOD);
        Map headers = (Map)options.get(REQUEST_HEADERS);
        InputStream body = (InputStream)options.get(REQUEST_BODY);
        URL u = new URL(url);
        String protocol = u.getProtocol();
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            InputStream responseStream;
            HttpURLConnection connection;
            if (protocol.equals("http")) {
                connection = (HttpURLConnection)u.openConnection();
            } else if (protocol.equals("https")) {
                connection = (HttpsURLConnection)u.openConnection();
            } else {
                throw new Exception("Unknown protocol");
            }
            connection.setRequestMethod(method);
            connection.setRequestProperty("User-Agent", USER_AGENT);
            if ((method.equals("POST") || method.equals("PUT")) && (headers == null || !headers.containsKey("Content-Type") && !headers.containsKey("content-type"))) {
                connection.setRequestProperty("Content-Type", "");
            }
            if (body != null) {
                if (headers == null || !headers.containsKey("Content-Length") && !headers.containsKey("content-length")) {
                    connection.setChunkedStreamingMode(0);
                } else {
                    int length = headers.containsKey("Content-Length") ? Integer.parseInt((String)headers.get("Content-Length")) : Integer.parseInt((String)headers.get("content-length"));
                    connection.setFixedLengthStreamingMode(length);
                }
            } else if (method.equals("PUT") || method.equals("POST")) {
                body = new ByteArrayInputStream(new byte[0]);
                connection.setFixedLengthStreamingMode(0);
            }
            if (headers != null) {
                for (Map.Entry e : headers.entrySet()) {
                    connection.addRequestProperty((String)e.getKey(), (String)e.getValue());
                }
            }
            if (body != null) {
                int len;
                if (!(body instanceof BufferedInputStream)) {
                    body = new BufferedInputStream(body);
                }
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                byte[] buffer = new byte[0x100000];
                while ((len = body.read(buffer, 0, buffer.length)) != -1) {
                    os.write(buffer, 0, len);
                }
                body.close();
            }
            try {
                responseStream = new BufferedInputStream(connection.getInputStream());
            }
            catch (IOException e) {
                responseStream = connection.getErrorStream();
            }
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
                responseHeaders.put(entry.getKey(), this.join(entry.getValue(), ", "));
            }
            response.put(CODE, connection.getResponseCode());
            response.put(MESSAGE, connection.getResponseMessage());
            response.put(RESPONSE_BODY, responseStream);
            response.put(RESPONSE_HEADERS, responseHeaders);
        }
        catch (ConnectException e) {
            ConnectError errorObj = new ConnectError(e.getMessage());
            environment.setThrownError(errorObj);
        }
        catch (SSLHandshakeException e) {
            ConnectError errorObj = new ConnectError(e.getMessage());
            environment.setThrownError(errorObj);
        }
        catch (UnknownHostException e) {
            ConnectError errorObj = new ConnectError(e.getMessage());
            environment.setThrownError(errorObj);
        }
        environment.setVariable(targetVar, response);
    }

    private String join(List<String> list, String separator) {
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (!first) {
                builder.append(separator);
            }
            builder.append(s);
            first = false;
        }
        return builder.toString();
    }
}

