/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.json;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.ContainerFactory;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.JSONParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Parse
implements Command {
    @Override
    public String getID() {
        return "json.parse";
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        Object input;
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress && (parameters[1] instanceof VarAddress || parameters[1] instanceof InputStream || parameters[1] instanceof String));
        VarAddress result = (VarAddress)parameters[0];
        if (parameters[1] instanceof VarAddress) {
            VarAddress inputAdd = (VarAddress)parameters[1];
            input = environment.getVariable(inputAdd);
            assert (input instanceof InputStream || input instanceof String);
        } else {
            input = parameters[1];
        }
        Object obj = null;
        if (input instanceof InputStream) {
            obj = Parse.parse((InputStream)input);
        } else if (input instanceof String) {
            obj = Parse.parse((String)input);
        }
        environment.setVariable(result, obj);
    }

    public static Object parse(InputStream input) throws Exception {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse((Reader)new InputStreamReader(input), (ContainerFactory)new CloudRailContainerFactory());
        input.close();
        return obj;
    }

    public static Object parse(String input) throws Exception {
        JSONParser parser = new JSONParser();
        return parser.parse(input, (ContainerFactory)new CloudRailContainerFactory());
    }

    private static class CloudRailContainerFactory
    implements ContainerFactory {
        private CloudRailContainerFactory() {
        }

        @Override
        public Map<?, ?> createObjectContainer() {
            return new TreeMap();
        }

        @Override
        public List<?> creatArrayContainer() {
            return new ArrayList();
        }
    }
}

