/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.math;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;

public class Floor
implements Command {
    public static final String COMMAND_ID = "math.floor";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        Object numberObj = parameters[1];
        if (numberObj instanceof VarAddress) {
            numberObj = environment.getVariable((VarAddress)numberObj);
        }
        if (!(numberObj instanceof Number)) {
            throw new IllegalArgumentException("command: math.floor argument number is not from type Number!");
        }
        Long longResult = (long)Math.floor(((Number)numberObj).doubleValue());
        environment.setVariable(resultVar, (Object)longResult);
    }
}

