/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.math;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;

public class Min
implements Command {
    public static final String COMMAND_ID = "math.min";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 2 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        boolean isDouble = false;
        double doubleResult = 0.0;
        long longResult = 0L;
        for (int i = 1; i < parameters.length; ++i) {
            if (parameters[i] instanceof VarAddress) {
                parameters[i] = environment.getVariable((VarAddress)parameters[i]);
            }
            if (!(parameters[i] instanceof Number)) {
                throw new IllegalArgumentException("command: math.min argument #" + i + " is not from type number!");
            }
            boolean bl = isDouble = isDouble || parameters[i] instanceof Double || parameters[i] instanceof Float;
            if (i <= 1) {
                if (isDouble) {
                    doubleResult = ((Number)parameters[i]).doubleValue();
                    continue;
                }
                longResult = ((Number)parameters[i]).longValue();
                doubleResult = longResult;
                continue;
            }
            if (isDouble) {
                doubleResult = Math.min(doubleResult, ((Number)parameters[i]).doubleValue());
                continue;
            }
            longResult = Math.min(longResult, ((Number)parameters[i]).longValue());
            doubleResult = longResult;
        }
        if (isDouble) {
            environment.setVariable(resultVar, (Object)doubleResult);
        } else {
            environment.setVariable(resultVar, (Object)longResult);
        }
    }
}

