/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.stream;

import android.support.annotation.NonNull;
import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.io.IOException;
import java.io.InputStream;

public class MakeLimitedStream
implements Command {
    @Override
    public String getID() {
        return "stream.makeLimitedStream";
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        Number limitNumber;
        InputStream stream;
        assert (parameters.length == 3 && parameters[0] instanceof VarAddress && (parameters[1] instanceof VarAddress || parameters[1] instanceof InputStream) && (parameters[2] instanceof VarAddress || parameters[2] instanceof Number));
        VarAddress resAddress = (VarAddress)parameters[0];
        if (parameters[1] instanceof VarAddress) {
            VarAddress streamAddress = (VarAddress)parameters[1];
            stream = (InputStream)environment.getVariable(streamAddress);
        } else {
            stream = (InputStream)parameters[1];
        }
        if (parameters[2] instanceof VarAddress) {
            VarAddress limitAddress = (VarAddress)parameters[2];
            limitNumber = (Number)environment.getVariable(limitAddress);
        } else {
            limitNumber = (Number)parameters[2];
        }
        long limit = limitNumber.longValue();
        LimitedInputStream result = new LimitedInputStream(stream, limit);
        environment.setVariable(resAddress, (Object)result);
    }

    private class LimitedInputStream
    extends InputStream {
        private InputStream source;
        private long available;

        public LimitedInputStream(InputStream source, long limit) {
            this.source = source;
            this.available = limit;
        }

        @Override
        public int read() throws IOException {
            if (this.available > 0L) {
                --this.available;
                return this.source.read();
            }
            return -1;
        }

        @Override
        public int read(@NonNull byte[] b, int off, int len) throws IOException {
            if (this.available > 0L) {
                len = (int)Math.min((long)len, this.available);
                int read = this.source.read(b, off, len);
                this.available -= (long)read;
                return read;
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

