/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.stream;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class StreamToString
implements Command {
    @Override
    public String getID() {
        return "stream.streamToString";
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        InputStream source;
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress && (parameters[1] instanceof InputStream || parameters[1] instanceof VarAddress));
        VarAddress target = (VarAddress)parameters[0];
        if (parameters[1] instanceof VarAddress) {
            VarAddress streamAddress = (VarAddress)parameters[1];
            source = (InputStream)environment.getVariable(streamAddress);
        } else {
            source = (InputStream)parameters[1];
        }
        String str = StreamToString.dumpStream(source);
        environment.setVariable(target, (Object)str);
    }

    public static String dumpStream(InputStream is) throws IOException {
        Scanner scanner = new Scanner(is);
        scanner.useDelimiter("\\A");
        String str = scanner.hasNext() ? scanner.next() : "";
        scanner.close();
        is.close();
        return str;
    }
}

