/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.string;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.util.ArrayList;

public class ChunkSplit
implements Command {
    public static final String COMMAND_ID = "string.chunkSplit";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length == 3 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        for (int i = 1; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof VarAddress)) continue;
            parameters[i] = environment.getVariable((VarAddress)parameters[i]);
        }
        if (!(parameters[1] instanceof String)) {
            throw new IllegalArgumentException("command: string.chunkSplit parameter sourceString is not from type String!");
        }
        if (!(parameters[2] instanceof Number)) {
            throw new IllegalArgumentException("command: string.chunkSplit parameter chunkSize is not from type Number!");
        }
        String sourceString = (String)parameters[1];
        int chunkSize = ((Number)parameters[2]).intValue();
        ArrayList<String> resultArray = new ArrayList<String>();
        for (int index = 0; index < sourceString.length(); index += chunkSize) {
            resultArray.add(sourceString.substring(index, Math.min(index + chunkSize, sourceString.length())));
        }
        environment.setVariable(resultVar, resultArray);
    }
}

