/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.string;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.util.Arrays;
import java.util.List;

public class Split
implements Command {
    public static final String COMMAND_ID = "string.split";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 3 && parameters.length <= 4 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        for (int i = 1; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof VarAddress)) continue;
            parameters[i] = environment.getVariable((VarAddress)parameters[i]);
        }
        if (!(parameters[1] instanceof String)) {
            throw new IllegalArgumentException("command: string.split parameter sourceString is not from type String!");
        }
        if (!(parameters[2] instanceof String)) {
            throw new IllegalArgumentException("command: string.split parameter regexSeparator is not from type String!");
        }
        String sourceString = (String)parameters[1];
        String regexSeparator = (String)parameters[2];
        int limit = -1;
        if (parameters.length >= 4) {
            if (!(parameters[3] instanceof Number)) {
                throw new IllegalArgumentException("command: string.split parameter limit is not from type Number!");
            }
            limit = ((Number)parameters[3]).intValue();
        }
        List<String> result = Arrays.asList(sourceString.split(regexSeparator, limit));
        environment.setVariable(resultVar, result);
    }
}

