/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.string;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;

public class Substring
implements Command {
    public static final String COMMAND_ID = "string.substring";

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 3 && parameters.length <= 4 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        for (int i = 1; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof VarAddress)) continue;
            parameters[i] = environment.getVariable((VarAddress)parameters[i]);
        }
        if (!(parameters[1] instanceof String)) {
            throw new IllegalArgumentException("command: string.substring parameter sourceString is not from type String!");
        }
        if (!(parameters[2] instanceof Number)) {
            throw new IllegalArgumentException("command: string.substring parameter startIdx is not from type Number!");
        }
        String sourceString = (String)parameters[1];
        int startIdx = ((Number)parameters[2]).intValue();
        int endIdx = sourceString.length();
        if (parameters.length >= 4) {
            if (!(parameters[3] instanceof Number)) {
                throw new IllegalArgumentException("command: string.substring parameter length is not from type Number!");
            }
            endIdx = ((Number)parameters[3]).intValue();
            if (endIdx > sourceString.length()) {
                throw new IllegalArgumentException("command: string.substring parameter endIdx > sourceString_length!");
            }
        }
        String substr = sourceString.substring(startIdx, endIdx);
        environment.setVariable(resultVar, (Object)substr);
    }
}

