/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.xml;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Parse
implements Command {
    @Override
    public String getID() {
        return "xml.parse";
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        Object input;
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress && (parameters[1] instanceof VarAddress || parameters[1] instanceof InputStream || parameters[1] instanceof String));
        VarAddress result = (VarAddress)parameters[0];
        if (parameters[1] instanceof VarAddress) {
            VarAddress inputAdd = (VarAddress)parameters[1];
            input = environment.getVariable(inputAdd);
            assert (input instanceof InputStream || input instanceof String);
        } else {
            input = parameters[1];
        }
        Map<String, Object> content = null;
        if (input instanceof InputStream) {
            content = Parse.parse((InputStream)input);
        } else if (input instanceof String) {
            content = Parse.parse((String)input);
        }
        environment.setVariable(result, content);
    }

    public static Map<String, Object> parse(String input) throws Exception {
        return Parse.parse(new ByteArrayInputStream(input.getBytes("utf-8")));
    }

    public static Map<String, Object> parse(InputStream input) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document root = builder.parse(input);
        return Parse.parseXML(root.getDocumentElement());
    }

    private static Map<String, Object> parseXML(Element element) {
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        NamedNodeMap attributes = element.getAttributes();
        TreeMap<String, String> resAttributes = new TreeMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String key = attribute.getNodeName();
            String value = attribute.getNodeValue();
            resAttributes.put(key, value);
        }
        res.put("attributes", resAttributes);
        res.put("name", element.getTagName());
        String resText = "";
        ArrayList<Map<String, Object>> resChildren = new ArrayList<Map<String, Object>>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            short nodeType = n.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)n;
                resChildren.add(Parse.parseXML(child));
                continue;
            }
            if (nodeType != 3) continue;
            resText = resText + n.getTextContent();
        }
        res.put("text", resText);
        res.put("children", resChildren);
        return res;
    }
}

