/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.xml;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Stringify
implements Command {
    @Override
    public String getID() {
        return "xml.stringify";
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        Object input;
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress && (parameters[1] instanceof VarAddress || parameters[1] instanceof Map));
        VarAddress result = (VarAddress)parameters[0];
        if (parameters[1] instanceof VarAddress) {
            VarAddress inputAdd = (VarAddress)parameters[1];
            input = environment.getVariable(inputAdd);
            assert (input instanceof Map);
        } else {
            input = parameters[1];
        }
        Map object = (Map)input;
        String output = Stringify.stringify(object);
        environment.setVariable(result, (Object)output);
    }

    public static String stringify(Map<String, Object> input) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = Stringify.buildXML(input, doc);
        doc.appendChild(rootElement);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    private static Element buildXML(Map<String, Object> object, Document document) {
        List children;
        String text;
        Element e = document.createElement((String)object.get("name"));
        Map attributes = (Map)object.get("attributes");
        if (attributes != null) {
            for (Map.Entry attribute : attributes.entrySet()) {
                e.setAttribute((String)attribute.getKey(), (String)attribute.getValue());
            }
        }
        if ((text = (String)object.get("text")) != null) {
            Text textNode = document.createTextNode(text);
            e.appendChild(textNode);
        }
        if ((children = (List)object.get("children")) != null) {
            for (Map child : children) {
                Element childXML = Stringify.buildXML(child, document);
                e.appendChild(childXML);
            }
        }
        return e;
    }
}

