/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.BusinessCloudStorage;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Bucket;
import com.cloudrail.si.types.BusinessFileMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AmazonS3
implements BusinessCloudStorage,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"if!=than", "$P0.region", "us-east-1", 2}, new Object[]{"string.concat", "$P0.baseUrl", "s3-", "$P0.region", ".amazonaws.com"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$P0.baseUrl", "s3.amazonaws.com"}, new Object[]{"set", "$P0.empty_body_hash", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855"}, new Object[]{"set", "$P0.chunk_size", 0x500000}});
            this.put("listBuckets", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.baseUrl"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L1.host", "$P0.baseUrl"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L1.x-amz-date"}, new Object[]{"set", "$L1.x-amz-content-sha256", "$P0.empty_body_hash"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"callFunc", "signRequest", "$P0", "$L0", null, null, "$L10", "$P0.empty_body_hash"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2", 200}, new Object[]{"xml.parse", "$L3", "$L2.responseBody"}, new Object[]{"get", "$L4", "$L3.children.1"}, new Object[]{"size", "$L5", "$L4.children"}, new Object[]{"create", "$L6", "Number", 0}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if<than", "$L6", "$L5", 7}, new Object[]{"get", "$L7", "$L4.children", "$L6"}, new Object[]{"create", "$L8", "Bucket"}, new Object[]{"set", "$L8.name", "$L7.children.0.text"}, new Object[]{"set", "$L8.identifier", "$L7.children.0.text"}, new Object[]{"push", "$P1", "$L8"}, new Object[]{"math.add", "$L6", "$L6", 1}, new Object[]{"jumpRel", -8}});
            this.put("createBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "PUT"}, new Object[]{"string.concat", "$L0.url", "https://", "$P2", ".", "$P0.baseUrl"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.host", "$P2", ".", "$P0.baseUrl"}, new Object[]{"set", "$L1.x-amz-acl", "private"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L1.x-amz-date"}, new Object[]{"if!=than", "$P0.region", "us-east-1", 19}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.name", "CreateBucketConfiguration"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.xmlns", "http://s3.amazonaws.com/doc/2006-03-01/"}, new Object[]{"set", "$L2.attributes", "$L3"}, new Object[]{"create", "$L3", "Array"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4.name", "LocationConstraint"}, new Object[]{"set", "$L4.text", "$P0.region"}, new Object[]{"push", "$L3", "$L4"}, new Object[]{"set", "$L2.children", "$L3"}, new Object[]{"xml.stringify", "$L3", "$L2"}, new Object[]{"size", "$L1.content-length", "$L3"}, new Object[]{"string.concat", "$L1.content-length", "$L1.content-length", ""}, new Object[]{"set", "$L1.content-type", "text/plain"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L3"}, new Object[]{"hash.sha256", "$L4", "$L3"}, new Object[]{"callFunc", "arrayToHex", "$P0", "$L1.x-amz-content-sha256", "$L4"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L1.x-amz-content-sha256", "$P0.empty_body_hash"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"if!=than", "$P0.region", "us-east-1", 2}, new Object[]{"push", "$L10", "content-length"}, new Object[]{"push", "$L10", "content-type"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-acl"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"callFunc", "signRequest", "$P0", "$L0", null, null, "$L10", "$L1.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5", 200}, new Object[]{"create", "$P1", "Bucket"}, new Object[]{"set", "$P1.name", "$P2"}, new Object[]{"set", "$P1.identifier", "$P2"}});
            this.put("deleteBucket", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "DELETE"}, new Object[]{"string.concat", "$L0.url", "https://", "$P1.name", ".", "$P0.baseUrl"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.host", "$P1.name", ".", "$P0.baseUrl"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L1.x-amz-date"}, new Object[]{"set", "$L1.x-amz-content-sha256", "$P0.empty_body_hash"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"callFunc", "signRequest", "$P0", "$L0", null, null, "$L10", "$L1.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2", 204}});
            this.put("listFiles", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"callFunc", "listFilesChunk", "$P0", "$L1", "$P2.name", "$L0", null}, new Object[]{"set", "$L0", null}, new Object[]{"size", "$L2", "$L1.children"}, new Object[]{"create", "$L3", "Number", 0}, new Object[]{"if<than", "$L3", "$L2", 13}, new Object[]{"get", "$L4", "$L1.children", "$L3"}, new Object[]{"if==than", "$L4.name", "NextContinuationToken", 1}, new Object[]{"set", "$L0", "$L4.text"}, new Object[]{"if==than", "$L4.name", "Contents", 7}, new Object[]{"create", "$L5", "BusinessFileMetaData"}, new Object[]{"set", "$L5.fileName", "$L4.children.0.text"}, new Object[]{"set", "$L5.fileID", "$L4.children.0.text"}, new Object[]{"math.add", "$L5.size", "$L4.children.3.text", 0}, new Object[]{"create", "$L6", "Date", "$L4.children.1.text"}, new Object[]{"set", "$L5.lastModified", "$L6.time"}, new Object[]{"push", "$P1", "$L5"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -14}, new Object[]{"if!=than", "$L0", null, 1}, new Object[]{"jumpRel", -20}});
            this.put("listFilesWithPrefix", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkPrefix", "$P0", "$P3"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"callFunc", "listFilesChunk", "$P0", "$L1", "$P2.name", "$L0", "$P3"}, new Object[]{"set", "$L0", null}, new Object[]{"size", "$L2", "$L1.children"}, new Object[]{"create", "$L3", "Number", 0}, new Object[]{"if<than", "$L3", "$L2", 13}, new Object[]{"get", "$L4", "$L1.children", "$L3"}, new Object[]{"if==than", "$L4.name", "NextContinuationToken", 1}, new Object[]{"set", "$L0", "$L4.text"}, new Object[]{"if==than", "$L4.name", "Contents", 7}, new Object[]{"create", "$L5", "BusinessFileMetaData"}, new Object[]{"set", "$L5.fileName", "$L4.children.0.text"}, new Object[]{"set", "$L5.fileID", "$L4.children.0.text"}, new Object[]{"math.add", "$L5.size", "$L4.children.3.text", 0}, new Object[]{"create", "$L6", "Date", "$L4.children.1.text"}, new Object[]{"set", "$L5.lastModified", "$L6.time"}, new Object[]{"push", "$P1", "$L5"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -14}, new Object[]{"if!=than", "$L0", null, 1}, new Object[]{"jumpRel", -20}});
            this.put("checkPrefix", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L1", "Error", "Prefix supplied is null", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("getFileMetadata", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "HEAD"}, new Object[]{"string.concat", "$L0.url", "https://", "$P2.name", ".", "$P0.baseUrl", "/", "$P3"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.host", "$P2.name", ".", "$P0.baseUrl"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L1.x-amz-date"}, new Object[]{"set", "$L1.x-amz-content-sha256", "$P0.empty_body_hash"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"callFunc", "signRequest", "$P0", "$L0", null, null, "$L10", "$L1.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2", 200}, new Object[]{"get", "$L3", "$L2.responseHeaders"}, new Object[]{"create", "$P1", "BusinessFileMetaData"}, new Object[]{"set", "$P1.fileName", "$P3"}, new Object[]{"set", "$P1.fileID", "$P3"}, new Object[]{"math.add", "$P1.size", "$L3.Content-Length", 0}, new Object[]{"callFunc", "parseDate", "$P0", "$P1.lastModified", "$L3.Last-Modified"}});
            this.put("deleteFile", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P1"}, new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "DELETE"}, new Object[]{"string.concat", "$L0.url", "https://", "$P2.name", ".", "$P0.baseUrl", "/", "$P1"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.host", "$P2.name", ".", "$P0.baseUrl"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L1.x-amz-date"}, new Object[]{"set", "$L1.x-amz-content-sha256", "$P0.empty_body_hash"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"callFunc", "signRequest", "$P0", "$L0", null, null, "$L10", "$L1.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2", 204}});
            this.put("uploadFile", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"callFunc", "checkSize", "$P0", "$P4"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://", "$P1.name", ".", "$P0.baseUrl", "/", "$P2", "?uploads"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.host", "$P1.name", ".", "$P0.baseUrl"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L1.x-amz-date"}, new Object[]{"set", "$L1.x-amz-content-sha256", "$P0.empty_body_hash"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"create", "$L11", "Object"}, new Object[]{"set", "$L11.uploads", ""}, new Object[]{"create", "$L12", "Array"}, new Object[]{"push", "$L12", "uploads"}, new Object[]{"callFunc", "signRequest", "$P0", "$L0", "$L11", "$L12", "$L10", "$L1.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2", 200}, new Object[]{"xml.parse", "$L3", "$L2.responseBody"}, new Object[]{"get", "$L0", "$L3.children.2.text"}, new Object[]{"create", "$L1", "Number", 1}, new Object[]{"create", "$L2", "Number", 0}, new Object[]{"create", "$L20", "Array"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.method", "PUT"}, new Object[]{"string.concat", "$L3.url", "https://", "$P1.name", ".", "$P0.baseUrl", "/", "$P2", "?partNumber=", "$L1", "&uploadId=", "$L0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L3.requestHeaders", "$L4"}, new Object[]{"string.concat", "$L4.host", "$P1.name", ".", "$P0.baseUrl"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L4.x-amz-date"}, new Object[]{"set", "$L4.content-type", "application/octet-stream"}, new Object[]{"math.add", "$L5", "$L2", "$P0.chunk_size"}, new Object[]{"if>than", "$L5", "$P4", 6}, new Object[]{"math.multiply", "$L6", "$L2", -1}, new Object[]{"math.add", "$L6", "$P4", "$L6"}, new Object[]{"string.concat", "$L4.content-length", "$L6", ""}, new Object[]{"stream.makeLimitedStream", "$L7", "$P3", "$L6"}, new Object[]{"set", "$L2", "$P4"}, new Object[]{"jumpRel", 3}, new Object[]{"string.concat", "$L4.content-length", "$P0.chunk_size"}, new Object[]{"stream.makeLimitedStream", "$L7", "$P3", "$P0.chunk_size"}, new Object[]{"math.add", "$L2", "$L2", "$P0.chunk_size"}, new Object[]{"stream.streamToData", "$L8", "$L7"}, new Object[]{"hash.sha256", "$L9", "$L8"}, new Object[]{"callFunc", "arrayToHex", "$P0", "$L4.x-amz-content-sha256", "$L9"}, new Object[]{"stream.dataToStream", "$L3.requestBody", "$L8"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"push", "$L10", "content-length"}, new Object[]{"push", "$L10", "content-type"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"create", "$L11", "Object"}, new Object[]{"string.concat", "$L11.partNumber", "$L1", ""}, new Object[]{"set", "$L11.uploadId", "$L0"}, new Object[]{"create", "$L12", "Array"}, new Object[]{"push", "$L12", "partNumber"}, new Object[]{"push", "$L12", "uploadId"}, new Object[]{"callFunc", "signRequest", "$P0", "$L3", "$L11", "$L12", "$L10", "$L4.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L13", "$L3"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L13", 200}, new Object[]{"push", "$L20", "$L13.responseHeaders.ETag"}, new Object[]{"if<than", "$L2", "$P4", 2}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -42}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.method", "POST"}, new Object[]{"string.concat", "$L1.url", "https://", "$P1.name", ".", "$P0.baseUrl", "/", "$P2", "?uploadId=", "$L0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L1.requestHeaders", "$L2"}, new Object[]{"string.concat", "$L2.host", "$P1.name", ".", "$P0.baseUrl"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L2.x-amz-date"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.name", "CompleteMultipartUpload"}, new Object[]{"create", "$L3.children", "Array"}, new Object[]{"size", "$L4", "$L20"}, new Object[]{"create", "$L5", "Number", 0}, new Object[]{"if<than", "$L5", "$L4", 15}, new Object[]{"create", "$L6", "Object"}, new Object[]{"set", "$L6.name", "Part"}, new Object[]{"create", "$L6.children", "Array"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.name", "PartNumber"}, new Object[]{"math.add", "$L8", "$L5", 1}, new Object[]{"string.concat", "$L7.text", "$L8", ""}, new Object[]{"push", "$L6.children", "$L7"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.name", "ETag"}, new Object[]{"get", "$L7.text", "$L20", "$L5"}, new Object[]{"push", "$L6.children", "$L7"}, new Object[]{"push", "$L3.children", "$L6"}, new Object[]{"math.add", "$L5", "$L5", 1}, new Object[]{"jumpRel", -16}, new Object[]{"xml.stringify", "$L4", "$L3"}, new Object[]{"size", "$L2.content-length", "$L4"}, new Object[]{"string.concat", "$L2.content-length", "$L2.content-length", ""}, new Object[]{"stream.stringToStream", "$L1.requestBody", "$L4"}, new Object[]{"hash.sha256", "$L5", "$L4"}, new Object[]{"callFunc", "arrayToHex", "$P0", "$L2.x-amz-content-sha256", "$L5"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"push", "$L10", "content-length"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"create", "$L11", "Object"}, new Object[]{"set", "$L11.uploadId", "$L0"}, new Object[]{"create", "$L12", "Array"}, new Object[]{"push", "$L12", "uploadId"}, new Object[]{"callFunc", "signRequest", "$P0", "$L1", "$L11", "$L12", "$L10", "$L2.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L6", "$L1"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6", 200}});
            this.put("downloadFile", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkBucket", "$P0", "$P3"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://", "$P3.name", ".", "$P0.baseUrl", "/", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.host", "$P3.name", ".", "$P0.baseUrl"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L1.x-amz-date"}, new Object[]{"set", "$L1.x-amz-content-sha256", "$P0.empty_body_hash"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"callFunc", "signRequest", "$P0", "$L0", null, null, "$L10", "$L1.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2", 200}, new Object[]{"set", "$P1", "$L2.responseBody"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 2}, new Object[]{"create", "$L1", "Error", "Disable base URL appending and provide a full URL."}, new Object[]{"throwError", "$L1"}, new Object[]{"set", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"if!=than", "$P2.body", null, 1}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 23}, new Object[]{"callFunc", "extractQuery", "$P0", "$L1", "$L0.url"}, new Object[]{"if!=than", "$L1", null, 2}, new Object[]{"object.getKeyArray", "$L2", "$L1"}, new Object[]{"array.sort", "$L3", "$L2"}, new Object[]{"if==than", "$L0.requestHeaders.x-amz-content-sha256", null, 7}, new Object[]{"if==than", "$P2.body", null, 2}, new Object[]{"set", "$L0.requestHeaders.x-amz-content-sha256", "$P0.empty_body_hash"}, new Object[]{"jumpRel", 4}, new Object[]{"stream.streamToData", "$L4", "$P2.body"}, new Object[]{"hash.sha256", "$L5", "$L4"}, new Object[]{"callFunc", "arrayToHex", "$P0", "$L0.requestHeaders.x-amz-content-sha256", "$L5"}, new Object[]{"stream.dataToStream", "$L0.requestBody", "$L4"}, new Object[]{"if==than", "$L0.requestHeaders.x-amz-date", null, 1}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L0.requestHeaders.x-amz-date"}, new Object[]{"if==than", "$L0.requestHeaders.host", null, 5}, new Object[]{"string.indexOf", "$L4", "$L0.url", "/", 10}, new Object[]{"if==than", "$L4", -1, 2}, new Object[]{"string.substring", "$L0.requestHeaders.host", "$L0.url", 8}, new Object[]{"jumpRel", 1}, new Object[]{"string.substring", "$L0.requestHeaders.host", "$L0.url", 8, "$L4"}, new Object[]{"object.getKeyArray", "$L4", "$L0.requestHeaders"}, new Object[]{"array.sort", "$L5", "$L4"}, new Object[]{"callFunc", "signRequest", "$P0", "$L0", "$L1", "$L3", "$L5", "$L0.requestHeaders.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("extractQuery", new Object[]{new Object[]{"string.split", "$L0", "$P2", "\\?", 2}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"if==than", "$L1", 1, 1}, new Object[]{"return"}, new Object[]{"create", "$P1", "Object"}, new Object[]{"string.split", "$L1", "$L0.1", "&"}, new Object[]{"size", "$L2", "$L1"}, new Object[]{"create", "$L3", "Number", 0}, new Object[]{"if<than", "$L3", "$L2", 9}, new Object[]{"get", "$L4", "$L1", "$L3"}, new Object[]{"string.split", "$L5", "$L4", "="}, new Object[]{"size", "$L6", "$L5"}, new Object[]{"if==than", "$L6", 1, 2}, new Object[]{"set", "$P1", "", "$L5.0"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$P1", "$L5.1", "$L5.0"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -10}});
            this.put("validateResponse", new Object[]{new Object[]{"if==than", "$P2", null, 2}, new Object[]{"if>=than", "$P1.code", 400, 20}, new Object[]{"jumpRel", 1}, new Object[]{"if!=than", "$P1.code", "$P2", 18}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L1", "Error", "File does not exist", "NotFound"}, new Object[]{"throwError", "$L1"}, new Object[]{"stream.streamToString", "$L0", "$P1.responseBody"}, new Object[]{"string.indexOf", "$L1", "$L0", "Your previous request to create the named bucket succeeded"}, new Object[]{"if!=than", "$L1", -1, 2}, new Object[]{"create", "$L1", "Error", "Bucket already exists!", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"string.indexOf", "$L1", "$L0", "The specified key does not exist"}, new Object[]{"if!=than", "$L1", -1, 2}, new Object[]{"create", "$L1", "Error", "File does not exist", "NotFound"}, new Object[]{"throwError", "$L1"}, new Object[]{"string.indexOf", "$L1", "$L0", "The specified bucket does not exist"}, new Object[]{"if!=than", "$L1", -1, 2}, new Object[]{"create", "$L1", "Error", "Bucket does not exist", "NotFound"}, new Object[]{"throwError", "$L1"}, new Object[]{"create", "$L1", "Error", "$L0", "Http"}, new Object[]{"throwError", "$L1"}});
            this.put("signRequest", new Object[]{new Object[]{"create", "$L0", "String", ""}, new Object[]{"string.concat", "$L0", "$P1.method", "\n"}, new Object[]{"string.indexOf", "$L1", "$P1.url", "amazonaws.com"}, new Object[]{"math.add", "$L1", "$L1", 13}, new Object[]{"string.indexOf", "$L2", "$P1.url", "?"}, new Object[]{"if==than", "$L2", -1, 2}, new Object[]{"string.substring", "$L1", "$P1.url", "$L1"}, new Object[]{"jumpRel", 1}, new Object[]{"string.substring", "$L1", "$P1.url", "$L1", "$L2"}, new Object[]{"if==than", "$L1", "", 1}, new Object[]{"set", "$L1", "/"}, new Object[]{"string.concat", "$L0", "$L0", "$L1", "\n"}, new Object[]{"if==than", "$P2", null, 2}, new Object[]{"string.concat", "$L0", "$L0", "\n"}, new Object[]{"jumpRel", 13}, new Object[]{"size", "$L1", "$P3"}, new Object[]{"create", "$L2", "Number", 0}, new Object[]{"create", "$L3", "String", ""}, new Object[]{"if<than", "$L2", "$L1", 7}, new Object[]{"get", "$L4", "$P3", "$L2"}, new Object[]{"get", "$L5", "$P2", "$L4"}, new Object[]{"string.urlEncode", "$L4", "$L4"}, new Object[]{"string.urlEncode", "$L5", "$L5"}, new Object[]{"string.concat", "$L3", "$L3", "&", "$L4", "=", "$L5"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -8}, new Object[]{"string.substring", "$L3", "$L3", 1}, new Object[]{"string.concat", "$L0", "$L0", "$L3", "\n"}, new Object[]{"size", "$L1", "$P4"}, new Object[]{"create", "$L2", "Number", 0}, new Object[]{"if<than", "$L2", "$L1", 5}, new Object[]{"get", "$L3", "$P4", "$L2"}, new Object[]{"get", "$L4", "$P1.requestHeaders", "$L3"}, new Object[]{"string.concat", "$L0", "$L0", "$L3", ":", "$L4", "\n"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -6}, new Object[]{"string.concat", "$L0", "$L0", "\n"}, new Object[]{"size", "$L1", "$P4"}, new Object[]{"create", "$L2", "Number", 0}, new Object[]{"create", "$L11", "String", ""}, new Object[]{"if<than", "$L2", "$L1", 8}, new Object[]{"if!=than", "$L2", 0, 2}, new Object[]{"string.concat", "$L0", "$L0", ";"}, new Object[]{"string.concat", "$L11", "$L11", ";"}, new Object[]{"get", "$L3", "$P4", "$L2"}, new Object[]{"string.concat", "$L0", "$L0", "$L3"}, new Object[]{"string.concat", "$L11", "$L11", "$L3"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -9}, new Object[]{"string.concat", "$L0", "$L0", "\n"}, new Object[]{"string.concat", "$L0", "$L0", "$P5"}, new Object[]{"hash.sha256", "$L1", "$L0"}, new Object[]{"callFunc", "arrayToHex", "$P0", "$L0", "$L1"}, new Object[]{"string.substring", "$L1", "$P1.requestHeaders.x-amz-date", 0, 8}, new Object[]{"string.concat", "$L1", "$L1", "/", "$P0.region", "/s3/aws4_request"}, new Object[]{"string.concat", "$L0", "AWS4-HMAC-SHA256\n", "$P1.requestHeaders.x-amz-date", "\n", "$L1", "\n", "$L0"}, new Object[]{"string.substring", "$L1", "$P1.requestHeaders.x-amz-date", 0, 8}, new Object[]{"string.concat", "$L2", "AWS4", "$P0.secretAccessKey"}, new Object[]{"crypt.hmac.sha256", "$L3", "$L2", "$L1"}, new Object[]{"crypt.hmac.sha256", "$L3", "$L3", "$P0.region"}, new Object[]{"crypt.hmac.sha256", "$L3", "$L3", "s3"}, new Object[]{"crypt.hmac.sha256", "$L3", "$L3", "aws4_request"}, new Object[]{"crypt.hmac.sha256", "$L3", "$L3", "$L0"}, new Object[]{"callFunc", "arrayToHex", "$P0", "$L4", "$L3"}, new Object[]{"string.substring", "$L1", "$P1.requestHeaders.x-amz-date", 0, 8}, new Object[]{"string.concat", "$P1.requestHeaders.Authorization", "AWS4-HMAC-SHA256 Credential=", "$P0.accessKeyId", "/", "$L1", "/", "$P0.region", "/s3/aws4_request,SignedHeaders=", "$L11", ",Signature=", "$L4"}});
            this.put("listFilesChunk", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://", "$P2", ".", "$P0.baseUrl", "?list-type=2"}, new Object[]{"if!=than", "$P3", null, 3}, new Object[]{"string.urlEncode", "$L1", "$P3"}, new Object[]{"string.concat", "$L2", "$L0.url", "&continuation-token=", "$L1"}, new Object[]{"string.concat", "$L0.url", "$L2"}, new Object[]{"if!=than", "$P4", null, 3}, new Object[]{"string.urlEncode", "$L1", "$P4"}, new Object[]{"string.concat", "$L3", "$L0.url", "&prefix=", "$L1"}, new Object[]{"string.concat", "$L0.url", "$L3"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.host", "$P2", ".", "$P0.baseUrl"}, new Object[]{"callFunc", "getCurrentDate", "$P0", "$L1.x-amz-date"}, new Object[]{"set", "$L1.x-amz-content-sha256", "$P0.empty_body_hash"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"push", "$L10", "host"}, new Object[]{"push", "$L10", "x-amz-content-sha256"}, new Object[]{"push", "$L10", "x-amz-date"}, new Object[]{"create", "$L11", "Object"}, new Object[]{"set", "$L11.list-type", "2"}, new Object[]{"create", "$L12", "Array"}, new Object[]{"if!=than", "$P3", null, 2}, new Object[]{"push", "$L12", "continuation-token"}, new Object[]{"set", "$L11.continuation-token", "$P3"}, new Object[]{"push", "$L12", "list-type"}, new Object[]{"if!=than", "$P4", null, 2}, new Object[]{"push", "$L12", "prefix"}, new Object[]{"set", "$L11.prefix", "$P4"}, new Object[]{"callFunc", "signRequest", "$P0", "$L0", "$L11", "$L12", "$L10", "$L1.x-amz-content-sha256"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2", 200}, new Object[]{"xml.parse", "$P1", "$L2.responseBody"}});
            this.put("parseDate", new Object[]{new Object[]{"string.substr", "$L0", "$P2", 5, 2}, new Object[]{"string.substr", "$L1", "$P2", 8, 3}, new Object[]{"callFunc", "getMonthNumber", "$P0", "$L6", "$L1"}, new Object[]{"string.substr", "$L2", "$P2", 12, 4}, new Object[]{"string.substr", "$L3", "$P2", 17, 8}, new Object[]{"string.concat", "$L4", "$L2", "-", "$L6", "-", "$L0", "T", "$L3", "Z"}, new Object[]{"create", "$L5", "Date", "$L4"}, new Object[]{"set", "$P1", "$L5.time"}});
            this.put("getMonthNumber", new Object[]{new Object[]{"if==than", "$P2", "Jan", 2}, new Object[]{"set", "$P1", "01"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Feb", 2}, new Object[]{"set", "$P1", "02"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Mar", 2}, new Object[]{"set", "$P1", "03"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Apr", 2}, new Object[]{"set", "$P1", "04"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "May", 2}, new Object[]{"set", "$P1", "05"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Jun", 2}, new Object[]{"set", "$P1", "06"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Jul", 2}, new Object[]{"set", "$P1", "07"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Aug", 2}, new Object[]{"set", "$P1", "08"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Sep", 2}, new Object[]{"set", "$P1", "09"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Oct", 2}, new Object[]{"set", "$P1", "10"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Nov", 2}, new Object[]{"set", "$P1", "11"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Dec", 2}, new Object[]{"set", "$P1", "12"}, new Object[]{"return"}, new Object[]{"create", "$L0", "Error", "Could not recognize month in Date"}, new Object[]{"throwError", "$L0"}});
            this.put("arrayToHex", new Object[]{new Object[]{"size", "$L1", "$P2"}, new Object[]{"set", "$L2", 0}, new Object[]{"create", "$P1", "String", ""}, new Object[]{"get", "$L3", "$P2", "$L2"}, new Object[]{"string.format", "$L4", "%02x", "$L3"}, new Object[]{"string.concat", "$P1", "$P1", "$L4"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"if>=than", "$L2", "$L1", -5}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Parameter should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P1"}, new Object[]{"if==than", "$P1.name", null, 3}, new Object[]{"if==than", "$P1.identifier", null, 2}, new Object[]{"create", "$L0", "Error", "Bucket name and identifier should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkSize", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Size can not be negative.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("getCurrentDate", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"set", "$L1", "$L0.rfcTime1123"}, new Object[]{"create", "$P1", "String", ""}, new Object[]{"string.substring", "$L2", "$L1", 12, 16}, new Object[]{"string.concat", "$P1", "$P1", "$L2"}, new Object[]{"string.substring", "$L2", "$L1", 8, 11}, new Object[]{"callFunc", "getMonthNumber", "$P0", "$L3", "$L2"}, new Object[]{"string.concat", "$P1", "$P1", "$L3"}, new Object[]{"string.substring", "$L2", "$L1", 5, 7}, new Object[]{"string.concat", "$P1", "$P1", "$L2", "T"}, new Object[]{"string.substring", "$L2", "$L1", 17, 19}, new Object[]{"string.concat", "$P1", "$P1", "$L2"}, new Object[]{"string.substring", "$L2", "$L1", 20, 22}, new Object[]{"string.concat", "$P1", "$P1", "$L2"}, new Object[]{"string.substring", "$L2", "$L1", 23, 25}, new Object[]{"string.concat", "$P1", "$P1", "$L2", "Z"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public AmazonS3(Context context, String accessKeyId, String secretAccessKey, String region) {
        this.initDataStructures(context);
        this.interpreterStorage.put("accessKeyId", accessKeyId);
        this.interpreterStorage.put("secretAccessKey", secretAccessKey);
        this.interpreterStorage.put("region", region);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to AmazonS3...");
        new InitSelfTestTask("AmazonS3", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Bucket createBucket(String bucketName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "createBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createBucket", this.interpreterStorage, null, bucketName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "createBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Bucket)ip.getParameter(1);
    }

    @Override
    public List<Bucket> listBuckets() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "listBuckets").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listBuckets", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "listBuckets").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void deleteBucket(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "deleteBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("deleteBucket", this.interpreterStorage, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "deleteBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void deleteFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "deleteFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("deleteFile", this.interpreterStorage, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "deleteFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public BusinessFileMetaData getFileMetadata(Bucket bucket, String fileName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "getFileMetadata").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getFileMetadata", this.interpreterStorage, null, bucket, fileName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "getFileMetadata").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (BusinessFileMetaData)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFiles(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "listFiles").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listFiles", this.interpreterStorage, null, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "listFiles").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFilesWithPrefix(Bucket bucket, String prefix) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "listFilesWithPrefix").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listFilesWithPrefix", this.interpreterStorage, null, bucket, prefix);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "listFilesWithPrefix").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void uploadFile(Bucket bucket, String name, InputStream stream, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "uploadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("uploadFile", this.interpreterStorage, bucket, name, stream, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "uploadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public InputStream downloadFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "downloadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("downloadFile", this.interpreterStorage, null, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "downloadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "AmazonS3", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("AmazonS3", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

