/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.BusinessCloudStorage;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Bucket;
import com.cloudrail.si.types.BusinessFileMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Backblaze
implements BusinessCloudStorage,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("Storage:createBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/json", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "Authorization"}, new Object[]{"string.concat", "$L9", "{\"accountId\":\"", "$P0.accountID", "\",\"bucketName\":\"", "$P2", "\",\"bucketType\":\"allPrivate\"}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.apiUrl", "/b2api/v1/b2_create_bucket"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"json.parse", "$L12", "$L12"}, new Object[]{"create", "$L5", "Bucket"}, new Object[]{"set", "$L5.name", "$P2"}, new Object[]{"set", "$L5.identifier", "$L12.bucketId"}, new Object[]{"set", "$P1", "$L5"}});
            this.put("Storage:deleteBucket", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/json", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "Authorization"}, new Object[]{"string.concat", "$L9", "{\"accountId\":\"", "$P0.accountID", "\",\"bucketId\":\"", "$P1.identifier", "\"}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.apiUrl", "/b2api/v1/b2_delete_bucket"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}});
            this.put("Storage:listBuckets", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "Authorization"}, new Object[]{"string.concat", "$L9", "{\"accountId\":\"", "$P0.accountID", "\"}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.apiUrl", "/b2api/v1/b2_list_buckets"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"json.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12.buckets"}, new Object[]{"create", "$L14", "Array"}, new Object[]{"if!=than", "$L10", 0, 7}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "Bucket"}, new Object[]{"get", "$L15", "$L12.buckets", "$L10"}, new Object[]{"set", "$L13.identifier", "$L15.bucketId"}, new Object[]{"set", "$L13.name", "$L15.bucketName"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -8}, new Object[]{"set", "$P1", "$L14"}});
            this.put("Storage:getFileMetadata", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$S0.apiUrl", "/b2api/v1/b2_list_file_names"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L1.Authorization", "$S0.authorizationToken"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.bucketId", "$P2.identifier"}, new Object[]{"set", "$L2.startFileName", "$P3"}, new Object[]{"set", "$L2.maxFileCount", 1}, new Object[]{"json.stringify", "$L3", "$L2"}, new Object[]{"size", "$L4", "$L3"}, new Object[]{"string.concat", "$L4", "$L4"}, new Object[]{"set", "$L1.Content-Length", "$L4"}, new Object[]{"stream.stringToStream", "$L3", "$L3"}, new Object[]{"set", "$L0.requestBody", "$L3"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4", "list file names", 200}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"size", "$L6", "$L5.files"}, new Object[]{"if==than", "$L6", 0, 2}, new Object[]{"create", "$L6", "Error", "File not found!", "NotFound"}, new Object[]{"throwError", "$L6"}, new Object[]{"get", "$L6", "$L5.files", 0}, new Object[]{"if!=than", "$P3", "$L6.fileName", 2}, new Object[]{"create", "$L7", "Error", "File not found!", "NotFound"}, new Object[]{"throwError", "$L7"}, new Object[]{"create", "$P1", "BusinessFileMetaData"}, new Object[]{"set", "$P1.fileName", "$L6.fileName"}, new Object[]{"set", "$P1.fileID", "$L6.fileId"}, new Object[]{"set", "$P1.size", "$L6.contentLength"}, new Object[]{"set", "$P1.lastModified", "$L6.uploadTimestamp"}});
            this.put("Storage:upload", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"callFunc", "checkSize", "$P0", "$P4"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "getUploadURL", "$P0", "$P1"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/octet-stream", "Content-Type"}, new Object[]{"set", "$L4", "$S0.uploadAuthorizationToken", "Authorization"}, new Object[]{"set", "$L4", "$P2", "X-Bz-File-Name"}, new Object[]{"stream.streamToData", "$L3", "$P3"}, new Object[]{"hash.sha1", "$L2", "$L3"}, new Object[]{"callFunc", "arrayToHex", "$P0", "$L20", "$L2"}, new Object[]{"set", "$L4", "$L20", "X-Bz-Content-Sha1"}, new Object[]{"string.concat", "$L4.Content-Length", "$P4"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "$S0.uploadURL"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.dataToStream", "$L3", "$L3"}, new Object[]{"set", "$L5.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"json.parse", "$L12", "$L12"}, new Object[]{"set", "$P1", "$L12.bucketId"}});
            this.put("Storage:download", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkBucket", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "Authorization"}, new Object[]{"string.concat", "$L1", "$S0.downloadUrl", "/file/", "$P3.name", "/", "$P2"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "$L1"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"set", "$P1", "$L6.responseBody"}});
            this.put("Storage:listFiles", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "Authorization"}, new Object[]{"string.concat", "$L9", "{\"bucketId\":\"", "$P2.identifier", "\"", ",", "\"maxFileCount\":", 1000, "}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.apiUrl", "/b2api/v1/b2_list_file_names"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"create", "$L14", "Array"}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"json.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12.files"}, new Object[]{"if!=than", "$L10", 0, 9}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "BusinessFileMetaData"}, new Object[]{"get", "$L15", "$L12.files", "$L10"}, new Object[]{"set", "$L13.fileID", "$L15.fileId"}, new Object[]{"set", "$L13.fileName", "$L15.fileName"}, new Object[]{"set", "$L13.lastModified", "$L15.uploadTimestamp"}, new Object[]{"set", "$L13.size", "$L15.contentLength"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -10}, new Object[]{"if!=than", "$L12.nextFileName", null, 9}, new Object[]{"string.concat", "$L9", "{\"bucketId\":\"", "$P2.identifier", "\"", ",", "\"maxFileCount\":", 1000, ",", "\"startFileName\":", "\"", "$L12.nextFileName", "\"", "}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"jumpRel", -23}, new Object[]{"set", "$P1", "$L14"}});
            this.put("Storage:listFilesWithPrefix", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkPrefix", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "Authorization"}, new Object[]{"string.concat", "$L9", "{\"bucketId\":\"", "$P2.identifier", "\"", ",", "\"maxFileCount\":", 1000, ",", "\"prefix\":\"", "$P3", "\"", "}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.apiUrl", "/b2api/v1/b2_list_file_names"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"create", "$L14", "Array"}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"json.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12.files"}, new Object[]{"if!=than", "$L10", 0, 9}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "BusinessFileMetaData"}, new Object[]{"get", "$L15", "$L12.files", "$L10"}, new Object[]{"set", "$L13.fileID", "$L15.fileId"}, new Object[]{"set", "$L13.fileName", "$L15.fileName"}, new Object[]{"set", "$L13.lastModified", "$L15.uploadTimestamp"}, new Object[]{"set", "$L13.size", "$L15.contentLength"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -10}, new Object[]{"if!=than", "$L12.nextFileName", null, 9}, new Object[]{"string.concat", "$L9", "{\"bucketId\":\"", "$P2.identifier", "\"", ",", "\"maxFileCount\":", 1000, ",", "\"startFileName\":", "\"", "$L12.nextFileName", "\"", "}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"jumpRel", -23}, new Object[]{"set", "$P1", "$L14"}});
            this.put("checkPrefix", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L1", "Error", "Prefix supplied is null", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("Storage:deleteFile", new Object[]{new Object[]{"callFunc", "Storage:getFileMetadata", "$P0", "$L0", "$P2", "$P1"}, new Object[]{"get", "$L15", "$L0.fileID"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "Authorization"}, new Object[]{"string.concat", "$L9", "{\"fileName\":\"", "$P1", "\",\"fileId\":\"", "$L15", "\"}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.apiUrl", "/b2api/v1/b2_delete_file_version"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 3}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.url", "$S0.apiUrl", "$P2.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"set", "$L0.requestHeaders.Authorization", "$S0.authorizationToken"}, new Object[]{"if!=than", "$P2.body", null, 6}, new Object[]{"if==than", "$L0.requestHeaders.Content-Length", null, 5}, new Object[]{"jumpRel", 1}, new Object[]{"if==than", "$L0.requestHeaders.content-length", null, 3}, new Object[]{"stream.streamToString", "$L1", "$L0.requestBody"}, new Object[]{"size", "$L2", "$L1"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Length", "$L2", ""}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L1", "advancedRequest"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("getUploadURL", new Object[]{new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "Authorization"}, new Object[]{"string.concat", "$L9", "{\"bucketId\":\"", "$P1.identifier", "\"}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.apiUrl", "/b2api/v1/b2_get_upload_url"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"json.parse", "$L12", "$L12"}, new Object[]{"set", "$S0.uploadURL", "$L12.uploadUrl"}, new Object[]{"set", "$S0.uploadAuthorizationToken", "$L12.authorizationToken"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if==than", "$S0.authorizationToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0"}, new Object[]{"return"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L2", "String"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"string.concat", "$L0", "$P0.accountID", ":", "$P0.appKey"}, new Object[]{"string.base64encode", "$L0", "$L0"}, new Object[]{"string.concat", "$L0", "Basic ", "$L0"}, new Object[]{"set", "$L4", "$L0", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "https://api.backblazeb2.com/b2api/v1/b2_authorize_account"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$S0.authorizationToken", "$L8.authorizationToken"}, new Object[]{"set", "$S0.accountId", "$L8.accountId"}, new Object[]{"set", "$S0.apiUrl", "$L8.apiUrl"}, new Object[]{"set", "$S0.downloadUrl", "$L8.downloadUrl"}, new Object[]{"set", "$S0.minimumPartSize", "$L8.minimumPartSize"}});
            this.put("checkHttpErrors", new Object[]{new Object[]{"if==than", "$P3", null, 2}, new Object[]{"if>=than", "$P1.code", 400, 24}, new Object[]{"jumpRel", 1}, new Object[]{"if!=than", "$P1.code", "$P3", 22}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L2", "$L0.message"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 400, 10}, new Object[]{"string.indexOf", "$L4", "$L2", "Invalid bucketId"}, new Object[]{"if!=than", "$L4", -1, 2}, new Object[]{"create", "$L3", "Error", "The requested bucket could not be found.", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"string.indexOf", "$L4", "$L2", "Bucket name is already in use"}, new Object[]{"if!=than", "$L4", -1, 2}, new Object[]{"create", "$L3", "Error", "The bucket already exists.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Parameter should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P1"}, new Object[]{"if==than", "$P1.name", null, 3}, new Object[]{"if==than", "$P1.identifier", null, 2}, new Object[]{"create", "$L0", "Error", "Bucket name and identifier should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkSize", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Size can not be negative.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("arrayToHex", new Object[]{new Object[]{"size", "$L1", "$P2"}, new Object[]{"set", "$L2", 0}, new Object[]{"create", "$P1", "String", ""}, new Object[]{"get", "$L3", "$P2", "$L2"}, new Object[]{"string.format", "$L4", "%02x", "$L3"}, new Object[]{"string.concat", "$P1", "$P1", "$L4"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"if>=than", "$L2", "$L1", -5}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Backblaze(Context context, String accountID, String appKey) {
        this.initDataStructures(context);
        this.interpreterStorage.put("accountID", accountID);
        this.interpreterStorage.put("appKey", appKey);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Backblaze...");
        new InitSelfTestTask("Backblaze", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Bucket createBucket(String bucketName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "createBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:createBucket", this.interpreterStorage, null, bucketName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "createBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Bucket)ip.getParameter(1);
    }

    @Override
    public List<Bucket> listBuckets() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "listBuckets").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:listBuckets", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "listBuckets").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void deleteBucket(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "deleteBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:deleteBucket", this.interpreterStorage, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "deleteBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void deleteFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "deleteFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:deleteFile", this.interpreterStorage, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "deleteFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public BusinessFileMetaData getFileMetadata(Bucket bucket, String fileName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "getFileMetadata").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:getFileMetadata", this.interpreterStorage, null, bucket, fileName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "getFileMetadata").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (BusinessFileMetaData)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFiles(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "listFiles").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:listFiles", this.interpreterStorage, null, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "listFiles").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFilesWithPrefix(Bucket bucket, String prefix) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "listFilesWithPrefix").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:listFilesWithPrefix", this.interpreterStorage, null, bucket, prefix);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "listFilesWithPrefix").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void uploadFile(Bucket bucket, String name, InputStream stream, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "uploadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:upload", this.interpreterStorage, bucket, name, stream, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "uploadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public InputStream downloadFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "downloadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:download", this.interpreterStorage, null, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "downloadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Backblaze", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Backblaze", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

