/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.CloudStorage;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.CloudMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.SpaceAllocation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Dropbox
implements CloudStorage,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"create", "$P0.paginationCache", "Object"}, new Object[]{"create", "$P0.paginationCache.offset", "Number", 0}, new Object[]{"create", "$P0.paginationCache.path", "String", "grgerfefrgerhggerger"}, new Object[]{"create", "$P0.paginationCache.metaCache", "Array"}});
            this.put("CloudStorage:getUserLogin", new Object[]{new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.emailAddress"}});
            this.put("CloudStorage:getUserName", new Object[]{new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.displayName"}});
            this.put("User:about", new Object[]{new Object[]{"if!=than", "$P0.userInfo", null, 4}, new Object[]{"create", "$L0", "Date"}, new Object[]{"math.add", "$L0", "$L0.Time", -1000}, new Object[]{"if>than", "$P0.userInfo.lastUpdate", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "User:aboutRequest", "$P0"}});
            this.put("User:aboutRequest", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://api.dropboxapi.com/2/users/get_current_account"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"create", "$P0.userInfo", "Object"}, new Object[]{"create", "$L4", "Date"}, new Object[]{"set", "$P0.userInfo.lastUpdate", "$L4.Time"}, new Object[]{"set", "$P0.userInfo.emailAddress", "$L3.email"}, new Object[]{"set", "$P0.userInfo.displayName", "$L3.name.display_name"}});
            this.put("CloudStorage:download", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/download"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$P2"}, new Object[]{"json.stringify", "$L4", "$L3"}, new Object[]{"set", "$L1.Dropbox-API-Arg", "$L4"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"set", "$P1", "$L5.responseBody"}});
            this.put("CloudStorage:upload", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkPositive", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P4", 0, 1}, new Object[]{"callFunc", "checkFileExists", "$P0", "$P1"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P1"}, new Object[]{"if<=than", "$P3", 10000000, 2}, new Object[]{"callFunc", "simpleUpload", "$P0", "$P2", "$P1", "$P4", "$P5"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "chunkedUpload", "$P0", "$P2", "$P1", "$P3", "$P4", "$P5"}});
            this.put("CloudStorage:move", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.from_path", "$P1"}, new Object[]{"set", "$L0.to_path", "$P2"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/move"}});
            this.put("CloudStorage:delete", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P1"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/delete"}});
            this.put("CloudStorage:copy", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.from_path", "$P1"}, new Object[]{"set", "$L0.to_path", "$P2"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/copy"}});
            this.put("CloudStorage:createFolder", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P1"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P1"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/create_folder"}});
            this.put("CloudStorage:getMetadata", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 2}, new Object[]{"create", "$L2", "Error", "Root does not have MetaData", "IllegalArgument"}, new Object[]{"throwError", "$L2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P2"}, new Object[]{"set", "$L0.include_media_info", true}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/get_metadata"}, new Object[]{"callFunc", "makeMeta", "$P0", "$P1", "$L1"}});
            this.put("CloudStorage:getChildren", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 1}, new Object[]{"set", "$P2", ""}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P2"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/list_folder"}, new Object[]{"callFunc", "processRawMeta", "$P0", "$P1", "$L1"}, new Object[]{"if==than", "$L1.has_more", 1, 5}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.cursor", "$L1.cursor"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L2", "https://api.dropboxapi.com/2/files/list_folder/continue"}, new Object[]{"callFunc", "processRawMeta", "$P0", "$P1", "$L1"}, new Object[]{"jumpRel", -6}});
            this.put("getChildrenPage", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 1}, new Object[]{"set", "$P2", ""}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if!=than", "$P0.paginationCache.path", "$P2", 1}, new Object[]{"jumpRel", 1}, new Object[]{"if<than", "$P3", "$P0.paginationCache.offset", 10}, new Object[]{"set", "$P0.paginationCache.path", "$P2"}, new Object[]{"set", "$P0.paginationCache.offset", 0}, new Object[]{"create", "$P0.paginationCache.metaCache", "Array"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P2"}, new Object[]{"set", "$L0.limit", "$P4"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/list_folder"}, new Object[]{"callFunc", "processRawMeta", "$P0", "$P0.paginationCache.metaCache", "$L1"}, new Object[]{"set", "$P0.paginationCache.cursor", "$L1.cursor"}, new Object[]{"jumpRel", -13}, new Object[]{"create", "$L0", "Number"}, new Object[]{"size", "$L0", "$P0.paginationCache.metaCache"}, new Object[]{"math.add", "$L0", "$L0", "$P0.paginationCache.offset"}, new Object[]{"if<than", "$P3", "$L0", 13}, new Object[]{"math.multiply", "$L1", "$P0.paginationCache.offset", -1}, new Object[]{"math.add", "$L1", "$L1", "$P3"}, new Object[]{"size", "$L0", "$P1"}, new Object[]{"if<than", "$L0", "$P4", 9}, new Object[]{"get", "$L2", "$P0.paginationCache.metaCache", "$L1"}, new Object[]{"push", "$P1", "$L2"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"size", "$L3", "$P0.paginationCache.metaCache"}, new Object[]{"if==than", "$L3", "$L1", 3}, new Object[]{"size", "$L4", "$P0.paginationCache.metaCache"}, new Object[]{"math.add", "$P3", "$L4", "$P0.paginationCache.offset"}, new Object[]{"jumpRel", 2}, new Object[]{"jumpRel", -11}, new Object[]{"return"}, new Object[]{"if==than", "$P0.paginationCache.cursor", null, 1}, new Object[]{"return"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.cursor", "$P0.paginationCache.cursor"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/list_folder/continue"}, new Object[]{"size", "$L2", "$P0.paginationCache.metaCache"}, new Object[]{"math.add", "$P0.paginationCache.offset", "$P0.paginationCache.offset", "$L2"}, new Object[]{"create", "$P0.paginationCache.metaCache", "Array"}, new Object[]{"callFunc", "processRawMeta", "$P0", "$P0.paginationCache.metaCache", "$L1"}, new Object[]{"set", "$P0.paginationCache.cursor", "$L1.cursor"}, new Object[]{"jumpRel", -42}});
            this.put("CloudStorage:exists", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://api.dropboxapi.com/2/files/get_metadata"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$P2"}, new Object[]{"json.stringify", "$L3", "$L3"}, new Object[]{"stream.stringToStream", "$L2.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"if==than", "$L4.code", 200, 2}, new Object[]{"set", "$P1", 1}, new Object[]{"return"}, new Object[]{"if<than", "$L4.code", 429, 5}, new Object[]{"json.parse", "$L0", "$L4.responseBody"}, new Object[]{"string.indexOf", "$L1", "$L0.error_summary", "not_found"}, new Object[]{"if!=than", "$L1", -1, 2}, new Object[]{"set", "$P1", 0}, new Object[]{"return"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L4"}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"if==than", "$S0.access_token", null, 1}, new Object[]{"return"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://api.dropboxapi.com/2/auth/token/revoke"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$S0.access_token", null}});
            this.put("getAllocation", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L1", "String"}, new Object[]{"set", "$L1", "https://api.dropboxapi.com/2/users/get_space_usage"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L4"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"create", "$L6", "SpaceAllocation"}, new Object[]{"set", "$L6.total", "$L5.allocation.allocated"}, new Object[]{"set", "$L6.used", "$L5.used"}, new Object[]{"set", "$P1", "$L6"}});
            this.put("createShareLink", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 2}, new Object[]{"create", "$L2", "Error", "Cannot share root", "IllegalArgument"}, new Object[]{"throwError", "$L2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P2"}, new Object[]{"set", "$L0.direct_only", true}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/sharing/list_shared_links"}, new Object[]{"size", "$L2", "$L1.links"}, new Object[]{"if==than", "$L2", 0, 5}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P2"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/sharing/create_shared_link_with_settings"}, new Object[]{"set", "$P1", "$L1.url"}, new Object[]{"return"}, new Object[]{"get", "$P1", "$L1", "links", 0, "url"}});
            this.put("CloudStorage:getThumbnail", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "CloudStorage:exists", "$P0", "$L0", "$P2"}, new Object[]{"if==than", "$L0", 0, 2}, new Object[]{"create", "$L0", "Error", "File does not exist.", "NotFound"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/get_thumbnail"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.path", "$P2"}, new Object[]{"set", "$L1.format", "jpeg"}, new Object[]{"set", "$L1.size", "w128h128"}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2", "$L1", "Dropbox-API-Arg"}, new Object[]{"set", "$L0.requestHeaders", "$L2"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"if==than", "$L3.code", 409, 1}, new Object[]{"return"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"set", "$P1", "$L3.responseBody"}});
            this.put("CloudStorage:searchFiles", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "", 2}, new Object[]{"create", "$L0", "Error", "The query is not allowed to be empty.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "https://api.dropboxapi.com/2/files/search"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L1.Content-Type", "application/json"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.path", ""}, new Object[]{"set", "$L2.query", "$P2"}, new Object[]{"set", "$L2.start", 0}, new Object[]{"set", "$L2.max_results", 100}, new Object[]{"set", "$L2.mode", "filename"}, new Object[]{"json.stringify", "$L3", "$L2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"create", "$L3", "Number"}, new Object[]{"size", "$L4", "$L2.matches"}, new Object[]{"if<than", "$L3", "$L4", 5}, new Object[]{"get", "$L5", "$L2.matches", "$L3"}, new Object[]{"callFunc", "makeMeta", "$P0", "$L6", "$L5.metadata"}, new Object[]{"push", "$P1", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -6}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "https://api.dropboxapi.com/2"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if!=than", null, "$S0.access_token", 1}, new Object[]{"return"}, new Object[]{"string.concat", "$L0", "https://www.dropbox.com/oauth2/authorize?response_type=code&force_reauthentication=true&redirect_uri=", "$P0.redirectUri", "&client_id=", "$P0.clientId", "&state=", "$P0.state"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0", null, "$P0.redirectUri"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://api.dropboxapi.com/oauth2/token"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L2.requestHeaders", "$L7"}, new Object[]{"string.concat", "$L3", "code=", "$L1", "&grant_type=authorization_code", "&redirect_uri=", "$P0.redirectUri", "&client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret"}, new Object[]{"stream.stringToStream", "$L4", "$L3"}, new Object[]{"set", "$L2.requestBody", "$L4"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"json.parse", "$L6", "$L5.responseBody"}, new Object[]{"set", "$S0.access_token", "$L6.access_token"}});
            this.put("standardJSONRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "$P3"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/json"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"json.stringify", "$L3", "$P2"}, new Object[]{"stream.stringToStream", "$L4", "$L3"}, new Object[]{"set", "$L0.requestBody", "$L4"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"json.parse", "$L6", "$L5.responseBody"}, new Object[]{"set", "$P1", "$L6"}});
            this.put("makeMeta", new Object[]{new Object[]{"create", "$P1", "CloudMetaData"}, new Object[]{"set", "$P1.name", "$P2.name"}, new Object[]{"if!=than", "$P2.server_modified", null, 2}, new Object[]{"create", "$L1", "Date", "$P2.server_modified"}, new Object[]{"set", "$P1.modifiedAt", "$L1.time"}, new Object[]{"if!=than", "$P2.client_modified", null, 2}, new Object[]{"create", "$L6", "Date", "$P2.client_modified"}, new Object[]{"set", "$P1.contentModifiedAt", "$L6.time"}, new Object[]{"get", "$L0", "$P2", ".tag"}, new Object[]{"if==than", "$L0", "folder", 2}, new Object[]{"set", "$P1.folder", 1}, new Object[]{"jumpRel", 2}, new Object[]{"set", "$P1.folder", 0}, new Object[]{"set", "$P1.size", "$P2.size"}, new Object[]{"set", "$P1.path", "$P2.path_display"}, new Object[]{"if!=than", "$P2.media_info", null, 6}, new Object[]{"if!=than", "$P2.media_info.metadata.dimensions", null, 5}, new Object[]{"get", "$L2", "$P2.media_info.metadata.dimensions"}, new Object[]{"get", "$L3", "$L2.width"}, new Object[]{"get", "$L4", "$L2.height"}, new Object[]{"create", "$L5", "ImageMetaData", "$L4", "$L3"}, new Object[]{"set", "$P1.imageMetaData", "$L5"}});
            this.put("processRawMeta", new Object[]{new Object[]{"set", "$L0", "$P2.entries"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"math.add", "$L2", "$L1", -1}, new Object[]{"if>=than", "$L2", 0, 5}, new Object[]{"get", "$L3", "$L0", "$L2"}, new Object[]{"callFunc", "makeMeta", "$P0", "$L4", "$L3"}, new Object[]{"push", "$P1", "$L4"}, new Object[]{"math.add", "$L2", "$L2", -1}, new Object[]{"jumpRel", -6}});
            this.put("simpleUpload", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/upload"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/octet-stream"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$P2"}, new Object[]{"if!=than", "$P3", 0, 1}, new Object[]{"set", "$L3.mode", "overwrite"}, new Object[]{"if!=than", "$P4", null, 1}, new Object[]{"set", "$L3.client_modified", "$P4"}, new Object[]{"json.stringify", "$L4", "$L3"}, new Object[]{"set", "$L1.Dropbox-API-Arg", "$L4"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L0.requestBody", "$P1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("chunkedUpload", new Object[]{new Object[]{"stream.makeLimitedStream", "$L0", "$P1", 10000000}, new Object[]{"callFunc", "chunkedStart", "$P0", "$L1", "$L0"}, new Object[]{"math.add", "$L2", "$P3", -10000000}, new Object[]{"set", "$L5", 10000000}, new Object[]{"if>than", "$L2", 10000000, 7}, new Object[]{"stream.makeLimitedStream", "$L3", "$P1", 10000000}, new Object[]{"callFunc", "chunkedAppend", "$P0", "$L3", "$L1", "$L5"}, new Object[]{"math.add", "$L4", "$L2", -10000000}, new Object[]{"set", "$L2", "$L4"}, new Object[]{"math.add", "$L6", "$L5", 10000000}, new Object[]{"set", "$L5", "$L6"}, new Object[]{"jumpRel", -8}, new Object[]{"callFunc", "chunkedFinish", "$P0", "$P1", "$P2", "$L1", "$L5", "$P4", "$P5"}});
            this.put("chunkedStart", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/upload_session/start"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/octet-stream"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L0.requestBody", "$P2"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$L4", "$L3.responseBody"}, new Object[]{"set", "$P1", "$L4.session_id"}});
            this.put("chunkedAppend", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/upload_session/append_v2"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/octet-stream"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.session_id", "$P2"}, new Object[]{"set", "$L3.offset", "$P3"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.cursor", "$L3"}, new Object[]{"json.stringify", "$L4", "$L7"}, new Object[]{"set", "$L1.Dropbox-API-Arg", "$L4"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L0.requestBody", "$P1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("chunkedFinish", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/upload_session/finish"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/octet-stream"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.session_id", "$P3"}, new Object[]{"set", "$L3.offset", "$P4"}, new Object[]{"create", "$L8", "Object"}, new Object[]{"if!=than", "$P5", 0, 1}, new Object[]{"set", "$L8.mode", "overwrite"}, new Object[]{"if!=than", "$P6", null, 1}, new Object[]{"set", "$L8.client_modified", "$P6"}, new Object[]{"set", "$L8.path", "$P2"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.cursor", "$L3"}, new Object[]{"set", "$L7.commit", "$L8"}, new Object[]{"json.stringify", "$L4", "$L7"}, new Object[]{"set", "$L1.Dropbox-API-Arg", "$L4"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L0.requestBody", "$P1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("validatePath", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Path shouldn't be null", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1", "", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L0", "String"}, new Object[]{"string.substr", "$L0", "$P1", 0, 1}, new Object[]{"if!=than", "$L0", "/", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L1", "Number"}, new Object[]{"size", "$L1", "$P1"}, new Object[]{"math.add", "$L1", "$L1", -1}, new Object[]{"if!=than", "$L1", 0, 5}, new Object[]{"create", "$L2", "String"}, new Object[]{"string.substr", "$L2", "$P1", "$L1", 1}, new Object[]{"if==than", "$L2", "/", 2}, new Object[]{"create", "$L3", "Error", "Path should not end with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Passed argument is null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkPositive", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Passed argument should be bigger than 0.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 26}, new Object[]{"if==than", "$P1.code", 400, 3}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 401, 3}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 500, 6}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"string.indexOf", "$L4", "$L2", "not_found"}, new Object[]{"if>=than", "$P1.code", 402, 5}, new Object[]{"if<=than", "$P1.code", 509, 4}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"if==than", "$L4", -1, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if!=than", "$L4", -1, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}});
            this.put("checkParentPathExists", new Object[]{new Object[]{"string.lastIndexOf", "$L0", "$P1", "/"}, new Object[]{"string.substring", "$L1", "$P1", 0, "$L0"}, new Object[]{"if==than", "$L1", "", 1}, new Object[]{"return"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://api.dropboxapi.com/2/files/get_metadata"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$L1"}, new Object[]{"json.stringify", "$L3", "$L3"}, new Object[]{"stream.stringToStream", "$L2.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"if!=than", "$L4.code", 200, 2}, new Object[]{"create", "$L5", "Error", "Target folder not found.", "NotFound"}, new Object[]{"throwError", "$L5"}});
            this.put("checkFileExists", new Object[]{new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://api.dropboxapi.com/2/files/get_metadata"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$P1"}, new Object[]{"json.stringify", "$L3", "$L3"}, new Object[]{"stream.stringToStream", "$L2.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"if==than", "$L4.code", 200, 2}, new Object[]{"create", "$L5", "Error", "File already exists.", "Http"}, new Object[]{"throwError", "$L5"}});
            this.put("CloudStorage:uploadWithContentModifiedDate", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "$P5"}, new Object[]{"create", "$L0", "Date"}, new Object[]{"set", "$L0.time", "$P5"}, new Object[]{"set", "$L1", "$L0.rfcTime"}, new Object[]{"callFunc", "CloudStorage:upload", "$P0", "$P1", "$P2", "$P3", "$P4", "$L1"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Dropbox(Context context, String clientId, String clientSecret, String redirectUri, String state) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.initService();
    }

    public Dropbox(Context context, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.interpreterStorage.put("state", "CloudRailSI");
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Dropbox...");
        new InitSelfTestTask("Dropbox", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public InputStream download(String filePath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "download").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:download", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "download").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public void upload(String filePath, InputStream stream, long size, boolean overwrite) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "upload").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:upload", this.interpreterStorage, filePath, stream, size, overwrite ? 1L : 0L);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "upload").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void move(String sourcePath, String destinationPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "move").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:move", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "move").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void delete(String filePath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "delete").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:delete", this.interpreterStorage, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "delete").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void copy(String sourcePath, String destinationPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "copy").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:copy", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "copy").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void createFolder(String folderPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "createFolder").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:createFolder", this.interpreterStorage, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "createFolder").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public CloudMetaData getMetadata(String filePath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "getMetadata").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getMetadata", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "getMetadata").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (CloudMetaData)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> getChildren(String folderPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "getChildren").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getChildren", this.interpreterStorage, null, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "getChildren").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> getChildrenPage(String path, long offset, long limit) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "getChildrenPage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getChildrenPage", this.interpreterStorage, null, path, offset, limit);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "getChildrenPage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public String getUserLogin() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "getUserLogin").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserLogin", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "getUserLogin").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getUserName() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "getUserName").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "getUserName").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String createShareLink(String path) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "createShareLink").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createShareLink", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "createShareLink").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public SpaceAllocation getAllocation() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "getAllocation").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getAllocation", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "getAllocation").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (SpaceAllocation)ip.getParameter(1);
    }

    @Override
    public boolean exists(String path) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "exists").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:exists", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "exists").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return !ip.getParameter(1).equals(0);
    }

    @Override
    public InputStream getThumbnail(String path) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "getThumbnail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getThumbnail", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "getThumbnail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> search(String query) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "search").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:searchFiles", this.interpreterStorage, null, query);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "search").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void uploadWithContentModifiedDate(String filePath, InputStream stream, long size, boolean overwrite, long contentModifiedDate) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "uploadWithContentModifiedDate").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:uploadWithContentModifiedDate", this.interpreterStorage, filePath, stream, size, overwrite ? 1L : 0L, contentModifiedDate);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "uploadWithContentModifiedDate").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Dropbox", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Dropbox", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

