/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.CloudStorage;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.CloudMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.SpaceAllocation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Egnyte
implements CloudStorage,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"if==than", "$P0.scopes", null, 2}, new Object[]{"set", "$P0.scope", "Egnyte.filesystem%20Egnyte.link"}, new Object[]{"jumpRel", 10}, new Object[]{"create", "$P0.scope", "String"}, new Object[]{"size", "$L0", "$P0.scopes"}, new Object[]{"create", "$L1", "Number", 0}, new Object[]{"if<than", "$L1", "$L0", 6}, new Object[]{"if!=than", "$L1", 0, 1}, new Object[]{"string.concat", "$P0.scope", "$P0.scope", "%20"}, new Object[]{"get", "$L2", "$P0.scopes", "$L1"}, new Object[]{"string.concat", "$P0.scope", "$P0.scope", "$L2"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -7}});
            this.put("CloudStorage:getUserLogin", new Object[]{new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.email"}});
            this.put("CloudStorage:getUserName", new Object[]{new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.displayName"}});
            this.put("User:about", new Object[]{new Object[]{"if!=than", "$P0.userInfo", null, 4}, new Object[]{"create", "$L0", "Date"}, new Object[]{"math.add", "$L0", "$L0.Time", -1000}, new Object[]{"if>than", "$P0.userInfo.lastUpdate", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "User:aboutRequest", "$P0"}});
            this.put("User:aboutRequest", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/userinfo"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P0.userInfo", "Object"}, new Object[]{"create", "$L3", "Date"}, new Object[]{"set", "$P0.userInfo.lastUpdate", "$L3.Time"}, new Object[]{"set", "$P0.userInfo.displayName", "$L2.username"}, new Object[]{"set", "$P0.userInfo.email", "$L2.email"}});
            this.put("CloudStorage:download", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "encodePath", "$P0", "$L12", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs-content", "$L12"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"set", "$P1", "$L5.responseBody"}});
            this.put("CloudStorage:upload", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "encodePath", "$P0", "$L11", "$P1"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkPositive", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P4", 0, 1}, new Object[]{"callFunc", "checkFileNotExists", "$P0", "$P1"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P1"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs-content", "$L11"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Length", "$P3", ""}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "text/plain"}, new Object[]{"if!=than", "$P5", null, 1}, new Object[]{"set", "$L0.requestHeaders.Last-Modified", "$P5"}, new Object[]{"set", "$L0.requestBody", "$P2"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("CloudStorage:move", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "encodePath", "$P0", "$L11", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L11"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.action", "move"}, new Object[]{"set", "$L1.destination", "$P2"}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("CloudStorage:delete", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "encodePath", "$P0", "$L11", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L11"}, new Object[]{"set", "$L0.method", "DELETE"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("CloudStorage:copy", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "encodePath", "$P0", "$L11", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L11"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.action", "copy"}, new Object[]{"set", "$L1.destination", "$P2"}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("CloudStorage:createFolder", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "encodePath", "$P0", "$L11", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P1"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L11"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.action", "add_folder"}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("CloudStorage:getMetadata", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "encodePath", "$P0", "$L12", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L12", "?list_content=false"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$L4", "$L3.responseBody"}, new Object[]{"callFunc", "extractMeta", "$P0", "$P1", "$L4"}});
            this.put("CloudStorage:getChildren", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "encodePath", "$P0", "$L12", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L12"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$L4", "$L3.responseBody"}, new Object[]{"if==than", "$L4.is_folder", 0, 2}, new Object[]{"create", "$L5", "Error", "Only folders have children, the given path points to a file", "IllegalArgument"}, new Object[]{"throwError", "$L5"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if!=than", "$L4.folders", null, 8}, new Object[]{"size", "$L5", "$L4.folders"}, new Object[]{"set", "$L6", 0}, new Object[]{"if<than", "$L6", "$L5", 5}, new Object[]{"get", "$L7", "$L4.folders", "$L6"}, new Object[]{"callFunc", "extractMeta", "$P0", "$L8", "$L7"}, new Object[]{"push", "$P1", "$L8"}, new Object[]{"math.add", "$L6", "$L6", 1}, new Object[]{"jumpRel", -6}, new Object[]{"if!=than", "$L4.files", null, 8}, new Object[]{"size", "$L5", "$L4.files"}, new Object[]{"set", "$L6", 0}, new Object[]{"if<than", "$L6", "$L5", 5}, new Object[]{"get", "$L7", "$L4.files", "$L6"}, new Object[]{"callFunc", "extractMeta", "$P0", "$L8", "$L7"}, new Object[]{"push", "$P1", "$L8"}, new Object[]{"math.add", "$L6", "$L6", 1}, new Object[]{"jumpRel", -6}});
            this.put("getChildrenPage", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "encodePath", "$P0", "$L12", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L12", "?offset=", "$P3", "&count=", "$P4"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$L4", "$L3.responseBody"}, new Object[]{"if==than", "$L4.is_folder", 0, 2}, new Object[]{"create", "$L5", "Error", "Only folders have children, the given path points to a file", "IllegalArgument"}, new Object[]{"throwError", "$L5"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if!=than", "$L4.folders", null, 8}, new Object[]{"size", "$L5", "$L4.folders"}, new Object[]{"set", "$L6", 0}, new Object[]{"if<than", "$L6", "$L5", 5}, new Object[]{"get", "$L7", "$L4.folders", "$L6"}, new Object[]{"callFunc", "extractMeta", "$P0", "$L8", "$L7"}, new Object[]{"push", "$P1", "$L8"}, new Object[]{"math.add", "$L6", "$L6", 1}, new Object[]{"jumpRel", -6}, new Object[]{"if!=than", "$L4.files", null, 8}, new Object[]{"size", "$L5", "$L4.files"}, new Object[]{"set", "$L6", 0}, new Object[]{"if<than", "$L6", "$L5", 5}, new Object[]{"get", "$L7", "$L4.files", "$L6"}, new Object[]{"callFunc", "extractMeta", "$P0", "$L8", "$L7"}, new Object[]{"push", "$P1", "$L8"}, new Object[]{"math.add", "$L6", "$L6", 1}, new Object[]{"jumpRel", -6}});
            this.put("CloudStorage:exists", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "encodePath", "$P0", "$L12", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L12", "?list_content=false&list_custom_metadata=false"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"if==than", "$L4.code", 200, 2}, new Object[]{"set", "$P1", 1}, new Object[]{"return"}, new Object[]{"set", "$P1", 0}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"set", "$S0.access_token", null}});
            this.put("CloudStorage:getAllocation", new Object[0]);
            this.put("CloudStorage:createShareLink", new Object[]{new Object[]{"callFunc", "CloudStorage:getMetadata", "$P0", "$L0", "$P2"}, new Object[]{"if==than", "$L0.folder", 0, 1}, new Object[]{"set", "$L1", "file"}, new Object[]{"if!=than", "$L0.folder", 0, 1}, new Object[]{"set", "$L1", "folder"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/links"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$P2"}, new Object[]{"set", "$L3.type", "$L1"}, new Object[]{"set", "$L3.accessibility", "anyone"}, new Object[]{"json.stringify", "$L3", "$L3"}, new Object[]{"stream.stringToStream", "$L2.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"get", "$P1", "$L5", "links", 0, "url"}});
            this.put("CloudStorage:getThumbnail", new Object[0]);
            this.put("CloudStorage:searchFiles", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "", 2}, new Object[]{"create", "$L0", "Error", "The query is not allowed to be empty.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/search"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"string.urlEncode", "$L2", "$P2"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "?query=", "$L2", "&count=100"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"create", "$L3", "Number"}, new Object[]{"size", "$L4", "$L2.results"}, new Object[]{"if<than", "$L3", "$L4", 5}, new Object[]{"get", "$L5", "$L2.results", "$L3"}, new Object[]{"callFunc", "extractMeta", "$P0", "$L6", "$L5"}, new Object[]{"push", "$P1", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -6}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.domain", ".egnyte.com"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if!=than", null, "$S0.access_token", 1}, new Object[]{"return"}, new Object[]{"string.concat", "$L0", "https://", "$P0.domain", ".egnyte.com/puboauth/token?response_type=code&scope=", "$P0.scope", "&redirect_uri=", "$P0.redirectUri", "&client_id=", "$P0.clientId", "&state=", "$P0.state"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0", null, "$P0.redirectUri"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://", "$P0.domain", ".egnyte.com/puboauth/token"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L2.requestHeaders", "$L7"}, new Object[]{"string.concat", "$L3", "code=", "$L1", "&grant_type=authorization_code", "&redirect_uri=", "$P0.redirectUri", "&client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret"}, new Object[]{"stream.stringToStream", "$L4", "$L3"}, new Object[]{"set", "$L2.requestBody", "$L4"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"json.parse", "$L6", "$L5.responseBody"}, new Object[]{"set", "$S0.access_token", "$L6.access_token"}});
            this.put("encodePath", new Object[]{new Object[]{"string.split", "$L0", "$P2", "/"}, new Object[]{"set", "$L1", 1}, new Object[]{"size", "$L2", "$L0"}, new Object[]{"set", "$P1", ""}, new Object[]{"if<than", "$L1", "$L2", 6}, new Object[]{"get", "$L4", "$L0", "$L1"}, new Object[]{"string.urlEncode", "$L4", "$L4"}, new Object[]{"callFunc", "replacePluses", "$P0", "$L4"}, new Object[]{"string.concat", "$P1", "$P1", "/", "$L4"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -7}});
            this.put("replacePluses", new Object[]{new Object[]{"string.split", "$L0", "$P1", "\\+"}, new Object[]{"set", "$L1", 1}, new Object[]{"size", "$L2", "$L0"}, new Object[]{"get", "$P1", "$L0", 0}, new Object[]{"if<than", "$L1", "$L2", 4}, new Object[]{"get", "$L3", "$L0", "$L1"}, new Object[]{"string.concat", "$P1", "$P1", "%20", "$L3"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -5}});
            this.put("validatePath", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Path shouldn't be null", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1", "", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L0", "String"}, new Object[]{"string.substr", "$L0", "$P1", 0, 1}, new Object[]{"if!=than", "$L0", "/", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L1", "Number"}, new Object[]{"size", "$L1", "$P1"}, new Object[]{"math.add", "$L1", "$L1", -1}, new Object[]{"if!=than", "$L1", 0, 5}, new Object[]{"create", "$L2", "String"}, new Object[]{"string.substr", "$L2", "$P1", "$L1", 1}, new Object[]{"if==than", "$L2", "/", 2}, new Object[]{"create", "$L3", "Error", "Path should not end with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Passed argument is null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkPositive", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Passed argument should be bigger than 0.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L0", "Error", "Authentication failed", "Authentication"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1.code", 403, 2}, new Object[]{"create", "$L0", "Error", "Not enough permissions or rate limit exceeded", "Authentication"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L0", "Error", "Resource not found", "NotFound"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1.code", 409, 2}, new Object[]{"create", "$L0", "Error", "Conflicting location", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if>=than", "$P1.code", 400, 3}, new Object[]{"stream.streamToString", "$L1", "$P1.responseBody"}, new Object[]{"create", "$L0", "Error", "$L1", "Http"}, new Object[]{"throwError", "$L0"}});
            this.put("checkParentPathExists", new Object[]{new Object[]{"string.lastIndexOf", "$L0", "$P1", "/"}, new Object[]{"string.substring", "$L1", "$P1", 0, "$L0"}, new Object[]{"if==than", "$L1", "", 1}, new Object[]{"return"}, new Object[]{"callFunc", "encodePath", "$P0", "$L11", "$L1"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L11", "?list_content=false&list_custom_metadata=false"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"if!=than", "$L4.code", 200, 2}, new Object[]{"create", "$L5", "Error", "Target folder not found.", "NotFound"}, new Object[]{"throwError", "$L5"}});
            this.put("checkFileNotExists", new Object[]{new Object[]{"callFunc", "encodePath", "$P0", "$L11", "$P1"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://", "$P0.domain", ".egnyte.com/pubapi/v1/fs", "$L11", "?list_content=false&list_custom_metadata=false"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"if==than", "$L4.code", 200, 2}, new Object[]{"create", "$L5", "Error", "File already exists.", "Http"}, new Object[]{"throwError", "$L5"}});
            this.put("extractMeta", new Object[]{new Object[]{"create", "$P1", "CloudMetaData"}, new Object[]{"set", "$P1.name", "$P2.name"}, new Object[]{"set", "$P1.path", "$P2.path"}, new Object[]{"if==than", "$P2.is_folder", 0, 5}, new Object[]{"set", "$P1.size", "$P2.size"}, new Object[]{"set", "$P1.folder", 0}, new Object[]{"callFunc", "parseDate", "$P0", "$P1.modifiedAt", "$P2.last_modified"}, new Object[]{"set", "$P1.contentModifiedAt", "$P1.modifiedAt"}, new Object[]{"return"}, new Object[]{"set", "$P1.folder", 1}, new Object[]{"set", "$P1.modifiedAt", "$P2.lastModified"}});
            this.put("parseDate", new Object[]{new Object[]{"string.substr", "$L0", "$P2", 5, 2}, new Object[]{"string.substr", "$L1", "$P2", 8, 3}, new Object[]{"callFunc", "getMonthNumber", "$P0", "$L6", "$L1"}, new Object[]{"string.substr", "$L2", "$P2", 12, 4}, new Object[]{"string.substr", "$L3", "$P2", 17, 8}, new Object[]{"string.concat", "$L4", "$L2", "-", "$L6", "-", "$L0", "T", "$L3", "Z"}, new Object[]{"create", "$L5", "Date", "$L4"}, new Object[]{"set", "$P1", "$L5.time"}});
            this.put("getMonthNumber", new Object[]{new Object[]{"if==than", "$P2", "Jan", 2}, new Object[]{"set", "$P1", "01"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Feb", 2}, new Object[]{"set", "$P1", "02"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Mar", 2}, new Object[]{"set", "$P1", "03"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Apr", 2}, new Object[]{"set", "$P1", "04"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "May", 2}, new Object[]{"set", "$P1", "05"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Jun", 2}, new Object[]{"set", "$P1", "06"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Jul", 2}, new Object[]{"set", "$P1", "07"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Aug", 2}, new Object[]{"set", "$P1", "08"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Sep", 2}, new Object[]{"set", "$P1", "09"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Oct", 2}, new Object[]{"set", "$P1", "10"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Nov", 2}, new Object[]{"set", "$P1", "11"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Dec", 2}, new Object[]{"set", "$P1", "12"}, new Object[]{"return"}, new Object[]{"create", "$L0", "Error", "Could not recognize month in Date"}, new Object[]{"throwError", "$L0"}});
            this.put("CloudStorage:uploadWithContentModifiedDate", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "$P5"}, new Object[]{"create", "$L0", "Date"}, new Object[]{"set", "$L0.time", "$P5"}, new Object[]{"set", "$L1", "$L0.rfcTime1123"}, new Object[]{"callFunc", "CloudStorage:upload", "$P0", "$P1", "$P2", "$P3", "$P4", "$L1"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Egnyte(Context context, String domain, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("domain", domain);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.interpreterStorage.put("state", "CloudRailSI");
        this.initService();
    }

    public Egnyte(Context context, String domain, String clientId, String clientSecret, List<String> scopes) {
        this.initDataStructures(context);
        this.interpreterStorage.put("domain", domain);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("scopes", scopes);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.interpreterStorage.put("state", "CloudRailSI");
        this.initService();
    }

    public Egnyte(Context context, String domain, String clientId, String clientSecret, String redirectUri, String state) {
        this.initDataStructures(context);
        this.interpreterStorage.put("domain", domain);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.initService();
    }

    public Egnyte(Context context, String domain, String clientId, String clientSecret, String redirectUri, String state, List<String> scopes) {
        this.initDataStructures(context);
        this.interpreterStorage.put("domain", domain);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.interpreterStorage.put("scopes", scopes);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Egnyte...");
        new InitSelfTestTask("Egnyte", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public InputStream download(String filePath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "download").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:download", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "download").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public void upload(String filePath, InputStream stream, long size, boolean overwrite) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "upload").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:upload", this.interpreterStorage, filePath, stream, size, overwrite ? 1L : 0L);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "upload").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void move(String sourcePath, String destinationPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "move").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:move", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "move").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void delete(String filePath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "delete").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:delete", this.interpreterStorage, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "delete").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void copy(String sourcePath, String destinationPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "copy").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:copy", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "copy").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void createFolder(String folderPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "createFolder").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:createFolder", this.interpreterStorage, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "createFolder").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public CloudMetaData getMetadata(String filePath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "getMetadata").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getMetadata", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "getMetadata").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (CloudMetaData)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> getChildren(String folderPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "getChildren").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getChildren", this.interpreterStorage, null, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "getChildren").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> getChildrenPage(String path, long offset, long limit) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "getChildrenPage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getChildrenPage", this.interpreterStorage, null, path, offset, limit);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "getChildrenPage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public String getUserLogin() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "getUserLogin").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserLogin", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "getUserLogin").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getUserName() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "getUserName").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "getUserName").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String createShareLink(String path) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "createShareLink").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:createShareLink", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "createShareLink").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public SpaceAllocation getAllocation() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "getAllocation").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getAllocation", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "getAllocation").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (SpaceAllocation)ip.getParameter(1);
    }

    @Override
    public boolean exists(String path) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "exists").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:exists", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "exists").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return !ip.getParameter(1).equals(0);
    }

    @Override
    public InputStream getThumbnail(String path) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "getThumbnail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getThumbnail", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "getThumbnail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> search(String query) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "search").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:searchFiles", this.interpreterStorage, null, query);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "search").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void uploadWithContentModifiedDate(String filePath, InputStream stream, long size, boolean overwrite, long contentModifiedDate) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "uploadWithContentModifiedDate").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:uploadWithContentModifiedDate", this.interpreterStorage, filePath, stream, size, overwrite ? 1L : 0L, contentModifiedDate);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "uploadWithContentModifiedDate").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Egnyte", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Egnyte", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

