/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Messaging;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.Message;
import com.cloudrail.si.types.MessageItem;
import com.cloudrail.si.types.MessagingAttachment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FacebookMessenger
implements Messaging,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"string.concat", "$P0.baseURL", "https://graph.facebook.com/v2.6/me/messages?access_token=", "$P0.botToken"}, new Object[]{"set", "$P0.boundaryString", "------7V0ub86bNNNKWdgJgsF7r0DxYtOB06XYxWvyMuYg5BucWEINpyFRcqisOXWr"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "https://graph.facebook.com/v2.6/me"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 1}, new Object[]{"string.concat", "$L0.url", "$L0.url", "?access_token=", "$P0.botToken"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("processWebhookRequest", new Object[]{new Object[]{"json.parse", "$L0", "$P2"}, new Object[]{"set", "$L0", "$L0.entry"}, new Object[]{"create", "$L1", "Number", 0}, new Object[]{"size", "$L2", "$L0"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if<than", "$L1", "$L2", 18}, new Object[]{"get", "$L3", "$L0", "$L1"}, new Object[]{"get", "$L4", "$L3.messaging", 0}, new Object[]{"get", "$L8", "$L3.messaging", 0}, new Object[]{"callFunc", "getLocation", "$P0", "$L5", "$L8.message.attachments"}, new Object[]{"callFunc", "getAttachments", "$P0", "$L6", "$L4.message.attachments"}, new Object[]{"create", "$L7", "Message"}, new Object[]{"set", "$L7.MessageId", "$L4.message.mid"}, new Object[]{"set", "$L7.SenderId", "$L4.sender.id"}, new Object[]{"set", "$L7.ChatId", "$L4.sender.id"}, new Object[]{"set", "$L7.SendAt", "$L4.timestamp"}, new Object[]{"set", "$L7.MessageText", "$L4.message.text"}, new Object[]{"if!=than", "$L5", null, 1}, new Object[]{"set", "$L7.Location", "$L5"}, new Object[]{"if!=than", "$L6", null, 1}, new Object[]{"set", "$L7.Attachments", "$L6"}, new Object[]{"push", "$P1", "$L7"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -19}});
            this.put("sendMessage", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "chatId"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P3", "messageText"}, new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", null, null, null}});
            this.put("sendImage", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "image", "$P7", "$P8"}});
            this.put("sendVideo", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "video", "$P7", "$P8"}});
            this.put("sendAudio", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "audio", "$P7", "$P8"}});
            this.put("sendFile", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "file", "$P7", "$P8"}});
            this.put("downloadContent", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P2.id"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$P1", "$P2"}, new Object[]{"set", "$P1.stream", "$L1.responseBody"}, new Object[]{"set", "$P1.mimeType", "$L1.responseHeaders.Content-Type"}});
            this.put("sendCarousel", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "$P0.baseURL"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"create", "$L1.recipient", "Object"}, new Object[]{"create", "$L1.message", "Object"}, new Object[]{"create", "$L1.message.attachment", "Object"}, new Object[]{"create", "$L1.message.attachment.payload", "Object"}, new Object[]{"set", "$L1.recipient.id", "$P2"}, new Object[]{"set", "$L1.message.attachment.type", "template"}, new Object[]{"set", "$L1.message.attachment.payload.template_type", "generic"}, new Object[]{"create", "$L1.message.attachment.payload.elements", "Array"}, new Object[]{"create", "$L3", "Number", 0}, new Object[]{"size", "$L4", "$P3"}, new Object[]{"if<than", "$L3", "$L4", 26}, new Object[]{"get", "$L5", "$P3", "$L3"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"set", "$L6.image_url", "$L5.mediaUrl"}, new Object[]{"set", "$L6.title", "$L5.title"}, new Object[]{"set", "$L6.subtitle", "$L5.subTitle"}, new Object[]{"create", "$L6.buttons", "Array"}, new Object[]{"set", "$L7", 0}, new Object[]{"size", "$L8", "$L5.buttons"}, new Object[]{"if<than", "$L7", "$L8", 14}, new Object[]{"get", "$L9", "$L5.buttons", "$L7"}, new Object[]{"create", "$L10", "Object"}, new Object[]{"set", "$L10.title", "$L9.text"}, new Object[]{"set", "$L11", "$L9.type"}, new Object[]{"if==than", "$L9.type", "uri", 1}, new Object[]{"set", "$L11", "web_url"}, new Object[]{"set", "$L10.type", "$L11"}, new Object[]{"if!=than", "$L9.url", null, 1}, new Object[]{"set", "$L10.url", "$L9.url"}, new Object[]{"if!=than", "$L9.payload", null, 1}, new Object[]{"set", "$L10.payload", "$L9.payload"}, new Object[]{"push", "$L6.buttons", "$L10"}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"jumpRel", -15}, new Object[]{"push", "$L1.message.attachment.payload.elements", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -27}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"create", "$L13", "Object"}, new Object[]{"http.requestCall", "$L13", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L13"}, new Object[]{"create", "$L14", "Date"}, new Object[]{"set", "$L14", "$L14.time"}, new Object[]{"create", "$P1", "Message"}, new Object[]{"set", "$P1.ChatId", "$P2"}, new Object[]{"set", "$P1.SendAt", "$L14"}});
            this.put("sendContent", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "chatId"}, new Object[]{"if!=than", "$P3", null, 8}, new Object[]{"if!=than", "$P4", null, 3}, new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", null, "$P4", "$P5", "$P6", "$P7", "$P8"}, new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", null, null, null, null, null}, new Object[]{"return"}, new Object[]{"if!=than", "$P5", null, 3}, new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", null, "$P4", "$P5", "$P6", "$P7", "$P8"}, new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", null, null, null, null, null}, new Object[]{"return"}, new Object[]{"if!=than", "$P5", null, 2}, new Object[]{"callFunc", "sendContentWithStream", "$P0", "$P1", "$P2", "$P3", "$P5", "$P6", "$P7", "$P8"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "sendContentWithID", "$P0", "$P1", "$P2", "$P3", "$P4", "$P6"}});
            this.put("sendContentWithID", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "$P0.baseURL"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"create", "$L1.recipient", "Object"}, new Object[]{"create", "$L1.message", "Object"}, new Object[]{"if!=than", "$P4", null, 2}, new Object[]{"create", "$L1.message.attachment", "Object"}, new Object[]{"create", "$L1.message.attachment.payload", "Object"}, new Object[]{"set", "$L1.recipient.id", "$P2"}, new Object[]{"if!=than", "$P3", null, 1}, new Object[]{"set", "$L1.message.text", "$P3"}, new Object[]{"if!=than", "$P4", null, 2}, new Object[]{"set", "$L1.message.attachment.type", "$P5"}, new Object[]{"set", "$L1.message.attachment.payload.url", "$P4"}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"create", "$L4", "Date"}, new Object[]{"create", "$P1", "Message"}, new Object[]{"if!=than", "$L3.message_id", null, 2}, new Object[]{"string.concat", "$L11", "$L3.message_id"}, new Object[]{"set", "$P1.MessageId", "$L11"}, new Object[]{"if!=than", "$P2", null, 2}, new Object[]{"string.concat", "$L13", "$P2"}, new Object[]{"set", "$P1.ChatId", "$L13"}, new Object[]{"set", "$P1.SendAt", "$L4.time"}, new Object[]{"if!=than", "$P3", null, 2}, new Object[]{"string.concat", "$L15", "$P3"}, new Object[]{"set", "$P1.MessageText", "$L15"}});
            this.put("sendContentWithStream", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "$P0.baseURL"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L11", "application/octet-stream"}, new Object[]{"if==than", "$P5", "image", 2}, new Object[]{"set", "$L11", "$P8"}, new Object[]{"if!=than", "$P6", null, 6}, new Object[]{"string.split", "$L8", "$P6", "\\."}, new Object[]{"size", "$L9", "$L8"}, new Object[]{"math.add", "$L9", "$L9", "-1"}, new Object[]{"get", "$L10", "$L8", "$L9"}, new Object[]{"getMimeType", "$L11", "$L10"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L1", "$L1", "--", "$P0.boundaryString", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Disposition: form-data; name=\"recipient\"\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Type:text/plain", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "{\"id\":\"", "$P2", "\"}\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "--", "$P0.boundaryString", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Disposition: form-data; name=\"message\"\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Type:text/plain", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "{"}, new Object[]{"if!=than", "$P3", null, 1}, new Object[]{"string.concat", "$L1", "$L1", "\"text\": \"", "$P3", "\", "}, new Object[]{"string.concat", "$L1", "$L1", "\"attachment\":{\"type\":\"", "$P5", "\", \"payload\":{}}}"}, new Object[]{"string.concat", "$L1", "$L1", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "--", "$P0.boundaryString", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Disposition: form-data; name=\"filedata\"; filename=\"", "$P6", "\"\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Type:", "$L11", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "\r\n"}, new Object[]{"string.concat", "$L5", "\r\n--", "$P0.boundaryString", "--\r\n"}, new Object[]{"stream.stringToStream", "$L6", "$L1"}, new Object[]{"stream.stringToStream", "$L7", "$L5"}, new Object[]{"stream.makeJoinedStream", "$L0.requestBody", "$L6", "$P4", "$L7"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Type", "multipart/form-data; boundary=", "$P0.boundaryString"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}});
            this.put("getLocation", new Object[]{new Object[]{"if==than", "$P2", null, 1}, new Object[]{"return"}, new Object[]{"create", "$L0", "Number", 0}, new Object[]{"size", "$L1", "$P2"}, new Object[]{"if<than", "$L0", "$L1", 6}, new Object[]{"get", "$L2", "$P2", "$L0"}, new Object[]{"if==than", "$L2.type", "location", 4}, new Object[]{"create", "$P1", "Location"}, new Object[]{"set", "$P1.Longitude", "$L2.payload.coordinates.long"}, new Object[]{"set", "$P1.Latitude", "$L2.payload.coordinates.lat"}, new Object[]{"return"}});
            this.put("getAttachments", new Object[]{new Object[]{"if==than", "$P2", null, 1}, new Object[]{"return"}, new Object[]{"create", "$L0", "Number", 0}, new Object[]{"size", "$L1", "$P2"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if<than", "$L0", "$L1", 7}, new Object[]{"get", "$L2", "$P2", "$L0"}, new Object[]{"if!=than", "$L2.type", "location", 4}, new Object[]{"if!=than", "$L2.type", "fallback", 3}, new Object[]{"create", "$L3", "MessagingAttachment", "$L2.payload.url", "$L2.type", null, null, null}, new Object[]{"push", "$P1", "$L3"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"jumpRel", -8}});
            this.put("extractMessageObject", new Object[0]);
            this.put("checkMandatory", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L1", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L0", "Error", "$L1", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 15}, new Object[]{"debug.out", "$P1.code"}, new Object[]{"stream.streamToString", "$L5", "$P1.responseBody"}, new Object[]{"set", "$L2", ""}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public FacebookMessenger(Context context, String botToken) {
        this.initDataStructures(context);
        this.interpreterStorage.put("botToken", botToken);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to FacebookMessenger...");
        new InitSelfTestTask("FacebookMessenger", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Message sendMessage(String receiverId, String message) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "FacebookMessenger", "sendMessage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendMessage", this.interpreterStorage, null, receiverId, message);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("FacebookMessenger", "sendMessage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendImage(String receiverId, String message, String imageId, InputStream imageStream, String previewUrl, String mimeType) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "FacebookMessenger", "sendImage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendImage", this.interpreterStorage, null, receiverId, message, imageId, imageStream, previewUrl, mimeType);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("FacebookMessenger", "sendImage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendVideo(String receiverId, String message, String videoId, InputStream videoStream, String previewUrl, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "FacebookMessenger", "sendVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendVideo", this.interpreterStorage, null, receiverId, message, videoId, videoStream, previewUrl, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("FacebookMessenger", "sendVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendAudio(String receiverId, String message, String audioId, InputStream audioStream, String previewUrl, String audioName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "FacebookMessenger", "sendAudio").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendAudio", this.interpreterStorage, null, receiverId, message, audioId, audioStream, previewUrl, audioName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("FacebookMessenger", "sendAudio").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendFile(String receiverId, String message, String fileId, InputStream fileStream, String previewUrl, String fileName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "FacebookMessenger", "sendFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendFile", this.interpreterStorage, null, receiverId, message, fileId, fileStream, previewUrl, fileName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("FacebookMessenger", "sendFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendCarousel(String receiverId, List<MessageItem> messageItem) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "FacebookMessenger", "sendCarousel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendCarousel", this.interpreterStorage, null, receiverId, messageItem);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("FacebookMessenger", "sendCarousel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public List<Message> parseReceivedMessages(InputStream httpRequest) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "FacebookMessenger", "parseReceivedMessages").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("processWebhookRequest", this.interpreterStorage, null, httpRequest);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("FacebookMessenger", "parseReceivedMessages").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public MessagingAttachment downloadContent(MessagingAttachment attachment) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "FacebookMessenger", "downloadContent").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("downloadContent", this.interpreterStorage, null, attachment);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("FacebookMessenger", "downloadContent").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (MessagingAttachment)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "FacebookMessenger", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("FacebookMessenger", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

