/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.PointsOfInterest;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.POI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Foursquare
implements PointsOfInterest,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"set", "$P0.baseUrl", "https://api.foursquare.com/v2"}, new Object[]{"create", "$P0.crToFoursquare", "Object"}, new Object[]{"create", "$P0.foursquareToCr", "Object"}, new Object[]{"callFunc", "addCategory", "$P0", "airport", "4bf58dd8d48988d1ed931735"}, new Object[]{"callFunc", "addCategory", "$P0", "atm", "52f2ab2ebcbc57f1066b8b56"}, new Object[]{"callFunc", "addCategory", "$P0", "amusement_park", "4bf58dd8d48988d182941735"}, new Object[]{"callFunc", "addCategory", "$P0", "aquarium", "4fceea171983d5d06c3e9823"}, new Object[]{"callFunc", "addCategory", "$P0", "art_gallery", "4bf58dd8d48988d1e2931735"}, new Object[]{"callFunc", "addCategory", "$P0", "bakery", "4bf58dd8d48988d16a941735 "}, new Object[]{"callFunc", "addCategory", "$P0", "bank", "4bf58dd8d48988d10a951735"}, new Object[]{"callFunc", "addCategory", "$P0", "bar", "4bf58dd8d48988d116941735"}, new Object[]{"callFunc", "addCategory", "$P0", "beauty_salon", "54541900498ea6ccd0202697"}, new Object[]{"callFunc", "addCategory", "$P0", "bicycle_store", "4bf58dd8d48988d115951735"}, new Object[]{"callFunc", "addCategory", "$P0", "book_store", "4bf58dd8d48988d114951735"}, new Object[]{"callFunc", "addCategory", "$P0", "bowling_alley", "4bf58dd8d48988d1e4931735"}, new Object[]{"callFunc", "addCategory", "$P0", "bus_station", "4bf58dd8d48988d1fe931735"}, new Object[]{"callFunc", "addCategory", "$P0", "cafe", "4bf58dd8d48988d16d941735"}, new Object[]{"callFunc", "addCategory", "$P0", "car_dealer", "4eb1c1623b7b52c0e1adc2ec"}, new Object[]{"callFunc", "addCategory", "$P0", "car_rental", "4bf58dd8d48988d1ef941735"}, new Object[]{"callFunc", "addCategory", "$P0", "car_repair", "56aa371be4b08b9a8d5734d3"}, new Object[]{"callFunc", "addCategory", "$P0", "car_wash", "4f04ae1f2fb6e1c99f3db0ba"}, new Object[]{"callFunc", "addCategory", "$P0", "casino", "4bf58dd8d48988d17c941735"}, new Object[]{"callFunc", "addCategory", "$P0", "cemetery", "4bf58dd8d48988d15c941735"}, new Object[]{"callFunc", "addCategory", "$P0", "church", "4bf58dd8d48988d132941735"}, new Object[]{"callFunc", "addCategory", "$P0", "clothing_store", "4bf58dd8d48988d103951735"}, new Object[]{"callFunc", "addCategory", "$P0", "convenience_store", "4d954b0ea243a5684a65b473"}, new Object[]{"callFunc", "addCategory", "$P0", "courthouse", "4bf58dd8d48988d12b941735"}, new Object[]{"callFunc", "addCategory", "$P0", "dentist", "4bf58dd8d48988d178941735"}, new Object[]{"callFunc", "addCategory", "$P0", "department_store", "4bf58dd8d48988d1f6941735"}, new Object[]{"callFunc", "addCategory", "$P0", "doctor", "4bf58dd8d48988d177941735"}, new Object[]{"callFunc", "addCategory", "$P0", "electronics_store", "4bf58dd8d48988d122951735"}, new Object[]{"callFunc", "addCategory", "$P0", "embassy", "4bf58dd8d48988d12c951735"}, new Object[]{"callFunc", "addCategory", "$P0", "finance", "503287a291d4c4b30a586d65"}, new Object[]{"callFunc", "addCategory", "$P0", "fire_station", "4bf58dd8d48988d12c941735"}, new Object[]{"callFunc", "addCategory", "$P0", "florist", "4bf58dd8d48988d11b951735"}, new Object[]{"callFunc", "addCategory", "$P0", "food", "4d4b7105d754a06374d81259"}, new Object[]{"callFunc", "addCategory", "$P0", "funeral_home", "4f4534884b9074f6e4fb0174"}, new Object[]{"callFunc", "addCategory", "$P0", "furniture_store", "4bf58dd8d48988d1f8941735"}, new Object[]{"callFunc", "addCategory", "$P0", "gas_station", "4bf58dd8d48988d113951735"}, new Object[]{"callFunc", "addCategory", "$P0", "grocery_or_supermarket", "4bf58dd8d48988d118951735"}, new Object[]{"callFunc", "addCategory", "$P0", "gym", "4bf58dd8d48988d175941735"}, new Object[]{"callFunc", "addCategory", "$P0", "hardware_store", "4bf58dd8d48988d112951735"}, new Object[]{"callFunc", "addCategory", "$P0", "health", "54541900498ea6ccd0202697"}, new Object[]{"callFunc", "addCategory", "$P0", "hindu_temple", "52e81612bcbc57f1066b7a3f"}, new Object[]{"callFunc", "addCategory", "$P0", "hospital", "4bf58dd8d48988d196941735"}, new Object[]{"callFunc", "addCategory", "$P0", "jewelry_store", "4bf58dd8d48988d111951735"}, new Object[]{"callFunc", "addCategory", "$P0", "laundry", "4bf58dd8d48988d1fc941735"}, new Object[]{"callFunc", "addCategory", "$P0", "lawyer", "52f2ab2ebcbc57f1066b8b3f"}, new Object[]{"callFunc", "addCategory", "$P0", "library", "4bf58dd8d48988d12f941735"}, new Object[]{"callFunc", "addCategory", "$P0", "locksmith", "52f2ab2ebcbc57f1066b8b1e"}, new Object[]{"callFunc", "addCategory", "$P0", "mosque", "4bf58dd8d48988d138941735"}, new Object[]{"callFunc", "addCategory", "$P0", "movie_theater", "4bf58dd8d48988d17f941735"}, new Object[]{"callFunc", "addCategory", "$P0", "museum", "4bf58dd8d48988d181941735"}, new Object[]{"callFunc", "addCategory", "$P0", "night_club", "4bf58dd8d48988d11f941735"}, new Object[]{"callFunc", "addCategory", "$P0", "parks", "4bf58dd8d48988d163941735"}, new Object[]{"callFunc", "addCategory", "$P0", "parking", "4c38df4de52ce0d596b336e1"}, new Object[]{"callFunc", "addCategory", "$P0", "pet_store", "4bf58dd8d48988d100951735"}, new Object[]{"callFunc", "addCategory", "$P0", "pharmacy", "4bf58dd8d48988d10f951735"}, new Object[]{"callFunc", "addCategory", "$P0", "physiotherapist", "5744ccdfe4b0c0459246b4af"}, new Object[]{"callFunc", "addCategory", "$P0", "police", "4bf58dd8d48988d12e941735"}, new Object[]{"callFunc", "addCategory", "$P0", "post_office", "4bf58dd8d48988d172941735"}, new Object[]{"callFunc", "addCategory", "$P0", "real_estate_agency", "5032885091d4c4b30a586d66"}, new Object[]{"callFunc", "addCategory", "$P0", "restaurant", "4d4b7105d754a06374d81259"}, new Object[]{"callFunc", "addCategory", "$P0", "rv_park", "52f2ab2ebcbc57f1066b8b53"}, new Object[]{"callFunc", "addCategory", "$P0", "school", "4bf58dd8d48988d13b941735"}, new Object[]{"callFunc", "addCategory", "$P0", "shoe_store", "4bf58dd8d48988d107951735"}, new Object[]{"callFunc", "addCategory", "$P0", "shopping_mall", "4bf58dd8d48988d1fd941735"}, new Object[]{"callFunc", "addCategory", "$P0", "spa", "4bf58dd8d48988d1ed941735"}, new Object[]{"callFunc", "addCategory", "$P0", "stadium", "4bf58dd8d48988d184941735"}, new Object[]{"callFunc", "addCategory", "$P0", "synagogue", "4bf58dd8d48988d139941735"}, new Object[]{"callFunc", "addCategory", "$P0", "taxi_stand", "53fca564498e1a175f32528b"}, new Object[]{"callFunc", "addCategory", "$P0", "train_station", "4bf58dd8d48988d129951735"}, new Object[]{"callFunc", "addCategory", "$P0", "travel_agency", "4f04b08c2fb6e1c99f3db0bd"}, new Object[]{"callFunc", "addCategory", "$P0", "university", "4d4b7105d754a06372d81259"}, new Object[]{"callFunc", "addCategory", "$P0", "veterinary_care", "4d954af4a243a5684765b473"}, new Object[]{"callFunc", "addCategory", "$P0", "zoo", "4bf58dd8d48988d17b941735"}});
            this.put("getNearbyPOIs", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Latitude"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "Longitude"}, new Object[]{"callFunc", "checkNull", "$P0", "$P4", "Radius"}, new Object[]{"callFunc", "checkLessThan", "$P0", "$P2", -90, "Latitude"}, new Object[]{"callFunc", "checkLessThan", "$P0", "$P3", -180, "Longitude"}, new Object[]{"callFunc", "checkLessThan", "$P0", "$P4", 0, "Radius"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P2", 90, "Latitude"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P3", 180, "Longitude"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P4", 40000, "Radius"}, new Object[]{"if!=than", "$P6", null, 1}, new Object[]{"callFunc", "checkIsEmpty", "$P0", "$P6", "Categories"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "/venues/search?v=20160614&m=foursquare"}, new Object[]{"string.concat", "$L1", "$P2", ",", "$P3"}, new Object[]{"string.urlEncode", "$L1", "$L1"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&ll=", "$L1"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&radius=", "$P4"}, new Object[]{"if!=than", "$P5", null, 2}, new Object[]{"string.urlEncode", "$L1", "$P5"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&query=", "$L1"}, new Object[]{"if!=than", "$P6", null, 3}, new Object[]{"callFunc", "getCategoriesString", "$P0", "$L2", "$P6"}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&categoryId=", "$L2"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpResponse", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"set", "$L3", "$L3.response.venues"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"create", "$L4", "Number", 0}, new Object[]{"size", "$L5", "$L3"}, new Object[]{"if<than", "$L4", "$L5", 5}, new Object[]{"get", "$L6", "$L3", "$L4"}, new Object[]{"callFunc", "extractPOI", "$P0", "$L7", "$L6"}, new Object[]{"push", "$P1", "$L7"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -6}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 2}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "$P2.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 6}, new Object[]{"string.indexOf", "$L1", "$L0.url", "?"}, new Object[]{"if==than", "$L1", -1, 2}, new Object[]{"string.concat", "$L0.url", "$L0.url", "?"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "checkHttpResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be null."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkLessThan", new Object[]{new Object[]{"if<than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be less than ", "$P2", "."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkGreaterThan", new Object[]{new Object[]{"if>than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be greater than ", "$P2", "."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkIsEmpty", new Object[]{new Object[]{"size", "$L0", "$P2"}, new Object[]{"if==than", "$L0", 0, 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be empty."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkHttpResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 9}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L1", "Error", "Invalid credentials or access rights.", "Authentication"}, new Object[]{"throwError", "$L1"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L1", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L1"}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"create", "$L1", "Error", "$L0.meta.errorDetail", "Http"}, new Object[]{"throwError", "$L1"}});
            this.put("getCategoriesString", new Object[]{new Object[]{"create", "$P1", "String"}, new Object[]{"create", "$L0", "Number", 0}, new Object[]{"size", "$L1", "$P2"}, new Object[]{"if<than", "$L0", "$L1", 10}, new Object[]{"get", "$L2", "$P2", "$L0"}, new Object[]{"get", "$L2", "$P0.crToFoursquare", "$L2"}, new Object[]{"if==than", "$L2", null, 2}, new Object[]{"create", "$L3", "Error", "Unknown category.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}, new Object[]{"if!=than", "$L0", 0, 1}, new Object[]{"string.concat", "$P1", "$P1", ","}, new Object[]{"string.concat", "$P1", "$P1", "$L2"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"jumpRel", -11}});
            this.put("extractPOI", new Object[]{new Object[]{"create", "$L0", "Array"}, new Object[]{"create", "$L1", "Number", 0}, new Object[]{"size", "$L2", "$P2.categories"}, new Object[]{"if<than", "$L1", "$L2", 7}, new Object[]{"get", "$L3", "$P2.categories", "$L1"}, new Object[]{"set", "$L3", "$L3.id"}, new Object[]{"get", "$L4", "$P0.foursquareToCr", "$L3"}, new Object[]{"if!=than", "$L4", null, 1}, new Object[]{"push", "$L0", "$L4"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -8}, new Object[]{"create", "$L1", "Location"}, new Object[]{"set", "$L1.latitude", "$P2.location.lat"}, new Object[]{"set", "$L1.longitude", "$P2.location.lng"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"string.concat", "$L2.url", "https://api.foursquare.com/v2/venues/", "$P2.id", "/photos"}, new Object[]{"string.concat", "$L2.url", "$L2.url", "?client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret"}, new Object[]{"string.concat", "$L2.url", "$L2.url", "&limit=1&v=20160614&m=foursquare"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "checkHttpResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$L4", "$L3.responseBody"}, new Object[]{"get", "$L5", "$L4.response.photos.items"}, new Object[]{"size", "$L6", "$L5"}, new Object[]{"if==than", "$L6", 0, 2}, new Object[]{"set", "$L6", null}, new Object[]{"jumpRel", 2}, new Object[]{"get", "$L5", "$L5", 0}, new Object[]{"string.concat", "$L6", "$L5.prefix", "original", "$L5.suffix"}, new Object[]{"create", "$P1", "POI", "$L0", "$L6", "$L1", "$P2.name", "$P2.contact.phone"}});
            this.put("addCategory", new Object[]{new Object[]{"set", "$P0.crToFoursquare", "$P2", "$P1"}, new Object[]{"set", "$P0.foursquareToCr", "$P1", "$P2"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Foursquare(Context context, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Foursquare...");
        new InitSelfTestTask("Foursquare", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public List<POI> getNearbyPOIs(Double latitude, Double longitude, Long radius, String searchTerm, List<String> categories) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Foursquare", "getNearbyPOIs").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getNearbyPOIs", this.interpreterStorage, null, latitude, longitude, radius, searchTerm, categories);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Foursquare", "getNearbyPOIs").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Foursquare", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Foursquare", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

