/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Email;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Attachment;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GMail
implements Email,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("sendEmail", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P1", "fromAddress"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "fromName"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P3", "toAddresses"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P4", "subject"}, new Object[]{"callFunc", "checkEmptyList", "$P0", "$P3", "toAddresses"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P1", "fromAddress"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "fromName"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P4", "subject"}, new Object[]{"set", "$L6", 1}, new Object[]{"set", "$L7", 1}, new Object[]{"if==than", "$P5", null, 1}, new Object[]{"set", "$L6", 0}, new Object[]{"if==than", "$P5", "", 1}, new Object[]{"set", "$L6", 0}, new Object[]{"if==than", "$P6", null, 1}, new Object[]{"set", "$L7", 0}, new Object[]{"if==than", "$P6", "", 1}, new Object[]{"set", "$L7", 0}, new Object[]{"if==than", "$L6", 0, 3}, new Object[]{"if==than", "$L7", 0, 2}, new Object[]{"create", "$L8", "Error", "Either a textBody or a htmlBody must be provided!", "IllegalArgument"}, new Object[]{"throwError", "$L8"}, new Object[]{"set", "$L11", 0}, new Object[]{"if!=than", "$P9", null, 3}, new Object[]{"size", "$L1", "$P9"}, new Object[]{"if!=than", "$L1", 0, 1}, new Object[]{"set", "$L11", 1}, new Object[]{"set", "$L12", "nfh39t8gui34fhoifc90a9fhg39pkjoiu90oh4ug"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://www.googleapis.com/gmail/v1/users/", "$P1", "/messages/send"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"set", "$L0.requestHeaders.uploadType", "multipart"}, new Object[]{"create", "$L4", "String"}, new Object[]{"string.concat", "$L4", "$L4", "Content-Type: multipart/mixed; boundary=", "$L12", "\r\n"}, new Object[]{"string.concat", "$L4", "$L4", "MIME-Version: 1.0\r\n"}, new Object[]{"create", "$L5", "Date"}, new Object[]{"string.concat", "$L4", "$L4", "Date: ", "$L5.rfcTime2822", "\r\n"}, new Object[]{"if!=than", "$P2", null, 3}, new Object[]{"if!=than", "$P2", "", 2}, new Object[]{"string.concat", "$L4", "$L4", "From: ", "$P2", " <", "$P1", ">", "\r\n"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L4", "$L4", "From: ", "$P1", "\r\n"}, new Object[]{"callFunc", "addAddresses", "$P0", "$L4", "$P3", "To"}, new Object[]{"callFunc", "addAddresses", "$P0", "$L4", "$P7", "Cc"}, new Object[]{"callFunc", "addAddresses", "$P0", "$L4", "$P8", "Bcc"}, new Object[]{"string.concat", "$L4", "$L4", "Subject: ", "$P4", "\r\n"}, new Object[]{"string.concat", "$L4", "$L4", "\r\n"}, new Object[]{"string.concat", "$L4", "$L4", "--", "$L12", "\r\n"}, new Object[]{"if==than", "$L7", 1, 2}, new Object[]{"string.concat", "$L4", "$L4", "Content-Type: text/html\r\n"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L4", "$L4", "Content-Type: text/plain\r\n"}, new Object[]{"string.concat", "$L4", "$L4", "Content-Transfer-Encoding: quoted-printable\r\n"}, new Object[]{"if==than", "$L7", 1, 2}, new Object[]{"string.concat", "$L4", "$L4", "$P6"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L4", "$L4", "$P5"}, new Object[]{"if==than", "$L11", 1, 1}, new Object[]{"callFunc", "addAttachments", "$P0", "$L4", "$P9", "$L12"}, new Object[]{"string.concat", "$L4", "$L4", "\r\n\r\n", "--", "$L12", "--"}, new Object[]{"string.base64encode", "$L4", "$L4", 0, 1}, new Object[]{"string.concat", "$L0.requestBody", "{\"raw\": \"", "$L4", "\"}"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L0.requestBody"}, new Object[]{"create", "$L9", "Object"}, new Object[]{"http.requestCall", "$L9", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L9"}, new Object[]{"create", "$L10", "String"}, new Object[]{"stream.streamToString", "$L10", "$L9.responseBody"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "https://www.googleapis.com/gmail/v1"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("addAddresses", new Object[]{new Object[]{"create", "$L0", "String"}, new Object[]{"if==than", "$P2", null, 1}, new Object[]{"return"}, new Object[]{"size", "$L1", "$P2"}, new Object[]{"if==than", "$L1", 0, 1}, new Object[]{"return"}, new Object[]{"create", "$L2", "Number", 0}, new Object[]{"if<than", "$L2", "$L1", 6}, new Object[]{"get", "$L3", "$P2", "$L2"}, new Object[]{"if>than", "$L2", 0, 1}, new Object[]{"string.concat", "$L0", "$L0", ", "}, new Object[]{"string.concat", "$L0", "$L0", "$L3"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -7}, new Object[]{"string.concat", "$P1", "$P1", "$P3", ": ", "$L0", "\r\n"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.accessToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0", "accessToken"}, new Object[]{"return"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L1.time", "$S0.expireIn"}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"callFunc", "authenticate", "$P0", "refreshToken"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L2", "String"}, new Object[]{"if==than", "$P1", "accessToken", 4}, new Object[]{"string.concat", "$L0", "https://accounts.google.com/o/oauth2/v2/auth?client_id=", "$P0.clientID", "&scope=", "https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fgmail.send", "&response_type=code&prompt=consent&access_type=offline&redirect_uri=", "$P0.redirectUri", "&state=", "$P0.state", "&suppress_webview_warning=true"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0"}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientID", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&code=", "$L1", "&grant_type=authorization_code"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientID", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&refresh_token=", "$S0.refreshToken", "&grant_type=refresh_token"}, new Object[]{"stream.stringToStream", "$L3", "$L2"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "https://www.googleapis.com/oauth2/v4/token"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestBody", "$L3"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6"}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$S0.accessToken", "$L8.access_token"}, new Object[]{"if!=than", "$L8.refresh_token", null, 1}, new Object[]{"set", "$S0.refreshToken", "$L8.refresh_token"}, new Object[]{"create", "$L10", "Date"}, new Object[]{"math.multiply", "$L9", "$L8.expires_in", 1000}, new Object[]{"math.add", "$L9", "$L9", "$L10.time", -60000}, new Object[]{"set", "$S0.expireIn", "$L9"}});
            this.put("addAttachments", new Object[]{new Object[]{"size", "$L0", "$P2"}, new Object[]{"create", "$L1", "Number", 0}, new Object[]{"if<than", "$L1", "$L0", 20}, new Object[]{"get", "$L2", "$P2", "$L1"}, new Object[]{"set", "$L4", "$L2.content"}, new Object[]{"set", "$L5", "$L2.filename"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$L4", "content"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$L5", "filename"}, new Object[]{"string.concat", "$P1", "$P1", "\r\n\r\n"}, new Object[]{"string.concat", "$P1", "$P1", "--", "$P3", "\r\n"}, new Object[]{"set", "$L10", "application/octet-stream"}, new Object[]{"if!=than", "$L2.mimeType", null, 2}, new Object[]{"if!=than", "$L2.mimeType", "", 1}, new Object[]{"set", "$L10", "$L2.mimeType"}, new Object[]{"string.concat", "$P1", "$P1", "Content-Type: ", "$L10", "; name: ", "$L5", "\r\n"}, new Object[]{"string.concat", "$P1", "$P1", "MIME-Version: 1.0\r\n"}, new Object[]{"string.concat", "$P1", "$P1", "Content-Transfer-Encoding: base64\r\n"}, new Object[]{"string.concat", "$P1", "$P1", "Content-Disposition: attachment; filename=", "$L5", "\r\n\r\n"}, new Object[]{"stream.streamToData", "$L4", "$L2.content"}, new Object[]{"string.base64encode", "$L4", "$L4"}, new Object[]{"string.concat", "$P1", "$P1", "$L4", "\r\n"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -21}, new Object[]{"string.concat", "$P1", "$P1", "\r\n"}});
            this.put("checkMandatory", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L1", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L0", "Error", "$L1", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkEmptyList", new Object[]{new Object[]{"size", "$L0", "$P1"}, new Object[]{"if==than", "$L0", 0, 3}, new Object[]{"string.concat", "$L2", "The list ", "$P2", " cannot be empty"}, new Object[]{"create", "$L1", "Error", "$L2", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkEmpty", new Object[]{new Object[]{"if==than", "$P1", "", 3}, new Object[]{"string.concat", "$L0", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 12}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L0", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L0", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L0"}, new Object[]{"json.parse", "$L1", "$P1.responseBody"}, new Object[]{"json.stringify", "$L1", "$L1.errors"}, new Object[]{"create", "$L0", "Error", "$L1", "Http"}, new Object[]{"throwError", "$L0"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public GMail(Context context, String clientID, String clientSecret, String redirectUri, String state) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientID", clientID);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.initService();
    }

    public GMail(Context context, String clientID, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientID", clientID);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.interpreterStorage.put("state", "CloudRailSI");
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to GMail...");
        new InitSelfTestTask("GMail", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public void sendEmail(String fromAddress, String fromName, List<String> toAddresses, String subject, String textBody, String htmlBody, List<String> ccAddresses, List<String> bccAddresses, List<Attachment> attachments) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GMail", "sendEmail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendEmail", this.interpreterStorage, fromAddress, fromName, toAddresses, subject, textBody, htmlBody, ccAddresses, bccAddresses, attachments);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GMail", "sendEmail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GMail", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GMail", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

