/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.BusinessCloudStorage;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Bucket;
import com.cloudrail.si.types.BusinessFileMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GoogleCloudPlatform
implements BusinessCloudStorage,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"set", "$P0.baseUrl", "https://www.googleapis.com"}, new Object[]{"string.concat", "$P0.storageBase", "$P0.baseUrl", "/storage/v1"}, new Object[]{"string.concat", "$P0.authBase", "$P0.baseUrl", "/oauth2/v4/token"}, new Object[]{"string.substring", "$P0.privateKey", "$P0.privateKey", 28}, new Object[]{"size", "$L0", "$P0.privateKey"}, new Object[]{"math.add", "$L0", "$L0", -26}, new Object[]{"string.substring", "$P0.privateKey", "$P0.privateKey", 0, "$L0"}});
            this.put("listBuckets", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b?project=", "$P0.projectId"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"size", "$L3", "$L2.items"}, new Object[]{"create", "$L4", "Number"}, new Object[]{"if<than", "$L4", "$L3", 7}, new Object[]{"get", "$L5", "$L2.items", "$L4"}, new Object[]{"create", "$L6", "Bucket"}, new Object[]{"set", "$L6.name", "$L5.name"}, new Object[]{"set", "$L6.identifier", "$L5.id"}, new Object[]{"push", "$P1", "$L6"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -8}});
            this.put("createBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b?project=", "$P0.projectId"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.name", "$P2"}, new Object[]{"json.stringify", "$L2", "$L1"}, new Object[]{"stream.stringToStream", "$L3", "$L2"}, new Object[]{"set", "$L0.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"create", "$P1", "Bucket"}, new Object[]{"set", "$P1.name", "$L2.name"}, new Object[]{"set", "$P1.identifier", "$L2.id"}});
            this.put("deleteBucket", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "DELETE"}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b/", "$P1.name"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("listFiles", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b/", "$P2.name", "/o?maxResults=1000"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"size", "$L3", "$L2.items"}, new Object[]{"create", "$L4", "Number"}, new Object[]{"if<than", "$L4", "$L3", 6}, new Object[]{"get", "$L5", "$L2.items", "$L4"}, new Object[]{"if==than", "$L5.timeDeleted", null, 2}, new Object[]{"callFunc", "makeMeta", "$P0", "$L6", "$L5"}, new Object[]{"push", "$P1", "$L6"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -7}, new Object[]{"if!=than", "$L2.nextPageToken", null, 7}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b/", "$P2.name", "/o?maxResults=1000", "&pageToken=", "$L2.nextPageToken"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"jumpRel", -17}});
            this.put("listFilesWithPrefix", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkPrefix", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b/", "$P2.name", "/o?maxResults=1000", "&prefix=", "$P3"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"size", "$L3", "$L2.items"}, new Object[]{"create", "$L4", "Number"}, new Object[]{"if<than", "$L4", "$L3", 6}, new Object[]{"get", "$L5", "$L2.items", "$L4"}, new Object[]{"if==than", "$L5.timeDeleted", null, 2}, new Object[]{"callFunc", "makeMeta", "$P0", "$L6", "$L5"}, new Object[]{"push", "$P1", "$L6"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -7}, new Object[]{"if!=than", "$L2.nextPageToken", null, 7}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b/", "$P2.name", "/o?maxResults=1000", "&pageToken=", "$L2.nextPageToken"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"jumpRel", -17}});
            this.put("checkPrefix", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L1", "Error", "Prefix supplied is null", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("getFileMetadata", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"callFunc", "encodeObjectName", "$P0", "$L3", "$P3"}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b/", "$P2.name", "/o/", "$L3"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "makeMeta", "$P0", "$P1", "$L2"}});
            this.put("deleteFile", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "DELETE"}, new Object[]{"callFunc", "encodeObjectName", "$P0", "$L2", "$P1"}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b/", "$P2.name", "/o/", "$L2"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("uploadFile", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"callFunc", "checkSize", "$P0", "$P4"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "encodeObjectName", "$P0", "$L1", "$P2"}, new Object[]{"callFunc", "initUpload", "$P0", "$L0", "$P1", "$L1"}, new Object[]{"callFunc", "performUpload", "$P0", "$L0", "$P3", "$P4"}});
            this.put("downloadFile", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P3"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"callFunc", "encodeObjectName", "$P0", "$L2", "$P2"}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "/b/", "$P3.name", "/o/", "$L2", "?alt=media"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$P1", "$L1.responseBody"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 3}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.url", "$P0.storageBase", "$P2.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"if!=than", "$P2.body", null, 1}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("initUpload", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "/upload/storage/v1/b/", "$P2.name", "/o?uploadType=resumable&name=", "$P3"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$P1", "$L1.responseHeaders.Location"}});
            this.put("performUpload", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "PUT"}, new Object[]{"set", "$L0.url", "$P1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Length", "$P3"}, new Object[]{"set", "$L0.requestBody", "$P2"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("makeMeta", new Object[]{new Object[]{"create", "$P1", "BusinessFileMetaData"}, new Object[]{"set", "$P1.fileName", "$P2.name"}, new Object[]{"set", "$P1.fileID", "$P2.id"}, new Object[]{"set", "$P1.size", "$P2.size"}, new Object[]{"create", "$L0", "Date", "$P2.updated"}, new Object[]{"set", "$P1.lastModified", "$L0.time"}});
            this.put("validateResponse", new Object[]{new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L0", "Error", "Not Found", "NotFound"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1.code", 409, 2}, new Object[]{"create", "$L0", "Error", "File or Bucket already exists", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if>=than", "$P1.code", 400, 4}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"json.stringify", "$L0", "$L0"}, new Object[]{"create", "$L1", "Error", "$L0", "HttpException"}, new Object[]{"throwError", "$L1"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if!=than", "$P0.accessToken", null, 3}, new Object[]{"create", "$L0", "Date"}, new Object[]{"if<than", "$L0.time", "$P0.expires", 1}, new Object[]{"return"}, new Object[]{"callFunc", "createJWT", "$P0", "$L0"}, new Object[]{"callFunc", "retrieveAccessToken", "$P0", "$L0"}});
            this.put("createJWT", new Object[]{new Object[]{"set", "$P1", "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.iss", "$P0.clientEmail"}, new Object[]{"set", "$L1.scope", "https://www.googleapis.com/auth/cloud-platform"}, new Object[]{"set", "$L1.aud", "https://www.googleapis.com/oauth2/v4/token"}, new Object[]{"create", "$L2", "Date"}, new Object[]{"math.add", "$L3", "$L2.time", 180000}, new Object[]{"set", "$L1.exp", "$L3"}, new Object[]{"math.multiply", "$L1.exp", "$L1.exp", 0.001}, new Object[]{"set", "$L1.iat", "$L2.time"}, new Object[]{"math.multiply", "$L1.iat", "$L1.iat", 0.001}, new Object[]{"json.stringify", "$L0", "$L1"}, new Object[]{"string.base64encode", "$L0", "$L0", 0, 1}, new Object[]{"string.concat", "$P1", "$P1", ".", "$L0"}, new Object[]{"stream.stringToStream", "$L0", "$P1"}, new Object[]{"stream.streamToData", "$L1", "$L0"}, new Object[]{"string.base64decode", "$L2", "$P0.privateKey"}, new Object[]{"crypt.rsa.sha256", "$L2", "$L1", "$L2"}, new Object[]{"string.base64encode", "$L3", "$L2", 0, 1}, new Object[]{"string.concat", "$P1", "$P1", ".", "$L3"}});
            this.put("retrieveAccessToken", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "$P0.authBase"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"string.concat", "$L1", "grant_type=urn%3Aietf%3Aparams%3Aoauth%3Agrant-type%3Ajwt-bearer&assertion=", "$P1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"set", "$P0.accessToken", "$L2.access_token"}, new Object[]{"create", "$L3", "Date"}, new Object[]{"math.multiply", "$L4", "$L2.expires_in", 1000}, new Object[]{"math.add", "$P0.expires", "$L3.time", "$L4", -1000000}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Parameter should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P1"}, new Object[]{"if==than", "$P1.name", null, 3}, new Object[]{"if==than", "$P1.identifier", null, 2}, new Object[]{"create", "$L0", "Error", "Bucket name and identifier should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkSize", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Size can not be negative.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("replace", new Object[]{new Object[]{"string.split", "$L0", "$P2", "$P3"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"set", "$L2", 0}, new Object[]{"if<than", "$L2", "$L1", 7}, new Object[]{"get", "$L5", "$L0", "$L2"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"set", "$L4", "$L5"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L4", "$L4", "$P4", "$L5"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -8}, new Object[]{"set", "$P1", "$L4"}});
            this.put("encodeObjectName", new Object[]{new Object[]{"callFunc", "replace", "$P0", "$L1", "$P2", "\u2019", "'"}, new Object[]{"string.urlEncode", "$P1", "$L1"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public GoogleCloudPlatform(Context context, String clientEmail, String privateKey, String projectId) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientEmail", clientEmail);
        this.interpreterStorage.put("privateKey", privateKey);
        this.interpreterStorage.put("projectId", projectId);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to GoogleCloudPlatform...");
        new InitSelfTestTask("GoogleCloudPlatform", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Bucket createBucket(String bucketName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "createBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createBucket", this.interpreterStorage, null, bucketName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "createBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Bucket)ip.getParameter(1);
    }

    @Override
    public List<Bucket> listBuckets() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "listBuckets").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listBuckets", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "listBuckets").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void deleteBucket(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "deleteBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("deleteBucket", this.interpreterStorage, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "deleteBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void deleteFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "deleteFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("deleteFile", this.interpreterStorage, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "deleteFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public BusinessFileMetaData getFileMetadata(Bucket bucket, String fileName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "getFileMetadata").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getFileMetadata", this.interpreterStorage, null, bucket, fileName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "getFileMetadata").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (BusinessFileMetaData)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFiles(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "listFiles").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listFiles", this.interpreterStorage, null, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "listFiles").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFilesWithPrefix(Bucket bucket, String prefix) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "listFilesWithPrefix").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listFilesWithPrefix", this.interpreterStorage, null, bucket, prefix);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "listFilesWithPrefix").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void uploadFile(Bucket bucket, String name, InputStream stream, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "uploadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("uploadFile", this.interpreterStorage, bucket, name, stream, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "uploadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public InputStream downloadFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "downloadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("downloadFile", this.interpreterStorage, null, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "downloadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GoogleCloudPlatform", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GoogleCloudPlatform", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

