/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Profile;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.DateOfBirth;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GooglePlus
implements Profile,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"if==than", "$P0.scopes", null, 2}, new Object[]{"set", "$P0.scope", "https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fplus.login+https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fplus.profile.emails.read"}, new Object[]{"jumpRel", 10}, new Object[]{"create", "$P0.scope", "String"}, new Object[]{"size", "$L0", "$P0.scopes"}, new Object[]{"create", "$L1", "Number", 0}, new Object[]{"if<than", "$L1", "$L0", 6}, new Object[]{"if!=than", "$L1", 0, 1}, new Object[]{"string.concat", "$P0.scope", "$P0.scope", "+"}, new Object[]{"get", "$L2", "$P0.scopes", "$L1"}, new Object[]{"string.concat", "$P0.scope", "$P0.scope", "$L2"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -7}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "https://www.googleapis.com/plus/v1"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://accounts.google.com/o/oauth2/revoke?token=", "$S0.accessToken"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$S0.accessToken", null}, new Object[]{"set", "$P0.userInfo", null}});
            this.put("Profile:getIdentifier", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"string.concat", "$P1", "googleplus-", "$P0.userInfo.id"}});
            this.put("Profile:getFullName", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.displayName", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.displayName"}});
            this.put("Profile:getEmail", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"get", "$P1", "$P0.userInfo.emails", 0, "value"}});
            this.put("Profile:getGender", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.gender", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.gender"}});
            this.put("Profile:getDescription", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.aboutMe", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.aboutMe"}});
            this.put("Profile:getDateOfBirth", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"create", "$P1", "DateOfBirth"}, new Object[]{"if!=than", "$P0.userInfo.birthday", null, 10}, new Object[]{"string.split", "$L0", "$P0.userInfo.birthday", "-"}, new Object[]{"get", "$L1", "$L0", 0}, new Object[]{"if!=than", "$L1", "0000", 1}, new Object[]{"math.add", "$P1.year", "$L1", 0}, new Object[]{"get", "$L1", "$L0", 1}, new Object[]{"if!=than", "$L1", "00", 1}, new Object[]{"math.add", "$P1.month", "$L1", 0}, new Object[]{"get", "$L1", "$L0", 2}, new Object[]{"if!=than", "$L1", "00", 1}, new Object[]{"math.add", "$P1.day", "$L1", 0}});
            this.put("Profile:getLocale", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.language", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.language"}});
            this.put("Profile:getPictureURL", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.image.url", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.image.url"}});
            this.put("checkUserInfo", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if!=than", "$P0.userInfo", null, 2}, new Object[]{"if>than", "$P0.expirationTime", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://www.googleapis.com/plus/v1/people/me"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$P0.userInfo", "$L3.responseBody"}, new Object[]{"create", "$P0.expirationTime", "Date"}, new Object[]{"math.add", "$P0.expirationTime.time", "$P0.expirationTime.time", 60000}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.accessToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0", "accessToken"}, new Object[]{"return"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L1.time", "$S0.expireIn"}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"callFunc", "authenticate", "$P0", "refreshToken"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L2", "String"}, new Object[]{"if==than", "$P1", "accessToken", 4}, new Object[]{"string.concat", "$L0", "https://accounts.google.com/o/oauth2/v2/auth?client_id=", "$P0.clientId", "&scope=", "$P0.scope", "&response_type=code&prompt=consent&access_type=offline&redirect_uri=", "$P0.redirectUri", "&state=", "$P0.state", "&suppress_webview_warning=true"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0", null, "$P0.redirectUri"}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&code=", "$L1", "&grant_type=authorization_code"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&refresh_token=", "$S0.refreshToken", "&grant_type=refresh_token"}, new Object[]{"stream.stringToStream", "$L3", "$L2"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "https://www.googleapis.com/oauth2/v4/token"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestBody", "$L3"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6"}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$S0.accessToken", "$L8.access_token"}, new Object[]{"if!=than", "$L8.refresh_token", null, 1}, new Object[]{"set", "$S0.refreshToken", "$L8.refresh_token"}, new Object[]{"create", "$L10", "Date"}, new Object[]{"math.multiply", "$L9", "$L8.expires_in", 1000}, new Object[]{"math.add", "$L9", "$L9", "$L10.time", -60000}, new Object[]{"set", "$S0.expireIn", "$L9"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 19}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 400, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 402, 5}, new Object[]{"if<=than", "$P1.code", 509, 4}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"if!=than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public GooglePlus(Context context, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.interpreterStorage.put("state", "CloudRailSI");
        this.initService();
    }

    public GooglePlus(Context context, String clientId, String clientSecret, List<String> scopes) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("scopes", scopes);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.interpreterStorage.put("state", "CloudRailSI");
        this.initService();
    }

    public GooglePlus(Context context, String clientId, String clientSecret, String redirectUri, String state) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.initService();
    }

    public GooglePlus(Context context, String clientId, String clientSecret, String redirectUri, String state, List<String> scopes) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.interpreterStorage.put("scopes", scopes);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to GooglePlus...");
        new InitSelfTestTask("GooglePlus", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public String getIdentifier() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "getIdentifier").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getIdentifier", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "getIdentifier").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getFullName() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "getFullName").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getFullName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "getFullName").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getEmail() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "getEmail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getEmail", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "getEmail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getGender() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "getGender").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getGender", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "getGender").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getDescription() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "getDescription").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDescription", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "getDescription").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public DateOfBirth getDateOfBirth() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "getDateOfBirth").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDateOfBirth", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "getDateOfBirth").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (DateOfBirth)ip.getParameter(1);
    }

    @Override
    public String getLocale() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "getLocale").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getLocale", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "getLocale").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getPictureURL() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "getPictureURL").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getPictureURL", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "getPictureURL").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "GooglePlus", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("GooglePlus", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

