/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Messaging;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.Message;
import com.cloudrail.si.types.MessageItem;
import com.cloudrail.si.types.MessagingAttachment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Line
implements Messaging,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "https://api.line.me/v2/bot/message"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 1}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.botToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("processWebhookRequest", new Object[]{new Object[]{"json.parse", "$L0", "$P2"}, new Object[]{"get", "$L1", "$L0.events", 0}, new Object[]{"if==than", "$L1.source.type", "user", 1}, new Object[]{"set", "$L2", "$L1.source.userId"}, new Object[]{"if==than", "$L1.type", "group", 1}, new Object[]{"set", "$L2", "$L1.source.groupId"}, new Object[]{"if==than", "$L1.type", "room", 1}, new Object[]{"set", "$L2", "$L1.source.roomId"}, new Object[]{"set", "$L3", null}, new Object[]{"if!=than", "$L1.message.longitude", null, 3}, new Object[]{"create", "$L3", "Location"}, new Object[]{"set", "$L3.Longitude", "$L1.message.longitude"}, new Object[]{"set", "$L3.Latitude", "$L1.message.latitude"}, new Object[]{"set", "$L4", null}, new Object[]{"if!=than", "$L1.message.type", "text", 3}, new Object[]{"create", "$L4", "Array"}, new Object[]{"create", "$L5", "MessagingAttachment", "$L1.message.id", "$L1.message.type", null, null, null}, new Object[]{"push", "$L4", "$L5"}, new Object[]{"create", "$L6", "Message"}, new Object[]{"if!=than", "$L1.message.id", null, 2}, new Object[]{"string.concat", "$L11", "$L1.message.id"}, new Object[]{"set", "$L6.MessageId", "$L11"}, new Object[]{"if!=than", "$L1.source.userId", null, 2}, new Object[]{"string.concat", "$L12", "$L1.source.userId"}, new Object[]{"set", "$L6.SenderId", "$L12"}, new Object[]{"if!=than", "$L2", null, 2}, new Object[]{"string.concat", "$L13", "$L2"}, new Object[]{"set", "$L6.ChatId", "$L13"}, new Object[]{"if!=than", "$L1.timestamp", null, 1}, new Object[]{"set", "$L6.SendAt", "$L1.timestamp"}, new Object[]{"if!=than", "$L1.message.text", null, 2}, new Object[]{"string.concat", "$L15", "$L1.message.text"}, new Object[]{"set", "$L6.MessageText", "$L15"}, new Object[]{"if!=than", "$L3", null, 1}, new Object[]{"set", "$L6.Location", "$L3"}, new Object[]{"if!=than", "$L4", null, 1}, new Object[]{"set", "$L6.Attachments", "$L4"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"push", "$P1", "$L6"}});
            this.put("sendMessage", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P3", "message text"}, new Object[]{"callFunc", "send", "$P0", "$P1", "text", "$P2", "$P3", null, null}});
            this.put("sendImage", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P4", "content URL"}, new Object[]{"if==than", "$P6", null, 1}, new Object[]{"set", "$P6", "$P4"}, new Object[]{"callFunc", "send", "$P0", "$P1", "image", "$P2", "$P3", "$P4", "$P6"}});
            this.put("sendVideo", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P4", "content URL"}, new Object[]{"if==than", "$P6", null, 1}, new Object[]{"set", "$P6", "https://webhooks.cloudrail.com/home/ubuntu/server/media/cloudrail_preview.png"}, new Object[]{"callFunc", "send", "$P0", "$P1", "video", "$P2", "$P3", "$P4", "$P6"}});
            this.put("sendAudio", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P4", "content URL"}, new Object[]{"if==than", "$P6", null, 1}, new Object[]{"set", "$P6", "https://webhooks.cloudrail.com/home/ubuntu/server/media/cloudrail_preview.png"}, new Object[]{"callFunc", "send", "$P0", "$P1", "audio", "$P2", "$P3", "$P4", "$P6"}});
            this.put("sendFile", new Object[0]);
            this.put("sendCarousel", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "https://api.line.me/v2/bot/message/push"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.to", "$P2"}, new Object[]{"create", "$L1.messages", "Array"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.type", "template"}, new Object[]{"set", "$L2.altText", "this is a template message"}, new Object[]{"create", "$L2.template", "Object"}, new Object[]{"set", "$L2.template.type", "carousel"}, new Object[]{"create", "$L2.template.columns", "Array"}, new Object[]{"create", "$L3", "Number", 0}, new Object[]{"size", "$L4", "$P3"}, new Object[]{"if<than", "$L3", "$L4", 21}, new Object[]{"get", "$L5", "$P3", "$L3"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"set", "$L6.thumbnailImageUrl", "$L5.mediaUrl"}, new Object[]{"set", "$L6.title", "$L5.title"}, new Object[]{"set", "$L6.text", "$L5.subTitle"}, new Object[]{"create", "$L6.actions", "Array"}, new Object[]{"set", "$L7", 0}, new Object[]{"size", "$L8", "$L5.buttons"}, new Object[]{"if<than", "$L7", "$L8", 9}, new Object[]{"get", "$L9", "$L5.buttons", "$L7"}, new Object[]{"create", "$L10", "Object"}, new Object[]{"set", "$L10.type", "$L9.type"}, new Object[]{"set", "$L10.label", "$L9.text"}, new Object[]{"set", "$L10.data", "$L9.payload"}, new Object[]{"set", "$L10.uri", "$L9.url"}, new Object[]{"push", "$L6.actions", "$L10"}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"jumpRel", -10}, new Object[]{"push", "$L2.template.columns", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -22}, new Object[]{"push", "$L1.messages", "$L2"}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.botToken"}, new Object[]{"size", "$L11", "$L1"}, new Object[]{"string.concat", "$L12", "$L11"}, new Object[]{"set", "$L0.requestHeaders.Content-Length", "$L12"}, new Object[]{"create", "$L13", "Object"}, new Object[]{"http.requestCall", "$L13", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L13"}, new Object[]{"create", "$L14", "Date"}, new Object[]{"set", "$L14", "$L14.time"}, new Object[]{"create", "$P1", "Message"}, new Object[]{"set", "$P1.ChatId", "$P2"}, new Object[]{"set", "$P1.SendAt", "$L14"}});
            this.put("downloadContent", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://api.line.me/v2/bot/message/", "$P2.id", "/content"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.botToken"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$P1", "$P2"}, new Object[]{"set", "$P1.stream", "$L1.responseBody"}, new Object[]{"set", "$P1.mimeType", "$L1.responseHeaders.Content-Type"}});
            this.put("send", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "https://api.line.me/v2/bot/message/push"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.to", "$P3"}, new Object[]{"create", "$L1.messages", "Array"}, new Object[]{"if!=than", "$P4", null, 4}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4.type", "text"}, new Object[]{"set", "$L4.text", "$P4"}, new Object[]{"push", "$L1.messages", "$L4"}, new Object[]{"if!=than", "$P5", null, 7}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.type", "$P2"}, new Object[]{"set", "$L5.originalContentUrl", "$P5"}, new Object[]{"set", "$L5.previewImageUrl", "$P6"}, new Object[]{"if==than", "$P2", "audio", 1}, new Object[]{"set", "$L5.duration", 1}, new Object[]{"push", "$L1.messages", "$L5"}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.botToken"}, new Object[]{"size", "$L2", "$L1"}, new Object[]{"string.concat", "$L20", "$L2"}, new Object[]{"set", "$L0.requestHeaders.Content-Length", "$L20"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"create", "$L4", "Date"}, new Object[]{"set", "$L4", "$L4.time"}, new Object[]{"create", "$P1", "Message"}, new Object[]{"set", "$P1.ChatId", "$P3"}, new Object[]{"set", "$P1.SendAt", "$L4"}, new Object[]{"set", "$P1.MessageText", "$P4"}});
            this.put("checkMandatory", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L1", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L0", "Error", "$L1", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 15}, new Object[]{"debug.out", "$P1.code"}, new Object[]{"stream.streamToString", "$L5", "$P1.responseBody"}, new Object[]{"debug.out", "$L5"}, new Object[]{"set", "$L2", ""}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Line(Context context, String botToken) {
        this.initDataStructures(context);
        this.interpreterStorage.put("botToken", botToken);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Line...");
        new InitSelfTestTask("Line", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Message sendMessage(String receiverId, String message) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Line", "sendMessage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendMessage", this.interpreterStorage, null, receiverId, message);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Line", "sendMessage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendImage(String receiverId, String message, String imageId, InputStream imageStream, String previewUrl, String mimeType) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Line", "sendImage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendImage", this.interpreterStorage, null, receiverId, message, imageId, imageStream, previewUrl, mimeType);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Line", "sendImage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendVideo(String receiverId, String message, String videoId, InputStream videoStream, String previewUrl, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Line", "sendVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendVideo", this.interpreterStorage, null, receiverId, message, videoId, videoStream, previewUrl, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Line", "sendVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendAudio(String receiverId, String message, String audioId, InputStream audioStream, String previewUrl, String audioName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Line", "sendAudio").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendAudio", this.interpreterStorage, null, receiverId, message, audioId, audioStream, previewUrl, audioName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Line", "sendAudio").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendFile(String receiverId, String message, String fileId, InputStream fileStream, String previewUrl, String fileName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Line", "sendFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendFile", this.interpreterStorage, null, receiverId, message, fileId, fileStream, previewUrl, fileName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Line", "sendFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendCarousel(String receiverId, List<MessageItem> messageItem) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Line", "sendCarousel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendCarousel", this.interpreterStorage, null, receiverId, messageItem);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Line", "sendCarousel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public List<Message> parseReceivedMessages(InputStream httpRequest) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Line", "parseReceivedMessages").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("processWebhookRequest", this.interpreterStorage, null, httpRequest);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Line", "parseReceivedMessages").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public MessagingAttachment downloadContent(MessagingAttachment attachment) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Line", "downloadContent").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("downloadContent", this.interpreterStorage, null, attachment);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Line", "downloadContent").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (MessagingAttachment)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Line", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Line", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

