/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.BusinessCloudStorage;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Bucket;
import com.cloudrail.si.types.BusinessFileMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MicrosoftAzure
implements BusinessCloudStorage,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("Storage:createBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P2", "\nrestype:share"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "PUT", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P2", "?restype=share"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "PUT"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 201}, new Object[]{"set", "$L12", "$L6.responseHeaders"}, new Object[]{"create", "$L10", "Bucket"}, new Object[]{"set", "$L10.name", "$P2"}, new Object[]{"if!=than", "$L12.Etag", null, 2}, new Object[]{"set", "$L10.identifier", "$L12.Etag"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L10.identifier", "$L12.ETag"}, new Object[]{"set", "$P1", "$L10"}});
            this.put("Storage:deleteBucket", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P1.name", "\nrestype:share"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "DELETE", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P1.name", "?restype=share"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "DELETE"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 202}});
            this.put("Storage:listBuckets", new Object[]{new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/\ncomp:list"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "GET", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/?comp=list"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"create", "$L14", "Array"}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"xml.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12.children.0.children"}, new Object[]{"if!=than", "$L10", 0, 7}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "Bucket"}, new Object[]{"get", "$L15", "$L12.children.0.children", "$L10"}, new Object[]{"set", "$L13.identifier", "$L15.children.1.children.1.text"}, new Object[]{"set", "$L13.name", "$L15.children.0.text"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -8}, new Object[]{"set", "$P1", "$L14"}});
            this.put("Storage:upload", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"callFunc", "checkNull", "$P0", "$P4"}, new Object[]{"callFunc", "checkSize", "$P0", "$P4"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"string.concat", "$L4.x-ms-content-length", "$P4", ""}, new Object[]{"set", "$L4", "file", "x-ms-type"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P1.name", "/", "$P2"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "PUT", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P1.name", "/", "$P2"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "PUT"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 201}, new Object[]{"set", "$L12", "$L6.responseHeaders"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"set", "$L4", "update", "x-ms-write"}, new Object[]{"set", "$L10", 3999999}, new Object[]{"set", "$L13", 4000000}, new Object[]{"set", "$L14", "$P4"}, new Object[]{"set", "$L15", 0}, new Object[]{"if!=than", "$L15", "$P4", 30}, new Object[]{"set", "$L16", 0}, new Object[]{"math.add", "$L16", "$L15", "$L10"}, new Object[]{"math.add", "$L17", "$L13", 1}, new Object[]{"set", "$L4", "$L13", "Content-Length"}, new Object[]{"string.concat", "$L3", "bytes=", "$L15", "-", "$L16"}, new Object[]{"if<=than", "$L14", "$L13", 3}, new Object[]{"set", "$L4", "$L14", "Content-Length"}, new Object[]{"math.add", "$L17", "$P4", -1}, new Object[]{"string.concat", "$L3", "bytes=", "$L15", "-", "$L17"}, new Object[]{"set", "$L4", "$L3", "x-ms-range"}, new Object[]{"math.add", "$L15", "$L15", "$L4.Content-Length"}, new Object[]{"math.multiply", "$L16", "$L4.Content-Length", -1}, new Object[]{"math.add", "$L14", "$L14", "$L16"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P1.name", "/", "$P2", "\ncomp:range"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "PUT", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P1.name", "/", "$P2", "?comp=range"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "PUT"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.makeLimitedStream", "$L0", "$P3", "$L4.Content-Length"}, new Object[]{"set", "$L5.requestBody", "$L0"}, new Object[]{"string.concat", "$L4.Content-Length", "$L4.Content-Length", ""}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 201}, new Object[]{"jumpRel", -31}});
            this.put("Storage:download", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkBucket", "$P0", "$P3"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P3.name", "/", "$P2"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "GET", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P3.name", "/", "$P2"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"set", "$P1", "$L6.responseBody"}});
            this.put("Storage:listFiles", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P2.name", "\ncomp:list", "\nrestype:directory"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "GET", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P2.name", "?restype=directory&comp=list"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"create", "$L14", "Array"}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"xml.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12.children.0.children"}, new Object[]{"if!=than", "$L10", 0, 19}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "BusinessFileMetaData"}, new Object[]{"get", "$L15", "$L12.children.0.children", "$L10"}, new Object[]{"if==than", "$L15.name", "Directory", 8}, new Object[]{"callFunc", "getSubDirectories", "$P0", "$L30", "$P2", "$L15.children.0.text"}, new Object[]{"size", "$L50", "$L30"}, new Object[]{"if!=than", "$L50", 0, 4}, new Object[]{"math.add", "$L50", "$L50", -1}, new Object[]{"get", "$L51", "$L30", "$L50"}, new Object[]{"push", "$L14", "$L51"}, new Object[]{"jumpRel", -5}, new Object[]{"jumpRel", 6}, new Object[]{"set", "$L13.fileName", "$L15.children.0.text"}, new Object[]{"size", "$L16", "$L15.children.1.children"}, new Object[]{"if!=than", "$L16", 0, 2}, new Object[]{"math.add", "$L11", "$L15.children.1.children.0.text", 0}, new Object[]{"set", "$L13.size", "$L11"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -20}, new Object[]{"set", "$P1", "$L14"}});
            this.put("Storage:listFilesWithPrefix", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkPrefix", "$P0", "$P3"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2016-05-31", "x-ms-version"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P2.name", "\ncomp:list", "\nprefix:", "$P3", "\nrestype:directory"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "GET", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P2.name", "?comp=list&prefix=", "$P3", "&restype=directory"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"create", "$L14", "Array"}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"xml.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12.children.1.children"}, new Object[]{"if!=than", "$L10", 0, 20}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "BusinessFileMetaData"}, new Object[]{"get", "$L15", "$L12.children.1.children", "$L10"}, new Object[]{"if==than", "$L15.name", "Directory", 8}, new Object[]{"create", "$L20", "String"}, new Object[]{"string.concat", "$L20", "$L15.children.0.text", "/"}, new Object[]{"set", "$L13.fileName", "$L20"}, new Object[]{"size", "$L16", "$L15.children.1.children"}, new Object[]{"if!=than", "$L16", 0, 2}, new Object[]{"math.add", "$L11", "$L15.children.1.children.0.text", 0}, new Object[]{"set", "$L13.size", "$L11"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"if==than", "$L15.name", "File", 6}, new Object[]{"set", "$L13.fileName", "$L15.children.0.text"}, new Object[]{"size", "$L16", "$L15.children.1.children"}, new Object[]{"if!=than", "$L16", 0, 2}, new Object[]{"math.add", "$L11", "$L15.children.1.children.0.text", 0}, new Object[]{"set", "$L13.size", "$L11"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -21}, new Object[]{"set", "$P1", "$L14"}});
            this.put("checkPrefix", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L1", "Error", "Prefix supplied is null", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("getSubDirectories", new Object[]{new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P2.name", "/", "$P3", "\ncomp:list", "\nrestype:directory"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "GET", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P2.name", "/", "$P3", "?restype=directory&comp=list"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"create", "$L14", "Array"}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"xml.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12.children.0.children"}, new Object[]{"if==than", "$L10", 0, 6}, new Object[]{"create", "$L40", "BusinessFileMetaData"}, new Object[]{"string.concat", "$L44", "$P3", "/"}, new Object[]{"set", "$L40.fileName", "$L44"}, new Object[]{"push", "$L14", "$L40"}, new Object[]{"set", "$P1", "$L14"}, new Object[]{"return"}, new Object[]{"if!=than", "$L10", 0, 21}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "BusinessFileMetaData"}, new Object[]{"get", "$L15", "$L12.children.0.children", "$L10"}, new Object[]{"if==than", "$L15.name", "Directory", 9}, new Object[]{"string.concat", "$L41", "$P3", "/", "$L15.children.0.text"}, new Object[]{"callFunc", "getSubDirectories", "$P0", "$L42", "$P2", "$L41"}, new Object[]{"size", "$L50", "$L42"}, new Object[]{"if!=than", "$L50", 0, 4}, new Object[]{"math.add", "$L50", "$L50", -1}, new Object[]{"get", "$L51", "$L42", "$L50"}, new Object[]{"push", "$L14", "$L51"}, new Object[]{"jumpRel", -5}, new Object[]{"jumpRel", 7}, new Object[]{"string.concat", "$L43", "$P3", "/", "$L15.children.0.text"}, new Object[]{"set", "$L13.fileName", "$L43"}, new Object[]{"size", "$L16", "$L15.children.1.children"}, new Object[]{"if!=than", "$L16", 0, 2}, new Object[]{"math.add", "$L11", "$L15.children.1.children.0.text", 0}, new Object[]{"set", "$L13.size", "$L11"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -22}, new Object[]{"set", "$P1", "$L14"}});
            this.put("Storage:getFileMetadata", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P2.name", "/", "$P3"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "HEAD", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P2.name", "/", "$P3"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "HEAD"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "get metadata", 200}, new Object[]{"set", "$L6", "$L6.responseHeaders"}, new Object[]{"create", "$L7", "BusinessFileMetaData"}, new Object[]{"set", "$L7.fileName", "$P3"}, new Object[]{"set", "$L7.fileID", "$L6.ETag"}, new Object[]{"math.add", "$L7.size", "$L6.Content-Length", 0}, new Object[]{"callFunc", "parseDate", "$P0", "$L7.lastModified", "$L6.Last-Modified"}, new Object[]{"set", "$P1", "$L7"}});
            this.put("Storage:deleteFile", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P1"}, new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "$L1.rfcTime1123", "x-ms-date"}, new Object[]{"set", "$L4", "2015-12-11", "x-ms-version"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.concat", "$L3", "/", "$P0.accountName", "/", "$P2.name", "/", "$P1"}, new Object[]{"create", "$L2", "String"}, new Object[]{"callFunc", "signedString", "$L2", "DELETE", "", "$L4", "$L3", "$P0"}, new Object[]{"string.concat", "$L2", "SharedKey ", "$P0.accountName", ":", "$L2"}, new Object[]{"set", "$L4", "$L2", "Authorization"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "https://", "$P0.accountName", ".file.core.windows.net/", "$P2.name", "/", "$P1"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "DELETE"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 202}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 2}, new Object[]{"string.concat", "$L0.url", "https://", "$P0.accountName", ".file.core.windows.net", "$P2.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"if!=than", "$P2.body", null, 1}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"if==than", "$L0.requestHeaders.x-ms-date", null, 2}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L0.requestHeaders.x-ms-date", "$L1.rfcTime1123"}, new Object[]{"callFunc", "extractCanonicalResources", "$P0", "$L1", "$L0.url"}, new Object[]{"callFunc", "signedString", "$L10", "$L0.method", "", "$L0.requestHeaders", "$L1", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "SharedKey ", "$P0.accountName", ":", "$L10"}, new Object[]{"http.requestCall", "$L11", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L11", "advancedRequest"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L11.code"}, new Object[]{"set", "$P1.headers", "$L11.responseHeaders"}, new Object[]{"set", "$P1.body", "$L11.responseBody"}});
            this.put("extractCanonicalResources", new Object[]{new Object[]{"string.concat", "$P1", "/", "$P0.accountName"}, new Object[]{"string.indexOf", "$L0", "$P2", ".net"}, new Object[]{"string.indexOf", "$L0", "$P2", "/", "$L0"}, new Object[]{"if!=than", "$L0", -1, 11}, new Object[]{"size", "$L1", "$P2"}, new Object[]{"math.add", "$L1", "$L1", -1}, new Object[]{"if!=than", "$L0", "$L1", 8}, new Object[]{"string.indexOf", "$L2", "$P2", "/", "$L1"}, new Object[]{"if==than", "$L2", -1, 6}, new Object[]{"string.substring", "$L3", "$P2", "$L0"}, new Object[]{"string.split", "$L20", "$L3", "\\?", 2}, new Object[]{"string.concat", "$P1", "$P1", "$L20.0"}, new Object[]{"jumpRel", 2}, new Object[]{"string.substring", "$L3", "$P2", "$L0", "$L2"}, new Object[]{"string.concat", "$P1", "$P1", "$L3"}, new Object[]{"string.split", "$L0", "$P2", "\\?", 2}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"if==than", "$L1", 1, 1}, new Object[]{"return"}, new Object[]{"string.split", "$L1", "$L0.1", "&"}, new Object[]{"size", "$L2", "$L1"}, new Object[]{"create", "$L3", "Number", 0}, new Object[]{"if<than", "$L3", "$L2", 10}, new Object[]{"get", "$L4", "$L1", "$L3"}, new Object[]{"string.split", "$L5", "$L4", "="}, new Object[]{"size", "$L10", "$L5"}, new Object[]{"if>than", "$L10", 1, 3}, new Object[]{"get", "$L11", "$L5", 0}, new Object[]{"get", "$L12", "$L5", 1}, new Object[]{"string.concat", "$L6", "$L11", ":", "$L12"}, new Object[]{"string.concat", "$P1", "$P1", "\n", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -11}});
            this.put("signedString", new Object[]{new Object[]{"object.getKeyArray", "$L0", "$P3"}, new Object[]{"array.sort", "$L0", "$L0"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"create", "$L2", "String"}, new Object[]{"create", "$L3", "Number"}, new Object[]{"if<than", "$L3", "$L1", 7}, new Object[]{"get", "$L4", "$L0", "$L3"}, new Object[]{"string.indexOf", "$L5", "$L4", "x-ms"}, new Object[]{"if!=than", "$L5", -1, 2}, new Object[]{"get", "$L6", "$P3", "$L4"}, new Object[]{"string.concat", "$L2", "$L2", "$L4", ":", "$L6", "\n"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -8}, new Object[]{"set", "$L6", ""}, new Object[]{"set", "$L7", ""}, new Object[]{"size", "$L5", "$P2"}, new Object[]{"if!=than", "$L5", 0, 2}, new Object[]{"callFunc", "generateMD5", "$L6", "$P2"}, new Object[]{"getMimeType", "$L7", "$P2"}, new Object[]{"string.concat", "$L1", "$P1", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "", "\n"}, new Object[]{"if!=than", "$P3.Content-Length", null, 1}, new Object[]{"string.concat", "$L1", "$L1", "$P3.Content-Length"}, new Object[]{"string.concat", "$L1", "$L1", "\n", "$L6", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "$L7", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "", "\n"}, new Object[]{"string.concat", "$L1", "$L1", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "$P4", ""}, new Object[]{"string.base64decode", "$L8", "$P5.accessKey"}, new Object[]{"callFunc", "generateSHA256", "$L10", "$L1", "$L8"}, new Object[]{"set", "$P0", "$L10"}});
            this.put("generateMD5", new Object[]{new Object[]{"hash.md5", "$L0", "$P1"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"set", "$L2", 0}, new Object[]{"set", "$P0", ""}, new Object[]{"get", "$L3", "$L0", "$L2"}, new Object[]{"string.format", "$L4", "%02x", "$L3"}, new Object[]{"string.concat", "$P0", "$P0", "$L4"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"if>=than", "$L2", "$L1", -5}});
            this.put("generateSHA256", new Object[]{new Object[]{"crypt.hmac.sha256", "$L0", "$P2", "$P1"}, new Object[]{"array.arrayToData", "$L1", "$L0"}, new Object[]{"string.base64encode", "$P0", "$L1"}});
            this.put("checkHttpErrors", new Object[]{new Object[]{"if==than", "$P3", null, 2}, new Object[]{"if>=than", "$P1.code", 400, 24}, new Object[]{"jumpRel", 1}, new Object[]{"if!=than", "$P1.code", "$P3", 20}, new Object[]{"set", "$L0", "$P1"}, new Object[]{"set", "$L2", "$L0.message"}, new Object[]{"string.indexOf", "$L3", "$L2", "The specified share already exists"}, new Object[]{"if!=than", "$L3", -1, 2}, new Object[]{"create", "$L3", "Error", "The bucket already exists.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}, new Object[]{"string.indexOf", "$L3", "$L2", "The specified resource does not exist"}, new Object[]{"if!=than", "$L3", -1, 2}, new Object[]{"create", "$L3", "Error", "The file does not exists.", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Parameter should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P1"}, new Object[]{"if==than", "$P1.name", null, 3}, new Object[]{"if==than", "$P1.identifier", null, 2}, new Object[]{"create", "$L0", "Error", "Bucket name and identifier should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkSize", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Size can not be negative.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("parseDate", new Object[]{new Object[]{"string.substr", "$L0", "$P2", 5, 2}, new Object[]{"string.substr", "$L1", "$P2", 8, 3}, new Object[]{"set", "$L6", ""}, new Object[]{"callFunc", "getMonthNumber", "$P0", "$L6", "$L1"}, new Object[]{"string.substr", "$L2", "$P2", 12, 4}, new Object[]{"string.substr", "$L3", "$P2", 17, 8}, new Object[]{"string.concat", "$L4", "$L2", "-", "$L6", "-", "$L0", "T", "$L3", "Z"}, new Object[]{"create", "$L5", "Date", "$L4"}, new Object[]{"set", "$P1", "$L5.time"}});
            this.put("getMonthNumber", new Object[]{new Object[]{"if==than", "$P2", "Jan", 2}, new Object[]{"set", "$P1", "01"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Feb", 2}, new Object[]{"set", "$P1", "02"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Mar", 2}, new Object[]{"set", "$P1", "03"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Apr", 2}, new Object[]{"set", "$P1", "04"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "May", 2}, new Object[]{"set", "$P1", "05"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Jun", 2}, new Object[]{"set", "$P1", "06"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Jul", 2}, new Object[]{"set", "$P1", "07"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Aug", 2}, new Object[]{"set", "$P1", "08"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Sep", 2}, new Object[]{"set", "$P1", "09"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Oct", 2}, new Object[]{"set", "$P1", "10"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Nov", 2}, new Object[]{"set", "$P1", "11"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Dec", 2}, new Object[]{"set", "$P1", "12"}, new Object[]{"return"}, new Object[]{"create", "$L0", "Error", "Could not recognize month in Date"}, new Object[]{"throwError", "$L0"}});
            this.put("arrayToHex", new Object[]{new Object[]{"size", "$L1", "$P2"}, new Object[]{"set", "$L2", 0}, new Object[]{"create", "$P1", "String", ""}, new Object[]{"get", "$L3", "$P2", "$L2"}, new Object[]{"string.format", "$L4", "%02x", "$L3"}, new Object[]{"string.concat", "$P1", "$P1", "$L4"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"if>=than", "$L2", "$L1", -5}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public MicrosoftAzure(Context context, String accountName, String accessKey) {
        this.initDataStructures(context);
        this.interpreterStorage.put("accountName", accountName);
        this.interpreterStorage.put("accessKey", accessKey);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to MicrosoftAzure...");
        new InitSelfTestTask("MicrosoftAzure", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Bucket createBucket(String bucketName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "createBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:createBucket", this.interpreterStorage, null, bucketName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "createBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Bucket)ip.getParameter(1);
    }

    @Override
    public List<Bucket> listBuckets() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "listBuckets").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:listBuckets", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "listBuckets").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void deleteBucket(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "deleteBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:deleteBucket", this.interpreterStorage, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "deleteBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void deleteFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "deleteFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:deleteFile", this.interpreterStorage, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "deleteFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public BusinessFileMetaData getFileMetadata(Bucket bucket, String fileName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "getFileMetadata").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:getFileMetadata", this.interpreterStorage, null, bucket, fileName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "getFileMetadata").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (BusinessFileMetaData)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFiles(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "listFiles").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:listFiles", this.interpreterStorage, null, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "listFiles").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFilesWithPrefix(Bucket bucket, String prefix) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "listFilesWithPrefix").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:listFilesWithPrefix", this.interpreterStorage, null, bucket, prefix);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "listFilesWithPrefix").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void uploadFile(Bucket bucket, String name, InputStream stream, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "uploadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:upload", this.interpreterStorage, bucket, name, stream, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "uploadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public InputStream downloadFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "downloadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:download", this.interpreterStorage, null, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "downloadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "MicrosoftAzure", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MicrosoftAzure", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

