/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.SMS;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Nexmo
implements SMS,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"set", "$P0.baseUrl", "https://rest.nexmo.com"}});
            this.put("SendNexmoSMS", new Object[]{new Object[]{"callFunc", "validateUserInput", "$P0", "$P1", "$P2", "$P3"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"create", "$L3", "String"}, new Object[]{"create", "$L4", "String"}, new Object[]{"string.urlEncode", "$L3", "$P3"}, new Object[]{"string.urlEncode", "$L5", "$P1"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "/sms/json?api_key=", "$P0.clientId", "&api_secret=", "$P0.clientSecret", "&to=", "$P2", "&from=", "$L5", "&text=", "$L3"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L1.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L1.Content-Length", "0"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkError", "$P0", "$L2", 1}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 2}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "$P2.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 6}, new Object[]{"string.indexOf", "$L1", "$L0.url", "?"}, new Object[]{"if==than", "$L1", -1, 2}, new Object[]{"string.concat", "$L0.url", "$L0.url", "?"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "api_key=", "$P0.clientId", "&api_secret=", "$P0.clientSecret"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "checkError", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("validateUserInput", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L1", "Error", "One of the arguments is 'null'. You need to assign a value to it.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"if==than", "$P2", null, 2}, new Object[]{"create", "$L1", "Error", "One of the arguments is 'null'. You need to assign a value to it.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"if==than", "$P3", null, 2}, new Object[]{"create", "$L1", "Error", "One of the arguments is 'null'. You need to assign a value to it.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P1"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"create", "$L1", "Error", "The 'From' number parameter is empty.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P2"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"create", "$L1", "Error", "The 'To' number parameter is empty.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P3"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"create", "$L1", "Error", "The message is empty.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P1"}, new Object[]{"if>than", "$L2", 16, 2}, new Object[]{"create", "$L1", "Error", "The 'From' phone number is too big, it should have maximum 15 digits. Example: +16175551212", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"string.lastIndexOf", "$L0", "$P2", "+"}, new Object[]{"if!=than", "$L0", 0, 2}, new Object[]{"create", "$L1", "Error", "The 'To' phone number isn't in E.164 format. Example: +16175551212", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P2"}, new Object[]{"if>than", "$L2", 16, 2}, new Object[]{"create", "$L1", "Error", "The 'To' phone number is too big, it should have maximum 15 digits. Example: +16175551212", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P3"}, new Object[]{"if>than", "$L2", 1600, 2}, new Object[]{"create", "$L1", "Error", "The length of the message exceeds the 1600 allowed characters.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkError", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 8}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$P1.message", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if!=than", "$P2", null, 8}, new Object[]{"stream.streamToString", "$L11", "$P1.responseBody"}, new Object[]{"create", "$L12", "Object"}, new Object[]{"json.parse", "$L12", "$L11"}, new Object[]{"set", "$L13", "$L12.messages.0.status"}, new Object[]{"set", "$L14", "$L12.messages.0.error-text"}, new Object[]{"if!=than", "$L13", "0", 2}, new Object[]{"create", "$L15", "Error", "$L14", "Http"}, new Object[]{"throwError", "$L15"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Nexmo(Context context, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Nexmo...");
        new InitSelfTestTask("Nexmo", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public void sendSMS(String fromName, String toNumber, String content) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Nexmo", "sendSMS").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("SendNexmoSMS", this.interpreterStorage, fromName, toNumber, content);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Nexmo", "sendSMS").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Nexmo", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Nexmo", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

