/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.CloudStorage;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.CloudMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.SpaceAllocation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PCloud
implements CloudStorage,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"set", "$P0.baseUrl", "https://api.pcloud.com/"}});
            this.put("CloudStorage:getUserLogin", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"string.concat", "$P0.userInfo.userId", "$P0.userInfo.userId"}, new Object[]{"set", "$P1", "$P0.userInfo.userId"}});
            this.put("CloudStorage:getUserName", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.emailAddress"}});
            this.put("User:about", new Object[]{new Object[]{"if!=than", "$P0.userInfo", null, 4}, new Object[]{"create", "$L0", "Date"}, new Object[]{"math.add", "$L0", "$L0.Time", -1000}, new Object[]{"if>than", "$P0.userInfo.lastUpdate", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "User:aboutRequest", "$P0"}});
            this.put("User:aboutRequest", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "userinfo"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L3", "$L2.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L3"}, new Object[]{"create", "$P0.userInfo", "Object"}, new Object[]{"create", "$L4", "Date"}, new Object[]{"set", "$P0.userInfo.lastUpdate", "$L4.Time"}, new Object[]{"set", "$P0.userInfo.emailAddress", "$L3.email"}, new Object[]{"string.concat", "$P0.userInfo.userId", "$L3.userid", ""}, new Object[]{"string.concat", "$P0.userInfo.isPremium", "$L3.premium", ""}, new Object[]{"set", "$P0.userInfo.quotaTotal", "$L3.quota"}, new Object[]{"set", "$P0.userInfo.quotaUsed", "$L3.usedquota"}});
            this.put("CloudStorage:download", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "getFileLink", "$P0", "$L0", "$P2"}, new Object[]{"callFunc", "downloadFile", "$P0", "$P1", "$L0"}});
            this.put("getFileLink", new Object[]{new Object[]{"string.urlEncode", "$L4", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "getfilelink", "?path=", "$L4"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L3", "$L2.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L3"}, new Object[]{"string.concat", "$P1", "https://", "$L3.hosts.0", "$L3.path"}});
            this.put("downloadFile", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P2"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"set", "$P1", "$L2.responseBody"}});
            this.put("CloudStorage:upload", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "getParentFolder", "$P0", "$L0", "$P1"}, new Object[]{"callFunc", "getFilename", "$P0", "$L1", "$P1"}, new Object[]{"callFunc", "CloudStorage:exists", "$P0", "$L7", "$L0"}, new Object[]{"if==than", "$L7", 0, 2}, new Object[]{"create", "$L8", "Error", "Directory does not exist.", "NotFound"}, new Object[]{"throwError", "$L8"}, new Object[]{"callFunc", "getRawFolderMetaData", "$P0", "$L5", "$L0", 0}, new Object[]{"if==than", "$L5", null, 2}, new Object[]{"create", "$L6", "Error", "Folder does not exist.", "NotFound"}, new Object[]{"throwError", "$L6"}, new Object[]{"string.urlEncode", "$L0", "$L0"}, new Object[]{"string.urlEncode", "$L1", "$L1"}, new Object[]{"callFunc", "getFileMetadata", "$P0", "$L11", "$P1"}, new Object[]{"if!=than", "$L11", null, 7}, new Object[]{"if==than", "$P4", true, 2}, new Object[]{"callFunc", "CloudStorage:delete", "$P0", "$P1"}, new Object[]{"jumpRel", 4}, new Object[]{"callFunc", "CloudStorage:exists", "$P0", "$L9", "$P1"}, new Object[]{"if==than", "$L9", 1, 2}, new Object[]{"create", "$L10", "Error", "File already exists", "Http"}, new Object[]{"throwError", "$L10"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "$P0.baseUrl", "uploadfile", "?path=", "$L0", "&nopartial=1&filename=", "$L1"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"string.concat", "$L2.requestHeaders.Content-Length", "$P3", ""}, new Object[]{"set", "$L2.requestBody", "$P2"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L4", "$L3.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L4"}});
            this.put("getParentFolder", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"string.lastIndexOf", "$L0", "$P2", "/"}, new Object[]{"if==than", "$L0", 0, 2}, new Object[]{"set", "$P1", "/"}, new Object[]{"return"}, new Object[]{"string.substring", "$P1", "$P2", 0, "$L0"}});
            this.put("getFilename", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"string.lastIndexOf", "$L0", "$P2", "/"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"string.substring", "$P1", "$P2", "$L0"}});
            this.put("CloudStorage:move", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"set", "$L0", "renamefile"}, new Object[]{"callFunc", "isFolder", "$P0", "$L1", "$P1"}, new Object[]{"if==than", "$L1", 1, 1}, new Object[]{"set", "$L0", "renamefolder"}, new Object[]{"string.urlEncode", "$L3", "$P1"}, new Object[]{"string.urlEncode", "$L4", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "$P0.baseUrl", "$L0", "?path=", "$L3", "&topath=", "$L4"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L6", "$L5.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L6"}});
            this.put("CloudStorage:delete", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.urlEncode", "$L5", "$P1"}, new Object[]{"set", "$L0", "deletefile"}, new Object[]{"callFunc", "isFolder", "$P0", "$L1", "$P1"}, new Object[]{"if==than", "$L1", 1, 1}, new Object[]{"set", "$L0", "deletefolderrecursive"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "$P0.baseUrl", "$L0", "?path=", "$L5"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L4", "$L3.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L4"}});
            this.put("CloudStorage:copy", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "CloudStorage:exists", "$P0", "$L0", "$P1"}, new Object[]{"if==than", "$L0", 0, 2}, new Object[]{"create", "$L2", "Error", "File or Folder does not exist!", "NotFound"}, new Object[]{"throwError", "$L2"}, new Object[]{"callFunc", "isFolder", "$P0", "$L0", "$P1"}, new Object[]{"callFunc", "isFolder", "$P0", "$L1", "$P2"}, new Object[]{"if==than", "$L0", 1, 1}, new Object[]{"jumpRel", 1}, new Object[]{"if==than", "$L1", 1, 2}, new Object[]{"create", "$L2", "Error", "Cannot copy folders.", "IllegalArgument"}, new Object[]{"throwError", "$L2"}, new Object[]{"string.urlEncode", "$L4", "$P1"}, new Object[]{"string.urlEncode", "$L5", "$P2"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"string.concat", "$L3.url", "$P0.baseUrl", "copyfile", "?path=", "$L4", "&topath=", "$L5"}, new Object[]{"create", "$L3.requestHeaders", "Object"}, new Object[]{"string.concat", "$L3.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L3.method", "POST"}, new Object[]{"http.requestCall", "$L6", "$L3"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L7", "$L6.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L7"}});
            this.put("CloudStorage:createFolder", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.urlEncode", "$L5", "$P1"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "createfolder", "?path=", "$L5"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L4", "$L3.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L4"}});
            this.put("CloudStorage:getMetadata", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"if==than", "$P2", "/", 2}, new Object[]{"create", "$L0", "Error", "Cannot get metadata for the root folder.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "getMetadata", "$P0", "$P1", "$P2"}, new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L1", "Error", "File or Folder not found", "NotFound"}, new Object[]{"throwError", "$L1"}});
            this.put("getMetadata", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "getFolderMetadata", "$P0", "$P1", "$P2"}, new Object[]{"if==than", "$P1", null, 1}, new Object[]{"callFunc", "getFileMetadata", "$P0", "$P1", "$P2"}});
            this.put("getFolderMetadata", new Object[]{new Object[]{"callFunc", "getRawFolderMetaData", "$P0", "$L0", "$P2", 0}, new Object[]{"if!=than", "$L0", null, 1}, new Object[]{"callFunc", "extractMetaData", "$P0", "$P1", "$L0"}});
            this.put("getRawFolderMetaData", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P2", "", 1}, new Object[]{"set", "$P2", "/"}, new Object[]{"string.urlEncode", "$L0", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L1.url", "$P0.baseUrl", "listfolder", "?path=", "$L0", "&recursive=", "$P3"}, new Object[]{"create", "$L1.requestHeaders", "Object"}, new Object[]{"string.concat", "$L1.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.method", "POST"}, new Object[]{"http.requestCall", "$L2", "$L1"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L3", "$L2.responseBody"}, new Object[]{"set", "$P1", "$L3.metadata"}});
            this.put("getFileMetadata", new Object[]{new Object[]{"callFunc", "getParentFolder", "$P0", "$L0", "$P2"}, new Object[]{"callFunc", "getFilename", "$P0", "$L1", "$P2"}, new Object[]{"callFunc", "getRawFolderMetaData", "$P0", "$L2", "$L0", 0}, new Object[]{"if==than", "$L2.contents", null, 1}, new Object[]{"return"}, new Object[]{"set", "$L2", "$L2.contents"}, new Object[]{"set", "$L3", 0}, new Object[]{"size", "$L4", "$L2"}, new Object[]{"if<than", "$L3", "$L4", 7}, new Object[]{"get", "$L5", "$L2", "$L3"}, new Object[]{"if==than", "$L5.isfolder", 0, 3}, new Object[]{"if==than", "$L5.name", "$L1", 2}, new Object[]{"callFunc", "extractMetaData", "$P0", "$P1", "$L5"}, new Object[]{"return"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -8}});
            this.put("extractMetaData", new Object[]{new Object[]{"create", "$P1", "CloudMetaData"}, new Object[]{"set", "$P1.path", "$P2.path"}, new Object[]{"set", "$P1.name", "$P2.name"}, new Object[]{"if!=than", "$P2.size", null, 1}, new Object[]{"set", "$P1.size", "$P2.size"}, new Object[]{"set", "$P1.folder", "$P2.isfolder"}, new Object[]{"if!=than", "$P2.modified", null, 2}, new Object[]{"create", "$L0", "Date", "$P2.modified"}, new Object[]{"set", "$P1.modifiedAt", "$L0.time"}, new Object[]{"if!=than", "$P2.width", null, 1}, new Object[]{"create", "$P1.imageMetaData", "ImageMetaData", "$P2.width", "$P2.height"}});
            this.put("CloudStorage:getChildren", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.urlEncode", "$L1", "$P2"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "listfolder?path=", "$L1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L4", "$L3.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L4"}, new Object[]{"callFunc", "extractMetadataArray", "$P0", "$P1", "$L4.metadata.contents"}});
            this.put("extractMetadataArray", new Object[]{new Object[]{"create", "$P1", "Array"}, new Object[]{"set", "$L0", 0}, new Object[]{"size", "$L1", "$P2"}, new Object[]{"if<than", "$L0", "$L1", 14}, new Object[]{"get", "$L2", "$P2", "$L0"}, new Object[]{"create", "$L3", "CloudMetaData"}, new Object[]{"set", "$L3.folder", "$L2.isfolder"}, new Object[]{"create", "$L4", "Date"}, new Object[]{"set", "$L3.modifiedAt", "$L4.time"}, new Object[]{"set", "$L3.name", "$L2.name"}, new Object[]{"set", "$L3.path", "$L2.path"}, new Object[]{"if!=than", "$L2.size", null, 1}, new Object[]{"set", "$L3.size", "$L2.size"}, new Object[]{"if!=than", "$L2.width", null, 1}, new Object[]{"create", "$L3.imageMetaData", "ImageMetaData", "$L2.width", "$L2.height"}, new Object[]{"push", "$P1", "$L3"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"jumpRel", -15}});
            this.put("CloudStorage:getChildrenPage", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "CloudStorage:getChildren", "$P0", "$L0", "$P2"}, new Object[]{"set", "$L1", "$P3"}, new Object[]{"math.add", "$L2", "$P3", "$P4"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if<than", "$L1", "$L2", 4}, new Object[]{"get", "$L3", "$L0", "$L1"}, new Object[]{"push", "$P1", "$L3"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -5}});
            this.put("CloudStorage:exists", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "getMetadata", "$P0", "$L0", "$P2"}, new Object[]{"set", "$P1", 0}, new Object[]{"if!=than", "$L0", null, 1}, new Object[]{"set", "$P1", 1}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"if==than", "$S0.access_token", null, 1}, new Object[]{"return"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "logout"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L2"}, new Object[]{"set", "$S0.access_token", null}});
            this.put("CloudStorage:getAllocation", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"create", "$P1", "SpaceAllocation"}, new Object[]{"set", "$P1.used", "$P0.userInfo.quotaUsed"}, new Object[]{"set", "$P1.total", "$P0.userInfo.quotaTotal"}});
            this.put("CloudStorage:createShareLink", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P2", "/", 2}, new Object[]{"create", "$L0", "Error", "Cannot share root!", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"set", "$L0", "getfilepublink"}, new Object[]{"callFunc", "isFolder", "$P0", "$L1", "$P2"}, new Object[]{"if==than", "$L1", 1, 1}, new Object[]{"set", "$L0", "getfolderpublink"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "$P0.baseUrl", "$L0", "?path=", "$P2"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L4", "$L3.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L4"}, new Object[]{"set", "$P1", "$L4.link"}});
            this.put("isFolder", new Object[]{new Object[]{"set", "$P1", 0}, new Object[]{"callFunc", "getRawFolderMetaData", "$P0", "$L0", "$P2", 0}, new Object[]{"if!=than", "$L0", null, 1}, new Object[]{"set", "$P1", 1}});
            this.put("CloudStorage:getThumbnail", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "CloudStorage:exists", "$P0", "$L0", "$P2"}, new Object[]{"if==than", "$L0", 0, 2}, new Object[]{"create", "$L0", "Error", "File does not exist.", "NotFound"}, new Object[]{"throwError", "$L0"}, new Object[]{"string.urlEncode", "$L1", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "getthumb", "?path=", "$L1", "&size=", "128x128"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"set", "$P1", "$L3.responseBody"}});
            this.put("CloudStorage:search", new Object[]{new Object[]{"callFunc", "setCurrentUser", "$P0"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "", 2}, new Object[]{"create", "$L0", "Error", "The query is not allowed to be empty.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "listfolder", "?path=", "%2F", "&recursive=", "1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L4", "$L3.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L4"}, new Object[]{"callFunc", "searchRecursive", "$P0", "$P1", "$L4.metadata.contents", "$P2", ""}});
            this.put("searchRecursive", new Object[]{new Object[]{"if==than", "$P1", null, 1}, new Object[]{"create", "$P1", "Array"}, new Object[]{"set", "$L0", 0}, new Object[]{"size", "$L1", "$P2"}, new Object[]{"if<than", "$L0", "$L1", 10}, new Object[]{"get", "$L2", "$P2", "$L0"}, new Object[]{"string.concat", "$L2.path", "$P4", "/", "$L2.name"}, new Object[]{"string.indexOf", "$L3", "$L2.name", "$P3"}, new Object[]{"if!=than", "$L3", -1, 2}, new Object[]{"callFunc", "extractMetaData", "$P0", "$L4", "$L2"}, new Object[]{"push", "$P1", "$L4"}, new Object[]{"if==than", "$L2.icon", "folder", 1}, new Object[]{"callFunc", "searchRecursive", "$P0", "$P1", "$L2.contents", "$P3", "$L2.path"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"jumpRel", -11}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[0]);
            this.put("customJsonParse", new Object[]{new Object[]{"stream.streamToString", "$L0", "$P2"}, new Object[]{"string.indexOf", "$L1", "$L0", "\"hash\""}, new Object[]{"if!=than", "$L1", -1, 6}, new Object[]{"string.indexOf", "$L2", "$L0", ",", "$L1"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"string.substring", "$L3", "$L0", 0, "$L1"}, new Object[]{"string.substring", "$L4", "$L0", "$L2"}, new Object[]{"string.concat", "$L0", "$L3", "$L4"}, new Object[]{"jumpRel", -8}, new Object[]{"json.parse", "$P1", "$L0"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if!=than", null, "$S0.access_token", 1}, new Object[]{"return"}, new Object[]{"string.urlEncode", "$L7", "$P0.redirectUri"}, new Object[]{"string.concat", "$L0", "https://my.pcloud.com/", "oauth2/authorize?response_type=code&force_reapprove=true&client_id=", "$P0.clientId", "&redirect_uri=", "$L7", "&state=", "$P0.state"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0", null, "$P0.redirectUri"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "$P0.baseUrl", "oauth2_token"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"set", "$L2.requestHeaders.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"string.concat", "$L3", "code=", "$L1", "&client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret"}, new Object[]{"size", "$L8", "$L3"}, new Object[]{"string.concat", "$L8", "$L8"}, new Object[]{"set", "$L2.requestHeaders.Content-Length", "$L8"}, new Object[]{"stream.stringToStream", "$L4", "$L3"}, new Object[]{"set", "$L2.requestBody", "$L4"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L6", "$L5.responseBody"}, new Object[]{"callFunc", "validateResult", "$P0", "$L6"}, new Object[]{"set", "$S0.access_token", "$L6.access_token"}, new Object[]{"set", "$S0.user_id", "$L6.uid"}});
            this.put("setCurrentUser", new Object[]{new Object[]{"if==than", "$P0.isUserSet", null, 8}, new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"stats.add", "PCloud:userId", "$P0.userInfo.userId"}, new Object[]{"hash.sha256", "$L1", "$P0.userInfo.emailAddress"}, new Object[]{"callFunc", "stringifyHash", "$P0", "$L3", "$L1"}, new Object[]{"stats.add", "PCloud:userEmail", "$L3"}, new Object[]{"stats.add", "PCloud:isPremium", "$P0.userInfo.isPremium"}, new Object[]{"set", "$P0.isUserSet", 1}});
            this.put("stringifyHash", new Object[]{new Object[]{"size", "$L1", "$P2"}, new Object[]{"set", "$L2", 0}, new Object[]{"set", "$P1", ""}, new Object[]{"get", "$L3", "$P2", "$L2"}, new Object[]{"string.format", "$L4", "%02x", "$L3"}, new Object[]{"string.concat", "$P1", "$P1", "$L4"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"if>=than", "$L2", "$L1", -5}});
            this.put("validatePath", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Path shouldn't be null", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1", "", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L0", "String"}, new Object[]{"string.substr", "$L0", "$P1", 0, 1}, new Object[]{"if!=than", "$L0", "/", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L1", "Number"}, new Object[]{"size", "$L1", "$P1"}, new Object[]{"math.add", "$L1", "$L1", -1}, new Object[]{"if!=than", "$L1", 0, 5}, new Object[]{"create", "$L2", "String"}, new Object[]{"string.substr", "$L2", "$P1", "$L1", 1}, new Object[]{"if==than", "$L2", "/", 2}, new Object[]{"create", "$L3", "Error", "Path should not end with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Passed argument is null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkPositive", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Passed argument should be bigger than 0.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 20}, new Object[]{"callFunc", "customJsonParse", "$P0", "$L0", "$P1.responseBody"}, new Object[]{"json.stringify", "$L2", "$L0"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 400, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 402, 5}, new Object[]{"if<=than", "$P1.code", 509, 4}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"if!=than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}});
            this.put("validateResult", new Object[]{new Object[]{"if==than", "$P1.result", 0, 1}, new Object[]{"return"}, new Object[]{"if==than", "$P1.result", 1000, 1}, new Object[]{"create", "$L4", "Error", "1000: Log in required", "Authentication"}, new Object[]{"if==than", "$P1.result", 1001, 1}, new Object[]{"create", "$L4", "Error", "1001: No full path or name/folderid provided.", "NotFound"}, new Object[]{"if==than", "$P1.result", 1002, 1}, new Object[]{"create", "$L4", "Error", "1002: No full path or folderid provided.", "NotFound"}, new Object[]{"if==than", "$P1.result", 1004, 1}, new Object[]{"create", "$L4", "Error", "1004: No fileid or path provided.", "IllegalArgument"}, new Object[]{"if==than", "$P1.result", 1014, 1}, new Object[]{"create", "$L4", "Error", "1014: Thumb can not be created from this file type.", "IllegalArgument"}, new Object[]{"if==than", "$P1.result", 1015, 1}, new Object[]{"create", "$L4", "Error", "1015: Please provide valid thumb size. Width and height must be divisible either by 4 or 5 and must be between 16 and 2048 (1024 for height).", "IllegalArgument"}, new Object[]{"if==than", "$P1.result", 1017, 1}, new Object[]{"create", "$L4", "Error", "1017: Invalid 'folderid' provided.", "NotFound"}, new Object[]{"if==than", "$P1.result", 1037, 1}, new Object[]{"create", "$L4", "Error", "1037: Please provide at least one of 'topath', 'tofolderid' or 'toname'.", "NotFound"}, new Object[]{"if==than", "$P1.result", 2000, 1}, new Object[]{"create", "$L4", "Error", "2000: Log in failed.", "Authentication"}, new Object[]{"if==than", "$P1.result", 2001, 1}, new Object[]{"create", "$L4", "Error", "2001: Invalid file/folder name.", "NotFound"}, new Object[]{"if==than", "$P1.result", 2002, 1}, new Object[]{"create", "$L4", "Error", "2002: A component of parent directory does not exist.", "NotFound"}, new Object[]{"if==than", "$P1.result", 2003, 1}, new Object[]{"create", "$L4", "Error", "2003: Access denied. You do not have permissions to preform this operation.", "Authentication"}, new Object[]{"if==than", "$P1.result", 2004, 1}, new Object[]{"create", "$L4", "Error", "2004: File or folder alredy exists.", "Http"}, new Object[]{"if==than", "$P1.result", 2005, 1}, new Object[]{"create", "$L4", "Error", "2005: Directory does not exist.", "NotFound"}, new Object[]{"if==than", "$P1.result", 2006, 1}, new Object[]{"create", "$L4", "Error", "2006: Folder is not empty.", "Http"}, new Object[]{"if==than", "$P1.result", 2007, 1}, new Object[]{"create", "$L4", "Error", "2007: Cannot delete the root folder.", "NotFound"}, new Object[]{"if==than", "$P1.result", 2008, 1}, new Object[]{"create", "$L4", "Error", "2008: User is over quota.", "Http"}, new Object[]{"if==than", "$P1.result", 2009, 1}, new Object[]{"create", "$L4", "Error", "2009: File not found.", "NotFound"}, new Object[]{"if==than", "$P1.result", 2010, 1}, new Object[]{"create", "$L4", "Error", "2010: Invalid Path.", "NotFound"}, new Object[]{"if==than", "$P1.result", 2023, 1}, new Object[]{"create", "$L4", "Error", "2023: You are trying to place shared folder into another shared folder.", "Http"}, new Object[]{"if==than", "$P1.result", 2028, 1}, new Object[]{"create", "$L4", "Error", "2028: There are active shares or sharerequests for this folder.", "Http"}, new Object[]{"if==than", "$P1.result", 2042, 1}, new Object[]{"create", "$L4", "Error", "2042: Cannot rename the root folder.", "NotFound"}, new Object[]{"if==than", "$P1.result", 2043, 1}, new Object[]{"create", "$L4", "Error", "2043: Cannot move a folder to a subfolder of itself.", "Http"}, new Object[]{"if==than", "$P1.result", 3001, 1}, new Object[]{"create", "$L4", "Error", "3001: Could not create thumb from the given file.", "IllegalArgument"}, new Object[]{"if==than", "$P1.result", 4000, 1}, new Object[]{"create", "$L4", "Error", "4000: Too many login tries from this IP address.", "Http"}, new Object[]{"if>=than", "$P1.result", 5000, 2}, new Object[]{"if<than", "$P1.result", 6000, 1}, new Object[]{"create", "$L4", "Error", "5000: Internal error. Try again later.", "ServiceUnavailable"}, new Object[]{"if==than", "$L4", null, 1}, new Object[]{"create", "$L4", "Error", "Unknown Error", "None"}, new Object[]{"throwError", "$L4"}});
            this.put("CloudStorage:uploadWithContentModifiedDate", new Object[]{new Object[]{"create", "$L0", "Error", "Cannot modify file metadata", "Forbidden"}, new Object[]{"throwError", "$L0"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public PCloud(Context context, String clientId, String clientSecret, String redirectUri, String state) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.initService();
    }

    public PCloud(Context context, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.interpreterStorage.put("state", "CloudRailSI");
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to PCloud...");
        new InitSelfTestTask("PCloud", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public InputStream download(String filePath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "download").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:download", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "download").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public void upload(String filePath, InputStream stream, long size, boolean overwrite) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "upload").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:upload", this.interpreterStorage, filePath, stream, size, overwrite ? 1L : 0L);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "upload").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void move(String sourcePath, String destinationPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "move").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:move", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "move").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void delete(String filePath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "delete").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:delete", this.interpreterStorage, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "delete").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void copy(String sourcePath, String destinationPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "copy").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:copy", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "copy").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void createFolder(String folderPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "createFolder").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:createFolder", this.interpreterStorage, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "createFolder").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public CloudMetaData getMetadata(String filePath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "getMetadata").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getMetadata", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "getMetadata").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (CloudMetaData)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> getChildren(String folderPath) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "getChildren").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getChildren", this.interpreterStorage, null, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "getChildren").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> getChildrenPage(String path, long offset, long limit) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "getChildrenPage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getChildrenPage", this.interpreterStorage, null, path, offset, limit);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "getChildrenPage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public String getUserLogin() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "getUserLogin").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserLogin", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "getUserLogin").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getUserName() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "getUserName").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "getUserName").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String createShareLink(String path) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "createShareLink").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:createShareLink", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "createShareLink").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public SpaceAllocation getAllocation() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "getAllocation").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getAllocation", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "getAllocation").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (SpaceAllocation)ip.getParameter(1);
    }

    @Override
    public boolean exists(String path) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "exists").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:exists", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "exists").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return !ip.getParameter(1).equals(0);
    }

    @Override
    public InputStream getThumbnail(String path) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "getThumbnail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getThumbnail", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "getThumbnail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> search(String query) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "search").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:search", this.interpreterStorage, null, query);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "search").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void uploadWithContentModifiedDate(String filePath, InputStream stream, long size, boolean overwrite, long contentModifiedDate) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "uploadWithContentModifiedDate").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:uploadWithContentModifiedDate", this.interpreterStorage, filePath, stream, size, overwrite ? 1L : 0L, contentModifiedDate);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "uploadWithContentModifiedDate").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PCloud", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PCloud", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

