/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Payment;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Charge;
import com.cloudrail.si.types.CreditCard;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.Refund;
import com.cloudrail.si.types.Subscription;
import com.cloudrail.si.types.SubscriptionPlan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PayPal
implements Payment,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"if==than", "$P0.useSandbox", 1, 2}, new Object[]{"set", "$P0.baseURL", "https://api.sandbox.paypal.com/v1"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$P0.baseURL", "https://api.paypal.com/v1"}, new Object[]{"set", "$P0.subscrCreationURL", "http://www.cloudrail.com"}, new Object[]{"set", "$P0.subscrCancellationURL", "http://www.cloudrail.com"}});
            this.put("createCharge", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Amount"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P2", "Amount"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "Currency"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P3", "Currency"}, new Object[]{"callFunc", "checkCurrency", "$P0", "$P3"}, new Object[]{"callFunc", "checkNull", "$P0", "$P4", "Credit Card"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.intent", "sale"}, new Object[]{"callFunc", "createPayer", "$P0", "$L0.payer", "$P4"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"set", "$L0.transactions", "$L1"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"callFunc", "createTransaction", "$P0", "$L2", "$P2", "$P3"}, new Object[]{"push", "$L1", "$L2"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.method", "POST"}, new Object[]{"string.concat", "$L3.url", "$P0.baseURL", "/payments/payment"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L3.requestHeaders", "$L4"}, new Object[]{"set", "$L4", "application/json", "Content-Type"}, new Object[]{"string.concat", "$L5", "Bearer ", "$P0.accessToken"}, new Object[]{"set", "$L4.Authorization", "$L5"}, new Object[]{"json.stringify", "$L6", "$L0"}, new Object[]{"stream.stringToStream", "$L3.requestBody", "$L6"}, new Object[]{"http.requestCall", "$L7", "$L3"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L7"}, new Object[]{"json.parse", "$L8", "$L7.responseBody"}, new Object[]{"callFunc", "extractCharge", "$P0", "$L9", "$L8"}, new Object[]{"set", "$P1", "$L9"}});
            this.put("getCharge", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Charge ID"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P2", "Charge ID"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/payments/payment/", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2"}, new Object[]{"json.parse", "$L4", "$L2.responseBody"}, new Object[]{"callFunc", "extractCharge", "$P0", "$L3", "$L4"}, new Object[]{"set", "$P1", "$L3"}});
            this.put("listCharges", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Start Time"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P2", "Start Time"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "End Time"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P3", "End Time"}, new Object[]{"if>than", "$P2", "$P3", 2}, new Object[]{"create", "$L0", "Error", "Start date can not be greater than end date.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L0", "Date"}, new Object[]{"if>than", "$P3", "$L0.time", 2}, new Object[]{"create", "$L0", "Error", "End date can not be greater than the current time.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "listPayments", "$P0", "$L0", "$P2", "$P3"}, new Object[]{"if!=than", "$P4", null, 10}, new Object[]{"create", "$L1", "Array"}, new Object[]{"create", "$L2", "Number"}, new Object[]{"size", "$L3", "$L0"}, new Object[]{"if<than", "$L2", "$L3", 5}, new Object[]{"get", "$L4", "$L0", "$L2"}, new Object[]{"if==than", "$P4", "$L4.source", 1}, new Object[]{"push", "$L1", "$L4"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -6}, new Object[]{"set", "$L0", "$L1"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("refundCharge", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Charge ID"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P2", "Charge ID"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "executeRefund", "$P0", "$P1", "$P2"}});
            this.put("partiallyRefundCharge", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Charge ID"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P2", "Charge ID"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "Amount"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P3", "Amount"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "executeRefund", "$P0", "$P1", "$P2", "$P3"}});
            this.put("getRefund", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Refund ID"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P2", "Refund ID"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/payments/refund/", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"callFunc", "extractRefund", "$P0", "$P1", "$L3"}});
            this.put("getRefundsForCharge", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Charge ID"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P2", "Charge ID"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/payments/payment/", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"get", "$L4", "$L3.transactions", 0}, new Object[]{"size", "$L5", "$L4.related_resources"}, new Object[]{"create", "$L6", "Number", 0}, new Object[]{"size", "$L7", "$L4.related_resources"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if<than", "$L6", "$L7", 6}, new Object[]{"get", "$L8", "$L4.related_resources", "$L6"}, new Object[]{"if!=than", "$L8.refund", null, 2}, new Object[]{"callFunc", "extractRefund", "$P0", "$L9", "$L8.refund"}, new Object[]{"push", "$P1", "$L9"}, new Object[]{"math.add", "$L6", "$L6", 1}, new Object[]{"jumpRel", -7}});
            this.put("createSubscriptionPlan", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Name"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P2", "Name"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "Amount"}, new Object[]{"callFunc", "checkNull", "$P0", "$P4", "Currency"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P4", "Currency"}, new Object[]{"callFunc", "checkNull", "$P0", "$P5", "Description"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P5", "Description"}, new Object[]{"callFunc", "checkNull", "$P0", "$P6", "Interval"}, new Object[]{"callFunc", "checkNull", "$P0", "$P7", "Interval Count"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P3", "Amount"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P7", "Interval Count"}, new Object[]{"callFunc", "checkCurrency", "$P0", "$P4"}, new Object[]{"callFunc", "checkNull", "$P0", "$P0.subscrCreationURL", "Subscription Created URL"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P0.subscrCreationURL", "Subscription Created URL"}, new Object[]{"callFunc", "checkNull", "$P0", "$P0.subscrCancellationURL", "Subscription Canceled URL"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P0.subscrCancellationURL", "Subscription Canceled URL"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/payments/billing-plans"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"set", "$L1.Content-Type", "application/json"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.name", "$P2"}, new Object[]{"set", "$L2.description", "$P5"}, new Object[]{"set", "$L2.type", "INFINITE"}, new Object[]{"create", "$L3", "Array"}, new Object[]{"set", "$L2.payment_definitions", "$L3"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"push", "$L3", "$L4"}, new Object[]{"set", "$L4.name", "Regular Payments"}, new Object[]{"set", "$L4.type", "REGULAR"}, new Object[]{"set", "$L4.frequency_interval", "$P7"}, new Object[]{"string.concat", "$L4.frequency_interval", "$L4.frequency_interval"}, new Object[]{"set", "$L4.cycles", "0"}, new Object[]{"callFunc", "getFrequency", "$P0", "$L4.frequency", "$P6"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L4.amount", "$L5"}, new Object[]{"set", "$L5.currency", "$P4"}, new Object[]{"callFunc", "normalizeAmount", "$P0", "$L5.value", "$P3"}, new Object[]{"create", "$L20", "Object"}, new Object[]{"set", "$L2.merchant_preferences", "$L20"}, new Object[]{"set", "$L20.cancel_url", "$P0.subscrCancellationURL"}, new Object[]{"set", "$L20.return_url", "$P0.subscrCreationURL"}, new Object[]{"set", "$L20.auto_bill_amount", "YES"}, new Object[]{"json.stringify", "$L6", "$L2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L6"}, new Object[]{"http.requestCall", "$L7", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L7"}, new Object[]{"json.parse", "$L8", "$L7.responseBody"}, new Object[]{"callFunc", "extractSubscriptionPlan", "$P0", "$L9", "$L8"}, new Object[]{"create", "$L10", "Object"}, new Object[]{"set", "$L10.method", "POST"}, new Object[]{"string.concat", "$L10.url", "$P0.baseURL", "/payments/billing-plans/", "$L9.id"}, new Object[]{"create", "$L11", "Object"}, new Object[]{"string.concat", "$L11.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"set", "$L11.Content-Type", "application/json"}, new Object[]{"set", "$L11.X-HTTP-METHOD-OVERRIDE", "PATCH"}, new Object[]{"set", "$L10.requestHeaders", "$L11"}, new Object[]{"create", "$L12", "Array"}, new Object[]{"create", "$L13", "Object"}, new Object[]{"set", "$L13.path", "/"}, new Object[]{"set", "$L13.op", "replace"}, new Object[]{"create", "$L14", "Object"}, new Object[]{"set", "$L14.state", "ACTIVE"}, new Object[]{"set", "$L13.value", "$L14"}, new Object[]{"push", "$L12", "$L13"}, new Object[]{"json.stringify", "$L15", "$L12"}, new Object[]{"stream.stringToStream", "$L10.requestBody", "$L15"}, new Object[]{"http.requestCall", "$L16", "$L10"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L16"}, new Object[]{"set", "$P1", "$L9"}});
            this.put("listSubscriptionPlans", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L20", "Array"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/payments/billing-plans?status=active&page_size=20"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"create", "$L4", "Number"}, new Object[]{"size", "$L5", "$L3.plans"}, new Object[]{"if<than", "$L4", "$L5", 10}, new Object[]{"get", "$L6", "$L3.plans", "$L4"}, new Object[]{"get", "$L7", "$L6.links", 0}, new Object[]{"set", "$L0.url", "$L7.href"}, new Object[]{"http.requestCall", "$L8", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L8"}, new Object[]{"json.parse", "$L9", "$L8.responseBody"}, new Object[]{"callFunc", "extractSubscriptionPlan", "$P0", "$L10", "$L9"}, new Object[]{"push", "$L20", "$L10"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -11}, new Object[]{"create", "$L4", "Number"}, new Object[]{"size", "$L5", "$L3.links"}, new Object[]{"if<than", "$L4", "$L5", 8}, new Object[]{"get", "$L6", "$L3.links", "$L4"}, new Object[]{"if==than", "$L6.rel", "next_page", 4}, new Object[]{"set", "$L0.url", "$L6.href"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2"}, new Object[]{"jumpRel", -23}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -9}, new Object[]{"set", "$P1", "$L20"}});
            this.put("createSubscription", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Subscription Plan ID"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P2", "Subscription Plan ID"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "Subscription Name"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P3", "Subscription Name"}, new Object[]{"callFunc", "checkNull", "$P0", "$P4", "Subscription Description"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P4", "Subscription Description"}, new Object[]{"callFunc", "checkNull", "$P0", "$P5", "Credit Card"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/payments/billing-agreements"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"set", "$L1.Content-Type", "application/json"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.name", "$P3"}, new Object[]{"set", "$L2.description", "$P4"}, new Object[]{"create", "$L3", "Date"}, new Object[]{"math.add", "$L3.time", "$L3.time", 120000}, new Object[]{"set", "$L2.start_date", "$L3.rfcTime"}, new Object[]{"callFunc", "createPayer", "$P0", "$L2.payer", "$P5"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4.id", "$P2"}, new Object[]{"set", "$L2.plan", "$L4"}, new Object[]{"json.stringify", "$L5", "$L2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L5"}, new Object[]{"http.requestCall", "$L6", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6"}, new Object[]{"json.parse", "$L7", "$L6.responseBody"}, new Object[]{"set", "$L7.name", "$P3"}, new Object[]{"set", "$L7.plan.id", "$P2"}, new Object[]{"callFunc", "extractSubscription", "$P0", "$P1", "$L7"}});
            this.put("updateSubscription", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Subscription ID"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P2", "Subscription Plan ID"}, new Object[]{"if==than", "$P3", null, 3}, new Object[]{"if==than", "$P4", null, 2}, new Object[]{"create", "$L0", "Error", "Provide a new credit card or a new subscription plan.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/payments/billing-agreements/", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"set", "$L1.X-HTTP-METHOD-OVERRIDE", "PATCH"}, new Object[]{"set", "$L1.Content-Type", "application/json"}, new Object[]{"create", "$L2", "Array"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.op", "replace"}, new Object[]{"set", "$L3.path", "/"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"if!=than", "$P3", null, 3}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.id", "$P3"}, new Object[]{"set", "$L4.plan", "$L5"}, new Object[]{"if!=than", "$P4", null, 1}, new Object[]{"callFunc", "createPayer", "$P0", "$L4.payer", "$P4"}, new Object[]{"set", "$L3.value", "$L4"}, new Object[]{"push", "$L2", "$L3"}, new Object[]{"json.stringify", "$L6", "$L2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L6"}, new Object[]{"http.requestCall", "$L7", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L7"}, new Object[]{"json.parse", "$L8", "$L7.responseBody"}, new Object[]{"callFunc", "extractSubscription", "$P0", "$P1", "$L8"}});
            this.put("cancelSubscription", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P1", "Subscription ID"}, new Object[]{"callFunc", "checkEmptyString", "$P0", "$P2", "Subscription Plan ID"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/payments/billing-agreements/", "$P1", "/cancel"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"set", "$L1.Content-Type", "application/json"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.note", "Cancelling the agreement."}, new Object[]{"json.stringify", "$L3", "$L2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 2}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "$P2.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.accessToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0"}, new Object[]{"return"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L1.time", "$S0.expiresIn"}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"callFunc", "authenticate", "$P0"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/oauth2/token"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "grant_type=client_credentials"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L1.Accept", "application/json"}, new Object[]{"set", "$L1", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"string.concat", "$L2", "$P0.clientId", ":", "$P0.clientSecret"}, new Object[]{"string.base64encode", "$L2", "$L2"}, new Object[]{"string.concat", "$L2", "Basic ", "$L2"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L3"}, new Object[]{"json.parse", "$L4", "$L3.responseBody"}, new Object[]{"set", "$P0.accessToken", "$L4.access_token"}, new Object[]{"create", "$L5", "Date"}, new Object[]{"math.multiply", "$L6", "$L4.expires_in", 1000}, new Object[]{"math.add", "$L6", "$L6", "$L5.time", -60000}, new Object[]{"set", "$P0.expiresIn", "$L6"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be null."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkEmptyString", new Object[]{new Object[]{"if==than", "$P1", "", 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be empty."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkLessThanZero", new Object[]{new Object[]{"if<=than", "$P1", 0, 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be less than 0."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkCurrency", new Object[]{new Object[]{"size", "$L0", "$P1"}, new Object[]{"if!=than", "$L0", 3, 2}, new Object[]{"create", "$L1", "Error", "Currency code has to have three letters.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkHttpErrors", new Object[]{new Object[]{"if==than", "$P1.code", 429, 2}, new Object[]{"create", "$L0", "Error", "Rate limit exceeded!", "Http"}, new Object[]{"throwError", "$L0"}, new Object[]{"if>=than", "$P1.code", 500, 8}, new Object[]{"if==than", "$P1.code", 503, 4}, new Object[]{"string.concat", "$L10", "The reurned code was ", "$P1.code", " ", "$P1.message"}, new Object[]{"create", "$L3", "Error", "$L10", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"jumpRel", 3}, new Object[]{"string.concat", "$L10", "The returned code was ", "$P1.code", " ", "$P1.message"}, new Object[]{"create", "$L3", "Error", "$L10", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 400, 26}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L2", "$L0.message"}, new Object[]{"if==than", "$L2", null, 1}, new Object[]{"set", "$L2", "$L0.error_description"}, new Object[]{"if==than", "$L2", "", 1}, new Object[]{"set", "$L2", "$L0.error_description"}, new Object[]{"if==than", "$L2", null, 1}, new Object[]{"set", "$L2", "$L0.error.message"}, new Object[]{"if==than", "$L2", "", 1}, new Object[]{"set", "$L2", "$L0.error.message"}, new Object[]{"if==than", "$L2", null, 3}, new Object[]{"if!=than", "$L0.field", null, 2}, new Object[]{"get", "$L10", "$L0.field.details", 0}, new Object[]{"set", "$L2", "$L10.issue"}, new Object[]{"if==than", "$L2", "", 3}, new Object[]{"if!=than", "$L0.field", null, 2}, new Object[]{"get", "$L10", "$L0.field.details", 0}, new Object[]{"set", "$L2", "$L10.issue"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
            this.put("createPayer", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.payment_method", "credit_card"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"set", "$L0.funding_instruments", "$L1"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"push", "$L1", "$L2"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L2.credit_card", "$L3"}, new Object[]{"set", "$L3.number", "$P2.number"}, new Object[]{"set", "$L3.type", "$P2.type"}, new Object[]{"string.concat", "$L4", "$P2.expire_month"}, new Object[]{"set", "$L3.expire_month", "$L4"}, new Object[]{"string.concat", "$L4", "$P2.expire_year"}, new Object[]{"set", "$L3.expire_year", "$L4"}, new Object[]{"set", "$L3.first_name", "$P2.firstName"}, new Object[]{"set", "$L3.last_name", "$P2.lastName"}, new Object[]{"if!=than", "$P2.cvc", null, 1}, new Object[]{"set", "$L3.cvv2", "$P2.cvc"}, new Object[]{"if!=than", "$P2.address", null, 8}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L3.billing_address", "$L5"}, new Object[]{"set", "$L5.line1", "$P2.address.line1"}, new Object[]{"set", "$L5.line2", "$P2.address.line2"}, new Object[]{"set", "$L5.city", "$P2.address.city"}, new Object[]{"set", "$L5.country_code", "$P2.address.country"}, new Object[]{"set", "$L5.postal_code", "$P2.address.postalCode"}, new Object[]{"set", "$L5.state", "$P2.address.state"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("createTransaction", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.amount", "$L1"}, new Object[]{"set", "$L1.currency", "$P3"}, new Object[]{"callFunc", "normalizeAmount", "$P0", "$L1.total", "$P2"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("extractCharge", new Object[]{new Object[]{"set", "$L0", "$P2"}, new Object[]{"get", "$L1", "$L0.transactions", 0}, new Object[]{"math.multiply", "$L2", "$L1.amount.total", 100}, new Object[]{"if<than", "$L2", 0, 1}, new Object[]{"math.multiply", "$L2", "$L2", -1}, new Object[]{"string.concat", "$L2", "$L2"}, new Object[]{"math.add", "$L2", "$L2"}, new Object[]{"create", "$L3", "Date", "$L0.create_time"}, new Object[]{"get", "$L4", "$L1.amount.currency"}, new Object[]{"get", "$L5", "$L0.id"}, new Object[]{"get", "$L6", "$L1.related_resources", 0}, new Object[]{"get", "$L7", "$L6.sale.state"}, new Object[]{"if==than", "$L7", "refunded", 2}, new Object[]{"set", "$L7", 1}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L7", 0}, new Object[]{"callFunc", "extractCreditCard", "$P0", "$L13", "$L0.payer"}, new Object[]{"get", "$L14", "$L0.state"}, new Object[]{"if==than", "$L14", "created", 2}, new Object[]{"set", "$L14", "pending"}, new Object[]{"jumpRel", 8}, new Object[]{"if==than", "$L14", "approved", 2}, new Object[]{"set", "$L14", "succeeded"}, new Object[]{"jumpRel", 5}, new Object[]{"if==than", "$L14", "canceled", 2}, new Object[]{"set", "$L14", "failed"}, new Object[]{"jumpRel", 2}, new Object[]{"if==than", "$L14", "expired", 2}, new Object[]{"set", "$L14", "failed"}, new Object[]{"create", "$P1", "Charge", "$L2", "$L3.time", "$L4", "$L5", "$L7", "$L13", "$L14"}});
            this.put("listPayments", new Object[]{new Object[]{"create", "$L0", "Array"}, new Object[]{"create", "$L10", "Date"}, new Object[]{"set", "$L10.time", "$P2"}, new Object[]{"string.urlEncode", "$L10", "$L10.rfcTime"}, new Object[]{"create", "$L11", "Date"}, new Object[]{"set", "$L11.time", "$P3"}, new Object[]{"string.urlEncode", "$L11", "$L11.rfcTime"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.method", "GET"}, new Object[]{"string.concat", "$L1.url", "$P0.baseURL", "/payments/payment?sort_by=create_time&", "start_time=", "$L10", "&end_time=", "$L11", "&count=20"}, new Object[]{"if!=than", "$L5", null, 1}, new Object[]{"string.concat", "$L1.url", "$L1.url", "&start_id=", "$L5"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L1.requestHeaders", "$L2"}, new Object[]{"string.concat", "$L2.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L3", "$L1"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L3"}, new Object[]{"json.parse", "$L4", "$L3.responseBody"}, new Object[]{"set", "$L5", "$L4.next_id"}, new Object[]{"create", "$L6", "Number", 0}, new Object[]{"get", "$L7", "$L4.count"}, new Object[]{"if<than", "$L6", "$L7", 5}, new Object[]{"get", "$L8", "$L4.payments", "$L6"}, new Object[]{"callFunc", "extractCharge", "$P0", "$L9", "$L8"}, new Object[]{"push", "$L0", "$L9"}, new Object[]{"math.add", "$L6", "$L6", 1}, new Object[]{"jumpRel", -6}, new Object[]{"if!=than", "$L5", null, 1}, new Object[]{"jumpRel", -22}, new Object[]{"set", "$P1", "$L0"}});
            this.put("executeRefund", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/payments/payment/", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"string.concat", "$L1.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"get", "$L4", "$L3.transactions", 0}, new Object[]{"set", "$L8", "$L4.amount.currency"}, new Object[]{"get", "$L4", "$L4.related_resources", 0}, new Object[]{"set", "$L4", "$L4.sale.id"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"string.concat", "$L5.url", "$P0.baseURL", "/payments/sale/", "$L4", "/refund"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"set", "$L5.requestHeaders", "$L6"}, new Object[]{"string.concat", "$L6.Authorization", "Bearer ", "$P0.accessToken"}, new Object[]{"set", "$L6", "application/json", "Content-Type"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"if!=than", "$P3", null, 4}, new Object[]{"create", "$L9", "Object"}, new Object[]{"set", "$L7.amount", "$L9"}, new Object[]{"set", "$L9.currency", "$L8"}, new Object[]{"callFunc", "normalizeAmount", "$P0", "$L9.total", "$P3"}, new Object[]{"json.stringify", "$L5.requestBody", "$L7"}, new Object[]{"stream.stringToStream", "$L5.requestBody", "$L5.requestBody"}, new Object[]{"http.requestCall", "$L9", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L9"}, new Object[]{"json.parse", "$L10", "$L9.responseBody"}, new Object[]{"callFunc", "extractRefund", "$P0", "$P1", "$L10"}});
            this.put("normalizeAmount", new Object[]{new Object[]{"math.multiply", "$L0", "$P2", 0.01}, new Object[]{"string.concat", "$L0", "$L0"}, new Object[]{"string.indexOf", "$L1", "$L0", "."}, new Object[]{"size", "$L2", "$L0"}, new Object[]{"math.multiply", "$L1", "$L1", -1}, new Object[]{"math.add", "$L3", "$L1", "$L2"}, new Object[]{"if==than", "$L3", 2, 1}, new Object[]{"string.concat", "$L0", "$L0", "0"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("extractRefund", new Object[]{new Object[]{"math.multiply", "$L0", "$P2.amount.total", 100}, new Object[]{"if<than", "$L0", 0, 1}, new Object[]{"math.multiply", "$L0", "$L0", -1}, new Object[]{"string.concat", "$L0", "$L0"}, new Object[]{"math.add", "$L0", "$L0"}, new Object[]{"get", "$L1", "$P2.parent_payment"}, new Object[]{"create", "$L2", "Date", "$P2.create_time"}, new Object[]{"set", "$L2", "$L2.time"}, new Object[]{"get", "$L3", "$P2.id"}, new Object[]{"get", "$L4", "$P2.state"}, new Object[]{"if==than", "$L4", "completed", 1}, new Object[]{"set", "$L4", "succeeded"}, new Object[]{"get", "$L5", "$P2.amount.currency"}, new Object[]{"create", "$P1", "Refund", "$L0", "$L1", "$L2", "$L3", "$L4", "$L5"}});
            this.put("getFrequency", new Object[]{new Object[]{"if==than", "$P2", "day", 2}, new Object[]{"set", "$P1", "DAY"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "week", 2}, new Object[]{"set", "$P1", "WEEK"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "month", 2}, new Object[]{"set", "$P1", "MONTH"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "year", 2}, new Object[]{"set", "$P1", "YEAR"}, new Object[]{"return"}, new Object[]{"create", "$L0", "Error", "Invalid interval. Allowed values are: 'day', 'week', 'month' or 'year'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("getInterval", new Object[]{new Object[]{"if==than", "$P2", "Day", 2}, new Object[]{"set", "$P1", "day"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Week", 2}, new Object[]{"set", "$P1", "week"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Month", 2}, new Object[]{"set", "$P1", "month"}, new Object[]{"return"}, new Object[]{"set", "$P1", "year"}});
            this.put("extractSubscriptionPlan", new Object[]{new Object[]{"get", "$L0", "$P2.payment_definitions", 0}, new Object[]{"math.multiply", "$L1", "$L0.amount.value", 100}, new Object[]{"string.concat", "$L1", "$L1"}, new Object[]{"math.add", "$L1", "$L1"}, new Object[]{"create", "$L2", "Date", "$P2.create_time"}, new Object[]{"callFunc", "getInterval", "$P0", "$L3", "$L0.frequency"}, new Object[]{"math.add", "$L4", "$L0.frequency_interval", 0}, new Object[]{"create", "$P1", "SubscriptionPlan", "$L1", "$L2.time", "$L0.amount.currency", "$P2.description", "$P2.id", "$L3", "$L4", "$P2.name"}});
            this.put("extractSubscription", new Object[]{new Object[]{"create", "$L0", "Date", "$P2.start_date"}, new Object[]{"if!=than", "$P2.agreement_details.last_payment_date", null, 2}, new Object[]{"create", "$L1", "Date", "$P2.agreement_details.last_payment_date"}, new Object[]{"set", "$L1", "$L1.time"}, new Object[]{"create", "$L2", "Date", "$P2.agreement_details.next_billing_date"}, new Object[]{"callFunc", "extractCreditCard", "$P0", "$L3", "$P2.payer"}, new Object[]{"get", "$L4", "$P2.state"}, new Object[]{"if==than", "$L4", "Active", 1}, new Object[]{"set", "$L4", "active"}, new Object[]{"if==than", "$L4", "Pending", 1}, new Object[]{"set", "$L4", "active"}, new Object[]{"if==than", "$L4", "Expired", 1}, new Object[]{"set", "$L4", "cancelled"}, new Object[]{"if==than", "$L4", "Suspend", 1}, new Object[]{"set", "$L4", "cancelled"}, new Object[]{"if==than", "$L4", "Reactivated", 1}, new Object[]{"set", "$L4", "active"}, new Object[]{"if==than", "$L4", "Cancel", 1}, new Object[]{"set", "$L4", "cancelled"}, new Object[]{"create", "$P1", "Subscription", "$L0.time", "$P2.description", "$P2.id", "$L1", "$P2.name", "$L2.time", "$L3", "$L4", "$P2.plan.id"}});
            this.put("extractCreditCard", new Object[]{new Object[]{"get", "$L8", "$P2.funding_instruments", 0}, new Object[]{"get", "$L9", "$L8.credit_card.type"}, new Object[]{"get", "$L10", "$L8.credit_card.number"}, new Object[]{"get", "$L11", "$L8.credit_card.expire_year"}, new Object[]{"math.add", "$L11", "$L11", 0}, new Object[]{"get", "$L12", "$L8.credit_card.expire_month"}, new Object[]{"math.add", "$L12", "$L12", 0}, new Object[]{"get", "$L13", "$L8.credit_card.cvv2"}, new Object[]{"get", "$L15", "$L8.credit_card.first_name"}, new Object[]{"get", "$L16", "$L8.credit_card.last_name"}, new Object[]{"size", "$L0", "$L10"}, new Object[]{"if==than", "$L0", 4, 1}, new Object[]{"string.concat", "$L10", "xxxxxxxxxxxx", "$L10"}, new Object[]{"get", "$L17", "$L8.credit_card.billing_address"}, new Object[]{"set", "$L18", null}, new Object[]{"if!=than", "$L17", null, 13}, new Object[]{"create", "$L18", "Address"}, new Object[]{"if!=than", "$L17.line1", null, 1}, new Object[]{"set", "$L18.line1", "$L17.line1"}, new Object[]{"if!=than", "$L17.line2", null, 1}, new Object[]{"set", "$L18.line2", "$L17.line2"}, new Object[]{"if!=than", "$L17.country_code", null, 1}, new Object[]{"set", "$L18.country", "$L17.country_code"}, new Object[]{"if!=than", "$L17.city", null, 1}, new Object[]{"set", "$L18.city", "$L17.city"}, new Object[]{"if!=than", "$L17.postal_code", null, 1}, new Object[]{"set", "$L18.postalCode", "$L17.postal_code"}, new Object[]{"if!=than", "$L17.state", null, 1}, new Object[]{"set", "$L18.state", "$L17.state"}, new Object[]{"create", "$P1", "CreditCard", "$L13", "$L12", "$L11", "$L10", "$L9", "$L15", "$L16", "$L18"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public PayPal(Context context, boolean useSandbox, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("useSandbox", useSandbox ? 1L : 0L);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to PayPal...");
        new InitSelfTestTask("PayPal", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Charge createCharge(Long amount, String currency, CreditCard source) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "createCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createCharge", this.interpreterStorage, null, amount, currency, source);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "createCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Charge)ip.getParameter(1);
    }

    @Override
    public Charge getCharge(String id) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "getCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getCharge", this.interpreterStorage, null, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "getCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Charge)ip.getParameter(1);
    }

    @Override
    public List<Charge> listCharges(Long from, Long to, CreditCard creditCard) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "listCharges").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listCharges", this.interpreterStorage, null, from, to, creditCard);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "listCharges").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public Refund refundCharge(String id) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "refundCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("refundCharge", this.interpreterStorage, null, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "refundCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Refund)ip.getParameter(1);
    }

    @Override
    public Refund partiallyRefundCharge(String id, Long amount) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "partiallyRefundCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("partiallyRefundCharge", this.interpreterStorage, null, id, amount);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "partiallyRefundCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Refund)ip.getParameter(1);
    }

    @Override
    public Refund getRefund(String id) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "getRefund").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getRefund", this.interpreterStorage, null, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "getRefund").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Refund)ip.getParameter(1);
    }

    @Override
    public List<Refund> getRefundsForCharge(String id) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "getRefundsForCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getRefundsForCharge", this.interpreterStorage, null, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "getRefundsForCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public SubscriptionPlan createSubscriptionPlan(String name, Long amount, String currency, String description, String interval, Long intervalCount) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "createSubscriptionPlan").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createSubscriptionPlan", this.interpreterStorage, null, name, amount, currency, description, interval, intervalCount);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "createSubscriptionPlan").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (SubscriptionPlan)ip.getParameter(1);
    }

    @Override
    public List<SubscriptionPlan> listSubscriptionPlans() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "listSubscriptionPlans").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listSubscriptionPlans", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "listSubscriptionPlans").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public Subscription createSubscription(String planID, String name, String description, CreditCard source) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "createSubscription").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createSubscription", this.interpreterStorage, null, planID, name, description, source);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "createSubscription").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Subscription)ip.getParameter(1);
    }

    @Override
    public void cancelSubscription(String id) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "cancelSubscription").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("cancelSubscription", this.interpreterStorage, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "cancelSubscription").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "PayPal", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("PayPal", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

