/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.BusinessCloudStorage;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Bucket;
import com.cloudrail.si.types.BusinessFileMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Rackspace
implements BusinessCloudStorage,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("Storage:createBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "X-Auth-Token"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.publicURL", "/", "$P2"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "PUT"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"if==than", "$L6.code", 202, 2}, new Object[]{"create", "$L3", "Error", "Bucket already exists.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "create bucket", 201}, new Object[]{"create", "$L14", "Bucket"}, new Object[]{"set", "$L14.name", "$P2"}, new Object[]{"set", "$L14.identifier", "$P2"}, new Object[]{"set", "$P1", "$L14"}});
            this.put("Storage:deleteBucket", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "X-Auth-Token"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.publicURL", "/", "$P1.name"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "DELETE"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"if!=than", "$L6.code", 204, 3}, new Object[]{"if==than", "$L6.code", 404, 2}, new Object[]{"create", "$L3", "Error", "Bucket not found.", "NotFound"}, new Object[]{"throwError", "$L3"}});
            this.put("Storage:listBuckets", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "X-Auth-Token"}, new Object[]{"set", "$L4", "application/json", "Accept"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.publicURL", "?format=json"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"create", "$L14", "Array"}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"json.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12"}, new Object[]{"if!=than", "$L10", 0, 7}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "Bucket"}, new Object[]{"get", "$L15", "$L12", "$L10"}, new Object[]{"set", "$L13.identifier", "$L15.name"}, new Object[]{"set", "$L13.name", "$L15.name"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -8}, new Object[]{"set", "$P1", "$L14"}});
            this.put("Storage:upload", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P1"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"callFunc", "checkSize", "$P0", "$P4"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/octet-stream", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "X-Auth-Token"}, new Object[]{"string.concat", "$L1", "$S0.publicURL", "/", "$P1.name", "/", "$P2"}, new Object[]{"string.concat", "$L4.Content-Length", "$P4"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "$L1"}, new Object[]{"set", "$L5.method", "PUT"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"set", "$L5.requestBody", "$P3"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"if!=than", "$L6.code", 201, 4}, new Object[]{"if!=than", "$L6.code", 202, 3}, new Object[]{"if==than", "$L6.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Error while uploading the file", "Upload Error"}, new Object[]{"throwError", "$L3"}});
            this.put("Storage:download", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkBucket", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "X-Auth-Token"}, new Object[]{"string.concat", "$L1", "$S0.publicURL", "/", "$P3.name", "/", "$P2"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "$L1"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"set", "$P1", "$L6.responseBody"}});
            this.put("Storage:listFiles", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "X-Auth-Token"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L10", "$S0.publicURL", "/", "$P2.name", "?format=json"}, new Object[]{"set", "$L5.url", "$L10"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"create", "$L14", "Array"}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"json.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12"}, new Object[]{"if!=than", "$L10", 0, 8}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "BusinessFileMetaData"}, new Object[]{"get", "$L15", "$L12", "$L10"}, new Object[]{"set", "$L13.fileID", "$L15.hash"}, new Object[]{"set", "$L13.fileName", "$L15.name"}, new Object[]{"set", "$L13.size", "$L15.bytes"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -9}, new Object[]{"set", "$P1", "$L14"}});
            this.put("Storage:listFilesWithPrefix", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkPrefix", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "X-Auth-Token"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L10", "$S0.publicURL", "/", "$P2.name", "?format=json"}, new Object[]{"if!=than", "$P3", null, 2}, new Object[]{"string.concat", "$L2", "$L10", "&prefix=", "$P3"}, new Object[]{"set", "$L10", "$L2"}, new Object[]{"set", "$L5.url", "$L10"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"create", "$L14", "Array"}, new Object[]{"stream.streamToString", "$L12", "$L6.responseBody"}, new Object[]{"json.parse", "$L12", "$L12"}, new Object[]{"size", "$L10", "$L12"}, new Object[]{"if!=than", "$L10", 0, 8}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"create", "$L13", "BusinessFileMetaData"}, new Object[]{"get", "$L15", "$L12", "$L10"}, new Object[]{"set", "$L13.fileID", "$L15.hash"}, new Object[]{"set", "$L13.fileName", "$L15.name"}, new Object[]{"set", "$L13.size", "$L15.bytes"}, new Object[]{"push", "$L14", "$L13"}, new Object[]{"jumpRel", -9}, new Object[]{"set", "$P1", "$L14"}});
            this.put("checkPrefix", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L1", "Error", "Prefix supplied is null", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("Storage:getFileMetadata", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$S0.publicURL", "/", "$P2.name", "/", "$P3"}, new Object[]{"set", "$L0.method", "HEAD"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L1.X-Auth-Token", "$S0.authorizationToken"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2", "get metadata", 200}, new Object[]{"get", "$L3", "$L2.responseHeaders"}, new Object[]{"create", "$P1", "BusinessFileMetaData"}, new Object[]{"set", "$P1.fileName", "$P3"}, new Object[]{"set", "$P1.fileID", "$P3"}, new Object[]{"set", "$P1.size", "$L3.Content-Length"}, new Object[]{"callFunc", "parseDate", "$P0", "$L4", "$L3.Last-Modified"}, new Object[]{"set", "$P1.lastModified", "$L4"}});
            this.put("Storage:deleteFile", new Object[]{new Object[]{"callFunc", "checkBucket", "$P0", "$P2"}, new Object[]{"callFunc", "checkNull", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4", "$S0.authorizationToken", "X-Auth-Token"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"string.concat", "$L0", "$S0.publicURL", "/", "$P2.name", "/", "$P1"}, new Object[]{"set", "$L5.url", "$L0"}, new Object[]{"set", "$L5.method", "DELETE"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"if!=than", "$L6.code", 204, 3}, new Object[]{"if==than", "$L6.code", 404, 2}, new Object[]{"create", "$L3", "Error", "File not found.", "NotFound"}, new Object[]{"throwError", "$L3"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 3}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.url", "$S0.publicURL", "$P2.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"set", "$L0.requestHeaders.X-Auth-Token", "$S0.authorizationToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L1", "advancedRequest"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if==than", "$S0.tokenID", null, 2}, new Object[]{"callFunc", "authenticate", "$P0"}, new Object[]{"return"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L2", "String"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/json", "Content-Type"}, new Object[]{"string.concat", "$L9", "{\"auth\": { \"RAX-KSKEY:apiKeyCredentials\": {\"username\": \"", "$P0.username", "\", \"apiKey\": \"", "$P0.apiKey", "\"}}}"}, new Object[]{"size", "$L10", "$L9"}, new Object[]{"string.concat", "$L4.Content-Length", "$L10"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "https://identity.api.rackspacecloud.com/v2.0/tokens"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"set", "$L5.requestBody", "$L9"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$L8", "$L8.access"}, new Object[]{"set", "$L9", "$L8.token"}, new Object[]{"set", "$S0.authorizationToken", "$L9.id"}, new Object[]{"set", "$S0.expires", "$L9.expires"}, new Object[]{"set", "$L8", "$L8.serviceCatalog"}, new Object[]{"size", "$L10", "$L8"}, new Object[]{"if!=than", "$L10", 0, 13}, new Object[]{"math.add", "$L10", "$L10", -1}, new Object[]{"get", "$L11", "$L8", "$L10"}, new Object[]{"if==than", "$L11.name", "cloudFiles", 9}, new Object[]{"size", "$L12", "$L11.endpoints"}, new Object[]{"if!=than", "$L12", 0, 7}, new Object[]{"math.add", "$L12", "$L12", -1}, new Object[]{"get", "$L13", "$L11.endpoints", "$L12"}, new Object[]{"if==than", "$L13.region", "$P0.region", 3}, new Object[]{"set", "$S0.tenantId", "$L13.tenantId"}, new Object[]{"set", "$S0.publicURL", "$L13.publicURL"}, new Object[]{"set", "$S0.internalURL", "$L13.internalURL"}, new Object[]{"jumpRel", -8}, new Object[]{"jumpRel", -14}});
            this.put("checkHttpErrors", new Object[]{new Object[]{"if==than", "$P3", null, 2}, new Object[]{"if>=than", "$P1.code", 400, 22}, new Object[]{"jumpRel", 1}, new Object[]{"if!=than", "$P1.code", "$P3", 20}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "Requested object wasn't found.", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L2", "$L0.message"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 400, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 402, 5}, new Object[]{"if<=than", "$P1.code", 509, 4}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"if!=than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Parameter should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkBucket", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P1"}, new Object[]{"if==than", "$P1.name", null, 3}, new Object[]{"if==than", "$P1.identifier", null, 2}, new Object[]{"create", "$L0", "Error", "Bucket name and identifier should not be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkSize", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Size can not be negative.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("parseDate", new Object[]{new Object[]{"string.substr", "$L0", "$P2", 5, 2}, new Object[]{"string.substr", "$L1", "$P2", 8, 3}, new Object[]{"callFunc", "getMonthNumber", "$P0", "$L6", "$L1"}, new Object[]{"string.substr", "$L2", "$P2", 12, 4}, new Object[]{"string.substr", "$L3", "$P2", 17, 8}, new Object[]{"string.concat", "$L4", "$L2", "-", "$L6", "-", "$L0", "T", "$L3", "Z"}, new Object[]{"create", "$L5", "Date", "$L4"}, new Object[]{"set", "$P1", "$L5.time"}});
            this.put("getMonthNumber", new Object[]{new Object[]{"if==than", "$P2", "Jan", 2}, new Object[]{"set", "$P1", "01"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Feb", 2}, new Object[]{"set", "$P1", "02"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Mar", 2}, new Object[]{"set", "$P1", "03"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Apr", 2}, new Object[]{"set", "$P1", "04"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "May", 2}, new Object[]{"set", "$P1", "05"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Jun", 2}, new Object[]{"set", "$P1", "06"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Jul", 2}, new Object[]{"set", "$P1", "07"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Aug", 2}, new Object[]{"set", "$P1", "08"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Sep", 2}, new Object[]{"set", "$P1", "09"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Oct", 2}, new Object[]{"set", "$P1", "10"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Nov", 2}, new Object[]{"set", "$P1", "11"}, new Object[]{"return"}, new Object[]{"if==than", "$P2", "Dec", 2}, new Object[]{"set", "$P1", "12"}, new Object[]{"return"}, new Object[]{"create", "$L0", "Error", "Could not recognize month in Date"}, new Object[]{"throwError", "$L0"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Rackspace(Context context, String username, String apiKey, String region) {
        this.initDataStructures(context);
        this.interpreterStorage.put("username", username);
        this.interpreterStorage.put("apiKey", apiKey);
        this.interpreterStorage.put("region", region);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Rackspace...");
        new InitSelfTestTask("Rackspace", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Bucket createBucket(String bucketName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "createBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:createBucket", this.interpreterStorage, null, bucketName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "createBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Bucket)ip.getParameter(1);
    }

    @Override
    public List<Bucket> listBuckets() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "listBuckets").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:listBuckets", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "listBuckets").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void deleteBucket(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "deleteBucket").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:deleteBucket", this.interpreterStorage, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "deleteBucket").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void deleteFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "deleteFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:deleteFile", this.interpreterStorage, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "deleteFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public BusinessFileMetaData getFileMetadata(Bucket bucket, String fileName) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "getFileMetadata").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:getFileMetadata", this.interpreterStorage, null, bucket, fileName);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "getFileMetadata").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (BusinessFileMetaData)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFiles(Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "listFiles").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:listFiles", this.interpreterStorage, null, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "listFiles").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public List<BusinessFileMetaData> listFilesWithPrefix(Bucket bucket, String prefix) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "listFilesWithPrefix").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:listFilesWithPrefix", this.interpreterStorage, null, bucket, prefix);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "listFilesWithPrefix").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void uploadFile(Bucket bucket, String name, InputStream stream, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "uploadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:upload", this.interpreterStorage, bucket, name, stream, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "uploadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public InputStream downloadFile(String fileName, Bucket bucket) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "downloadFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Storage:download", this.interpreterStorage, null, fileName, bucket);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "downloadFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Rackspace", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Rackspace", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

