/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Email;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Attachment;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SendGrid
implements Email,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"set", "$P0.baseUrl", "https://api.sendgrid.com/v3"}});
            this.put("sendEmail", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P1", "fromAddress"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "fromName"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P3", "toAddresses"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P4", "subject"}, new Object[]{"callFunc", "checkEmptyList", "$P0", "$P3", "toAddresses"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P1", "fromAddress"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "fromName"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P4", "subject"}, new Object[]{"set", "$L2", 1}, new Object[]{"set", "$L3", 1}, new Object[]{"if==than", "$P5", null, 1}, new Object[]{"set", "$L2", 0}, new Object[]{"if==than", "$P5", "", 1}, new Object[]{"set", "$L2", 0}, new Object[]{"if==than", "$P6", null, 1}, new Object[]{"set", "$L3", 0}, new Object[]{"if==than", "$P6", "", 1}, new Object[]{"set", "$L3", 0}, new Object[]{"if==than", "$L2", 0, 3}, new Object[]{"if==than", "$L3", 0, 2}, new Object[]{"create", "$L4", "Error", "Either a textBody or a htmlBody must be provided!", "IllegalArgument"}, new Object[]{"throwError", "$L4"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "/mail/send"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.apiKey"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"create", "$L1.from", "Object"}, new Object[]{"set", "$L1.from.email", "$P1"}, new Object[]{"set", "$L1.from.name", "$P2"}, new Object[]{"set", "$L1.subject", "$P4"}, new Object[]{"create", "$L1.content", "Array"}, new Object[]{"if==than", "$L2", 1, 4}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.type", "text/plain"}, new Object[]{"set", "$L5.value", "$P5"}, new Object[]{"push", "$L1.content", "$L5"}, new Object[]{"if==than", "$L3", 1, 4}, new Object[]{"create", "$L6", "Object"}, new Object[]{"set", "$L6.type", "text/html"}, new Object[]{"set", "$L6.value", "$P6"}, new Object[]{"push", "$L1.content", "$L6"}, new Object[]{"create", "$L1.personalizations", "Array"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"callFunc", "pushAddresses", "$P0", "$L7.to", "$P3"}, new Object[]{"callFunc", "pushAddresses", "$P0", "$L7.cc", "$P7"}, new Object[]{"callFunc", "pushAddresses", "$P0", "$L7.bcc", "$P8"}, new Object[]{"push", "$L1.personalizations", "$L7"}, new Object[]{"callFunc", "pushAttachments", "$P0", "$L1", "$P9"}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"http.requestCall", "$L0", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L0"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 2}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "$P2.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 1}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.apiKey"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("pushAddresses", new Object[]{new Object[]{"if==than", "$P2", null, 1}, new Object[]{"return"}, new Object[]{"size", "$L0", "$P2"}, new Object[]{"if==than", "$L0", 0, 1}, new Object[]{"return"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"set", "$L1", 0}, new Object[]{"get", "$L2", "$P2", "$L1"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.email", "$L2"}, new Object[]{"push", "$P1", "$L3"}, new Object[]{"math.add", "$L1", 1}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"jumpRel", -7}});
            this.put("pushAttachments", new Object[]{new Object[]{"if==than", "$P2", null, 1}, new Object[]{"return"}, new Object[]{"size", "$L0", "$P2"}, new Object[]{"if==than", "$L0", 0, 1}, new Object[]{"return"}, new Object[]{"create", "$L1", "Number", 0}, new Object[]{"create", "$P1.attachments", "Array"}, new Object[]{"if<than", "$L1", "$L0", 16}, new Object[]{"get", "$L2", "$P2", "$L1"}, new Object[]{"set", "$L4", "$L2.content"}, new Object[]{"set", "$L5", "$L2.filename"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$L4", "content"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$L5", "filename"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"create", "$L4", "String"}, new Object[]{"stream.streamToData", "$L4", "$L2.content"}, new Object[]{"string.base64encode", "$L4", "$L4"}, new Object[]{"set", "$L3.content", "$L4"}, new Object[]{"if!=than", "$L2.mimeType", null, 1}, new Object[]{"set", "$L3.type", "$L2.mimeType"}, new Object[]{"set", "$L3.filename", "$L2.filename"}, new Object[]{"push", "$P1.attachments", "$L3"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -17}});
            this.put("checkMandatory", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L1", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L0", "Error", "$L1", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkEmptyList", new Object[]{new Object[]{"size", "$L0", "$P1"}, new Object[]{"if==than", "$L0", 0, 3}, new Object[]{"string.concat", "$L2", "The list ", "$P2", " cannot be empty"}, new Object[]{"create", "$L1", "Error", "$L2", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkEmpty", new Object[]{new Object[]{"if==than", "$P1", "", 3}, new Object[]{"string.concat", "$L0", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 10}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"json.stringify", "$L0", "$L0.errors"}, new Object[]{"create", "$L3", "Error", "$L0", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public SendGrid(Context context, String apiKey) {
        this.initDataStructures(context);
        this.interpreterStorage.put("apiKey", apiKey);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to SendGrid...");
        new InitSelfTestTask("SendGrid", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public void sendEmail(String fromAddress, String fromName, List<String> toAddresses, String subject, String textBody, String htmlBody, List<String> ccAddresses, List<String> bccAddresses, List<Attachment> attachments) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SendGrid", "sendEmail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendEmail", this.interpreterStorage, fromAddress, fromName, toAddresses, subject, textBody, htmlBody, ccAddresses, bccAddresses, attachments);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SendGrid", "sendEmail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SendGrid", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SendGrid", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

