/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Messaging;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.Message;
import com.cloudrail.si.types.MessageItem;
import com.cloudrail.si.types.MessagingAttachment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SlackBot
implements Messaging,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"set", "$P0.baseURL", "https://slack.com/api/"}, new Object[]{"set", "$P0.boundaryString", "------7V0ub86bNNNKWdgJgsF7r0DxYtOB06XYxWvyMuYg5BucWEINpyFRcqisOXWr"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[0]);
            this.put("processWebhookRequest", new Object[]{new Object[]{"stream.streamToString", "$L1", "$P2"}, new Object[]{"string.indexOf", "$L2", "$L1", "payload"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"string.urlDecode", "$L1", "$L1"}, new Object[]{"string.substring", "$L1", "$L1", 8}, new Object[]{"json.parse", "$L0", "$L1"}, new Object[]{"if==than", "$L0.type", "interactive_message", 2}, new Object[]{"callFunc", "extractInteractiveMessageObject", "$P0", "$L1", "$L0"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "extractMessageObject", "$P0", "$L1", "$L0.event"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"push", "$P1", "$L1"}});
            this.put("sendMessage", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "chat.postMessage"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.botToken"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.channel", "$P2"}, new Object[]{"if!=than", "$P3", null, 1}, new Object[]{"set", "$L3.text", "$P3"}, new Object[]{"if!=than", "$P4", null, 3}, new Object[]{"set", "$L3.replace_original", "false"}, new Object[]{"set", "$L3.delete_original", "false"}, new Object[]{"set", "$L3.attachments", "$P4"}, new Object[]{"json.stringify", "$L4", "$L3"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L4"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "extractMessageObject", "$P0", "$P1", "$L2.message"}});
            this.put("sendImage", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "$P6", "$P7"}});
            this.put("sendVideo", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "$P6", "$P7"}});
            this.put("sendAudio", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "$P6", "$P7"}});
            this.put("sendFile", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "$P6", "$P7"}});
            this.put("sendCarousel", new Object[]{new Object[]{"set", "$L0", 0}, new Object[]{"size", "$L1", "$P3"}, new Object[]{"create", "$L2", "Array"}, new Object[]{"if<than", "$L0", "$L1", 28}, new Object[]{"get", "$L3", "$P3", "$L0"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4.text", "$L3.title"}, new Object[]{"if!=than", "$L3.subTitle", null, 1}, new Object[]{"string.concat", "$L4.text", "$L4.text", " ", "$L3.subTitle"}, new Object[]{"set", "$L4.fallback", "default"}, new Object[]{"set", "$L4.callback_id", "default"}, new Object[]{"set", "$L4.attachment_type", "default"}, new Object[]{"set", "$L4.image_url", "$L3.mediaUrl"}, new Object[]{"create", "$L4.actions", "Array"}, new Object[]{"set", "$L5", 0}, new Object[]{"size", "$L6", "$L3.buttons"}, new Object[]{"if<than", "$L5", "$L6", 12}, new Object[]{"get", "$L7", "$L3.buttons", "$L5"}, new Object[]{"create", "$L8", "Object"}, new Object[]{"set", "$L8.name", "someName"}, new Object[]{"set", "$L8.text", "$L7.text"}, new Object[]{"set", "$L8.type", "button"}, new Object[]{"if!=than", "$L7.url", null, 2}, new Object[]{"set", "$L8.value", "$L7.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L8.value", "$L7.payload"}, new Object[]{"push", "$L4.actions", "$L8"}, new Object[]{"math.add", "$L5", "$L5", 1}, new Object[]{"jumpRel", -13}, new Object[]{"push", "$L2", "$L4"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"jumpRel", -29}, new Object[]{"callFunc", "sendMessage", "$P0", "$P1", "$P2", "", "$L2"}});
            this.put("downloadContent", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "$P2.id"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.botToken"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$P1", "$P2"}, new Object[]{"set", "$P1.stream", "$L1.responseBody"}, new Object[]{"if==than", "$P1.mimeType", null, 1}, new Object[]{"set", "$P1.mimeType", "$L4.responseHeaders.Content-Type"}});
            this.put("extractMessageObject", new Object[]{new Object[]{"create", "$P1", "Message"}, new Object[]{"set", "$P1.senderId", "$P2.user"}, new Object[]{"set", "$P1.chatId", "$P2.channel"}, new Object[]{"set", "$P1.messageText", "$P2.text"}, new Object[]{"set", "$P1.messageId", "$P2.ts"}, new Object[]{"set", "$P1.sendAt", "$P2.ts"}, new Object[]{"if!=than", "$P2.subtype", null, 2}, new Object[]{"if==than", "$P2.subtype", "file_share", 1}, new Object[]{"callFunc", "addAttachment", "$P0", "$P1", "$P2.file"}});
            this.put("extractInteractiveMessageObject", new Object[]{new Object[]{"create", "$P1", "Message"}, new Object[]{"set", "$P1.senderId", "$P2.user.id"}, new Object[]{"set", "$P1.chatId", "$P2.channel.id"}, new Object[]{"set", "$P1.messageId", "$P2.action_ts"}, new Object[]{"set", "$P1.replyTo", "$P2.message_ts"}, new Object[]{"set", "$P1.sendAt", "$P2.action_ts"}, new Object[]{"get", "$L1", "$P2.actions", 0}, new Object[]{"set", "$P1.messageText", "$L1.value"}});
            this.put("addAttachment", new Object[]{new Object[]{"if!=than", "$P2.url_private_download", null, 2}, new Object[]{"set", "$L1", "$P2.url_private_download"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L1", "$P2.url_private"}, new Object[]{"create", "$L0", "MessagingAttachment", "$L1", "file", "$P2.mimetype", null, null}, new Object[]{"create", "$P1.Attachments", "Array"}, new Object[]{"push", "$P1.Attachments", "$L0"}});
            this.put("sendContent", new Object[]{new Object[]{"if==than", "$P4", null, 2}, new Object[]{"callFunc", "uploadContent", "$P0", "$P1", "$P5", "$P2", "$P7"}, new Object[]{"return"}, new Object[]{"callFunc", "sendMessage", "$P0", "$P1", "$P2", "$P4"}});
            this.put("uploadContent", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "files.upload"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L1", "$L1", "--", "$P0.boundaryString", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Disposition: form-data; name=\"channels\"\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "$P3", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "--", "$P0.boundaryString", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Disposition: form-data; name=\"file\"; filename=\"", "$P3", "\"\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Type:image/png", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "\r\n"}, new Object[]{"string.concat", "$L2", "\r\n--", "$P0.boundaryString", "--\r\n"}, new Object[]{"stream.stringToStream", "$L3", "$L1"}, new Object[]{"stream.stringToStream", "$L4", "$L2"}, new Object[]{"stream.makeJoinedStream", "$L0.requestBody", "$L3", "$P2", "$L4"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Type", "multipart/form-data; boundary=", "$P0.boundaryString"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$P0.botToken"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}});
            this.put("checkMandatory", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L1", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L0", "Error", "$L1", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 15}, new Object[]{"debug.out", "$P1.code"}, new Object[]{"stream.streamToString", "$L5", "$P1.responseBody"}, new Object[]{"debug.out", "$L5"}, new Object[]{"set", "$L2", ""}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public SlackBot(Context context, String botToken) {
        this.initDataStructures(context);
        this.interpreterStorage.put("botToken", botToken);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to SlackBot...");
        new InitSelfTestTask("SlackBot", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Message sendMessage(String receiverId, String message) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SlackBot", "sendMessage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendMessage", this.interpreterStorage, null, receiverId, message);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SlackBot", "sendMessage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendImage(String receiverId, String message, String imageId, InputStream imageStream, String previewUrl, String mimeType) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SlackBot", "sendImage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendImage", this.interpreterStorage, null, receiverId, message, imageId, imageStream, previewUrl, mimeType);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SlackBot", "sendImage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendVideo(String receiverId, String message, String videoId, InputStream videoStream, String previewUrl, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SlackBot", "sendVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendVideo", this.interpreterStorage, null, receiverId, message, videoId, videoStream, previewUrl, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SlackBot", "sendVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendAudio(String receiverId, String message, String audioId, InputStream audioStream, String previewUrl, String audioName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SlackBot", "sendAudio").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendAudio", this.interpreterStorage, null, receiverId, message, audioId, audioStream, previewUrl, audioName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SlackBot", "sendAudio").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendFile(String receiverId, String message, String fileId, InputStream fileStream, String previewUrl, String fileName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SlackBot", "sendFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendFile", this.interpreterStorage, null, receiverId, message, fileId, fileStream, previewUrl, fileName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SlackBot", "sendFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendCarousel(String receiverId, List<MessageItem> messageItem) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SlackBot", "sendCarousel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendCarousel", this.interpreterStorage, null, receiverId, messageItem);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SlackBot", "sendCarousel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public List<Message> parseReceivedMessages(InputStream httpRequest) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SlackBot", "parseReceivedMessages").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("processWebhookRequest", this.interpreterStorage, null, httpRequest);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SlackBot", "parseReceivedMessages").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public MessagingAttachment downloadContent(MessagingAttachment attachment) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SlackBot", "downloadContent").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("downloadContent", this.interpreterStorage, null, attachment);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SlackBot", "downloadContent").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (MessagingAttachment)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "SlackBot", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("SlackBot", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

