/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Messaging;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.Message;
import com.cloudrail.si.types.MessageItem;
import com.cloudrail.si.types.MessagingAttachment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Telegram
implements Messaging,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"string.concat", "$P0.baseURL", "https://api.telegram.org/bot", "$P0.botToken"}, new Object[]{"string.concat", "$P0.fileURL", "https://api.telegram.org/file/bot", "$P0.botToken"}, new Object[]{"set", "$P0.boundaryString", "------7V0ub86bNNNKWdgJgsF7r0DxYtOB06XYxWvyMuYg5BucWEINpyFRcqisOXWr"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"callFunc", "setWebhook", "$P0"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "$P0.baseURL"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("setWebhook", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/setWebhook?url=", "$P0.webhook"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("processWebhookRequest", new Object[]{new Object[]{"json.parse", "$L0", "$P2"}, new Object[]{"if!=than", "$L0.message", null, 1}, new Object[]{"callFunc", "extractMessageObject", "$P0", "$L1", "$L0.message", null}, new Object[]{"if!=than", "$L0.edited_message", null, 1}, new Object[]{"callFunc", "extractMessageObject", "$P0", "$L1", "$L0.edited_message", "$L0.edited_message.message_id"}, new Object[]{"if!=than", "$L0.channel_post", null, 1}, new Object[]{"callFunc", "extractMessageObject", "$P0", "$L1", "$L0.channel_post", null}, new Object[]{"if!=than", "$L0.edited_channel_post", null, 1}, new Object[]{"callFunc", "extractMessageObject", "$P0", "$L1", "$L0.edited_channel_post", "$L0.edited_channel_post.message_id"}, new Object[]{"if!=than", "$L0.callback_query", null, 1}, new Object[]{"callFunc", "extractCallbackQuery", "$P0", "$L1", "$L0.callback_query"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"push", "$P1", "$L1"}});
            this.put("sendMessage", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "chatId"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P3", "messageText"}, new Object[]{"callFunc", "setWebhook", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.urlEncode", "$P3", "$P3"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/sendMessage?chat_id=", "$P2", "&text=", "$P3"}, new Object[]{"if!=than", "$P4", null, 1}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&reply_markup=", "$P4"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "extractMessageObject", "$P0", "$P1", "$L2.result", null}});
            this.put("sendImage", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "/sendPhoto", "photo", "somename"}});
            this.put("sendVideo", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "/sendVideo", "video", "somename"}});
            this.put("sendAudio", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "/sendAudio", "audio", "somename"}});
            this.put("sendFile", new Object[]{new Object[]{"callFunc", "sendContent", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "/sendDocument", "document", "$P7"}});
            this.put("sendCarousel", new Object[]{new Object[]{"set", "$L0", 0}, new Object[]{"size", "$L1", "$P3"}, new Object[]{"if<than", "$L0", "$L1", 28}, new Object[]{"get", "$L2", "$P3", "$L0"}, new Object[]{"if!=than", "$L2.subTitle", null, 1}, new Object[]{"string.concat", "$L2.title", "$L2.title", "\n", "$L2.subTitle"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"create", "$L3.inline_keyboard", "Array"}, new Object[]{"set", "$L4", 0}, new Object[]{"size", "$L5", "$L2.buttons"}, new Object[]{"if<than", "$L4", "$L5", 12}, new Object[]{"get", "$L6", "$L2.buttons", "$L4"}, new Object[]{"create", "$L7", "Array"}, new Object[]{"create", "$L8", "Object"}, new Object[]{"set", "$L8.text", "$L6.text"}, new Object[]{"if!=than", "$L6.url", null, 2}, new Object[]{"set", "$L8.url", "$L6.url"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L8.callback_data", "$L6.payload"}, new Object[]{"push", "$L7", "$L8"}, new Object[]{"push", "$L3.inline_keyboard", "$L7"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -13}, new Object[]{"json.stringify", "$L3", "$L3"}, new Object[]{"string.urlEncode", "$L3", "$L3"}, new Object[]{"if==than", "$L2.mediaUrl", null, 2}, new Object[]{"callFunc", "sendMessage", "$P0", "$P1", "$P2", "$L2.title", "$L3"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "sendContentWithID", "$P0", "$P1", "$P2", "$L2.title", "$L2.mediaUrl", "/sendPhoto", "photo", "$L3"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"jumpRel", -29}});
            this.put("downloadContent", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/getFile?file_id=", "$P2.id"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"string.concat", "$L3.url", "$P0.fileURL", "/", "$L2.result.file_path"}, new Object[]{"set", "$L3.method", "GET"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"http.requestCall", "$L4", "$L3"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L4"}, new Object[]{"set", "$P1", "$P2"}, new Object[]{"set", "$P1.stream", "$L4.responseBody"}, new Object[]{"if==than", "$P1.mimeType", null, 1}, new Object[]{"set", "$P1.mimeType", "$L4.responseHeaders.Content-Type"}});
            this.put("sendContent", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "chatId"}, new Object[]{"if==than", "$P4", null, 3}, new Object[]{"if==than", "$P5", null, 2}, new Object[]{"create", "$L4", "Error", "Either a file identifer or a file stream must be provided!", "IllegalArgument"}, new Object[]{"throwError", "$L4"}, new Object[]{"callFunc", "setWebhook", "$P0"}, new Object[]{"if!=than", "$P4", null, 2}, new Object[]{"callFunc", "sendContentWithID", "$P0", "$P1", "$P2", "$P3", "$P4", "$P6", "$P7"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "sendContentWithStream", "$P0", "$P1", "$P2", "$P3", "$P5", "$P6", "$P7", "$P8"}});
            this.put("sendContentWithID", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.urlEncode", "$P4", "$P4"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "$P5", "?chat_id=", "$P2", "&", "$P6", "=", "$P4"}, new Object[]{"if!=than", "$P3", null, 2}, new Object[]{"string.urlEncode", "$P3", "$P3"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&caption=", "$P3"}, new Object[]{"if!=than", "$P7", null, 1}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&reply_markup=", "$P7"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "extractMessageObject", "$P0", "$P1", "$L2.result", null}});
            this.put("sendContentWithStream", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "$P5"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L1", "$L1", "--", "$P0.boundaryString", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Disposition: form-data; name=\"chat_id\"\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "$P2", "\r\n"}, new Object[]{"if!=than", "$P3", null, 4}, new Object[]{"string.concat", "$L1", "$L1", "--", "$P0.boundaryString", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Disposition: form-data; name=\"caption\"\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "$P3", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "--", "$P0.boundaryString", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Disposition: form-data; name=\"", "$P6", "\"; filename=\"", "$P7", "\"\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "Content-Type:image/png", "\r\n"}, new Object[]{"string.concat", "$L1", "$L1", "\r\n"}, new Object[]{"string.concat", "$L5", "\r\n--", "$P0.boundaryString", "--\r\n"}, new Object[]{"stream.stringToStream", "$L6", "$L1"}, new Object[]{"stream.stringToStream", "$L7", "$L5"}, new Object[]{"stream.makeJoinedStream", "$L0.requestBody", "$L6", "$P4", "$L7"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Type", "multipart/form-data; boundary=", "$P0.boundaryString"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}});
            this.put("extractMessageObject", new Object[]{new Object[]{"create", "$L1", "Array"}, new Object[]{"callFunc", "addAttachment", "$P0", "$L1", "$P2", "photo", "image"}, new Object[]{"callFunc", "addAttachment", "$P0", "$L1", "$P2", "audio", "audio"}, new Object[]{"callFunc", "addAttachment", "$P0", "$L1", "$P2", "voice", "audio"}, new Object[]{"callFunc", "addAttachment", "$P0", "$L1", "$P2", "video", "video"}, new Object[]{"callFunc", "addAttachment", "$P0", "$L1", "$P2", "video_note", "video"}, new Object[]{"callFunc", "addAttachment", "$P0", "$L1", "$P2", "file", "file"}, new Object[]{"callFunc", "addAttachment", "$P0", "$L1", "$P2", "document", "file"}, new Object[]{"size", "$L8", "$L1"}, new Object[]{"create", "$P1", "Message"}, new Object[]{"if!=than", "$P2.message_id", null, 2}, new Object[]{"string.concat", "$L11", "$P2.message_id"}, new Object[]{"set", "$P1.MessageId", "$L11"}, new Object[]{"if!=than", "$P2.from.id", null, 2}, new Object[]{"string.concat", "$L12", "$P2.from.id"}, new Object[]{"set", "$P1.SenderId", "$L12"}, new Object[]{"if!=than", "$P2.chat.id", null, 2}, new Object[]{"string.concat", "$L13", "$P2.chat.id"}, new Object[]{"set", "$P1.ChatId", "$L13"}, new Object[]{"if!=than", "$P2.reply_to_message.message_id", null, 2}, new Object[]{"string.concat", "$L14", "$P2.reply_to_message.message_id"}, new Object[]{"set", "$P1.ReplyTo", "$L14"}, new Object[]{"if!=than", "$P3", null, 1}, new Object[]{"set", "$P1.EditOf", "$P3"}, new Object[]{"if!=than", "$P2.text", null, 2}, new Object[]{"string.concat", "$L15", "$P2.text"}, new Object[]{"set", "$P1.MessageText", "$L15"}, new Object[]{"if!=than", "$P2.date", null, 1}, new Object[]{"set", "$P1.SendAt", "$P2.date"}, new Object[]{"if!=than", "$P2.location", null, 4}, new Object[]{"create", "$L0", "Location"}, new Object[]{"set", "$L0.Longitude", "$P2.location.longitude"}, new Object[]{"set", "$L0.Latitude", "$P2.location.latitude"}, new Object[]{"set", "$P1.Location", "$L0"}, new Object[]{"if!=than", "$L8", 0, 1}, new Object[]{"set", "$P1.Attachments", "$L1"}});
            this.put("extractCallbackQuery", new Object[]{new Object[]{"create", "$P1", "Message"}, new Object[]{"if!=than", "$P2.id", null, 2}, new Object[]{"string.concat", "$L11", "$P2.id"}, new Object[]{"set", "$P1.MessageId", "$L11"}, new Object[]{"if!=than", "$P2.message.from.id", null, 2}, new Object[]{"string.concat", "$L12", "$P2.message.from.id"}, new Object[]{"set", "$P1.SenderId", "$L12"}, new Object[]{"if!=than", "$P2.message.chat.id", null, 2}, new Object[]{"string.concat", "$L13", "$P2.message.chat.id"}, new Object[]{"set", "$P1.ChatId", "$L13"}, new Object[]{"if!=than", "$P2.message.message_id", null, 2}, new Object[]{"string.concat", "$L14", "$P2.message.message_id"}, new Object[]{"set", "$P1.ReplyTo", "$L14"}, new Object[]{"if!=than", "$P2.data", null, 2}, new Object[]{"string.concat", "$L15", "$P2.data"}, new Object[]{"set", "$P1.MessageText", "$L15"}, new Object[]{"if!=than", "$P2.date", null, 1}, new Object[]{"set", "$P1.SendAt", "$P2.date"}, new Object[]{"if!=than", "$P2.location", null, 4}, new Object[]{"create", "$L0", "Location"}, new Object[]{"set", "$L0.Longitude", "$P2.location.longitude"}, new Object[]{"set", "$L0.Latitude", "$P2.location.latitude"}, new Object[]{"set", "$P1.Location", "$L0"}});
            this.put("addAttachment", new Object[]{new Object[]{"get", "$L0", "$P2", "$P3"}, new Object[]{"if==than", "$P3", "photo", 3}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"math.add", "$L1", "$L1", -1}, new Object[]{"get", "$L0", "$L0", "$L1"}, new Object[]{"if!=than", "$L0", null, 2}, new Object[]{"create", "$L2", "MessagingAttachment", "$L0.file_id", "$P4", "$L0.mime_type", "$P2.caption", null}, new Object[]{"push", "$P1", "$L2"}});
            this.put("checkMandatory", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L1", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L0", "Error", "$L1", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 15}, new Object[]{"debug.out", "$P1.code"}, new Object[]{"stream.streamToString", "$L5", "$P1.responseBody"}, new Object[]{"debug.out", "$L5"}, new Object[]{"set", "$L2", ""}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Telegram(Context context, String botToken, String webhook) {
        this.initDataStructures(context);
        this.interpreterStorage.put("botToken", botToken);
        this.interpreterStorage.put("webhook", webhook);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Telegram...");
        new InitSelfTestTask("Telegram", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Message sendMessage(String receiverId, String message) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Telegram", "sendMessage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendMessage", this.interpreterStorage, null, receiverId, message);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Telegram", "sendMessage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendImage(String receiverId, String message, String imageId, InputStream imageStream, String previewUrl, String mimeType) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Telegram", "sendImage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendImage", this.interpreterStorage, null, receiverId, message, imageId, imageStream, previewUrl, mimeType);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Telegram", "sendImage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendVideo(String receiverId, String message, String videoId, InputStream videoStream, String previewUrl, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Telegram", "sendVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendVideo", this.interpreterStorage, null, receiverId, message, videoId, videoStream, previewUrl, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Telegram", "sendVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendAudio(String receiverId, String message, String audioId, InputStream audioStream, String previewUrl, String audioName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Telegram", "sendAudio").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendAudio", this.interpreterStorage, null, receiverId, message, audioId, audioStream, previewUrl, audioName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Telegram", "sendAudio").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendFile(String receiverId, String message, String fileId, InputStream fileStream, String previewUrl, String fileName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Telegram", "sendFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendFile", this.interpreterStorage, null, receiverId, message, fileId, fileStream, previewUrl, fileName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Telegram", "sendFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendCarousel(String receiverId, List<MessageItem> messageItem) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Telegram", "sendCarousel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendCarousel", this.interpreterStorage, null, receiverId, messageItem);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Telegram", "sendCarousel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public List<Message> parseReceivedMessages(InputStream httpRequest) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Telegram", "parseReceivedMessages").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("processWebhookRequest", this.interpreterStorage, null, httpRequest);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Telegram", "parseReceivedMessages").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public MessagingAttachment downloadContent(MessagingAttachment attachment) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Telegram", "downloadContent").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("downloadContent", this.interpreterStorage, null, attachment);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Telegram", "downloadContent").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (MessagingAttachment)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Telegram", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Telegram", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

