/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Video;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.ChannelMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.VideoMetaData;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Twitch
implements Video,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("uploadVideo", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "title"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P3", "description"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P4", "video"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P5", "size"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P6", "channel ID"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "title"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P3", "description"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P6", "channel ID"}, new Object[]{"callFunc", "checkGreater0", "$P0", "$P5", "size"}, new Object[]{"string.urlEncode", "$P2", "$P2"}, new Object[]{"string.urlEncode", "$P3", "$P3"}, new Object[]{"string.urlEncode", "$P6", "$P6"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "startNewVideo", "$P0", "$L0", "$P2", "$P3", "$P6"}, new Object[]{"callFunc", "uploadVideoParts", "$P0", "$L0.upload.url", "$L0.upload.token", "$P5", "$P4"}, new Object[]{"callFunc", "completeNewVideo", "$P0", "$L0.upload.url", "$L0.upload.token"}, new Object[]{"set", "$L1", "$L0.video"}, new Object[]{"create", "$L2", "Date", "$L1.created_at"}, new Object[]{"set", "$L5", "$L2.time"}, new Object[]{"string.concat", "$L3", "$L1._id"}, new Object[]{"string.concat", "$L4", "$L1.channel._id"}, new Object[]{"create", "$P1", "VideoMetaData", "$L3", "$L1.title", "$L1.description", "$L5", "$L4", "$L1.length", "$L1.preview.large", null, "$L1.views", null, null}});
            this.put("searchVideos", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "query"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "query"}, new Object[]{"if==than", "$P3", null, 1}, new Object[]{"set", "$P3", 0}, new Object[]{"if<than", "$P3", 0, 1}, new Object[]{"set", "$P3", 0}, new Object[]{"if==than", "$P4", null, 1}, new Object[]{"set", "$P4", 50}, new Object[]{"if<=than", "$P4", 0, 1}, new Object[]{"set", "$P4", 50}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://api.twitch.tv/kraken/search/streams?query=", "$P2", "&limit=", "$P4", "&offset=", "$P3"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Client-ID", "$P0.clientId"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/vnd.twitchtv.v5+json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"stream.streamToString", "$L3", "$L1.responseBody"}, new Object[]{"json.parse", "$L4", "$L3"}, new Object[]{"create", "$L2", "Array"}, new Object[]{"set", "$L2", "$L4.streams"}, new Object[]{"size", "$L3", "$L2"}, new Object[]{"if==than", "$L3", 0, 1}, new Object[]{"return"}, new Object[]{"create", "$L4", "Number", 0}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if<than", "$L4", "$L3", 9}, new Object[]{"get", "$L7", "$L2", "$L4"}, new Object[]{"create", "$L8", "Date", "$L7.created_at"}, new Object[]{"set", "$L11", "$L8.time"}, new Object[]{"string.concat", "$L9", "$L7._id"}, new Object[]{"string.concat", "$L10", "$L7.channel._id"}, new Object[]{"create", "$L6", "VideoMetaData", "$L9", null, null, "$L11", "$L10", null, "$L7.preview.large", null, "$L7.viewers", null, null}, new Object[]{"push", "$P1", "$L6"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -10}});
            this.put("getVideo", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "video ID"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "video ID"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://api.twitch.tv/kraken/videos/", "$P2"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Client-ID", "$P0.clientId"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/vnd.twitchtv.v5+json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"stream.streamToString", "$L2", "$L1.responseBody"}, new Object[]{"json.parse", "$L3", "$L2"}, new Object[]{"create", "$L4", "Date", "$L3.created_at"}, new Object[]{"set", "$L7", "$L4.time"}, new Object[]{"string.concat", "$L5", "$L3._id"}, new Object[]{"string.concat", "$L6", "$L3.channel._id"}, new Object[]{"create", "$P1", "VideoMetaData", "$L5", "$L3.title", "$L3.description", "$L7", "$L6", "$L3.length", "$L3.preview.large", null, "$L3.views", null, null}});
            this.put("getChannel", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "channel ID"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "channel ID"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://api.twitch.tv/kraken/channels/", "$P2"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Client-ID", "$P0.clientId"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/vnd.twitchtv.v5+json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"stream.streamToString", "$L3", "$L1.responseBody"}, new Object[]{"json.parse", "$L2", "$L3"}, new Object[]{"create", "$P1", "ChannelMetaData", "$L2._id", "$L2.display_name", "$L2.followers", "$L2.url", "$L2.logo", "$L2.profile_banner"}});
            this.put("getOwnChannel", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L0.url", "https://api.twitch.tv/kraken/channel"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Client-ID", "$P0.clientId"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "OAuth ", "$S0.accessToken"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/vnd.twitchtv.v5+json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"stream.streamToString", "$L2", "$L1.responseBody"}, new Object[]{"json.parse", "$L3", "$L2"}, new Object[]{"create", "$P1", "ChannelMetaData", "$L3._id", "$L3.display_name", "$L3.followers", "$L3.url", "$L3.logo", "$L3.profile_banner"}});
            this.put("listVideosForChannel", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "channel ID"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "channel ID"}, new Object[]{"if==than", "$P3", null, 1}, new Object[]{"set", "$P3", 0}, new Object[]{"if<than", "$P3", 0, 1}, new Object[]{"set", "$P3", 0}, new Object[]{"if==than", "$P4", null, 1}, new Object[]{"set", "$P4", 50}, new Object[]{"if<=than", "$P4", 0, 1}, new Object[]{"set", "$P4", 50}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://api.twitch.tv/kraken/channels/", "$P2", "/videos?limit=", "$P4", "&offset=", "$P3"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Client-ID", "$P0.clientId"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/vnd.twitchtv.v5+json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"stream.streamToString", "$L8", "$L1.responseBody"}, new Object[]{"json.parse", "$L9", "$L8"}, new Object[]{"set", "$L2", "$L9.videos"}, new Object[]{"size", "$L3", "$L2"}, new Object[]{"if==than", "$L3", 0, 1}, new Object[]{"return"}, new Object[]{"create", "$L4", "Number", 0}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if<than", "$L4", "$L3", 9}, new Object[]{"get", "$L7", "$L2", "$L4"}, new Object[]{"create", "$L8", "Date", "$L7.created_at"}, new Object[]{"set", "$L11", "$L8.time"}, new Object[]{"string.concat", "$L9", "$L7._id"}, new Object[]{"string.concat", "$L10", "$L7.channel._id"}, new Object[]{"create", "$L6", "VideoMetaData", "$L9", "$L7.title", "$L7.description", "$L11", "$L9", "$L7.length", "$L7.preview.large", null, "$L7.views", null, null}, new Object[]{"push", "$P1", "$L6"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -10}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"if!=than", "$S0.accessToken", null, 7}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://api.twitch.tv/kraken/oauth2/revoke?client_id=", "$P0.clientId", "&token=", "$S0.accessToken"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$S0.accessToken", null}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "https://api.twitch.tv/kraken"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("startNewVideo", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://api.twitch.tv/kraken/videos?channel_id=", "$P4", "&title=", "$P2"}, new Object[]{"if!=than", "$P3", null, 2}, new Object[]{"if!=than", "$P3", "", 1}, new Object[]{"string.concat", "$L0.url", "$L0.url", "&description=", "$P3"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Client-ID", "$P0.clientId"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/vnd.twitchtv.v5+json"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "OAuth ", "$S0.accessToken"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$L3", "String"}, new Object[]{"stream.streamToString", "$L3", "$L1.responseBody"}, new Object[]{"json.parse", "$P1", "$L3"}});
            this.put("uploadVideoParts", new Object[]{new Object[]{"set", "$L0", 1}, new Object[]{"if>than", "$P3", 0, 12}, new Object[]{"if>than", "$P3", 25000000, 4}, new Object[]{"stream.makeLimitedStream", "$L1", "$P4", 25000000}, new Object[]{"math.add", "$P3", "$P3", -25000000}, new Object[]{"set", "$L2", 25000000}, new Object[]{"jumpRel", 3}, new Object[]{"set", "$L1", "$P4"}, new Object[]{"set", "$L2", "$P3"}, new Object[]{"set", "$P3", 0}, new Object[]{"callFunc", "uploadChunk", "$P0", "$P1", "$P2", "$L0", "$L1", "$L2"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"jumpRel", -13}});
            this.put("uploadChunk", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "PUT"}, new Object[]{"string.concat", "$L0.url", "$P1", "?part=", "$P3", "&upload_token=", "$P2"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Length", "$P5"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/vnd.twitchtv.v5+json"}, new Object[]{"set", "$L0.requestBody", "$P4"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("completeNewVideo", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P1", "/complete?upload_token=", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("checkMandatory", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L1", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L0", "Error", "$L1", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkEmptyList", new Object[]{new Object[]{"size", "$L0", "$P1"}, new Object[]{"if==than", "$L0", 0, 3}, new Object[]{"string.concat", "$L2", "The list ", "$P2", " cannot be empty"}, new Object[]{"create", "$L1", "Error", "$L2", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkEmpty", new Object[]{new Object[]{"if==than", "$P1", "", 3}, new Object[]{"string.concat", "$L0", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkEquals", new Object[]{new Object[]{"if!=than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " does not match ", "$P4"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkGreater0", new Object[]{new Object[]{"if<=than", "$P1", 0, 3}, new Object[]{"string.concat", "$L0", "$P2", " has to be greater than 0"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.accessToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0", "accessToken"}, new Object[]{"return"}, new Object[]{"callFunc", "authenticate", "$P0", "refreshToken"}, new Object[]{"return"}});
            this.put("authenticate", new Object[]{new Object[]{"if==than", "$P1", "refreshToken", 9}, new Object[]{"create", "$L8", "Object"}, new Object[]{"string.concat", "$L8.url", "https://api.twitch.tv/kraken/oauth2/token", "?grant_type=refresh_token", "&refresh_token=", "$S0.refreshToken", "&client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret"}, new Object[]{"set", "$L8.method", "POST"}, new Object[]{"http.requestCall", "$L9", "$L8"}, new Object[]{"stream.streamToString", "$L10", "$L9.responseBody"}, new Object[]{"json.parse", "$L11", "$L10"}, new Object[]{"set", "$S0.accessToken", "$L11.access_token"}, new Object[]{"set", "$S0.refreshToken", "$L11.refresh_token"}, new Object[]{"return"}, new Object[]{"create", "$L0", "String"}, new Object[]{"string.concat", "$L0", "https://api.twitch.tv/kraken/oauth2/authorize?client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&response_type=code&scope=channel_read+channel_editor&state=", "$P0.state", "&force_verify=true"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0", null, "$P0.redirectUri"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"string.concat", "$L2.url", "https://api.twitch.tv/kraken/oauth2/token", "?client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret", "&code=", "$L1", "&grant_type=authorization_code", "&redirect_uri=", "$P0.redirectUri"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"create", "$L6", "String"}, new Object[]{"stream.streamToString", "$L6", "$L5.responseBody"}, new Object[]{"json.parse", "$L7", "$L6"}, new Object[]{"set", "$S0.accessToken", "$L7.access_token"}, new Object[]{"set", "$S0.refreshToken", "$L7.refresh_token"}, new Object[]{"set", "$S0.expireIn", "$L7.expires_in"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 14}, new Object[]{"stream.streamToString", "$L4", "$P1.responseBody"}, new Object[]{"set", "$L2", ""}, new Object[]{"debug.out", "$L4"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "HTTP"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Twitch(Context context, String clientId, String clientSecret, String redirectUri, String state) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.initService();
    }

    public Twitch(Context context, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.interpreterStorage.put("state", "CloudRailSI");
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Twitch...");
        new InitSelfTestTask("Twitch", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public VideoMetaData uploadVideo(String title, String description, InputStream stream, long size, String channelId, String mimeType) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitch", "uploadVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("uploadVideo", this.interpreterStorage, null, title, description, stream, size, channelId, mimeType);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitch", "uploadVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (VideoMetaData)ip.getParameter(1);
    }

    @Override
    public List<VideoMetaData> searchVideos(String query, long offset, long limit) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitch", "searchVideos").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("searchVideos", this.interpreterStorage, null, query, offset, limit);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitch", "searchVideos").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public VideoMetaData getVideo(String videoId) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitch", "getVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getVideo", this.interpreterStorage, null, videoId);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitch", "getVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (VideoMetaData)ip.getParameter(1);
    }

    @Override
    public ChannelMetaData getChannel(String channelId) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitch", "getChannel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getChannel", this.interpreterStorage, null, channelId);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitch", "getChannel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (ChannelMetaData)ip.getParameter(1);
    }

    @Override
    public ChannelMetaData getOwnChannel() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitch", "getOwnChannel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getOwnChannel", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitch", "getOwnChannel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (ChannelMetaData)ip.getParameter(1);
    }

    @Override
    public List<VideoMetaData> listVideosForChannel(String channelId, long offset, long limit) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitch", "listVideosForChannel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listVideosForChannel", this.interpreterStorage, null, channelId, offset, limit);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitch", "listVideosForChannel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitch", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitch", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitch", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitch", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitch", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitch", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

