/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Profile;
import com.cloudrail.si.interfaces.Social;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.DateOfBirth;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Twitter
implements Profile,
Social,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"delete", "$S0.oauthToken"}, new Object[]{"delete", "$S0.oauthTokenSecret"}, new Object[]{"set", "$P0.userInfo", null}});
            this.put("Social:postUpdate", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "The status is not allowed to be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"size", "$L0", "$P1"}, new Object[]{"if>than", "$L0", 140, 2}, new Object[]{"create", "$L0", "Error", "The status is not allowed to contain more than 140 characters.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "post", "$P0", "$P1"}});
            this.put("Social:postImage", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "The message is not allowed to be null", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P2", null, 2}, new Object[]{"create", "$L0", "Error", "The image is not allowed to be null", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "https://upload.twitter.com/1.1/media/upload.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1"}, new Object[]{"create", "$L2", "String", "AaB03xh3u2hfiugiuhuo34gwhoughugheruighui34giuwrgh"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Type", "multipart/form-data; boundary=", "$L2"}, new Object[]{"string.concat", "$L3", "--", "$L2", "\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "Content-Disposition: form-data; name=\"media\"\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "Content-Type: application/octet-stream\r\n\r\n"}, new Object[]{"stream.stringToStream", "$L3", "$L3"}, new Object[]{"string.concat", "$L4", "\r\n--", "$L2", "--"}, new Object[]{"stream.stringToStream", "$L4", "$L4"}, new Object[]{"stream.makeJoinedStream", "$L0.requestBody", "$L3", "$P2", "$L4"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"json.parse", "$L6", "$L5.responseBody"}, new Object[]{"set", "$L7", "$L6.media_id_string"}, new Object[]{"callFunc", "post", "$P0", "$P1", "$L7"}});
            this.put("Social:postVideo", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "The message is not allowed to be null", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P2", null, 2}, new Object[]{"create", "$L0", "Error", "The image is not allowed to be null", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "initUpload", "$P0", "$L0", "$P3", "$P4"}, new Object[]{"callFunc", "performUpload", "$P0", "$L0", "$P2", "$P3"}, new Object[]{"callFunc", "finishUpload", "$P0", "$L0"}, new Object[]{"callFunc", "post", "$P0", "$P1", "$L0"}});
            this.put("Social:getConnections", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L0.url", "https://api.twitter.com/1.1/friends/ids.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "count"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"push", "$L1", "stringify_ids"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.count", "5000"}, new Object[]{"set", "$L3.stringify_ids", "true"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1", "$L3"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "?count=5000&stringify_ids=true"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$L3", "$L2.ids"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"create", "$L4", "Number", 0}, new Object[]{"size", "$L5", "$L3"}, new Object[]{"if<than", "$L4", "$L5", 5}, new Object[]{"get", "$L6", "$L3", "$L4"}, new Object[]{"string.concat", "$L6", "twitter-", "$L6"}, new Object[]{"push", "$P1", "$L6"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -6}});
            this.put("Profile:getIdentifier", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"string.concat", "$P1", "twitter-", "$P0.userInfo.id"}});
            this.put("Profile:getFullName", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.name"}});
            this.put("Profile:getEmail", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.email"}});
            this.put("Profile:getGender", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.gender"}});
            this.put("Profile:getDescription", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.description"}});
            this.put("Profile:getDateOfBirth", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.dateOfBirth"}});
            this.put("Profile:getLocale", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.locale"}});
            this.put("Profile:getPictureURL", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.pictureURL"}});
            this.put("User:getInfo", new Object[]{new Object[]{"if!=than", "$P0.userInfo", null, 4}, new Object[]{"create", "$L0", "Date"}, new Object[]{"math.add", "$L0", "$L0.Time", -10000}, new Object[]{"if>than", "$P0.userInfo.lastUpdate", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "User:sendInfoRequest", "$P0"}});
            this.put("User:sendInfoRequest", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L0.url", "https://api.twitter.com/1.1/account/verify_credentials.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P0.userInfo", "Object"}, new Object[]{"create", "$L3", "Date"}, new Object[]{"set", "$P0.userInfo.lastUpdate", "$L3.Time"}, new Object[]{"set", "$P0.userInfo.id", "$L2.id_str"}, new Object[]{"set", "$P0.userInfo.name", "$L2.name"}, new Object[]{"set", "$P0.userInfo.email", null}, new Object[]{"set", "$P0.userInfo.gender", null}, new Object[]{"set", "$P0.userInfo.description", "$L2.description"}, new Object[]{"create", "$P0.userInfo.dateOfBirth", "DateOfBirth"}, new Object[]{"set", "$P0.userInfo.locale", "$L2.lang"}, new Object[]{"set", "$P0.userInfo.pictureURL", "$L2.profile_image_url"}});
            this.put("initUpload", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://upload.twitter.com/1.1/media/upload.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "command"}, new Object[]{"push", "$L1", "media_type"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"push", "$L1", "total_bytes"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.command", "INIT"}, new Object[]{"set", "$L2.media_type", "$P3"}, new Object[]{"string.concat", "$L2.total_bytes", "$P2", ""}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1", "$L2"}, new Object[]{"string.urlEncode", "$L3", "$P3"}, new Object[]{"string.concat", "$L3", "command=INIT&media_type=", "$L3", "&total_bytes=", "$P2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L3"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"set", "$P1", "$L5.media_id_string"}});
            this.put("performUpload", new Object[]{new Object[]{"create", "$L20", "Number", 0x200000}, new Object[]{"create", "$L21", "Number", 0}, new Object[]{"create", "$L22", "Number", 1}, new Object[]{"if<than", "$L22", "$P3", 35}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://upload.twitter.com/1.1/media/upload.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1"}, new Object[]{"create", "$L2", "String", "AaB03xh3u2hfiugiuhuo34gwhoughugheruighui34giuwrgh"}, new Object[]{"string.concat", "$L3", "--", "$L2", "\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "Content-Disposition: form-data; name=\"command\"\r\n\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "APPEND\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "--", "$L2", "\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "Content-Disposition: form-data; name=\"media_id\"\r\n\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "$P1", "\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "--", "$L2", "\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "Content-Disposition: form-data; name=\"segment_index\"\r\n\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "$L21", "\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "--", "$L2", "\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "Content-Disposition: form-data; name=\"media\"\r\n"}, new Object[]{"string.concat", "$L3", "$L3", "Content-Type: application/octet-stream\r\n\r\n"}, new Object[]{"stream.stringToStream", "$L3", "$L3"}, new Object[]{"stream.makeLimitedStream", "$L23", "$P2", "$L20"}, new Object[]{"string.concat", "$L4", "\r\n--", "$L2", "--"}, new Object[]{"stream.stringToStream", "$L4", "$L4"}, new Object[]{"stream.makeJoinedStream", "$L0.requestBody", "$L3", "$L23", "$L4"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Type", "multipart/form-data; boundary=", "$L2"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"math.add", "$L22", "$L22", "$L20"}, new Object[]{"math.add", "$L21", "$L21", 1}, new Object[]{"jumpRel", -36}});
            this.put("finishUpload", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://upload.twitter.com/1.1/media/upload.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "command"}, new Object[]{"push", "$L1", "media_id"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.command", "FINALIZE"}, new Object[]{"set", "$L2.media_id", "$P1"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1", "$L2"}, new Object[]{"string.concat", "$L3", "command=FINALIZE&media_id=", "$P1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L3"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L4"}});
            this.put("post", new Object[]{new Object[]{"string.urlEncode", "$L3", "$P1"}, new Object[]{"callFunc", "urlEncode", "$P0", "$L5", "$L3"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://api.twitter.com/1.1/statuses/update.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"if!=than", "$P2", null, 1}, new Object[]{"push", "$L1", "media_ids"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"push", "$L1", "status"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4.status", "$P1"}, new Object[]{"if!=than", "$P2", null, 1}, new Object[]{"set", "$L4.media_ids", "$P2"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1", "$L4"}, new Object[]{"string.concat", "$L21", "status=", "$L5"}, new Object[]{"if!=than", "$P2", null, 1}, new Object[]{"string.concat", "$L21", "$L21", "&media_ids=", "$P2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L21"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "https://api.twitter.com/1.1"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"if==than", "$P2.headers.Content-Type", "application/x-www-form-urlencoded", 3}, new Object[]{"stream.streamToString", "$L10", "$P2.body"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L10"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 21}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.split", "$L2", "$P2.url", "\\?", 2}, new Object[]{"size", "$L3", "$L2"}, new Object[]{"create", "$L4", "String"}, new Object[]{"if==than", "$L3", 2, 1}, new Object[]{"get", "$L4", "$L2", 1}, new Object[]{"if==than", "$P2.headers.Content-Type", "application/x-www-form-urlencoded", 4}, new Object[]{"size", "$L6", "$L4"}, new Object[]{"if>than", "$L6", 0, 1}, new Object[]{"string.concat", "$L4", "$L4", "&"}, new Object[]{"string.concat", "$L4", "$L4", "$L10"}, new Object[]{"callFunc", "extractParameters", "$P0", "$L6", "$L4"}, new Object[]{"object.getKeyArray", "$L5", "$L6"}, new Object[]{"push", "$L5", "oauth_consumer_key"}, new Object[]{"push", "$L5", "oauth_nonce"}, new Object[]{"push", "$L5", "oauth_signature_method"}, new Object[]{"push", "$L5", "oauth_timestamp"}, new Object[]{"push", "$L5", "oauth_token"}, new Object[]{"push", "$L5", "oauth_version"}, new Object[]{"array.sort", "$L5", "$L5"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L5", "$L6"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("extractParameters", new Object[]{new Object[]{"create", "$P1", "Object"}, new Object[]{"size", "$L0", "$P2"}, new Object[]{"if==than", "$L0", 0, 1}, new Object[]{"return"}, new Object[]{"string.split", "$L1", "$P2", "&"}, new Object[]{"size", "$L2", "$L1"}, new Object[]{"set", "$L3", 0}, new Object[]{"if<than", "$L3", "$L2", 7}, new Object[]{"get", "$L4", "$L1", "$L3"}, new Object[]{"string.split", "$L5", "$L4", "=", 2}, new Object[]{"get", "$L6", "$L5", 0}, new Object[]{"get", "$L7", "$L5", 1}, new Object[]{"set", "$P1", "$L7", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -8}});
            this.put("oAuth1:signRequest", new Object[]{new Object[]{"if==than", "$P1.requestHeaders", null, 1}, new Object[]{"create", "$P1.requestHeaders", "Object"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.oauth_consumer_key", "$P0.clientId"}, new Object[]{"callFunc", "oAuth1:generateNonce", "$L0.oauth_nonce"}, new Object[]{"set", "$L0.oauth_signature_method", "HMAC-SHA1"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"math.multiply", "$L1", "$L1.Time", 0.001}, new Object[]{"math.floor", "$L1", "$L1"}, new Object[]{"string.format", "$L0.oauth_timestamp", "%d", "$L1"}, new Object[]{"set", "$L0.oauth_token", "$S0.oauthToken"}, new Object[]{"set", "$L0.oauth_version", "1.0"}, new Object[]{"string.split", "$L2", "$P1.url", "\\?", 2}, new Object[]{"get", "$L2", "$L2", 0}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"string.concat", "$L1", "$P1.method", "&", "$L2", "&"}, new Object[]{"set", "$L2", ""}, new Object[]{"set", "$L3", 0}, new Object[]{"size", "$L4", "$P2"}, new Object[]{"if<than", "$L3", "$L4", 15}, new Object[]{"get", "$L5", "$P2", "$L3"}, new Object[]{"if==than", "$L5", "oauth_callback", 1}, new Object[]{"set", "$L0.oauth_callback", "$P0.redirectUri"}, new Object[]{"get", "$L6", "$L0", "$L5"}, new Object[]{"if>than", "$L3", 0, 1}, new Object[]{"string.concat", "$L2", "$L2", "&"}, new Object[]{"if==than", "$L6", null, 1}, new Object[]{"get", "$L6", "$P3", "$L5"}, new Object[]{"string.urlEncode", "$L6", "$L6"}, new Object[]{"if==than", "$L5", "status", 2}, new Object[]{"callFunc", "urlEncode", "$P0", "$L20", "$L6"}, new Object[]{"set", "$L6", "$L20"}, new Object[]{"string.concat", "$L2", "$L2", "$L5", "=", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -16}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "$L2"}, new Object[]{"set", "$L2", "$S0.oauthTokenSecret"}, new Object[]{"if==than", "$L2", null, 1}, new Object[]{"set", "$L2", ""}, new Object[]{"string.concat", "$L2", "$P0.clientSecret", "&", "$L2"}, new Object[]{"crypt.hmac.sha1", "$L2", "$L2", "$L1"}, new Object[]{"array.uint8ToBase64", "$L2", "$L2"}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"set", "$L0.oauth_signature", "$L2"}, new Object[]{"set", "$L2", "OAuth "}, new Object[]{"if!=than", "$L0.oauth_callback", null, 2}, new Object[]{"string.urlEncode", "$L3", "$L0.oauth_callback"}, new Object[]{"string.concat", "$L2", "$L2", "oauth_callback", "=\"", "$L3", "\"", ", "}, new Object[]{"string.concat", "$L2", "$L2", "oauth_consumer_key", "=\"", "$L0.oauth_consumer_key", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_nonce", "=\"", "$L0.oauth_nonce", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_signature", "=\"", "$L0.oauth_signature", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_signature_method", "=\"", "$L0.oauth_signature_method", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_timestamp", "=\"", "$L0.oauth_timestamp", "\""}, new Object[]{"if!=than", "$L0.oauth_token", null, 1}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_token", "=\"", "$L0.oauth_token", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_version", "=\"", "$L0.oauth_version", "\""}, new Object[]{"set", "$P1.requestHeaders.Authorization", "$L2"}});
            this.put("oAuth1:generateNonce", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"string.format", "$L0", "%d", "$L0.Time"}, new Object[]{"hash.md5", "$L0", "$L0"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"set", "$L2", 0}, new Object[]{"set", "$P0", ""}, new Object[]{"get", "$L3", "$L0", "$L2"}, new Object[]{"string.format", "$L4", "%02x", "$L3"}, new Object[]{"string.concat", "$P0", "$P0", "$L4"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"if>=than", "$L2", "$L1", -5}});
            this.put("urlEncode", new Object[]{new Object[]{"string.split", "$L0", "$P2", "\\+"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"create", "$L2", "Number"}, new Object[]{"set", "$L2", 0}, new Object[]{"create", "$L4", "String"}, new Object[]{"if<than", "$L2", "$L1", 7}, new Object[]{"get", "$L5", "$L0", "$L2"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"set", "$L4", "$L5"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L4", "$L4", "%20", "$L5"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -8}, new Object[]{"set", "$P1", "$L4"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if!=than", "$S0.oauthToken", null, 2}, new Object[]{"if!=than", "$S0.oauthTokenSecret", null, 1}, new Object[]{"return"}, new Object[]{"callFunc", "authenticate", "$P0"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "https://api.twitter.com/oauth/request_token"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "oauth_callback"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$L1.code", 200, 3}, new Object[]{"stream.streamToString", "$L2", "$L1.responseBody"}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"stream.streamToString", "$L2", "$L1.responseBody"}, new Object[]{"string.split", "$L2", "$L2", "&"}, new Object[]{"set", "$L3", 0}, new Object[]{"size", "$L4", "$L2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"if<than", "$L3", "$L4", 8}, new Object[]{"get", "$L5", "$L2", "$L3"}, new Object[]{"string.split", "$L6", "$L5", "=", 2}, new Object[]{"get", "$L7", "$L6", 0}, new Object[]{"get", "$L8", "$L6", 1}, new Object[]{"string.urlDecode", "$L8", "$L8"}, new Object[]{"set", "$L0", "$L8", "$L7"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -9}, new Object[]{"string.concat", "$L3", "https://api.twitter.com/oauth/authenticate?oauth_token=", "$L0.oauth_token"}, new Object[]{"create", "$L4", "Array"}, new Object[]{"push", "$L4", "oauth_token"}, new Object[]{"push", "$L4", "oauth_verifier"}, new Object[]{"awaitCodeRedirect", "$L3", "$L3", "$L4", "$P0.redirectUri"}, new Object[]{"set", "$S0.oauthToken", "$L3.oauth_token"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4.method", "POST"}, new Object[]{"set", "$L4.url", "https://api.twitter.com/oauth/access_token"}, new Object[]{"create", "$L4.requestHeaders", "Object"}, new Object[]{"set", "$L4.requestHeaders.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"string.urlEncode", "$L5", "$L3.oauth_verifier"}, new Object[]{"string.concat", "$L5", "oauth_verifier=", "$L5"}, new Object[]{"stream.stringToStream", "$L4.requestBody", "$L5"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"set", "$L6.oauth_verifier", "$L3.oauth_verifier"}, new Object[]{"create", "$L7", "Array"}, new Object[]{"push", "$L7", "oauth_callback"}, new Object[]{"push", "$L7", "oauth_consumer_key"}, new Object[]{"push", "$L7", "oauth_nonce"}, new Object[]{"push", "$L7", "oauth_signature_method"}, new Object[]{"push", "$L7", "oauth_timestamp"}, new Object[]{"push", "$L7", "oauth_verifier"}, new Object[]{"push", "$L7", "oauth_version"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L4", "$L7", "$L6"}, new Object[]{"http.requestCall", "$L9", "$L4"}, new Object[]{"if!=than", "$L9.code", 200, 3}, new Object[]{"stream.streamToString", "$L10", "$L9.responseBody"}, new Object[]{"create", "$L11", "Error", "$L10", "Authentication"}, new Object[]{"throwError", "$L11"}, new Object[]{"stream.streamToString", "$L10", "$L9.responseBody"}, new Object[]{"string.split", "$L10", "$L10", "&"}, new Object[]{"set", "$L11", 0}, new Object[]{"size", "$L12", "$L10"}, new Object[]{"create", "$L13", "Object"}, new Object[]{"if<than", "$L11", "$L12", 8}, new Object[]{"get", "$L14", "$L10", "$L11"}, new Object[]{"string.split", "$L15", "$L14", "=", 2}, new Object[]{"get", "$L16", "$L15", 0}, new Object[]{"get", "$L17", "$L15", 1}, new Object[]{"string.urlDecode", "$L17", "$L17"}, new Object[]{"set", "$L13", "$L17", "$L16"}, new Object[]{"math.add", "$L11", "$L11", 1}, new Object[]{"jumpRel", -9}, new Object[]{"string.urlDecode", "$S0.oauthToken", "$L13.oauth_token"}, new Object[]{"string.urlDecode", "$S0.oauthTokenSecret", "$L13.oauth_token_secret"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 3}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Twitter(Context context, String clientId, String clientSecret, String redirectUri) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.initService();
    }

    public Twitter(Context context, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Twitter...");
        new InitSelfTestTask("Twitter", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public String getIdentifier() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "getIdentifier").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getIdentifier", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "getIdentifier").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getFullName() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "getFullName").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getFullName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "getFullName").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getEmail() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "getEmail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getEmail", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "getEmail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getGender() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "getGender").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getGender", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "getGender").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getDescription() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "getDescription").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDescription", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "getDescription").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public DateOfBirth getDateOfBirth() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "getDateOfBirth").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDateOfBirth", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "getDateOfBirth").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (DateOfBirth)ip.getParameter(1);
    }

    @Override
    public String getLocale() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "getLocale").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getLocale", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "getLocale").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getPictureURL() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "getPictureURL").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getPictureURL", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "getPictureURL").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void postUpdate(String content) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "postUpdate").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Social:postUpdate", this.interpreterStorage, content);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "postUpdate").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void postImage(String message, InputStream image) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "postImage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Social:postImage", this.interpreterStorage, message, image);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "postImage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void postVideo(String message, InputStream video, long size, String mimeType) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "postVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Social:postVideo", this.interpreterStorage, message, video, size, mimeType);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "postVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public List<String> getConnections() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "getConnections").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Social:getConnections", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "getConnections").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twitter", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twitter", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

