/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.SMS;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Twizo
implements SMS {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"set", "$P0.baseUrl", "https://api-asia-01.twizo.com"}});
            this.put("sendSMS", new Object[]{new Object[]{"callFunc", "validateUserInput", "$P0", "$P1", "$P2", "$P3"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.baseUrl", "/sms/submitsimple"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L1.Accept", "application/json"}, new Object[]{"set", "$L1.Content-Type", "application/json; charset=utf8"}, new Object[]{"string.concat", "$L2", "twizo:", "$P0.key"}, new Object[]{"string.base64encode", "$L3", "$L2"}, new Object[]{"string.concat", "$L1.Authorization", "Basic ", "$L3"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.tag", "cloudrail"}, new Object[]{"set", "$L2.body", "$P3"}, new Object[]{"set", "$L2.sender", "$P1"}, new Object[]{"create", "$L3", "Array"}, new Object[]{"push", "$L3", "$P2"}, new Object[]{"set", "$L2.recipients", "$L3"}, new Object[]{"json.stringify", "$L4", "$L2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L4"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("validateUserInput", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "The sender name is not allowed to be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P2", null, 2}, new Object[]{"create", "$L0", "Error", "The recipient is not allowed to be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P3", null, 2}, new Object[]{"create", "$L0", "Error", "The content is not allowed to be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1", "", 2}, new Object[]{"create", "$L0", "Error", "The sender name is not allowed to be empty.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P2", "", 2}, new Object[]{"create", "$L0", "Error", "The recipient is not allowed to be empty.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P3", "", 2}, new Object[]{"create", "$L0", "Error", "The content is not allowed to be empty.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 4}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"json.stringify", "$L0", "$L0"}, new Object[]{"create", "$L2", "Error", "$L0", "Http"}, new Object[]{"throwError", "$L2"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Twizo(Context context, String key) {
        this.initDataStructures(context);
        this.interpreterStorage.put("key", key);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Twizo...");
        new InitSelfTestTask("Twizo", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public void sendSMS(String fromName, String toNumber, String content) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Twizo", "sendSMS").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendSMS", this.interpreterStorage, fromName, toNumber, content);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twizo", "sendSMS").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

