/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Messaging;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.Message;
import com.cloudrail.si.types.MessageItem;
import com.cloudrail.si.types.MessagingAttachment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Viber
implements Messaging,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"string.concat", "$P0.baseURL", "https://chatapi.viber.com/pa"}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "$P0.baseURL"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if==than", "$L0.requestHeaders", null, 1}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 1}, new Object[]{"string.concat", "$L0.requestHeaders.X-Viber-Auth-Token", "$P0.botToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("setWebhook", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/set_webhook"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L3", "Array"}, new Object[]{"push", "$L3", "delivered"}, new Object[]{"push", "$L3", "seen"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4.url", "$P0.webhook"}, new Object[]{"set", "$L4.event_types", "$L3"}, new Object[]{"json.stringify", "$L4", "$L4"}, new Object[]{"size", "$L20", "$L4"}, new Object[]{"string.concat", "$L21", "$L20"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2", "$P0.botToken", "X-Viber-Auth-Token"}, new Object[]{"set", "$L2", "application/json", "Content-Type"}, new Object[]{"set", "$L2", "$L21", "Content-Length"}, new Object[]{"set", "$L0.requestHeaders", "$L2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L4"}, new Object[]{"http.requestCall", "$L0", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L0"}});
            this.put("processWebhookRequest", new Object[]{new Object[]{"json.parse", "$L0", "$P2"}, new Object[]{"if!=than", "$L0.event", "message", 1}, new Object[]{"return"}, new Object[]{"set", "$L3", null}, new Object[]{"set", "$L2", "$L0.message.location"}, new Object[]{"if!=than", "$L2", null, 3}, new Object[]{"create", "$L3", "Location"}, new Object[]{"set", "$L3.Longitude", "$L2.lng"}, new Object[]{"set", "$L3.Latitude", "$L2.lat"}, new Object[]{"set", "$L4", null}, new Object[]{"if!=than", "$L0.message.type", "text", 6}, new Object[]{"create", "$L4", "Array"}, new Object[]{"set", "$L8", "$L0.message.type"}, new Object[]{"if==than", "$L8", "picture", 1}, new Object[]{"set", "$L8", "image"}, new Object[]{"create", "$L5", "MessagingAttachment", "$L0.message.media", "$L8", null, null, null}, new Object[]{"push", "$L4", "$L5"}, new Object[]{"create", "$L6", "Message"}, new Object[]{"if!=than", "$L0.message_token", null, 2}, new Object[]{"string.concat", "$L11", "$L0.message_token"}, new Object[]{"set", "$L6.MessageId", "$L11"}, new Object[]{"if!=than", "$L0.sender.id", null, 3}, new Object[]{"string.concat", "$L12", "$L0.sender.id"}, new Object[]{"set", "$L6.SenderId", "$L12"}, new Object[]{"set", "$L6.ChatId", "$L12"}, new Object[]{"if!=than", "$L0.user_id", null, 3}, new Object[]{"string.concat", "$L14", "$L0.sender.id"}, new Object[]{"set", "$L6.SenderId", "$L14"}, new Object[]{"set", "$L6.ChatId", "$L14"}, new Object[]{"create", "$L7", "Date"}, new Object[]{"set", "$L7", "$L7.time"}, new Object[]{"set", "$L6.SendAt", "$L7"}, new Object[]{"if!=than", "$L0.message.text", null, 2}, new Object[]{"string.concat", "$L15", "$L0.message.text"}, new Object[]{"set", "$L6.MessageText", "$L15"}, new Object[]{"if!=than", "$L3", null, 1}, new Object[]{"set", "$L6.Location", "$L3"}, new Object[]{"if!=than", "$L4", null, 1}, new Object[]{"set", "$L6.Attachments", "$L4"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"push", "$P1", "$L6"}});
            this.put("sendMessage", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "chatId"}, new Object[]{"callFunc", "checkMandatory", "$P3", "message text"}, new Object[]{"callFunc", "send", "$P0", "$P1", "$P2", "text", "$P3", null, null, null, null}});
            this.put("sendImage", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "chatId"}, new Object[]{"callFunc", "checkMandatory", "$P4", "content URL"}, new Object[]{"if==than", "$P6", null, 1}, new Object[]{"set", "$P6", "https://webhooks.cloudrail.com/home/ubuntu/server/media/cloudrail_small_preview_viber.jpg"}, new Object[]{"callFunc", "send", "$P0", "$P1", "$P2", "picture", "$P3", "$P4", "$P6", null, null}});
            this.put("sendVideo", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "chatId"}, new Object[]{"callFunc", "checkMandatory", "$P4", "content URL"}, new Object[]{"callFunc", "checkMandatory", "$P7", "video size"}, new Object[]{"if==than", "$P6", null, 1}, new Object[]{"set", "$P6", "https://webhooks.cloudrail.com/home/ubuntu/server/media/cloudrail_small_preview_viber.jpg"}, new Object[]{"callFunc", "send", "$P0", "$P1", "$P2", "video", "$P3", "$P4", "$P6", null, "$P7"}});
            this.put("sendAudio", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "chatId"}, new Object[]{"callFunc", "checkMandatory", "$P4", "content URL"}, new Object[]{"callFunc", "checkMandatory", "$P7", "mp3 file name"}, new Object[]{"callFunc", "checkMandatory", "$P8", "file size"}, new Object[]{"callFunc", "send", "$P0", "$P1", "$P2", "file", null, "$P4", null, "$P7", "$P8"}});
            this.put("sendFile", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "chatId"}, new Object[]{"callFunc", "checkMandatory", "$P4", "content URL"}, new Object[]{"callFunc", "checkMandatory", "$P7", "file name"}, new Object[]{"callFunc", "checkMandatory", "$P8", "file size"}, new Object[]{"callFunc", "send", "$P0", "$P1", "$P2", "file", null, "$P4", null, "$P7", "$P8"}});
            this.put("downloadContent", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "$P2.id"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$P1", "$P2"}, new Object[]{"set", "$P1.stream", "$L1.responseBody"}, new Object[]{"set", "$P1.mimeType", "$L1.responseHeaders.Content-Type"}});
            this.put("sendCarousel", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/send_message"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.name", "$P0.botName"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.receiver", "$P2"}, new Object[]{"set", "$L1.type", "rich_media"}, new Object[]{"set", "$L1.min_api_version", "2"}, new Object[]{"create", "$L1.rich_media", "Object"}, new Object[]{"set", "$L1.rich_media.Type", "rich_media"}, new Object[]{"set", "$L1.rich_media.ButtonsGroupColumns", "6"}, new Object[]{"set", "$L1.rich_media.ButtonsGroupRows", "7"}, new Object[]{"set", "$L1.rich_media.BgColor", "#FFFFFF"}, new Object[]{"create", "$L1.rich_media.Buttons", "Array"}, new Object[]{"create", "$L3", "Number", 0}, new Object[]{"size", "$L4", "$P3"}, new Object[]{"if<than", "$L3", "$L4", 16}, new Object[]{"get", "$L5", "$P3", "$L3"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"callFunc", "makeCarouselRow", "$P0", "$L15", "image", null, null, null, "$L5.mediaUrl", null}, new Object[]{"push", "$L1.rich_media.Buttons", "$L15"}, new Object[]{"callFunc", "makeCarouselRow", "$P0", "$L16", "text", "$L5.title", "$L5.subTitle", null, null, null}, new Object[]{"push", "$L1.rich_media.Buttons", "$L16"}, new Object[]{"create", "$L7", "Number", 0}, new Object[]{"size", "$L8", "$L5.buttons"}, new Object[]{"if<than", "$L7", "$L8", 5}, new Object[]{"get", "$L9", "$L5.buttons", "$L7"}, new Object[]{"callFunc", "makeCarouselRow", "$P0", "$L17", "button", "$L9.text", null, "$L9.type", "$L9.url", null}, new Object[]{"push", "$L1.rich_media.Buttons", "$L17"}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"jumpRel", -6}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -17}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"size", "$L20", "$L1"}, new Object[]{"string.concat", "$L21", "$L20"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2", "$P0.botToken", "X-Viber-Auth-Token"}, new Object[]{"set", "$L2", "application/json", "Content-Type"}, new Object[]{"set", "$L2", "$L21", "Content-Length"}, new Object[]{"set", "$L0.requestHeaders", "$L2"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"create", "$L4", "Date"}, new Object[]{"set", "$L8", "$L4.time"}, new Object[]{"create", "$P1", "Message"}, new Object[]{"set", "$P1.SenderId", "$P2"}, new Object[]{"set", "$P1.ChatId", "$P2"}, new Object[]{"set", "$P1.SendAt", "$L8"}});
            this.put("send", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "$P0.baseURL", "/send_message"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.name", "$P0.botName"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L20", "$P2"}, new Object[]{"set", "$L1.receiver", "$L20"}, new Object[]{"set", "$L1.type", "$P3"}, new Object[]{"set", "$L1.sender", "$L5"}, new Object[]{"if!=than", "$P4", null, 1}, new Object[]{"set", "$L1.text", "$P4"}, new Object[]{"if!=than", "$P5", null, 1}, new Object[]{"set", "$L1.media", "$P5"}, new Object[]{"if!=than", "$P6", null, 1}, new Object[]{"set", "$L1.thumbnail", "$P6"}, new Object[]{"if!=than", "$P7", null, 1}, new Object[]{"set", "$L1.file_name", "$P7"}, new Object[]{"if!=than", "$P8", null, 1}, new Object[]{"set", "$L1.size", "$P8"}, new Object[]{"json.stringify", "$L1", "$L1"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"size", "$L20", "$L1"}, new Object[]{"string.concat", "$L21", "$L20"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2", "$P0.botToken", "X-Viber-Auth-Token"}, new Object[]{"set", "$L2", "application/json", "Content-Type"}, new Object[]{"set", "$L2", "$L21", "Content-Length"}, new Object[]{"set", "$L0.requestHeaders", "$L2"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"create", "$L4", "Date"}, new Object[]{"set", "$L8", "$L4.time"}, new Object[]{"create", "$P1", "Message"}, new Object[]{"set", "$P1.SenderId", "$P2"}, new Object[]{"set", "$P1.ChatId", "$P2"}, new Object[]{"set", "$P1.SendAt", "$L8"}, new Object[]{"if!=than", "$P4", null, 1}, new Object[]{"set", "$P1.MessageText", "$P4"}});
            this.put("makeCarouselRow", new Object[]{new Object[]{"create", "$P1", "Object"}, new Object[]{"set", "$P1.Columns", "6"}, new Object[]{"if==than", "$P2", "image", 2}, new Object[]{"set", "$P1.Rows", "3"}, new Object[]{"set", "$P1.Image", "$P6"}, new Object[]{"if==than", "$P2", "text", 4}, new Object[]{"set", "$P1.Rows", "2"}, new Object[]{"string.concat", "$L1", "<font color=#323232><b>", "$P3", "</b></font><br />", "$P4"}, new Object[]{"set", "$P1.Text", "$L1"}, new Object[]{"set", "$P1.TextHAlign", "left"}, new Object[]{"if==than", "$P2", "button", 4}, new Object[]{"set", "$P1.Rows", "1"}, new Object[]{"string.concat", "$L1", "<font color=#8367db><b>", "$P3", "</b></font>"}, new Object[]{"set", "$P1.Text", "$L1"}, new Object[]{"set", "$P1.TextHAlign", "middle"}, new Object[]{"if!=than", "$P2", "image", 2}, new Object[]{"set", "$P1.TextSize", "medium"}, new Object[]{"set", "$P1.TextVAlign", "middle"}, new Object[]{"if!=than", "$P6", "button", 3}, new Object[]{"set", "$P1.ActionType", ""}, new Object[]{"set", "$P1.ActionBody", ""}, new Object[]{"return"}, new Object[]{"if!=than", "$P6", null, 3}, new Object[]{"set", "$P1.ActionType", "open-url"}, new Object[]{"set", "$P1.ActionBody", "$P6"}, new Object[]{"return"}, new Object[]{"set", "$P1.ActionType", "reply"}, new Object[]{"set", "$P1.ActionBody", "$P7"}});
            this.put("checkMandatory", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L1", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L0", "Error", "$L1", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 15}, new Object[]{"debug.out", "$P1.code"}, new Object[]{"stream.streamToString", "$L5", "$P1.responseBody"}, new Object[]{"debug.out", "$L5"}, new Object[]{"set", "$L2", ""}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Viber(Context context, String botToken, String webhook, String botName) {
        this.initDataStructures(context);
        this.interpreterStorage.put("botToken", botToken);
        this.interpreterStorage.put("webhook", webhook);
        this.interpreterStorage.put("botName", botName);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Viber...");
        new InitSelfTestTask("Viber", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Message sendMessage(String receiverId, String message) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Viber", "sendMessage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendMessage", this.interpreterStorage, null, receiverId, message);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Viber", "sendMessage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendImage(String receiverId, String message, String imageId, InputStream imageStream, String previewUrl, String mimeType) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Viber", "sendImage").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendImage", this.interpreterStorage, null, receiverId, message, imageId, imageStream, previewUrl, mimeType);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Viber", "sendImage").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendVideo(String receiverId, String message, String videoId, InputStream videoStream, String previewUrl, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Viber", "sendVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendVideo", this.interpreterStorage, null, receiverId, message, videoId, videoStream, previewUrl, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Viber", "sendVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendAudio(String receiverId, String message, String audioId, InputStream audioStream, String previewUrl, String audioName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Viber", "sendAudio").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendAudio", this.interpreterStorage, null, receiverId, message, audioId, audioStream, previewUrl, audioName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Viber", "sendAudio").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendFile(String receiverId, String message, String fileId, InputStream fileStream, String previewUrl, String fileName, long size) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Viber", "sendFile").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendFile", this.interpreterStorage, null, receiverId, message, fileId, fileStream, previewUrl, fileName, size);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Viber", "sendFile").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public Message sendCarousel(String receiverId, List<MessageItem> messageItem) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Viber", "sendCarousel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendCarousel", this.interpreterStorage, null, receiverId, messageItem);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Viber", "sendCarousel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Message)ip.getParameter(1);
    }

    @Override
    public List<Message> parseReceivedMessages(InputStream httpRequest) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Viber", "parseReceivedMessages").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("processWebhookRequest", this.interpreterStorage, null, httpRequest);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Viber", "parseReceivedMessages").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public MessagingAttachment downloadContent(MessagingAttachment attachment) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Viber", "downloadContent").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("downloadContent", this.interpreterStorage, null, attachment);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Viber", "downloadContent").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (MessagingAttachment)ip.getParameter(1);
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Viber", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Viber", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

