/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Video;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.ChannelMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.VideoMetaData;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Vimeo
implements Video,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("uploadVideo", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "title"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P4", "video"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P3", "desctiption"}, new Object[]{"callFunc", "checkMandatory", "$P0", "$P5", "size"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "title"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P3", "description"}, new Object[]{"callFunc", "checkGreater0", "$P0", "$P5", "size"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkQuota", "$P0", "$P5"}, new Object[]{"callFunc", "generateUploadTicket", "$P0", "$L0", "$P6"}, new Object[]{"callFunc", "uploadStream", "$P0", "$L0.uploadUri", "$P4", "$P5", 0, "$P7"}, new Object[]{"callFunc", "verifyUpload", "$P0", "$L0.uploadUri", "$P4", "$P5", 0, "$P7"}, new Object[]{"callFunc", "completeUpload", "$P0", "$L1", "$L0.completeUri"}, new Object[]{"callFunc", "getVideo", "$P0", "$P1", "$L1", "$P2", "$P3"}});
            this.put("searchVideos", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "query"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "query"}, new Object[]{"callFunc", "getVideosFromAPI", "$P0", "$P1", "$P2", "$P3", "$P4", "search"}});
            this.put("listVideosForChannel", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "channel ID"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "channel ID"}, new Object[]{"callFunc", "getVideosFromAPI", "$P0", "$P1", "$P2", "$P3", "$P4", "channel"}});
            this.put("getVideo", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "video ID"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "video ID"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://api.vimeo.com/videos/", "$P2"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L5", 0}, new Object[]{"if!=than", "$P3", null, 5}, new Object[]{"if!=than", "$P3", "", 4}, new Object[]{"if!=than", "$P4", null, 3}, new Object[]{"if!=than", "$P4", "", 2}, new Object[]{"set", "$L5", 1}, new Object[]{"set", "$L0.method", "PATCH"}, new Object[]{"if==than", "$L5", 1, 6}, new Object[]{"create", "$L6", "Object"}, new Object[]{"set", "$L6.name", "$P3"}, new Object[]{"set", "$L6.description", "$P4"}, new Object[]{"json.stringify", "$L7", "$L6"}, new Object[]{"stream.stringToStream", "$L8", "$L7"}, new Object[]{"set", "$L0.requestBody", "$L8"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"callFunc", "generateUnauthenticatedTokens", "$P0", "$L1"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$L1"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/json"}, new Object[]{"set", "$L9", 0}, new Object[]{"if!=than", "$L7", null, 1}, new Object[]{"size", "$L9", "$L7"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Length", "$L9"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"stream.streamToString", "$L3", "$L2.responseBody"}, new Object[]{"json.parse", "$L4", "$L3"}, new Object[]{"callFunc", "extractVideoMetaData", "$P0", "$P1", "$L4"}});
            this.put("getChannel", new Object[]{new Object[]{"callFunc", "checkMandatory", "$P0", "$P2", "channel ID"}, new Object[]{"callFunc", "checkEmpty", "$P0", "$P2", "channel ID"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://api.vimeo.com/users/", "$P2"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"callFunc", "generateUnauthenticatedTokens", "$P0", "$L1"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$L1"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"stream.streamToString", "$L3", "$L2.responseBody"}, new Object[]{"json.parse", "$L4", "$L3"}, new Object[]{"callFunc", "extractChannelMetaData", "$P0", "$P1", "$L4"}});
            this.put("getOwnChannel", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://api.vimeo.com/me"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"stream.streamToString", "$L2", "$L1.responseBody"}, new Object[]{"json.parse", "$L3", "$L2"}, new Object[]{"callFunc", "extractChannelMetaData", "$P0", "$P1", "$L3"}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"if!=than", "$S0.accessToken", null, 10}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "DELETE"}, new Object[]{"set", "$L0.url", "https://api.vimeo.com/tokens"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$S0.accessToken", null}, new Object[]{"set", "$S0.accessTokenUnauth", null}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "https://api.vimeo.com"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("checkQuota", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L0.url", "https://api.vimeo.com/me"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"stream.streamToString", "$L2", "$L1.responseBody"}, new Object[]{"json.parse", "$L3", "$L2"}, new Object[]{"set", "$L4", "$L3.upload_quota.space.free"}, new Object[]{"if<than", "$L4", "$P1", 3}, new Object[]{"string.concat", "$L5", "This upload would exceed your Vimeo upload quota"}, new Object[]{"create", "$L6", "Error", "$L5", "Http"}, new Object[]{"throwError", "$L6"}});
            this.put("generateUploadTicket", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "https://api.vimeo.com/me/videos"}, new Object[]{"if!=than", "$P2", null, 2}, new Object[]{"if!=than", "$P2", "", 1}, new Object[]{"string.concat", "$L0.url", "https://api.vimeo.com/users/", "$P2", "/videos"}, new Object[]{"create", "$L4", "String", "type=streaming"}, new Object[]{"stream.stringToStream", "$L5", "$L4"}, new Object[]{"set", "$L0.requestBody", "$L5"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"size", "$L6", "$L4"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Length", "$L6"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"stream.streamToString", "$L2", "$L1.responseBody"}, new Object[]{"json.parse", "$L3", "$L2"}, new Object[]{"create", "$P1", "Object"}, new Object[]{"set", "$P1.uploadUri", "$L3.upload_link_secure"}, new Object[]{"set", "$P1.completeUri", "$L3.complete_uri"}});
            this.put("uploadStream", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "PUT"}, new Object[]{"set", "$L0.url", "$P1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Length", "$P3"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "$P5"}, new Object[]{"if!=than", "$P4", 0, 2}, new Object[]{"math.add", "$L2", "$P4", 1}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Range", "bytes ", "$L2", "-", "$P3", "/", "$P3"}, new Object[]{"set", "$L0.requestBody", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("verifyUpload", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "PUT"}, new Object[]{"set", "$L0.url", "$P1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"set", "$L0.requestHeaders.Content-Length", "0"}, new Object[]{"string.concat", "$L0.requestHeaders.Content-Range", "bytes *", "/", "*"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"string.split", "$L3", "$L1.responseHeaders.Range", "-"}, new Object[]{"get", "$L3", "$L3", 1}, new Object[]{"string.concat", "$L7", "$P3"}, new Object[]{"if==than", "$L3", "$L7", 1}, new Object[]{"return"}, new Object[]{"math.add", "$L4", "$P4", 1}, new Object[]{"if<=than", "$L4", 3, 3}, new Object[]{"callFunc", "uploadStream", "$P0", "$P1", "$P2", "$P3", "$L3", "$P5"}, new Object[]{"callFunc", "verifyUpload", "$P0", "$P1", "$P2", "$P3", "$L4", "$P5"}, new Object[]{"return"}, new Object[]{"create", "$L5", "Error", "Upload failed"}, new Object[]{"throwError", "$L5"}});
            this.put("completeUpload", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "DELETE"}, new Object[]{"string.concat", "$L0.url", "https://api.vimeo.com", "$P2"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$L2", "$L1.responseHeaders.Location"}, new Object[]{"string.substr", "$P1", "$L2", 8}});
            this.put("generateUnauthenticatedTokens", new Object[]{new Object[]{"if!=than", "$S0.accessToken", null, 3}, new Object[]{"if!=than", "$S0.accessToken", "", 2}, new Object[]{"set", "$P1", "$S0.accessToken"}, new Object[]{"return"}, new Object[]{"if!=than", "$S0.accessTokenUnauth", null, 3}, new Object[]{"if!=than", "$S0.accessTokenUnauth", "", 2}, new Object[]{"set", "$P1", "$S0.accessTokenUnauth"}, new Object[]{"return"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "https://api.vimeo.com/oauth/authorize/client?grant_type=client_credentials"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L1", "$P0.clientId", ":", "$P0.clientSecret"}, new Object[]{"string.base64encode", "$L1", "$L1"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "basic ", "$L1"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/vnd.vimeo.*+json; version=3.0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"stream.streamToString", "$L3", "$L2.responseBody"}, new Object[]{"json.parse", "$L4", "$L3"}, new Object[]{"set", "$P1", "$L4.access_token"}, new Object[]{"set", "$S0.accessTokenUnauth", "$L4.access_token"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if==than", "$S0.accessToken", null, 1}, new Object[]{"callFunc", "authenticate", "$P0"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L0", "String"}, new Object[]{"string.concat", "$L0", "https://api.vimeo.com/oauth/authorize?client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&response_type=code&scope=public+private+upload+edit&state=", "$P0.state"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0", null, "$P0.redirectUri"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"string.concat", "$L2.url", "https://api.vimeo.com/oauth/access_token"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.code", "$L1"}, new Object[]{"set", "$L7.grant_type", "authorization_code"}, new Object[]{"set", "$L7.redirect_uri", "$P0.redirectUri"}, new Object[]{"json.stringify", "$L8", "$L7"}, new Object[]{"stream.stringToStream", "$L9", "$L8"}, new Object[]{"set", "$L2.requestBody", "$L9"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L3", "$P0.clientId", ":", "$P0.clientSecret"}, new Object[]{"string.base64encode", "$L3", "$L3"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "basic ", "$L3"}, new Object[]{"set", "$L2.requestHeaders.Content-Type", "application/json"}, new Object[]{"size", "$L10", "$L8"}, new Object[]{"string.concat", "$L10", "$L10"}, new Object[]{"set", "$L2.requestHeaders.Content-Length", "$L10"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L4"}, new Object[]{"create", "$L5", "String"}, new Object[]{"stream.streamToString", "$L5", "$L4.responseBody"}, new Object[]{"json.parse", "$L6", "$L5"}, new Object[]{"set", "$S0.accessToken", "$L6.access_token"}});
            this.put("getVideosFromAPI", new Object[]{new Object[]{"callFunc", "checkSmallerEquals", "$P0", "$P4", 100, "limit"}, new Object[]{"if==than", "$P3", null, 1}, new Object[]{"set", "$P3", 0}, new Object[]{"if<than", "$P3", 0, 1}, new Object[]{"set", "$P3", 0}, new Object[]{"if==than", "$P4", null, 1}, new Object[]{"set", "$P4", 50}, new Object[]{"if<=than", "$P4", 0, 1}, new Object[]{"set", "$P4", 50}, new Object[]{"math.add", "$L1", "$P3", "$P4"}, new Object[]{"math.multiply", "$L2", "$P3", 0.01}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"math.multiply", "$L3", "$L1", 0.01}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"callFunc", "getVideoPage", "$P0", "$L4", "$P2", "$L2", 100, "$P5"}, new Object[]{"callFunc", "modulo", "$P0", "$L5", "$P3", 100}, new Object[]{"math.add", "$L6", "$L5", "$P4"}, new Object[]{"set", "$L7", "$L6"}, new Object[]{"if>than", "$L7", 100, 1}, new Object[]{"set", "$L7", 100}, new Object[]{"math.add", "$L6", "$L6", -100}, new Object[]{"create", "$P1", "Array"}, new Object[]{"callFunc", "pushVideosToArray", "$P0", "$P1", "$L4", "$L5", "$L7"}, new Object[]{"if!=than", "$L2", "$L3", 2}, new Object[]{"callFunc", "getVideoPage", "$P0", "$L8", "$P2", "$L3", 100, "$P5"}, new Object[]{"callFunc", "pushVideosToArray", "$P0", "$P1", "$L8", 0, "$L6"}});
            this.put("getVideoPage", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L0.url", "https://api.vimeo.com/"}, new Object[]{"if==than", "$P5", "search", 4}, new Object[]{"string.concat", "$L0.url", "$L0.url", "videos?"}, new Object[]{"if!=than", "$P2", null, 2}, new Object[]{"if!=than", "$P2", "", 1}, new Object[]{"string.concat", "$L0.url", "$L0.url", "query=", "$P2", "&"}, new Object[]{"if==than", "$P5", "channel", 1}, new Object[]{"string.concat", "$L0.url", "$L0.url", "users/", "$P2", "/videos?"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "page=", "$P3", "&per_page=", "$P4"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"callFunc", "generateUnauthenticatedTokens", "$P0", "$L1"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$L1"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"stream.streamToString", "$L3", "$L2.responseBody"}, new Object[]{"json.parse", "$L4", "$L3"}, new Object[]{"set", "$P1", "$L4.data"}});
            this.put("modulo", new Object[]{new Object[]{"math.divide", "$L0", "$P2", "$P3"}, new Object[]{"math.floor", "$L0", "$L0"}, new Object[]{"math.multiply", "$L0", "$P3", "$L0"}, new Object[]{"math.multiply", "$L0", "$L0", -1}, new Object[]{"math.add", "$P1", "$P2", "$L0"}});
            this.put("pushVideosToArray", new Object[]{new Object[]{"size", "$L0", "$P2"}, new Object[]{"set", "$L1", "$P3"}, new Object[]{"if<than", "$L1", "$L0", 6}, new Object[]{"if<than", "$L1", "$P4", 5}, new Object[]{"get", "$L2", "$P2", "$L1"}, new Object[]{"callFunc", "extractVideoMetaData", "$P0", "$L3", "$L2"}, new Object[]{"push", "$P1", "$L3"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -7}});
            this.put("extractVideoMetaData", new Object[]{new Object[]{"create", "$L0", "Date", "$P2.created_time"}, new Object[]{"set", "$L6", "$L0.time"}, new Object[]{"set", "$L1", "$P2.uri"}, new Object[]{"string.substr", "$L1", "$L1", 8}, new Object[]{"string.concat", "$L2", "$P2.user.uri"}, new Object[]{"string.substr", "$L2", "$L2", 7}, new Object[]{"set", "$L3", "$P2.pictures.sizes"}, new Object[]{"size", "$L4", "$L3"}, new Object[]{"math.add", "$L4", "$L4", -1}, new Object[]{"get", "$L5", "$L3", "$L4"}, new Object[]{"create", "$P1", "VideoMetaData", "$L1", "$P2.name", "$P2.description", "$L6", "$L2", "$P2.duration", "$L5.link", "$P2.embed.html", "$P2.stats.plays", "$P2.metadata.connections.likes.total", null}});
            this.put("extractChannelMetaData", new Object[]{new Object[]{"set", "$L0", "$P2.uri"}, new Object[]{"string.substr", "$L0", "$L0", 7}, new Object[]{"set", "$L1", "$P2.pictures.sizes"}, new Object[]{"size", "$L2", "$L1"}, new Object[]{"math.add", "$L2", "$L2", -1}, new Object[]{"get", "$L3", "$L1", "$L2"}, new Object[]{"create", "$P1", "ChannelMetaData", "$L0", "$P2.name", "$P2.metadata.connections.followers.total", "$P2.link", "$L2.link", null}});
            this.put("checkMandatory", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L1", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L0", "Error", "$L1", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkEmptyList", new Object[]{new Object[]{"size", "$L0", "$P1"}, new Object[]{"if==than", "$L0", 0, 3}, new Object[]{"string.concat", "$L2", "The list ", "$P2", " cannot be empty"}, new Object[]{"create", "$L1", "Error", "$L2", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkEmpty", new Object[]{new Object[]{"if==than", "$P1", "", 3}, new Object[]{"string.concat", "$L0", "Field ", "$P2", " is mandatory"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkEquals", new Object[]{new Object[]{"if!=than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " does not match ", "$P4"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkGreater0", new Object[]{new Object[]{"if<=than", "$P1", 0, 3}, new Object[]{"string.concat", "$L0", "$P2", " has to be greater than 0"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkSmallerEquals", new Object[]{new Object[]{"if>than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " has to be smaller than or equal to ", "$P2"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 17}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L2", "$L0.code"}, new Object[]{"if!=than", "$L0.message", null, 1}, new Object[]{"string.concat", "$L2", "; $L0.message"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public Vimeo(Context context, String clientId, String clientSecret, String redirectUri, String state) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.initService();
    }

    public Vimeo(Context context, String clientId, String clientSecret) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", "https://www.cloudrailauth.com/auth");
        this.interpreterStorage.put("state", "CloudRailSI");
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to Vimeo...");
        new InitSelfTestTask("Vimeo", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public VideoMetaData uploadVideo(String title, String description, InputStream stream, long size, String channelId, String mimeType) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Vimeo", "uploadVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("uploadVideo", this.interpreterStorage, null, title, description, stream, size, channelId, mimeType);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Vimeo", "uploadVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (VideoMetaData)ip.getParameter(1);
    }

    @Override
    public List<VideoMetaData> searchVideos(String query, long offset, long limit) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Vimeo", "searchVideos").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("searchVideos", this.interpreterStorage, null, query, offset, limit);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Vimeo", "searchVideos").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public VideoMetaData getVideo(String videoId) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Vimeo", "getVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getVideo", this.interpreterStorage, null, videoId);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Vimeo", "getVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (VideoMetaData)ip.getParameter(1);
    }

    @Override
    public ChannelMetaData getChannel(String channelId) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Vimeo", "getChannel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getChannel", this.interpreterStorage, null, channelId);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Vimeo", "getChannel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (ChannelMetaData)ip.getParameter(1);
    }

    @Override
    public ChannelMetaData getOwnChannel() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Vimeo", "getOwnChannel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getOwnChannel", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Vimeo", "getOwnChannel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (ChannelMetaData)ip.getParameter(1);
    }

    @Override
    public List<VideoMetaData> listVideosForChannel(String channelId, long offset, long limit) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Vimeo", "listVideosForChannel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listVideosForChannel", this.interpreterStorage, null, channelId, offset, limit);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Vimeo", "listVideosForChannel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Vimeo", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Vimeo", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Vimeo", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Vimeo", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "Vimeo", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Vimeo", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

