/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import android.content.Context;
import android.os.Looper;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.AdvancedRequestSupporter;
import com.cloudrail.si.interfaces.Video;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.AdvancedRequestResponse;
import com.cloudrail.si.types.AdvancedRequestSpecification;
import com.cloudrail.si.types.ChannelMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.VideoMetaData;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class YouTube
implements Video,
AdvancedRequestSupporter {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"create", "$P0.paginationCache", "Object"}, new Object[]{"create", "$P0.paginationCache.offset", "Number", 0}, new Object[]{"create", "$P0.paginationCache.metaCache", "Array"}, new Object[]{"create", "$P0.paginationCache.query", "String"}, new Object[]{"create", "$P0.paginationChannelCache", "Object"}, new Object[]{"create", "$P0.paginationChannelCache.offset", "Number", 0}, new Object[]{"create", "$P0.paginationChannelCache.metaCache", "Array"}, new Object[]{"create", "$P0.paginationChannelCache.channelId", "String"}, new Object[]{"set", "$P0.baseUrl", "https://www.googleapis.com/youtube/v3"}, new Object[]{"if==than", "$P0.scopes", null, 2}, new Object[]{"set", "$P0.scope", "https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fyoutube"}, new Object[]{"jumpRel", 11}, new Object[]{"create", "$P0.scope", "String"}, new Object[]{"size", "$L0", "$P0.scopes"}, new Object[]{"create", "$L1", "Number", 0}, new Object[]{"if<than", "$L1", "$L0", 7}, new Object[]{"if!=than", "$L1", 0, 1}, new Object[]{"string.concat", "$P0.scope", "$P0.scope", "+"}, new Object[]{"get", "$L2", "$P0.scopes", "$L1"}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"string.concat", "$P0.scope", "$P0.scope", "$L2"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -8}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://accounts.google.com/o/oauth2/revoke?token=", "$S0.accessToken"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$S0.accessToken", null}});
            this.put("uploadVideo", new Object[]{new Object[]{"callFunc", "requiredClientIDConstructor", "$P0"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2", "title"}, new Object[]{"callFunc", "checkNull", "$P0", "$P4", "video"}, new Object[]{"callFunc", "checkNull", "$P0", "$P5", "size"}, new Object[]{"callFunc", "checkNull", "$P0", "$P7", "mime type"}, new Object[]{"callFunc", "checkIsEmpty", "$P0", "$P2", "title"}, new Object[]{"callFunc", "checkIsEmpty", "$P0", "$P7", "mime type"}, new Object[]{"callFunc", "checkGreater0", "$P0", "$P5", "size"}, new Object[]{"create", "$L12", "String"}, new Object[]{"string.concat", "$L12", "$P5"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "https://www.googleapis.com/upload/youtube/v3/videos?uploadType=resumable&part=snippet"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"set", "$L3", "application/json", "Content-Type"}, new Object[]{"create", "$L4", "String"}, new Object[]{"string.concat", "$L4", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L3", "$L4", "Authorization"}, new Object[]{"create", "$L28", "String"}, new Object[]{"set", "$L28", "$P7"}, new Object[]{"set", "$L3", "$L28", "X-Upload-Content-Type"}, new Object[]{"set", "$L3", "$L12", "X-Upload-Content-Length"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.title", "$P2"}, new Object[]{"set", "$L7.description", "$P3"}, new Object[]{"set", "$L5.snippet", "$L7"}, new Object[]{"create", "$L6", "String"}, new Object[]{"json.stringify", "$L6", "$L5"}, new Object[]{"stream.stringToStream", "$L7", "$L6"}, new Object[]{"set", "$L0.requestBody", "$L7"}, new Object[]{"create", "$L8", "Object"}, new Object[]{"http.requestCall", "$L8", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L8"}, new Object[]{"create", "$L9", "String"}, new Object[]{"get", "$L9", "$L8.responseHeaders", "Location"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.method", "PUT"}, new Object[]{"set", "$L2.url", "$L9"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L2.requestHeaders", "$L3"}, new Object[]{"set", "$L3", "$L12", "Content-Length"}, new Object[]{"set", "$L3", "$L28", "Content-Type"}, new Object[]{"create", "$L4", "String"}, new Object[]{"string.concat", "$L4", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L3", "$L4", "Authorization"}, new Object[]{"set", "$L2.requestBody", "$P4"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"json.parse", "$L9", "$L5.responseBody"}, new Object[]{"callFunc", "getVideo", "$P0", "$P1", "$L9.id"}});
            this.put("searchVideos", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Query"}, new Object[]{"callFunc", "checkIsEmpty", "$P0", "$P2", "Query"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if!=than", "$P0.paginationCache.query", "$P2", 22}, new Object[]{"jumpRel", 1}, new Object[]{"if<than", "$P3", "$P0.paginationCache.offset", 20}, new Object[]{"set", "$P0.paginationCache.query", "$P2"}, new Object[]{"set", "$P0.paginationCache.offset", 0}, new Object[]{"create", "$P0.paginationCache.metaCache", "Array"}, new Object[]{"string.concat", "$L1", "https://www.googleapis.com/youtube/v3/search?part=id&type=video&maxResults=50"}, new Object[]{"string.urlEncode", "$L2", "$P2"}, new Object[]{"string.concat", "$L1", "$L1", "&q=", "$L2"}, new Object[]{"callFunc", "getRawMetaData", "$P0", "$L6", "$L1"}, new Object[]{"create", "$L7", "Number"}, new Object[]{"size", "$L8", "$L6.items"}, new Object[]{"create", "$L20", "String"}, new Object[]{"if<than", "$L7", "$L8", 6}, new Object[]{"get", "$L9", "$L6.items", "$L7"}, new Object[]{"if!=than", "$L7", 0, 1}, new Object[]{"string.concat", "$L20", "$L20", ","}, new Object[]{"string.concat", "$L20", "$L20", "$L9.id.videoId"}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"jumpRel", -7}, new Object[]{"set", "$P0.paginationCache.cursor", "$L6.nextPageToken"}, new Object[]{"callFunc", "getVideos", "$P0", "$P0.paginationCache.metaCache", "$L20"}, new Object[]{"jumpRel", -23}, new Object[]{"create", "$L0", "Number"}, new Object[]{"size", "$L0", "$P0.paginationCache.metaCache"}, new Object[]{"math.add", "$L0", "$L0", "$P0.paginationCache.offset"}, new Object[]{"if<than", "$P3", "$L0", 14}, new Object[]{"math.multiply", "$L1", "$P0.paginationCache.offset", -1}, new Object[]{"math.add", "$L1", "$L1", "$P3"}, new Object[]{"size", "$L0", "$P1"}, new Object[]{"if<than", "$L0", "$P4", 9}, new Object[]{"get", "$L2", "$P0.paginationCache.metaCache", "$L1"}, new Object[]{"push", "$P1", "$L2"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"size", "$L3", "$P0.paginationCache.metaCache"}, new Object[]{"if==than", "$L3", "$L1", 3}, new Object[]{"size", "$L4", "$P0.paginationCache.metaCache"}, new Object[]{"math.add", "$P3", "$L4", "$P0.paginationCache.offset"}, new Object[]{"jumpRel", 2}, new Object[]{"jumpRel", -11}, new Object[]{"return"}, new Object[]{"if==than", "$P0.paginationCache.cursor", null, 1}, new Object[]{"return"}, new Object[]{"size", "$L2", "$P0.paginationCache.metaCache"}, new Object[]{"math.add", "$P0.paginationCache.offset", "$P0.paginationCache.offset", "$L2"}, new Object[]{"create", "$P0.paginationCache.metaCache", "Array"}, new Object[]{"string.concat", "$L1", "https://www.googleapis.com/youtube/v3/search?part=id&type=video&maxResults=50"}, new Object[]{"string.urlEncode", "$L2", "$P2"}, new Object[]{"string.concat", "$L1", "$L1", "&q=", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "&pageToken=", "$P0.paginationCache.cursor"}, new Object[]{"callFunc", "getRawMetaData", "$P0", "$L6", "$L1"}, new Object[]{"create", "$L7", "Number"}, new Object[]{"size", "$L8", "$L6.items"}, new Object[]{"create", "$L20", "String"}, new Object[]{"if<than", "$L7", "$L8", 6}, new Object[]{"get", "$L9", "$L6.items", "$L7"}, new Object[]{"if!=than", "$L7", 0, 1}, new Object[]{"string.concat", "$L20", "$L20", ","}, new Object[]{"string.concat", "$L20", "$L20", "$L9.id.videoId"}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"jumpRel", -7}, new Object[]{"set", "$P0.paginationCache.cursor", "$L6.nextPageToken"}, new Object[]{"callFunc", "getVideos", "$P0", "$P0.paginationCache.metaCache", "$L20"}, new Object[]{"jumpRel", -64}});
            this.put("getVideo", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Video ID"}, new Object[]{"callFunc", "checkIsEmpty", "$P0", "$P2", "Video ID"}, new Object[]{"string.concat", "$L1", "https://www.googleapis.com/youtube/v3/videos?part=snippet,contentDetails,statistics,player"}, new Object[]{"string.concat", "$L1", "$L1", "&id=", "$P2"}, new Object[]{"callFunc", "getRawMetaData", "$P0", "$L3", "$L1"}, new Object[]{"set", "$L4", "$L3.items"}, new Object[]{"create", "$L5", "Number", 0}, new Object[]{"get", "$L6", "$L4", "$L5"}, new Object[]{"callFunc", "makeVideoMetaData", "$P0", "$P1", "$L6"}});
            this.put("getVideos", new Object[]{new Object[]{"string.concat", "$L1", "https://www.googleapis.com/youtube/v3/videos?part=snippet,contentDetails,statistics,player"}, new Object[]{"string.concat", "$L1", "$L1", "&id=", "$P2"}, new Object[]{"callFunc", "getRawMetaData", "$P0", "$L3", "$L1"}, new Object[]{"set", "$L7", "$L3.items"}, new Object[]{"create", "$L8", "Number", 0}, new Object[]{"create", "$L9", "Number"}, new Object[]{"size", "$L9", "$L7"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if<than", "$L8", "$L9", 5}, new Object[]{"get", "$L10", "$L7", "$L8"}, new Object[]{"callFunc", "makeVideoMetaData", "$P0", "$L11", "$L10"}, new Object[]{"push", "$P1", "$L11"}, new Object[]{"math.add", "$L8", "$L8", 1}, new Object[]{"jumpRel", -6}});
            this.put("getChannel", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Channel ID"}, new Object[]{"callFunc", "checkIsEmpty", "$P0", "$P2", "Channel ID"}, new Object[]{"string.concat", "$L1", "https://www.googleapis.com/youtube/v3/channels?part=snippet,contentDetails,statistics,brandingSettings"}, new Object[]{"string.concat", "$L1", "$L1", "&id=", "$P2"}, new Object[]{"callFunc", "getRawMetaData", "$P0", "$L3", "$L1"}, new Object[]{"set", "$L4", "$L3.items"}, new Object[]{"create", "$L5", "Number", 0}, new Object[]{"get", "$L6", "$L4", "$L5"}, new Object[]{"callFunc", "makeChannelMetaData", "$P0", "$P1", "$L6"}});
            this.put("getOwnChannel", new Object[]{new Object[]{"callFunc", "requiredClientIDConstructor", "$P0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L1", "https://www.googleapis.com/youtube/v3/channels?part=snippet,contentDetails,statistics,brandingSettings&mine=true"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"create", "$L4", "String"}, new Object[]{"string.concat", "$L4", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L3", "$L4", "Authorization"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"set", "$L4", "$L3.items"}, new Object[]{"create", "$L5", "Number", 0}, new Object[]{"get", "$L6", "$L4", "$L5"}, new Object[]{"callFunc", "makeChannelMetaData", "$P0", "$P1", "$L6"}});
            this.put("listVideosForChannel", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Channel Id"}, new Object[]{"callFunc", "checkIsEmpty", "$P0", "$P2", "Channel Id"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if!=than", "$P0.paginationChannelCache.channelId", "$P2", 22}, new Object[]{"jumpRel", 1}, new Object[]{"if<than", "$P3", "$P0.paginationChannelCache.offset", 20}, new Object[]{"set", "$P0.paginationChannelCache.channelId", "$P2"}, new Object[]{"set", "$P0.paginationChannelCache.offset", 0}, new Object[]{"create", "$P0.paginationChannelCache.metaCache", "Array"}, new Object[]{"string.concat", "$L1", "https://www.googleapis.com/youtube/v3/search?part=id&type=video&maxResults=50"}, new Object[]{"set", "$L2", "$P2"}, new Object[]{"string.concat", "$L1", "$L1", "&channelId=", "$L2"}, new Object[]{"callFunc", "getRawMetaData", "$P0", "$L6", "$L1"}, new Object[]{"create", "$L7", "Number"}, new Object[]{"size", "$L8", "$L6.items"}, new Object[]{"create", "$L20", "String"}, new Object[]{"if<than", "$L7", "$L8", 6}, new Object[]{"get", "$L9", "$L6.items", "$L7"}, new Object[]{"if!=than", "$L7", 0, 1}, new Object[]{"string.concat", "$L20", "$L20", ","}, new Object[]{"string.concat", "$L20", "$L20", "$L9.id.videoId"}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"jumpRel", -7}, new Object[]{"set", "$P0.paginationChannelCache.cursor", "$L6.nextPageToken"}, new Object[]{"callFunc", "getVideos", "$P0", "$P0.paginationChannelCache.metaCache", "$L20"}, new Object[]{"jumpRel", -23}, new Object[]{"create", "$L0", "Number"}, new Object[]{"size", "$L0", "$P0.paginationChannelCache.metaCache"}, new Object[]{"math.add", "$L0", "$L0", "$P0.paginationChannelCache.offset"}, new Object[]{"if<than", "$P3", "$L0", 14}, new Object[]{"math.multiply", "$L1", "$P0.paginationChannelCache.offset", -1}, new Object[]{"math.add", "$L1", "$L1", "$P3"}, new Object[]{"size", "$L0", "$P1"}, new Object[]{"if<than", "$L0", "$P4", 9}, new Object[]{"get", "$L2", "$P0.paginationChannelCache.metaCache", "$L1"}, new Object[]{"push", "$P1", "$L2"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"size", "$L3", "$P0.paginationChannelCache.metaCache"}, new Object[]{"if==than", "$L3", "$L1", 3}, new Object[]{"size", "$L4", "$P0.paginationChannelCache.metaCache"}, new Object[]{"math.add", "$P3", "$L4", "$P0.paginationChannelCache.offset"}, new Object[]{"jumpRel", 2}, new Object[]{"jumpRel", -11}, new Object[]{"return"}, new Object[]{"if==than", "$P0.paginationChannelCache.cursor", null, 1}, new Object[]{"return"}, new Object[]{"size", "$L2", "$P0.paginationChannelCache.metaCache"}, new Object[]{"math.add", "$P0.paginationChannelCache.offset", "$P0.paginationChannelCache.offset", "$L2"}, new Object[]{"create", "$P0.paginationChannelCache.metaCache", "Array"}, new Object[]{"string.concat", "$L1", "https://www.googleapis.com/youtube/v3/search?part=id&type=video&maxResults=50"}, new Object[]{"set", "$L2", "$P2"}, new Object[]{"string.concat", "$L1", "$L1", "&channelId=", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "&pageToken=", "$P0.paginationChannelCache.cursor"}, new Object[]{"callFunc", "getRawMetaData", "$P0", "$L6", "$L1"}, new Object[]{"create", "$L7", "Number"}, new Object[]{"size", "$L8", "$L6.items"}, new Object[]{"create", "$L20", "String"}, new Object[]{"if<than", "$L7", "$L8", 6}, new Object[]{"get", "$L9", "$L6.items", "$L7"}, new Object[]{"if!=than", "$L7", 0, 1}, new Object[]{"string.concat", "$L20", "$L20", ","}, new Object[]{"string.concat", "$L20", "$L20", "$L9.id.videoId"}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"jumpRel", -7}, new Object[]{"set", "$P0.paginationChannelCache.cursor", "$L6.nextPageToken"}, new Object[]{"callFunc", "getVideos", "$P0", "$P0.paginationChannelCache.metaCache", "$L20"}, new Object[]{"jumpRel", -64}});
            this.put("AdvancedRequestSupporter:advancedRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L0.url", "String"}, new Object[]{"if!=than", "$P2.appendBaseUrl", 0, 1}, new Object[]{"set", "$L0.url", "https://www.googleapis.com/youtube/v3"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$P2.url"}, new Object[]{"set", "$L0.requestHeaders", "$P2.headers"}, new Object[]{"set", "$L0.method", "$P2.method"}, new Object[]{"set", "$L0.requestBody", "$P2.body"}, new Object[]{"if!=than", "$P2.appendAuthorization", 0, 2}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$P2.checkErrors", 0, 1}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P1", "AdvancedRequestResponse"}, new Object[]{"set", "$P1.status", "$L1.code"}, new Object[]{"set", "$P1.headers", "$L1.responseHeaders"}, new Object[]{"set", "$P1.body", "$L1.responseBody"}});
            this.put("makeVideoMetaData", new Object[]{new Object[]{"set", "$L1", "$P2.snippet"}, new Object[]{"set", "$L2", "$L1.thumbnails"}, new Object[]{"set", "$L3", "$P2.statistics"}, new Object[]{"create", "$L4", "Date", "$L1.publishedAt"}, new Object[]{"create", "$L5", "Number", 0}, new Object[]{"create", "$L6", "Number", 0}, new Object[]{"create", "$L7", "Number", 0}, new Object[]{"math.add", "$L5", "$L3.viewCount", 0}, new Object[]{"if!=than", "$L3.likeCount", null, 2}, new Object[]{"math.add", "$L6", "$L3.likeCount", 0}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L6", null}, new Object[]{"if!=than", "$L3.likeCount", null, 2}, new Object[]{"math.add", "$L7", "$L3.dislikeCount", 0}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L7", null}, new Object[]{"callFunc", "convertDuration", "$P0", "$L11", "$P2.contentDetails.duration"}, new Object[]{"create", "$L8", "Number", 0}, new Object[]{"math.add", "$L8", "$L11", 0}, new Object[]{"create", "$P1", "VideoMetaData", "$P2.id", "$L1.title", "$L1.description", "$L4.time", "$L1.channelId", "$L8", "$L2.high.url", "$P2.player.embedHtml", "$L5", "$L6", "$L7"}});
            this.put("makeChannelMetaData", new Object[]{new Object[]{"set", "$L1", "$P2.snippet.thumbnails"}, new Object[]{"string.concat", "$L2", "www.youtube.com/channel/", "$P2.id"}, new Object[]{"set", "$L3", "$P2.brandingSettings"}, new Object[]{"create", "$L4", "Number", 0}, new Object[]{"if!=than", "$P2.statistics.subscriberCount", null, 2}, new Object[]{"math.add", "$L4", "$P2.statistics.subscriberCount", 0}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L4", null}, new Object[]{"create", "$P1", "ChannelMetaData", "$P2.id", "$P2.snippet.title", "$L4", "$L2", "$L1.high.url", "$L3.image.bannerImageUrl"}});
            this.put("getRawMetaData", new Object[]{new Object[]{"set", "$L1", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"if!=than", "$P0.apiKey", null, 3}, new Object[]{"string.concat", "$L1", "$L1", "&key=", "$P0.apiKey"}, new Object[]{"callFunc", "getViaAPIKey", "$P0", "$L2", "$L1"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "getViaAuthorization", "$P0", "$L2", "$L1"}, new Object[]{"set", "$P1", "$L2"}});
            this.put("convertDurationToSeconds", new Object[]{new Object[]{"set", "$L1", "$P2"}, new Object[]{"create", "$L2", "Number", 0}, new Object[]{"create", "$L4", "Number"}, new Object[]{"create", "$L5", "Number"}, new Object[]{"create", "$L6", "Number"}, new Object[]{"create", "$L7", "Number"}, new Object[]{"callFunc", "replace", "$P0", "$L31", "$L1", "P", ""}, new Object[]{"callFunc", "replace", "$P0", "$L30", "$L31", "T", ""}, new Object[]{"create", "$L0", "Number"}, new Object[]{"string.indexOf", "$L0", "$L30", "H"}, new Object[]{"if!=than", "$L0", -1, 5}, new Object[]{"string.substring", "$L50", "$L30", 0, "$L0"}, new Object[]{"math.add", "$L51", "$L50", 0}, new Object[]{"math.multiply", "$L5", "$L51", 3600}, new Object[]{"callFunc", "removeString", "$P0", "$L30", "$L30", "H"}, new Object[]{"jumpRel", 1}, new Object[]{"math.add", "$L2", "$L2", "$L5"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"create", "$L10", "Number"}, new Object[]{"string.indexOf", "$L10", "$L30", "M"}, new Object[]{"if!=than", "$L10", -1, 6}, new Object[]{"string.substring", "$L60", "$L30", "$L0", "$L10"}, new Object[]{"callFunc", "replace", "$P0", "$L61", "$L60", "M", ""}, new Object[]{"math.add", "$L62", "$L61", 0}, new Object[]{"math.multiply", "$L6", "$L62", 60}, new Object[]{"callFunc", "removeString", "$P0", "$L30", "$L30", "M"}, new Object[]{"jumpRel", 1}, new Object[]{"math.add", "$L2", "$L2", "$L6"}, new Object[]{"math.add", "$L10", "$L10", 1}, new Object[]{"create", "$L20", "Number"}, new Object[]{"string.indexOf", "$L20", "$L30", "S"}, new Object[]{"if!=than", "$L20", -1, 4}, new Object[]{"string.substring", "$L70", "$L30", "$L10", "$L20"}, new Object[]{"callFunc", "replace", "$P0", "$L71", "$L70", "S", ""}, new Object[]{"math.add", "$L7", "$L71", 0}, new Object[]{"jumpRel", 1}, new Object[]{"debug.out", "$L7"}, new Object[]{"math.add", "$L2", "$L2", "$L7"}, new Object[]{"set", "$P1", "$L2"}});
            this.put("convertDuration", new Object[]{new Object[]{"set", "$L1", "$P2"}, new Object[]{"create", "$L2", "Number", 0}, new Object[]{"create", "$L5", "Number"}, new Object[]{"create", "$L6", "Number"}, new Object[]{"create", "$L7", "Number"}, new Object[]{"callFunc", "replace", "$P0", "$L31", "$L1", "P", ""}, new Object[]{"callFunc", "replace", "$P0", "$L30", "$L31", "T", ""}, new Object[]{"callFunc", "findNumberFromString", "$P0", "$L5", "$L30", "H", 3600}, new Object[]{"callFunc", "removeString", "$P0", "$L31", "$L30", "H"}, new Object[]{"math.add", "$L2", "$L2", "$L5"}, new Object[]{"callFunc", "findNumberFromString", "$P0", "$L6", "$L31", "M", 60}, new Object[]{"callFunc", "removeString", "$P0", "$L32", "$L31", "M"}, new Object[]{"math.add", "$L2", "$L2", "$L6"}, new Object[]{"callFunc", "findNumberFromString", "$P0", "$L7", "$L32", "S", 1}, new Object[]{"math.add", "$L2", "$L2", "$L7"}, new Object[]{"set", "$P1", "$L2"}});
            this.put("findNumberFromString", new Object[]{new Object[]{"create", "$L0", "Number"}, new Object[]{"string.indexOf", "$L0", "$P2", "$P3"}, new Object[]{"if!=than", "$L0", -1, 6}, new Object[]{"string.substring", "$L2", "$P2", 0, "$L0"}, new Object[]{"math.add", "$L3", "$L2", 0}, new Object[]{"math.multiply", "$L5", "$L3", "$P4"}, new Object[]{"set", "$P1", "$L5"}, new Object[]{"return"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$P1", "0"}});
            this.put("getViaAPIKey", new Object[]{new Object[]{"set", "$L1", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"json.parse", "$P1", "$L2.responseBody"}});
            this.put("getViaAuthorization", new Object[]{new Object[]{"set", "$L1", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"create", "$L4", "String"}, new Object[]{"string.concat", "$L4", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L3", "$L4", "Authorization"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"json.parse", "$P1", "$L2.responseBody"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.accessToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0", "accessToken"}, new Object[]{"return"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L1.time", "$S0.expireIn"}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"callFunc", "authenticate", "$P0", "refreshToken"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L2", "String"}, new Object[]{"if==than", "$P1", "accessToken", 4}, new Object[]{"string.concat", "$L0", "https://accounts.google.com/o/oauth2/v2/auth?client_id=", "$P0.clientId", "&scope=", "$P0.scope", "&response_type=code&prompt=consent&access_type=offline&redirect_uri=", "$P0.redirectUri", "&state=", "$P0.state", "&suppress_webview_warning=true"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0", null, "$P0.redirectUri"}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&code=", "$L1", "&grant_type=authorization_code"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&refresh_token=", "$S0.refreshToken", "&grant_type=refresh_token"}, new Object[]{"stream.stringToStream", "$L3", "$L2"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "https://www.googleapis.com/oauth2/v4/token"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestBody", "$L3"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6"}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$S0.accessToken", "$L8.access_token"}, new Object[]{"if!=than", "$L8.refresh_token", null, 1}, new Object[]{"set", "$S0.refreshToken", "$L8.refresh_token"}, new Object[]{"create", "$L10", "Date"}, new Object[]{"math.multiply", "$L9", "$L8.expires_in", 1000}, new Object[]{"math.add", "$L9", "$L9", "$L10.time", -60000}, new Object[]{"set", "$S0.expireIn", "$L9"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 19}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 400, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 402, 5}, new Object[]{"if<=than", "$P1.code", 509, 4}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"if!=than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be null."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkIsEmpty", new Object[]{new Object[]{"size", "$L0", "$P2"}, new Object[]{"if==than", "$L0", 0, 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be empty."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkGreater0", new Object[]{new Object[]{"if<=than", "$P1", 0, 3}, new Object[]{"string.concat", "$L0", "$P2", " has to be greater than 0"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("requiredClientIDConstructor", new Object[]{new Object[]{"if!=than", "$P0.apiKey", null, 3}, new Object[]{"string.concat", "$L0", "You cannot use the API key with this service, the other constructor "}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("replace", new Object[]{new Object[]{"string.split", "$L0", "$P2", "$P3"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"set", "$L2", 0}, new Object[]{"if<than", "$L2", "$L1", 7}, new Object[]{"get", "$L5", "$L0", "$L2"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"set", "$L4", "$L5"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L4", "$L4", "$P4", "$L5"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -8}, new Object[]{"set", "$P1", "$L4"}});
            this.put("removeString", new Object[]{new Object[]{"create", "$L3", "Number"}, new Object[]{"string.lastIndexOf", "$L3", "$P2", "$P3"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"create", "$L29", "String"}, new Object[]{"string.substring", "$L29", "$P2", "$L3"}, new Object[]{"set", "$P1", "$L29"}});
        }
    });
    private Map<String, Object> interpreterStorage;
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage;

    public YouTube(Context context, String apiKey) {
        this.initDataStructures(context);
        this.interpreterStorage.put("apiKey", apiKey);
        this.initService();
    }

    public YouTube(Context context, String clientId, String clientSecret, String redirectUri, String state) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.initService();
    }

    public YouTube(Context context, String clientId, String clientSecret, String redirectUri, String state, List<String> scopes) {
        this.initDataStructures(context);
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        this.interpreterStorage.put("scopes", scopes);
        this.initService();
    }

    private void initDataStructures(Context context) {
        this.interpreterStorage = new TreeMap<String, Object>();
        this.persistentStorage = new ArrayList<Object>();
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("activity", context);
        this.instanceDependencyStorage.put("auth_dialog_text", "Connecting to YouTube...");
        new InitSelfTestTask("YouTube", context).start();
    }

    private void initService() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public VideoMetaData uploadVideo(String title, String description, InputStream stream, long size, String channelId, String mimeType) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "YouTube", "uploadVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("uploadVideo", this.interpreterStorage, null, title, description, stream, size, channelId, mimeType);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("YouTube", "uploadVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (VideoMetaData)ip.getParameter(1);
    }

    @Override
    public List<VideoMetaData> searchVideos(String query, long offset, long limit) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "YouTube", "searchVideos").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("searchVideos", this.interpreterStorage, null, query, offset, limit);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("YouTube", "searchVideos").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public VideoMetaData getVideo(String videoId) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "YouTube", "getVideo").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getVideo", this.interpreterStorage, null, videoId);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("YouTube", "getVideo").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (VideoMetaData)ip.getParameter(1);
    }

    @Override
    public ChannelMetaData getChannel(String channelId) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "YouTube", "getChannel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getChannel", this.interpreterStorage, null, channelId);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("YouTube", "getChannel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (ChannelMetaData)ip.getParameter(1);
    }

    @Override
    public ChannelMetaData getOwnChannel() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "YouTube", "getOwnChannel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getOwnChannel", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("YouTube", "getOwnChannel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (ChannelMetaData)ip.getParameter(1);
    }

    @Override
    public List<VideoMetaData> listVideosForChannel(String channelId, long offset, long limit) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "YouTube", "listVideosForChannel").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listVideosForChannel", this.interpreterStorage, null, channelId, offset, limit);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("YouTube", "listVideosForChannel").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "YouTube", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("YouTube", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "YouTube", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("YouTube", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public AdvancedRequestResponse advancedRequest(AdvancedRequestSpecification specification) {
        CloudRail.validateKey();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("The methods of CloudRail SI must not be executed on the UI Thread! They involve Thread blocking and network requests.");
        }
        new ReportCallTask((Context)this.instanceDependencyStorage.get("activity"), "YouTube", "advancedRequest").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("AdvancedRequestSupporter:advancedRequest", this.interpreterStorage, null, specification);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("YouTube", "advancedRequest").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (AdvancedRequestResponse)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void useAdvancedAuthentication() {
        this.instanceDependencyStorage.put("advanced_auth", true);
    }
}

