/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.statistics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.cloudrail.si.CloudRail;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.JSONObject;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.JSONParser;
import com.cloudrail.si.statistics.SendStatisticsTask;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Timer;
import java.util.TimerTask;

public class Statistics {
    private static final String libraryVersion = "2.22.4";
    private static final String SERVER_URL = "https://keys.cloudrail.com/api/entries";
    private static final long DELAY = 300000L;
    private static Statistics ourInstance = new Statistics();
    private static JSONObject ADD_STATS = new JSONObject();
    private JSONObject data = new JSONObject();
    private long next = 1L;
    private long count = 0L;
    private String entryID = null;
    private Context context = null;
    private Timer timer = null;
    private boolean block = false;

    private Statistics() {
    }

    public static Statistics getInstance() {
        return ourInstance;
    }

    public synchronized void addCall(Context context, String service, String method) {
        if (this.context == null) {
            this.context = context;
        }
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new SendStatisticsTask(), 300000L);
        }
        JSONObject calls = this.getMethodCalls(service, method);
        calls.put("count", (Long)calls.get("count") + 1L);
        ++this.count;
        if (this.count == this.next) {
            this.next *= 2L;
            this.sendStatistics();
        }
    }

    public synchronized void addError(String service, String method) {
        if (CloudRail.getAppKey() == null) {
            return;
        }
        JSONObject calls = this.getMethodCalls(service, method);
        calls.put("error", (Long)calls.get("error") + 1L);
    }

    public synchronized void sendStatistics() {
        if (this.count == 0L) {
            return;
        }
        JSONObject body = new JSONObject();
        if (this.entryID == null) {
            PackageInfo packageInfo = null;
            try {
                packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            String appVersionName = "";
            Long appVersionCode = -1L;
            if (packageInfo != null) {
                appVersionName = packageInfo.versionName;
                appVersionCode = packageInfo.versionCode;
            }
            JSONObject app = new JSONObject();
            String className = this.context.getApplicationInfo().className;
            app.put("className", className);
            String packageName = this.context.getPackageName();
            app.put("packageName", packageName);
            app.put("versionCode", appVersionCode);
            app.put("versionName", appVersionName);
            String appValueString = className + packageName + appVersionCode + appVersionName;
            String appHash = this.hashString(appValueString);
            JSONObject client = new JSONObject();
            client.put("device", Build.DEVICE);
            client.put("model", Build.MODEL);
            String osName = System.getProperty("os.name");
            client.put("os", osName);
            String osVersion = System.getProperty("os.version");
            client.put("os_version", osVersion);
            client.put("product", Build.PRODUCT);
            client.put("sdk_version", Build.VERSION.SDK_INT);
            client.put("serial", Build.SERIAL);
            String clientValueString = Build.DEVICE + Build.MODEL + osName + osVersion + Build.PRODUCT + Build.VERSION.SDK_INT + Build.SERIAL;
            String clientHash = this.hashString(clientValueString);
            body.put("appHash", appHash);
            body.put("clientHash", clientHash);
            body.put("app", app);
            body.put("client", client);
        } else {
            body.put("id", this.entryID);
        }
        if (CloudRail.getAppKey() != null) {
            body.put("appKey", CloudRail.getAppKey());
        }
        body.put("data", this.data);
        body.put("platform", "Android");
        body.put("libraryVersion", libraryVersion);
        body.put("additionalStats", ADD_STATS);
        boolean success = this.sendRequest(body.toJSONString());
        if (success) {
            this.data = new JSONObject();
            this.count = 0L;
            this.timer.cancel();
            this.timer = null;
        }
    }

    public Boolean getBlock() {
        return this.block;
    }

    public void setAddStats(String key, Object value) {
        ADD_STATS.put(key, value);
    }

    private JSONObject getMethodCalls(String service, String method) {
        JSONObject callsToService;
        if (!this.data.containsKey(service)) {
            this.data.put(service, new JSONObject());
        }
        if (!(callsToService = (JSONObject)this.data.get(service)).containsKey(method)) {
            JSONObject temp = new JSONObject();
            temp.put("count", 0L);
            temp.put("error", 0L);
            callsToService.put(method, temp);
        }
        return (JSONObject)callsToService.get(method);
    }

    private String hashString(String source) {
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        m.reset();
        m.update(source.getBytes());
        byte[] digest = m.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String hashtext = bigInt.toString(16);
        while (hashtext.length() < 32) {
            hashtext = "0" + hashtext;
        }
        return hashtext;
    }

    private boolean sendRequest(String body) {
        try {
            String line;
            URL url = new URL(SERVER_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(body);
            wr.close();
            if (connection.getResponseCode() != 200) {
                throw new RuntimeException();
            }
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuilder response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            JSONObject resp = (JSONObject)new JSONParser().parse(response.toString());
            if (this.entryID == null) {
                this.entryID = (String)resp.get("id");
            }
            if (resp.get("block") != null) {
                this.block = (Boolean)resp.get("block");
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

