/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.types;

import com.cloudrail.si.servicecode.commands.json.Stringify;
import com.cloudrail.si.types.SandboxObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class AdvancedRequestSpecification
extends SandboxObject {
    private String url;
    private String method = "GET";
    private InputStream body;
    private Map<String, String> headers = new HashMap<String, String>();
    private boolean appendAuthorization = true;
    private boolean checkErrors = true;
    private boolean appendBaseUrl = true;

    public AdvancedRequestSpecification(String url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setBodyAsStream(InputStream body) {
        this.body = body;
    }

    public void setBodyAsString(String body) {
        this.body = new ByteArrayInputStream(body.getBytes());
    }

    public void setBodyStringifyJson(Object body) {
        this.setBodyAsString(Stringify.stringify(body));
    }

    public void setBodyStringifyXml(Map<String, Object> body) {
        try {
            this.setBodyAsString(com.cloudrail.si.servicecode.commands.xml.Stringify.stringify(body));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void disableAuthorization() {
        this.appendAuthorization = false;
    }

    public void disableErrorChecking() {
        this.checkErrors = false;
    }

    public void disableBaseUrl() {
        this.appendBaseUrl = false;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public InputStream getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean getAppendAuthorization() {
        return this.appendAuthorization;
    }

    public boolean getCheckErrors() {
        return this.checkErrors;
    }

    public boolean getAppendBaseUrl() {
        return this.appendBaseUrl;
    }
}

