/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.types;

import com.cloudrail.si.types.CreditCard;
import com.cloudrail.si.types.SandboxObject;
import java.util.Currency;

public class Charge
extends SandboxObject {
    private String id;
    private Long amount;
    private String currency;
    private CreditCard source;
    private Long created;
    private String status;
    private boolean refunded;

    public Charge(Long amount, Long created, String currency, String id, Number refunded, CreditCard source, String status) {
        if (currency == null || id == null || source == null || status == null || refunded == null) {
            throw new IllegalArgumentException("One or more parameters are null.");
        }
        if (amount < 0L) {
            throw new IllegalArgumentException("The amount can not be less than 0.");
        }
        if (!this.validateCurrency(currency)) {
            throw new IllegalArgumentException("The passed currency is invalid.");
        }
        if (!this.validateStatus(status)) {
            throw new IllegalArgumentException("The passed state should be one of: 'pending', 'succeeded' or 'failed'.");
        }
        this.amount = amount;
        this.created = created;
        this.currency = currency.toUpperCase();
        this.id = id;
        this.refunded = refunded.intValue() != 0;
        this.source = source;
        this.status = status;
    }

    public Long getAmount() {
        return this.amount;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRefunded() {
        return this.refunded;
    }

    public CreditCard getSource() {
        return this.source;
    }

    public String getStatus() {
        return this.status;
    }

    private boolean validateCurrency(String currency) {
        try {
            String capitalCurrency = currency.toUpperCase();
            Currency currency1 = Currency.getInstance(capitalCurrency);
            return currency1 != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean validateStatus(String status) {
        return status.equals("pending") || status.equals("failed") || status.equals("succeeded");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Charge)) {
            return false;
        }
        Charge charge = (Charge)o;
        if (this.refunded != charge.refunded) {
            return false;
        }
        if (!this.id.equals(charge.id)) {
            return false;
        }
        if (!this.amount.equals(charge.amount)) {
            return false;
        }
        if (!this.currency.equals(charge.currency)) {
            return false;
        }
        if (!this.source.equals(charge.source)) {
            return false;
        }
        if (!this.created.equals(charge.created)) {
            return false;
        }
        return this.status.equals(charge.status);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.amount.hashCode();
        result = 31 * result + this.currency.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.created.hashCode();
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (this.refunded ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Charge{id='" + this.id + '\'' + ", amount=" + this.amount + ", currency='" + this.currency + '\'' + ", source=" + this.source + ", created=" + this.created + ", status='" + this.status + '\'' + ", refunded=" + this.refunded + '}';
    }
}

