/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.types;

import com.cloudrail.si.types.Address;
import com.cloudrail.si.types.SandboxObject;

public class CreditCard
extends SandboxObject
implements Comparable<CreditCard> {
    private String firstName;
    private String lastName;
    private Address address;
    private String number;
    private String cvc;
    private Long expire_month;
    private Long expire_year;
    private String type;

    public CreditCard(String cvc, Long expire_month, Long expire_year, String number, String type, String firstName, String lastName, Address address) {
        this.setCvc(cvc);
        this.setExpire_month(expire_month);
        this.setExpire_year(expire_year);
        this.setNumber(number);
        this.setType(type);
        this.setFirstName(firstName);
        this.setLastName(lastName);
        this.setAddress(address);
    }

    public String getCvc() {
        return this.cvc;
    }

    public void setCvc(String cvc) {
        this.cvc = cvc;
    }

    public Long getExpire_month() {
        return this.expire_month;
    }

    public void setExpire_month(Long expire_month) {
        if (expire_month == null) {
            throw new IllegalArgumentException("Expiration month shouldn't be null");
        }
        if (expire_month <= 0L || expire_month > 12L) {
            throw new IllegalArgumentException("Expiration month needs to be between 1 and 12.");
        }
        this.expire_month = expire_month;
    }

    public Long getExpire_year() {
        return this.expire_year;
    }

    public void setExpire_year(Long expire_year) {
        if (expire_year == null) {
            throw new IllegalArgumentException("Expiration year shouldn't be null");
        }
        if (expire_year < 1970L || String.valueOf(expire_year).length() != 4) {
            throw new IllegalArgumentException("Expiration year needs to be a four digit number.");
        }
        this.expire_year = expire_year;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        if (number == null) {
            throw new IllegalArgumentException("Card number is not allowed to be null.");
        }
        this.number = number;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Card type is not allowed to be null.");
        }
        if (!(type.equals("visa") || type.equals("mastercard") || type.equals("discover") || type.equals("amex"))) {
            throw new IllegalArgumentException("Unknown card type. Allowed values are: 'visa', 'mastercard', 'discover' or 'amex'.");
        }
        this.type = type;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditCard that = (CreditCard)o;
        if (this.firstName != null ? !this.firstName.equals(that.firstName) : that.firstName != null) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(that.lastName) : that.lastName != null) {
            return false;
        }
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (!this.number.equals(that.number)) {
            return false;
        }
        if (this.cvc != null ? !this.cvc.equals(that.cvc) : that.cvc != null) {
            return false;
        }
        if (!this.expire_month.equals(that.expire_month)) {
            return false;
        }
        if (!this.expire_year.equals(that.expire_year)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.firstName != null ? this.firstName.hashCode() : 0;
        result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + this.number.hashCode();
        result = 31 * result + (this.cvc != null ? this.cvc.hashCode() : 0);
        result = 31 * result + this.expire_month.hashCode();
        result = 31 * result + this.expire_year.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "CreditCard{firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", address=" + this.address + ", number='" + this.number + '\'' + ", cvc='" + this.cvc + '\'' + ", expire_month=" + this.expire_month + ", expire_year=" + this.expire_year + ", type='" + this.type + '\'' + '}';
    }

    @Override
    public int compareTo(CreditCard another) {
        String b;
        if (another == null) {
            throw new IllegalArgumentException("Value to compare with is not allowed to be null.");
        }
        int compare = this.firstName.compareTo(another.firstName);
        if (compare != 0) {
            return compare;
        }
        compare = this.lastName.compareTo(another.lastName);
        if (compare != 0) {
            return compare;
        }
        String a = this.number.substring(12);
        compare = a.compareTo(b = another.number.substring(12));
        if (compare != 0) {
            return compare;
        }
        compare = this.expire_month.compareTo(another.expire_month);
        if (compare != 0) {
            return compare;
        }
        compare = this.expire_year.compareTo(another.expire_year);
        if (compare != 0) {
            return compare;
        }
        return this.type.compareTo(another.type);
    }
}

