/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.types;

import com.cloudrail.si.types.JSONAware;
import com.cloudrail.si.types.SandboxObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class Date
extends SandboxObject
implements Comparable<Object>,
JSONAware {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    private static final SimpleDateFormat format3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ");
    private static final SimpleDateFormat rfc1123Format = new SimpleDateFormat("EEE',' dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private static final SimpleDateFormat rfc2822Format = new SimpleDateFormat("EEE',' dd MMM yyyy HH:mm:ss Z", Locale.US);
    private java.util.Date date;

    public Date() {
        this.date = new java.util.Date();
    }

    public Date(String d) {
        try {
            this.date = format.parse(d);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.date == null) {
            try {
                this.date = format2.parse(d);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.date == null) {
            try {
                this.date = format3.parse(d);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.date == null) {
            try {
                this.date = rfc1123Format.parse(d);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.date == null) {
            try {
                this.date = rfc2822Format.parse(d);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.date == null && System.getProperty("java.vendor.url") != "http://www.android.com") {
            SimpleDateFormat format4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
            try {
                this.date = format4.parse(d);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
        }
    }

    public long getTime() {
        return this.date.getTime();
    }

    public String getRfcTime() {
        return format.format(this.date);
    }

    public String getRfcTimeUsingFormat2() {
        return format2.format(this.date);
    }

    public String getRfcTimeUsingFormat3() {
        return format3.format(this.date);
    }

    public String getRfcTime1123() {
        return rfc1123Format.format(this.date);
    }

    public String getRfcTime2822() {
        return rfc2822Format.format(this.date);
    }

    public void setTime(long time) {
        this.date.setTime(time);
    }

    public java.util.Date getDate() {
        return this.date;
    }

    @Override
    public int compareTo(Object another) {
        if (!(another instanceof Date)) {
            throw new ClassCastException();
        }
        return this.date.compareTo(((Date)another).getDate());
    }

    @Override
    public String toJSONString() {
        return Long.toString(this.date.getTime());
    }

    @Override
    public Date fromJSONString(String jsonString) {
        Date d = new Date();
        d.setTime(Long.parseLong(jsonString));
        return d;
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        format2.setTimeZone(TimeZone.getTimeZone("UTC"));
        rfc1123Format.setTimeZone(TimeZone.getTimeZone("UTC"));
        rfc2822Format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

